/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Method getMethod(Class<?> clazz, String name, Class<?> ... params) throws ReflectionException {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) throws ReflectionException {
        ReflectiveOperationException ex;
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new ReflectionException(ex);
    }

    public static boolean isInstanceOf(Object object, String className) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            String name = superClass.getName();
            if (!name.equals(className)) continue;
            return true;
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        return cause == null ? throwable : cause;
    }

    public static class ReflectionException
    extends Exception {
        public ReflectionException() {
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

