/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.internal.R;

public class SwipeDismissLayout
extends FrameLayout {
    private static final String TAG = "SwipeDismissLayout";
    private static final float DISMISS_MIN_DRAG_WIDTH_RATIO = 0.33f;
    private boolean mUseDynamicTranslucency = true;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private ViewTreeObserver.OnEnterAnimationCompleteListener mOnEnterAnimationCompleteListener = new ViewTreeObserver.OnEnterAnimationCompleteListener(){

        @Override
        public void onEnterAnimationComplete() {
            if (SwipeDismissLayout.this.mUseDynamicTranslucency && SwipeDismissLayout.this.getContext() instanceof Activity) {
                ((Activity)SwipeDismissLayout.this.getContext()).convertFromTranslucent();
            }
        }
    };
    private BroadcastReceiver mScreenOffReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (SwipeDismissLayout.this.mDismissed) {
                SwipeDismissLayout.this.dismiss();
            } else {
                SwipeDismissLayout.this.cancel();
            }
            SwipeDismissLayout.this.resetMembers();
        }
    };
    private IntentFilter mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
    private float mLastX;

    public SwipeDismissLayout(Context context) {
        super(context);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        TypedArray a = context.getTheme().obtainStyledAttributes(R.styleable.Theme);
        this.mUseDynamicTranslucency = !a.hasValue(5);
        a.recycle();
    }

    public void setOnDismissedListener(OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getContext() instanceof Activity) {
            this.getViewTreeObserver().addOnEnterAnimationCompleteListener(this.mOnEnterAnimationCompleteListener);
        }
        this.getContext().registerReceiver(this.mScreenOffReceiver, this.mScreenOffFilter);
    }

    @Override
    protected void onDetachedFromWindow() {
        this.getContext().unregisterReceiver(this.mScreenOffReceiver);
        if (this.getContext() instanceof Activity) {
            this.getViewTreeObserver().removeOnEnterAnimationCompleteListener(this.mOnEnterAnimationCompleteListener);
        }
        super.onDetachedFromWindow();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e(TAG, "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.canScroll(this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            return super.onTouchEvent(ev);
        }
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.dismiss();
                } else if (this.mSwiping) {
                    this.cancel();
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                if (this.mUseDynamicTranslucency && this.getContext() instanceof Activity) {
                    ((Activity)this.getContext()).convertToTranslucent(null, null);
                }
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private void setProgress(float deltaX) {
        this.mTranslationX = deltaX;
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, deltaX / (float)this.getWidth(), deltaX);
        }
    }

    private void dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    protected void cancel() {
        if (this.mUseDynamicTranslucency && this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).convertFromTranslucent();
        }
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    private void resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private void updateSwiping(MotionEvent ev) {
        if (!this.mSwiping) {
            float deltaY;
            float deltaX = ev.getRawX() - this.mDownX;
            this.mSwiping = deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > (float)(this.mSlop * this.mSlop) ? deltaX > (float)(this.mSlop * 2) && Math.abs(deltaY) < Math.abs(deltaX) : false;
        }
    }

    private void updateDismiss(MotionEvent ev) {
        float deltaX = ev.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(ev);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        if (!this.mDismissed && deltaX > (float)this.getWidth() * 0.33f && ev.getRawX() >= this.mLastX) {
            this.mDismissed = true;
        }
        if (this.mDismissed && this.mSwiping && (deltaX < (float)this.getWidth() * 0.33f || this.mVelocityTracker.getXVelocity() < (float)(-this.mMinFlingVelocity))) {
            this.mDismissed = false;
        }
    }

    protected boolean canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    public static interface OnSwipeProgressChangedListener {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCancelled(SwipeDismissLayout var1);
    }

    public static interface OnDismissedListener {
        public void onDismissed(SwipeDismissLayout var1);
    }
}

