/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.animation;

import android.animation.TimeInterpolator;
import android.view.Choreographer;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class FallbackLUTInterpolator
implements NativeInterpolatorFactory,
TimeInterpolator {
    private TimeInterpolator mSourceInterpolator;
    private final float[] mLut;

    public FallbackLUTInterpolator(TimeInterpolator interpolator2, long duration) {
        this.mSourceInterpolator = interpolator2;
        this.mLut = FallbackLUTInterpolator.createLUT(interpolator2, duration);
    }

    private static float[] createLUT(TimeInterpolator interpolator2, long duration) {
        long frameIntervalNanos = Choreographer.getInstance().getFrameIntervalNanos();
        int animIntervalMs = (int)(frameIntervalNanos / 1000000L);
        int numAnimFrames = (int)Math.ceil((double)duration / (double)animIntervalMs);
        float[] values = new float[numAnimFrames];
        float lastFrame = numAnimFrames - 1;
        for (int i = 0; i < numAnimFrames; ++i) {
            float inValue = (float)i / lastFrame;
            values[i] = interpolator2.getInterpolation(inValue);
        }
        return values;
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createLutInterpolator(this.mLut);
    }

    public static long createNativeInterpolator(TimeInterpolator interpolator2, long duration) {
        float[] lut = FallbackLUTInterpolator.createLUT(interpolator2, duration);
        return NativeInterpolatorFactoryHelper.createLutInterpolator(lut);
    }

    @Override
    public float getInterpolation(float input) {
        return this.mSourceInterpolator.getInterpolation(input);
    }
}

