/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.java.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlUtils {
    private static final String STRING_ARRAY_SEPARATOR = ":";

    public static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    public static int convertValueToList(CharSequence value, String[] options, int defaultValue) {
        if (null != value) {
            for (int i = 0; i < options.length; ++i) {
                if (!value.equals(options[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    public static boolean convertValueToBoolean(CharSequence value, boolean defaultValue) {
        boolean result = false;
        if (null == value) {
            return defaultValue;
        }
        if (value.equals("1") || value.equals("true") || value.equals("TRUE")) {
            result = true;
        }
        return result;
    }

    public static int convertValueToInt_Original(CharSequence charSeq, int defaultValue) {
        if (null == charSeq) {
            return defaultValue;
        }
        String nm = charSeq.toString();
        int sign = 1;
        int index = 0;
        int len = nm.length();
        int base = 10;
        if ('-' == nm.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == nm.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = nm.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == nm.charAt(index)) {
            ++index;
            base = 16;
        }
        return Integer.parseInt(nm.substring(index), base) * sign;
    }

    @LayoutlibDelegate
    public static int convertValueToInt(CharSequence charSequence, int n) {
        return XmlUtils_Delegate.convertValueToInt(charSequence, n);
    }

    public static int convertValueToUnsignedInt(String value, int defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return XmlUtils.parseUnsignedIntAttribute(value);
    }

    public static int parseUnsignedIntAttribute(CharSequence charSeq) {
        String value = charSeq.toString();
        int index = 0;
        int len = value.length();
        int base = 10;
        if ('0' == value.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = value.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == value.charAt(index)) {
            ++index;
            base = 16;
        }
        return (int)Long.parseLong(value.substring(index), base);
    }

    public static void writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        FastXmlSerializer serializer = new FastXmlSerializer();
        serializer.setOutput(out, Charsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeListXml(List val, OutputStream out) throws XmlPullParserException, IOException {
        XmlSerializer serializer = Xml.newSerializer();
        serializer.setOutput(out, Charsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeListXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeMapXml(Map val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeMapXml(val, name, out, null);
    }

    public static void writeMapXml(Map val, String name, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        XmlUtils.writeMapXml(val, out, callback);
        out.endTag(null, "map");
    }

    public static void writeMapXml(Map val, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            return;
        }
        Set s = val.entrySet();
        for (Map.Entry e : s) {
            XmlUtils.writeValueXml(e.getValue(), (String)e.getKey(), out, callback);
        }
    }

    public static void writeListXml(List val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.size();
        for (int i = 0; i < N; ++i) {
            XmlUtils.writeValueXml(val.get(i), null, out);
        }
        out.endTag(null, "list");
    }

    public static void writeSetXml(Set val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "set");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        for (Object v : val) {
            XmlUtils.writeValueXml(v, null, out);
        }
        out.endTag(null, "set");
    }

    public static void writeByteArrayXml(byte[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        StringBuilder sb = new StringBuilder(val.length * 2);
        for (int i = 0; i < N; ++i) {
            byte b = val[i];
            int h = b >> 4;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
            h = b & 0xFF;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
        }
        out.text(sb.toString());
        out.endTag(null, "byte-array");
    }

    public static void writeIntArrayXml(int[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Integer.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "int-array");
    }

    public static void writeLongArrayXml(long[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "long-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Long.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "long-array");
    }

    public static void writeDoubleArrayXml(double[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "double-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Double.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "double-array");
    }

    public static void writeStringArrayXml(String[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "string-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "string-array");
    }

    public static void writeBooleanArrayXml(boolean[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "boolean-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Boolean.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "boolean-array");
    }

    public static void writeValueXml(Object v, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeValueXml(v, name, out, null);
    }

    private static void writeValueXml(Object v, String name, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        String typeStr;
        if (v == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v.toString());
            out.endTag(null, "string");
            return;
        }
        if (v instanceof Integer) {
            typeStr = "int";
        } else if (v instanceof Long) {
            typeStr = "long";
        } else if (v instanceof Float) {
            typeStr = "float";
        } else if (v instanceof Double) {
            typeStr = "double";
        } else if (v instanceof Boolean) {
            typeStr = "boolean";
        } else {
            if (v instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v, name, out);
                return;
            }
            if (v instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v, name, out);
                return;
            }
            if (v instanceof long[]) {
                XmlUtils.writeLongArrayXml((long[])v, name, out);
                return;
            }
            if (v instanceof double[]) {
                XmlUtils.writeDoubleArrayXml((double[])v, name, out);
                return;
            }
            if (v instanceof String[]) {
                XmlUtils.writeStringArrayXml((String[])v, name, out);
                return;
            }
            if (v instanceof boolean[]) {
                XmlUtils.writeBooleanArrayXml((boolean[])v, name, out);
                return;
            }
            if (v instanceof Map) {
                XmlUtils.writeMapXml((Map)v, name, out);
                return;
            }
            if (v instanceof List) {
                XmlUtils.writeListXml((List)v, name, out);
                return;
            }
            if (v instanceof Set) {
                XmlUtils.writeSetXml((Set)v, name, out);
                return;
            }
            if (v instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v.toString());
                out.endTag(null, "string");
                return;
            }
            if (callback != null) {
                callback.writeUnknownObject(v, name, out);
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v);
        }
        out.startTag(null, typeStr);
        if (name != null) {
            out.attribute(null, "name", name);
        }
        out.attribute(null, "value", v.toString());
        out.endTag(null, typeStr);
    }

    public static HashMap<String, ?> readMapXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, Charsets.UTF_8.name());
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static ArrayList readListXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, Charsets.UTF_8.name());
        return (ArrayList)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static HashSet readSetXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashSet)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static HashMap<String, ?> readThisMapXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisMapXml(parser, endTag, name, null);
    }

    public static HashMap<String, ?> readThisMapXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, false);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static ArrayMap<String, ?> readThisArrayMapXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        ArrayMap<String, Object> map = new ArrayMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, true);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static ArrayList readThisListXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisListXml(parser, endTag, name, null, false);
    }

    private static ArrayList readThisListXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                list.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return list;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static HashSet readThisSetXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisSetXml(parser, endTag, name, null, false);
    }

    private static HashSet readThisSetXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        HashSet<Object> set = new HashSet<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                set.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return set;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] readThisIntArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in byte-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in byte-array");
        }
        parser.next();
        int[] array2 = new int[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Integer.parseInt(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] readThisLongArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in long-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in long-array");
        }
        parser.next();
        long[] array2 = new long[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Long.parseLong(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] readThisDoubleArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in double-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in double-array");
        }
        parser.next();
        double[] array2 = new double[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Double.parseDouble(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] readThisStringArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in string-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in string-array");
        }
        parser.next();
        String[] array2 = new String[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = parser.getAttributeValue(null, "value");
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean[] readThisBooleanArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in string-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in string-array");
        }
        parser.next();
        boolean[] array2 = new boolean[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Boolean.valueOf(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static Object readValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name, null, false);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static Object readThisValueXml(XmlPullParser parser, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        String tagName;
        block22: {
            int eventType;
            Object res;
            String valueName = parser.getAttributeValue(null, "name");
            tagName = parser.getName();
            if (tagName.equals("null")) {
                res = null;
            } else {
                if (tagName.equals("string")) {
                    block21: {
                        String value = "";
                        while (true) {
                            int eventType2 = parser.next();
                            if (eventType2 == 1) break block21;
                            if (eventType2 == 3) {
                                if (parser.getName().equals("string")) {
                                    name[0] = valueName;
                                    return value;
                                }
                                throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                            }
                            if (eventType2 == 4) {
                                value = value + parser.getText();
                                continue;
                            }
                            if (eventType2 == 2) break;
                        }
                        throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                    }
                    throw new XmlPullParserException("Unexpected end of document in <string>");
                }
                res = XmlUtils.readThisPrimitiveValueXml(parser, tagName);
                if (res == null) {
                    if (tagName.equals("int-array")) {
                        res = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("long-array")) {
                        res = XmlUtils.readThisLongArrayXml(parser, "long-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("double-array")) {
                        res = XmlUtils.readThisDoubleArrayXml(parser, "double-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("string-array")) {
                        res = XmlUtils.readThisStringArrayXml(parser, "string-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("boolean-array")) {
                        res = XmlUtils.readThisBooleanArrayXml(parser, "boolean-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("map")) {
                        parser.next();
                        res = arrayMap ? XmlUtils.readThisArrayMapXml(parser, "map", name, callback) : XmlUtils.readThisMapXml(parser, "map", name, callback);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("list")) {
                        parser.next();
                        res = XmlUtils.readThisListXml(parser, "list", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("set")) {
                        parser.next();
                        res = XmlUtils.readThisSetXml(parser, "set", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (callback != null) {
                        res = callback.readThisUnknownObjectXml(parser, tagName);
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unknown tag: " + tagName);
                }
            }
            do {
                eventType = parser.next();
                if (eventType == 1) break block22;
                if (eventType == 3) {
                    if (parser.getName().equals(tagName)) {
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
                }
                if (eventType == 4) {
                    throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
                }
            } while (eventType != 2);
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
        }
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }

    private static Object readThisPrimitiveValueXml(XmlPullParser parser, String tagName) throws XmlPullParserException, IOException {
        try {
            if (tagName.equals("int")) {
                return Integer.parseInt(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("long")) {
                return Long.valueOf(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("float")) {
                return new Float(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("double")) {
                return new Double(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("boolean")) {
                return Boolean.valueOf(parser.getAttributeValue(null, "value"));
            }
            return null;
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need value attribute in <" + tagName + ">");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in value attribute in <" + tagName + ">");
        }
    }

    public static void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    public static void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }

    public static boolean nextElementWithin(XmlPullParser parser, int outerDepth) throws IOException, XmlPullParserException {
        int type;
        do {
            if ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() != outerDepth)) continue;
            return false;
        } while (type != 2 || parser.getDepth() != outerDepth + 1);
        return true;
    }

    public static int readIntAttribute(XmlPullParser in, String name, int defaultValue) {
        String value = in.getAttributeValue(null, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int readIntAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as int");
        }
    }

    public static void writeIntAttribute(XmlSerializer out, String name, int value) throws IOException {
        out.attribute(null, name, Integer.toString(value));
    }

    public static long readLongAttribute(XmlPullParser in, String name, long defaultValue) {
        String value = in.getAttributeValue(null, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long readLongAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    public static void writeLongAttribute(XmlSerializer out, String name, long value) throws IOException {
        out.attribute(null, name, Long.toString(value));
    }

    public static float readFloatAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    public static void writeFloatAttribute(XmlSerializer out, String name, float value) throws IOException {
        out.attribute(null, name, Float.toString(value));
    }

    public static boolean readBooleanAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        return Boolean.parseBoolean(value);
    }

    public static boolean readBooleanAttribute(XmlPullParser in, String name, boolean defaultValue) {
        String value = in.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static void writeBooleanAttribute(XmlSerializer out, String name, boolean value) throws IOException {
        out.attribute(null, name, Boolean.toString(value));
    }

    public static Uri readUriAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        return value != null ? Uri.parse(value) : null;
    }

    public static void writeUriAttribute(XmlSerializer out, String name, Uri value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value.toString());
        }
    }

    public static String readStringAttribute(XmlPullParser in, String name) {
        return in.getAttributeValue(null, name);
    }

    public static void writeStringAttribute(XmlSerializer out, String name, String value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value);
        }
    }

    public static byte[] readByteArrayAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        if (value != null) {
            return Base64.decode(value, 0);
        }
        return null;
    }

    public static void writeByteArrayAttribute(XmlSerializer out, String name, byte[] value) throws IOException {
        if (value != null) {
            out.attribute(null, name, Base64.encodeToString(value, 0));
        }
    }

    public static Bitmap readBitmapAttribute(XmlPullParser in, String name) {
        byte[] value = XmlUtils.readByteArrayAttribute(in, name);
        if (value != null) {
            return BitmapFactory.decodeByteArray(value, 0, value.length);
        }
        return null;
    }

    @Deprecated
    public static void writeBitmapAttribute(XmlSerializer out, String name, Bitmap value) throws IOException {
        if (value != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            value.compress(Bitmap.CompressFormat.PNG, 90, os);
            XmlUtils.writeByteArrayAttribute(out, name, os.toByteArray());
        }
    }

    public static interface ReadMapCallback {
        public Object readThisUnknownObjectXml(XmlPullParser var1, String var2) throws XmlPullParserException, IOException;
    }

    public static interface WriteMapCallback {
        public void writeUnknownObject(Object var1, String var2, XmlSerializer var3) throws XmlPullParserException, IOException;
    }
}

