/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.VectorDrawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ImageUtils;
import java.util.Arrays;
import java.util.WeakHashMap;

public class NotificationColorUtil {
    private static final String TAG = "NotificationColorUtil";
    private static final Object sLock = new Object();
    private static NotificationColorUtil sInstance;
    private final ImageUtils mImageUtils = new ImageUtils();
    private final WeakHashMap<Bitmap, Pair<Boolean, Integer>> mGrayscaleBitmapCache = new WeakHashMap();
    private final int mGrayscaleIconMaxSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationColorUtil getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new NotificationColorUtil(context);
            }
            return sInstance;
        }
    }

    private NotificationColorUtil(Context context) {
        this.mGrayscaleIconMaxSize = context.getResources().getDimensionPixelSize(0x1050005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGrayscaleIcon(Bitmap bitmap) {
        int generationId;
        boolean result;
        if (bitmap.getWidth() > this.mGrayscaleIconMaxSize || bitmap.getHeight() > this.mGrayscaleIconMaxSize) {
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            Pair<Boolean, Integer> cached = this.mGrayscaleBitmapCache.get(bitmap);
            if (cached != null && ((Integer)cached.second).intValue() == bitmap.getGenerationId()) {
                return (Boolean)cached.first;
            }
        }
        Object object2 = this.mImageUtils;
        synchronized (object2) {
            result = this.mImageUtils.isGrayscale(bitmap);
            generationId = bitmap.getGenerationId();
        }
        object2 = sLock;
        synchronized (object2) {
            this.mGrayscaleBitmapCache.put(bitmap, Pair.create(result, generationId));
        }
        return result;
    }

    public boolean isGrayscaleIcon(Drawable d) {
        if (d == null) {
            return false;
        }
        if (d instanceof BitmapDrawable) {
            BitmapDrawable bd = (BitmapDrawable)d;
            return bd.getBitmap() != null && this.isGrayscaleIcon(bd.getBitmap());
        }
        if (d instanceof AnimationDrawable) {
            AnimationDrawable ad = (AnimationDrawable)d;
            int count = ad.getNumberOfFrames();
            return count > 0 && this.isGrayscaleIcon(ad.getFrame(0));
        }
        return d instanceof VectorDrawable;
    }

    public boolean isGrayscaleIcon(Context context, Icon icon) {
        if (icon == null) {
            return false;
        }
        switch (icon.getType()) {
            case 1: {
                return this.isGrayscaleIcon(icon.getBitmap());
            }
            case 2: {
                return this.isGrayscaleIcon(context, icon.getResId());
            }
        }
        return false;
    }

    public boolean isGrayscaleIcon(Context context, int drawableResId) {
        if (drawableResId != 0) {
            try {
                return this.isGrayscaleIcon(context.getDrawable(drawableResId));
            }
            catch (Resources.NotFoundException ex) {
                Log.e(TAG, "Drawable not found: " + drawableResId);
                return false;
            }
        }
        return false;
    }

    public CharSequence invertCharSequenceColors(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            Object[] arr$ = spans;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Object span;
                Object resultSpan = span = arr$[i$];
                if (span instanceof TextAppearanceSpan) {
                    resultSpan = this.processTextAppearanceSpan((TextAppearanceSpan)span);
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private TextAppearanceSpan processTextAppearanceSpan(TextAppearanceSpan span) {
        ColorStateList colorStateList = span.getTextColor();
        if (colorStateList != null) {
            int[] colors = colorStateList.getColors();
            boolean changed = false;
            for (int i = 0; i < colors.length; ++i) {
                if (!ImageUtils.isGrayscale(colors[i])) continue;
                if (!changed) {
                    colors = Arrays.copyOf(colors, colors.length);
                }
                colors[i] = this.processColor(colors[i]);
                changed = true;
            }
            if (changed) {
                return new TextAppearanceSpan(span.getFamily(), span.getTextStyle(), span.getTextSize(), new ColorStateList(colorStateList.getStates(), colors), span.getLinkTextColor());
            }
        }
        return span;
    }

    private int processColor(int color2) {
        return Color.argb(Color.alpha(color2), 255 - Color.red(color2), 255 - Color.green(color2), 255 - Color.blue(color2));
    }
}

