/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Debug;
import android.os.StrictMode;

public class MemInfoReader {
    final long[] mInfos = new long[13];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMemInfo() {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        try {
            Debug.getMemInfo(this.mInfos);
        }
        finally {
            StrictMode.setThreadPolicy(savedPolicy);
        }
    }

    public long getTotalSize() {
        return this.mInfos[0] * 1024L;
    }

    public long getFreeSize() {
        return this.mInfos[1] * 1024L;
    }

    public long getCachedSize() {
        return this.getCachedSizeKb() * 1024L;
    }

    public long getKernelUsedSize() {
        return this.getKernelUsedSizeKb() * 1024L;
    }

    public long getTotalSizeKb() {
        return this.mInfos[0];
    }

    public long getFreeSizeKb() {
        return this.mInfos[1];
    }

    public long getCachedSizeKb() {
        return this.mInfos[2] + this.mInfos[3] - this.mInfos[9];
    }

    public long getKernelUsedSizeKb() {
        return this.mInfos[4] + this.mInfos[5] + this.mInfos[10] + this.mInfos[11] + this.mInfos[12];
    }

    public long getSwapTotalSizeKb() {
        return this.mInfos[6];
    }

    public long getSwapFreeSizeKb() {
        return this.mInfos[7];
    }

    public long getZramTotalSizeKb() {
        return this.mInfos[8];
    }

    public long[] getRawInfo() {
        return this.mInfos;
    }
}

