/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.session.MediaController;
import android.media.session.MediaSessionLegacyHelper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.FloatingActionMode;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.StandaloneActionMode;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.IconMenuPresenter;
import com.android.internal.view.menu.ListMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.BackgroundFallback;
import com.android.internal.widget.DecorContentParent;
import com.android.internal.widget.FloatingToolbar;
import com.android.internal.widget.SwipeDismissLayout;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PhoneWindow
extends Window
implements MenuBuilder.Callback {
    private static final String TAG = "PhoneWindow";
    private static final boolean SWEEP_OPEN_MENU = false;
    private static final int DEFAULT_BACKGROUND_FADE_DURATION_MS = 300;
    private static final int CUSTOM_TITLE_COMPATIBLE_FEATURES = 13505;
    private static final Transition USE_DEFAULT_TRANSITION = new TransitionSet();
    final DialogMenuCallback mContextMenuCallback = new DialogMenuCallback(6);
    final TypedValue mMinWidthMajor = new TypedValue();
    final TypedValue mMinWidthMinor = new TypedValue();
    TypedValue mFixedWidthMajor;
    TypedValue mFixedWidthMinor;
    TypedValue mFixedHeightMajor;
    TypedValue mFixedHeightMinor;
    private DecorView mDecor;
    private ViewGroup mContentParent;
    private ViewGroup mContentRoot;
    SurfaceHolder.Callback2 mTakeSurfaceCallback;
    InputQueue.Callback mTakeInputQueueCallback;
    private boolean mIsFloating;
    private LayoutInflater mLayoutInflater;
    private TextView mTitleView;
    private DecorContentParent mDecorContentParent;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    private TransitionManager mTransitionManager;
    private Scene mContentScene;
    static final int FLAG_RESOURCE_SET_ICON = 1;
    static final int FLAG_RESOURCE_SET_LOGO = 2;
    static final int FLAG_RESOURCE_SET_ICON_FALLBACK = 4;
    int mResourcesSetFlags;
    int mIconRes;
    int mLogoRes;
    private DrawableFeatureState[] mDrawables;
    private PanelFeatureState[] mPanels;
    private PanelFeatureState mPreparedPanel;
    private int mPanelChordingKey;
    private ImageView mLeftIconView;
    private ImageView mRightIconView;
    private ProgressBar mCircularProgressBar;
    private ProgressBar mHorizontalProgressBar;
    private int mBackgroundResource = 0;
    private int mBackgroundFallbackResource = 0;
    private Drawable mBackgroundDrawable;
    private float mElevation;
    private boolean mClipToOutline;
    private int mFrameResource = 0;
    private int mTextColor = 0;
    private int mStatusBarColor = 0;
    private int mNavigationBarColor = 0;
    private boolean mForcedStatusBarColor = false;
    private boolean mForcedNavigationBarColor = false;
    private CharSequence mTitle = null;
    private int mTitleColor = 0;
    private boolean mAlwaysReadCloseOnTouchAttr = false;
    private ContextMenuBuilder mContextMenu;
    private MenuDialogHelper mContextMenuHelper;
    private boolean mClosingActionMenu;
    private int mVolumeControlStreamType = Integer.MIN_VALUE;
    private MediaController mMediaController;
    private AudioManager mAudioManager;
    private KeyguardManager mKeyguardManager;
    private int mUiOptions = 0;
    private boolean mInvalidatePanelMenuPosted;
    private int mInvalidatePanelMenuFeatures;
    private final Runnable mInvalidatePanelMenuRunnable = new Runnable(){

        @Override
        public void run() {
            for (int i = 0; i <= 13; ++i) {
                if ((PhoneWindow.this.mInvalidatePanelMenuFeatures & 1 << i) == 0) continue;
                PhoneWindow.this.doInvalidatePanelMenu(i);
            }
            PhoneWindow.this.mInvalidatePanelMenuPosted = false;
            PhoneWindow.this.mInvalidatePanelMenuFeatures = 0;
        }
    };
    private Transition mEnterTransition = null;
    private Transition mReturnTransition = USE_DEFAULT_TRANSITION;
    private Transition mExitTransition = null;
    private Transition mReenterTransition = USE_DEFAULT_TRANSITION;
    private Transition mSharedElementEnterTransition = null;
    private Transition mSharedElementReturnTransition = USE_DEFAULT_TRANSITION;
    private Transition mSharedElementExitTransition = null;
    private Transition mSharedElementReenterTransition = USE_DEFAULT_TRANSITION;
    private Boolean mAllowReturnTransitionOverlap;
    private Boolean mAllowEnterTransitionOverlap;
    private long mBackgroundFadeDurationMillis = -1L;
    private Boolean mSharedElementsUseOverlay;
    private Rect mTempRect;
    private Rect mOutsets = new Rect();
    private boolean mIsStartingWindow;
    static final RotationWatcher sRotationWatcher = new RotationWatcher();
    private static final String FOCUSED_ID_TAG = "android:focusedViewId";
    private static final String VIEWS_TAG = "android:views";
    private static final String PANELS_TAG = "android:Panels";
    private static final String ACTION_BAR_TAG = "android:ActionBar";

    public PhoneWindow(Context context) {
        super(context);
        this.mLayoutInflater = LayoutInflater.from(context);
    }

    @Override
    public void setContainer(Window container) {
        super.setContainer(container);
    }

    @Override
    public boolean requestFeature(int featureId) {
        if (this.mContentParent != null) {
            throw new AndroidRuntimeException("requestFeature() must be called before adding content");
        }
        int features = this.getFeatures();
        int newFeatures = features | 1 << featureId;
        if ((newFeatures & 0x80) != 0 && (newFeatures & 0xFFFFCB3E) != 0) {
            throw new AndroidRuntimeException("You cannot combine custom titles with other title features");
        }
        if ((features & 2) != 0 && featureId == 8) {
            return false;
        }
        if ((features & 0x100) != 0 && featureId == 1) {
            this.removeFeature(8);
        }
        if ((features & 0x100) != 0 && featureId == 11) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if ((features & 0x800) != 0 && featureId == 8) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if (featureId == 5 && this.getContext().getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
            throw new AndroidRuntimeException("You cannot use indeterminate progress on a watch.");
        }
        return super.requestFeature(featureId);
    }

    @Override
    public void setUiOptions(int uiOptions) {
        this.mUiOptions = uiOptions;
    }

    @Override
    public void setUiOptions(int uiOptions, int mask) {
        this.mUiOptions = this.mUiOptions & ~mask | uiOptions & mask;
    }

    @Override
    public TransitionManager getTransitionManager() {
        return this.mTransitionManager;
    }

    @Override
    public void setTransitionManager(TransitionManager tm) {
        this.mTransitionManager = tm;
    }

    @Override
    public Scene getContentScene() {
        return this.mContentScene;
    }

    @Override
    public void setContentView(int layoutResID) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            Scene newScene = Scene.getSceneForLayout(this.mContentParent, layoutResID, this.getContext());
            this.transitionTo(newScene);
        } else {
            this.mLayoutInflater.inflate(layoutResID, this.mContentParent);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    @Override
    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            view.setLayoutParams(params);
            Scene newScene = new Scene(this.mContentParent, view);
            this.transitionTo(newScene);
        } else {
            this.mContentParent.addView(view, params);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        }
        if (this.hasFeature(12)) {
            Log.v(TAG, "addContentView does not support content transitions");
        }
        this.mContentParent.addView(view, params);
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    private void transitionTo(Scene scene) {
        if (this.mContentScene == null) {
            scene.enter();
        } else {
            this.mTransitionManager.transitionTo(scene);
        }
        this.mContentScene = scene;
    }

    @Override
    public View getCurrentFocus() {
        return this.mDecor != null ? this.mDecor.findFocus() : null;
    }

    @Override
    public void takeSurface(SurfaceHolder.Callback2 callback) {
        this.mTakeSurfaceCallback = callback;
    }

    @Override
    public void takeInputQueue(InputQueue.Callback callback) {
        this.mTakeInputQueueCallback = callback;
    }

    @Override
    public boolean isFloating() {
        return this.mIsFloating;
    }

    @Override
    public LayoutInflater getLayoutInflater() {
        return this.mLayoutInflater;
    }

    @Override
    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        } else if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setWindowTitle(title);
        }
        this.mTitle = title;
    }

    @Override
    @Deprecated
    public void setTitleColor(int textColor) {
        if (this.mTitleView != null) {
            this.mTitleView.setTextColor(textColor);
        }
        this.mTitleColor = textColor;
    }

    public boolean preparePanel(PanelFeatureState st, KeyEvent event) {
        boolean isActionBarMenu;
        Window.Callback cb;
        if (this.isDestroyed()) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        if ((cb = this.getCallback()) != null) {
            st.createdPanelView = cb.onCreatePanelView(st.featureId);
        }
        boolean bl = isActionBarMenu = st.featureId == 0 || st.featureId == 8;
        if (isActionBarMenu && this.mDecorContentParent != null) {
            this.mDecorContentParent.setMenuPrepared();
        }
        if (st.createdPanelView == null) {
            if (st.menu == null || st.refreshMenuContent) {
                if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                    return false;
                }
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                    }
                    this.mDecorContentParent.setMenu(st.menu, this.mActionMenuPresenterCallback);
                }
                st.menu.stopDispatchingItemsChanged();
                if (cb == null || !cb.onCreatePanelMenu(st.featureId, st.menu)) {
                    st.setMenu(null);
                    if (isActionBarMenu && this.mDecorContentParent != null) {
                        this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                st.refreshMenuContent = false;
            }
            st.menu.stopDispatchingItemsChanged();
            if (st.frozenActionViewState != null) {
                st.menu.restoreActionViewStates(st.frozenActionViewState);
                st.frozenActionViewState = null;
            }
            if (!cb.onPreparePanel(st.featureId, st.createdPanelView, st.menu)) {
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                }
                st.menu.startDispatchingItemsChanged();
                return false;
            }
            KeyCharacterMap kmap = KeyCharacterMap.load(event != null ? event.getDeviceId() : -1);
            st.qwertyMode = kmap.getKeyboardType() != 1;
            st.menu.setQwertyMode(st.qwertyMode);
            st.menu.startDispatchingItemsChanged();
        }
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        PanelFeatureState st;
        if (this.mDecorContentParent == null && (st = this.getPanelState(0, false)) != null && st.menu != null) {
            if (st.isOpen) {
                Bundle state = new Bundle();
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.saveHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.saveHierarchyState(state);
                }
                PhoneWindow.clearMenuViews(st);
                this.reopenMenu(false);
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.restoreHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.restoreHierarchyState(state);
                }
            } else {
                PhoneWindow.clearMenuViews(st);
            }
        }
    }

    private static void clearMenuViews(PanelFeatureState st) {
        st.createdPanelView = null;
        st.refreshDecorView = true;
        st.clearMenuPresenters();
    }

    @Override
    public void openPanel(int featureId, KeyEvent event) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.showOverflowMenu();
        } else {
            this.openPanel(this.getPanelState(featureId, true), event);
        }
    }

    private void openPanel(PanelFeatureState st, KeyEvent event) {
        ViewGroup.LayoutParams lp;
        Window.Callback cb;
        if (st.isOpen || this.isDestroyed()) {
            return;
        }
        if (st.featureId == 0) {
            boolean isHoneycombApp;
            Context context = this.getContext();
            Configuration config = context.getResources().getConfiguration();
            boolean isXLarge = (config.screenLayout & 0xF) == 4;
            boolean bl = isHoneycombApp = context.getApplicationInfo().targetSdkVersion >= 11;
            if (isXLarge && isHoneycombApp) {
                return;
            }
        }
        if ((cb = this.getCallback()) != null && !cb.onMenuOpened(st.featureId, st.menu)) {
            this.closePanel(st, true);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        int width = -2;
        if (st.decorView == null || st.refreshDecorView) {
            int backgroundResId;
            if (st.decorView == null) {
                if (!this.initializePanelDecor(st) || st.decorView == null) {
                    return;
                }
            } else if (st.refreshDecorView && st.decorView.getChildCount() > 0) {
                st.decorView.removeAllViews();
            }
            if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
                return;
            }
            ViewGroup.LayoutParams lp2 = st.shownPanelView.getLayoutParams();
            if (lp2 == null) {
                lp2 = new ViewGroup.LayoutParams(-2, -2);
            }
            if (lp2.width == -1) {
                backgroundResId = st.fullBackground;
                width = -1;
            } else {
                backgroundResId = st.background;
            }
            st.decorView.setWindowBackground(this.getContext().getDrawable(backgroundResId));
            ViewParent shownPanelParent = st.shownPanelView.getParent();
            if (shownPanelParent != null && shownPanelParent instanceof ViewGroup) {
                ((ViewGroup)shownPanelParent).removeView(st.shownPanelView);
            }
            st.decorView.addView(st.shownPanelView, lp2);
            if (!st.shownPanelView.hasFocus()) {
                st.shownPanelView.requestFocus();
            }
        } else if (!st.isInListMode()) {
            width = -1;
        } else if (st.createdPanelView != null && (lp = st.createdPanelView.getLayoutParams()) != null && lp.width == -1) {
            width = -1;
        }
        st.isHandled = false;
        WindowManager.LayoutParams lp2 = new WindowManager.LayoutParams(width, -2, st.x, st.y, 1003, 0x820000, st.decorView.mDefaultOpacity);
        if (st.isCompact) {
            lp2.gravity = this.getOptionsPanelGravity();
            sRotationWatcher.addWindow(this);
        } else {
            lp2.gravity = st.gravity;
        }
        lp2.windowAnimations = st.windowAnimations;
        wm.addView(st.decorView, lp2);
        st.isOpen = true;
    }

    @Override
    public void closePanel(int featureId) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.hideOverflowMenu();
        } else if (featureId == 6) {
            this.closeContextMenu();
        } else {
            this.closePanel(this.getPanelState(featureId, true), true);
        }
    }

    public void closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(st.menu);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm != null && st.isOpen) {
            if (st.decorView != null) {
                wm.removeView(st.decorView);
                if (st.isCompact) {
                    sRotationWatcher.removeWindow(this);
                }
            }
            if (doCallback) {
                this.callOnPanelClosed(st.featureId, st, null);
            }
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        if (st.isInExpandedMode) {
            st.refreshDecorView = true;
            st.isInExpandedMode = false;
        }
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
            this.mPanelChordingKey = 0;
        }
    }

    void checkCloseActionMenu(Menu menu2) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onPanelClosed(8, menu2);
        }
        this.mClosingActionMenu = false;
    }

    @Override
    public void togglePanel(int featureId, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (st.isOpen) {
            this.closePanel(st, true);
        } else {
            this.openPanel(st, event);
        }
    }

    @Override
    public void invalidatePanelMenu(int featureId) {
        this.mInvalidatePanelMenuFeatures |= 1 << featureId;
        if (!this.mInvalidatePanelMenuPosted && this.mDecor != null) {
            this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    void doPendingInvalidatePanelMenu() {
        if (this.mInvalidatePanelMenuPosted) {
            this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuRunnable.run();
        }
    }

    void doInvalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, false);
        if (st == null) {
            return;
        }
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 8 || featureId == 0) && this.mDecorContentParent != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    public boolean onKeyDownPanel(int featureId, KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getRepeatCount() == 0) {
            this.mPanelChordingKey = keyCode;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (st != null && !st.isOpen) {
                return this.preparePanel(st, event);
            }
        }
        return false;
    }

    public void onKeyUpPanel(int featureId, KeyEvent event) {
        if (this.mPanelChordingKey != 0) {
            this.mPanelChordingKey = 0;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (event.isCanceled() || this.mDecor != null && this.mDecor.mPrimaryActionMode != null || st == null) {
                return;
            }
            boolean playSoundEffect = false;
            if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
                if (!this.mDecorContentParent.isOverflowMenuShowing()) {
                    if (!this.isDestroyed() && this.preparePanel(st, event)) {
                        playSoundEffect = this.mDecorContentParent.showOverflowMenu();
                    }
                } else {
                    playSoundEffect = this.mDecorContentParent.hideOverflowMenu();
                }
            } else if (st.isOpen || st.isHandled) {
                playSoundEffect = st.isOpen;
                this.closePanel(st, true);
            } else if (st.isPrepared) {
                boolean show = true;
                if (st.refreshMenuContent) {
                    st.isPrepared = false;
                    show = this.preparePanel(st, event);
                }
                if (show) {
                    EventLog.writeEvent(50001, 0);
                    this.openPanel(st, event);
                    playSoundEffect = true;
                }
            }
            if (playSoundEffect) {
                AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
                if (audioManager != null) {
                    audioManager.playSoundEffect(0);
                } else {
                    Log.w(TAG, "Couldn't get audio manager");
                }
            }
        }
    }

    @Override
    public void closeAllPanels() {
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null) continue;
            this.closePanel(panel, true);
        }
        this.closeContextMenu();
    }

    private synchronized void closeContextMenu() {
        if (this.mContextMenu != null) {
            this.mContextMenu.close();
            this.dismissContextMenu();
        }
    }

    private synchronized void dismissContextMenu() {
        this.mContextMenu = null;
        if (this.mContextMenuHelper != null) {
            this.mContextMenuHelper.dismiss();
            this.mContextMenuHelper = null;
        }
    }

    @Override
    public boolean performPanelShortcut(int featureId, int keyCode, KeyEvent event, int flags) {
        return this.performPanelShortcut(this.getPanelState(featureId, false), keyCode, event, flags);
    }

    private boolean performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem() || st == null) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled) {
            st.isHandled = true;
            if ((flags & 1) == 0 && this.mDecorContentParent == null) {
                this.closePanel(st, true);
            }
        }
        return handled;
    }

    @Override
    public boolean performPanelIdentifierAction(int featureId, int id2, int flags) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (!this.preparePanel(st, new KeyEvent(0, 82))) {
            return false;
        }
        if (st.menu == null) {
            return false;
        }
        boolean res = st.menu.performIdentifierAction(id2, flags);
        if (this.mDecorContentParent == null) {
            this.closePanel(st, true);
        }
        return res;
    }

    public PanelFeatureState findMenuPanel(Menu menu2) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu2) continue;
            return panel;
        }
        return null;
    }

    @Override
    public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        PanelFeatureState panel;
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed() && (panel = this.findMenuPanel(menu2.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    @Override
    public void onMenuModeChange(MenuBuilder menu2) {
        this.reopenMenu(true);
    }

    private void reopenMenu(boolean toggleMenuMode) {
        if (this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && (!ViewConfiguration.get(this.getContext()).hasPermanentMenuKey() || this.mDecorContentParent.isOverflowMenuShowPending())) {
            Window.Callback cb = this.getCallback();
            if (!this.mDecorContentParent.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.isDestroyed()) {
                    PanelFeatureState st;
                    if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                        this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
                        this.mInvalidatePanelMenuRunnable.run();
                    }
                    if ((st = this.getPanelState(0, false)) != null && st.menu != null && !st.refreshMenuContent && cb.onPreparePanel(0, st.createdPanelView, st.menu)) {
                        cb.onMenuOpened(8, st.menu);
                        this.mDecorContentParent.showOverflowMenu();
                    }
                }
            } else {
                this.mDecorContentParent.hideOverflowMenu();
                PanelFeatureState st = this.getPanelState(0, false);
                if (st != null && cb != null && !this.isDestroyed()) {
                    cb.onPanelClosed(8, st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        boolean newExpandedMode = toggleMenuMode ? !st.isInExpandedMode : st.isInExpandedMode;
        st.refreshDecorView = true;
        this.closePanel(st, false);
        st.isInExpandedMode = newExpandedMode;
        this.openPanel(st, null);
    }

    protected boolean initializePanelMenu(PanelFeatureState st) {
        Context context = this.getContext();
        if ((st.featureId == 0 || st.featureId == 8) && this.mDecorContentParent != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme baseTheme = context.getTheme();
            baseTheme.resolveAttribute(16843825, outValue, true);
            Resources.Theme widgetTheme = null;
            if (outValue.resourceId != 0) {
                widgetTheme = context.getResources().newTheme();
                widgetTheme.setTo(baseTheme);
                widgetTheme.applyStyle(outValue.resourceId, true);
                widgetTheme.resolveAttribute(16843671, outValue, true);
            } else {
                baseTheme.resolveAttribute(16843671, outValue, true);
            }
            if (outValue.resourceId != 0) {
                if (widgetTheme == null) {
                    widgetTheme = context.getResources().newTheme();
                    widgetTheme.setTo(baseTheme);
                }
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            if (widgetTheme != null) {
                context = new ContextThemeWrapper(context, 0);
                context.getTheme().setTo(widgetTheme);
            }
        }
        MenuBuilder menu2 = new MenuBuilder(context);
        menu2.setCallback(this);
        st.setMenu(menu2);
        return true;
    }

    protected boolean initializePanelDecor(PanelFeatureState st) {
        st.decorView = new DecorView(this.getContext(), st.featureId);
        st.gravity = 81;
        st.setStyle(this.getContext());
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.Window, 0, st.listPresenterTheme);
        float elevation = a.getDimension(38, 0.0f);
        if (elevation != 0.0f) {
            st.decorView.setElevation(elevation);
        }
        a.recycle();
        return true;
    }

    private int getOptionsPanelGravity() {
        try {
            return WindowManagerHolder.sWindowManager.getPreferredOptionsPanelGravity();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Couldn't getOptionsPanelGravity; using default", ex);
            return 81;
        }
    }

    void onOptionsPanelRotationChanged() {
        WindowManager.LayoutParams lp;
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = lp = st.decorView != null ? (WindowManager.LayoutParams)st.decorView.getLayoutParams() : null;
        if (lp != null) {
            lp.gravity = this.getOptionsPanelGravity();
            WindowManager wm = this.getWindowManager();
            if (wm != null) {
                wm.updateViewLayout(st.decorView, lp);
            }
        }
    }

    protected boolean initializePanelContent(PanelFeatureState st) {
        if (st.createdPanelView != null) {
            st.shownPanelView = st.createdPanelView;
            return true;
        }
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        MenuView menuView = st.isInListMode() ? st.getListMenuView(this.getContext(), this.mPanelMenuPresenterCallback) : st.getIconMenuView(this.getContext(), this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)((Object)menuView);
        if (st.shownPanelView != null) {
            int defaultAnimations = menuView.getWindowAnimations();
            if (defaultAnimations != 0) {
                st.windowAnimations = defaultAnimations;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean performContextMenuIdentifierAction(int id2, int flags) {
        return this.mContextMenu != null ? this.mContextMenu.performIdentifierAction(id2, flags) : false;
    }

    @Override
    public void setElevation(float elevation) {
        this.mElevation = elevation;
        if (this.mDecor != null) {
            this.mDecor.setElevation(elevation);
        }
        this.dispatchWindowAttributesChanged(this.getAttributes());
    }

    @Override
    public void setClipToOutline(boolean clipToOutline) {
        this.mClipToOutline = clipToOutline;
        if (this.mDecor != null) {
            this.mDecor.setClipToOutline(clipToOutline);
        }
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != this.mBackgroundDrawable || this.mBackgroundResource != 0) {
            this.mBackgroundResource = 0;
            this.mBackgroundDrawable = drawable2;
            if (this.mDecor != null) {
                this.mDecor.setWindowBackground(drawable2);
            }
            if (this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(drawable2 != null ? 0 : this.mBackgroundFallbackResource);
            }
        }
    }

    @Override
    public void setFeatureDrawableResource(int featureId, int resId) {
        if (resId != 0) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.resid != resId) {
                st.resid = resId;
                st.uri = null;
                st.local = this.getContext().getDrawable(resId);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    @Override
    public void setFeatureDrawableUri(int featureId, Uri uri) {
        if (uri != null) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.uri == null || !st.uri.equals(uri)) {
                st.resid = 0;
                st.uri = uri;
                st.local = this.loadImageURI(uri);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    @Override
    public void setFeatureDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.resid = 0;
        st.uri = null;
        if (st.local != drawable2) {
            st.local = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    @Override
    public void setFeatureDrawableAlpha(int featureId, int alpha) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.alpha != alpha) {
            st.alpha = alpha;
            this.updateDrawable(featureId, st, false);
        }
    }

    protected void setFeatureDefaultDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.def != drawable2) {
            st.def = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    @Override
    public void setFeatureInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    protected void updateDrawable(int featureId, boolean fromActive) {
        DrawableFeatureState st = this.getDrawableState(featureId, false);
        if (st != null) {
            this.updateDrawable(featureId, st, fromActive);
        }
    }

    protected void onDrawableChanged(int featureId, Drawable drawable2, int alpha) {
        ImageView view;
        if (featureId == 3) {
            view = this.getLeftIconView();
        } else if (featureId == 4) {
            view = this.getRightIconView();
        } else {
            return;
        }
        if (drawable2 != null) {
            drawable2.setAlpha(alpha);
            view.setImageDrawable(drawable2);
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    protected void onIntChanged(int featureId, int value) {
        FrameLayout titleContainer;
        if (featureId == 2 || featureId == 5) {
            this.updateProgressBars(value);
        } else if (featureId == 7 && (titleContainer = (FrameLayout)this.findViewById(16908353)) != null) {
            this.mLayoutInflater.inflate(value, (ViewGroup)titleContainer);
        }
    }

    private void updateProgressBars(int value) {
        ProgressBar circularProgressBar = this.getCircularProgressBar(true);
        ProgressBar horizontalProgressBar = this.getHorizontalProgressBar(true);
        int features = this.getLocalFeatures();
        if (value == -1) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    int level = horizontalProgressBar.getProgress();
                    int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                    horizontalProgressBar.setVisibility(visibility);
                } else {
                    Log.e(TAG, "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(0);
                } else {
                    Log.e(TAG, "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -2) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    horizontalProgressBar.setVisibility(8);
                } else {
                    Log.e(TAG, "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(8);
                } else {
                    Log.e(TAG, "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -3) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(true);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
        } else if (value == -4) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(false);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
        } else if (0 <= value && value <= 10000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setProgress(value - 0);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        } else if (20000 <= value && value <= 30000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setSecondaryProgress(value - 20000);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
            this.showProgressBars(horizontalProgressBar, circularProgressBar);
        }
    }

    private void showProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private void hideProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        Animation anim2 = AnimationUtils.loadAnimation(this.getContext(), 0x10A0001);
        anim2.setDuration(1000L);
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.startAnimation(anim2);
            spinnyProgressBar.setVisibility(4);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.startAnimation(anim2);
            horizontalProgressBar.setVisibility(4);
        }
    }

    @Override
    public void setIcon(int resId) {
        this.mIconRes = resId;
        this.mResourcesSetFlags |= 1;
        this.mResourcesSetFlags &= 0xFFFFFFFB;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setIcon(resId);
        }
    }

    @Override
    public void setDefaultIcon(int resId) {
        if ((this.mResourcesSetFlags & 1) != 0) {
            return;
        }
        this.mIconRes = resId;
        if (!(this.mDecorContentParent == null || this.mDecorContentParent.hasIcon() && (this.mResourcesSetFlags & 4) == 0)) {
            if (resId != 0) {
                this.mDecorContentParent.setIcon(resId);
                this.mResourcesSetFlags &= 0xFFFFFFFB;
            } else {
                this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                this.mResourcesSetFlags |= 4;
            }
        }
    }

    @Override
    public void setLogo(int resId) {
        this.mLogoRes = resId;
        this.mResourcesSetFlags |= 2;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    @Override
    public void setDefaultLogo(int resId) {
        if ((this.mResourcesSetFlags & 2) != 0) {
            return;
        }
        this.mLogoRes = resId;
        if (this.mDecorContentParent != null && !this.mDecorContentParent.hasLogo()) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    @Override
    public void setLocalFocus(boolean hasFocus, boolean inTouchMode) {
        this.getViewRootImpl().windowFocusChanged(hasFocus, inTouchMode);
    }

    @Override
    public void injectInputEvent(InputEvent event) {
        this.getViewRootImpl().dispatchInputEvent(event);
    }

    private ViewRootImpl getViewRootImpl() {
        ViewRootImpl viewRootImpl;
        if (this.mDecor != null && (viewRootImpl = this.mDecor.getViewRootImpl()) != null) {
            return viewRootImpl;
        }
        throw new IllegalStateException("view not added");
    }

    @Override
    public void takeKeyEvents(boolean get) {
        this.mDecor.setFocusable(get);
    }

    @Override
    public boolean superDispatchKeyEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyEvent(event);
    }

    @Override
    public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyShortcutEvent(event);
    }

    @Override
    public boolean superDispatchTouchEvent(MotionEvent event) {
        return this.mDecor.superDispatchTouchEvent(event);
    }

    @Override
    public boolean superDispatchTrackballEvent(MotionEvent event) {
        return this.mDecor.superDispatchTrackballEvent(event);
    }

    @Override
    public boolean superDispatchGenericMotionEvent(MotionEvent event) {
        return this.mDecor.superDispatchGenericMotionEvent(event);
    }

    protected boolean onKeyDown(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                int direction = 0;
                switch (keyCode) {
                    case 24: {
                        direction = 1;
                        break;
                    }
                    case 25: {
                        direction = -1;
                        break;
                    }
                    case 164: {
                        direction = 101;
                    }
                }
                if (this.mMediaController != null) {
                    this.mMediaController.adjustVolume(direction, 1);
                } else {
                    MediaSessionLegacyHelper.getHelper(this.getContext()).sendAdjustVolumeBy(this.mVolumeControlStreamType, direction, 4113);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEvent(event);
            }
            case 82: {
                this.onKeyDownPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                if (event.getRepeatCount() > 0 || featureId < 0) break;
                if (dispatcher != null) {
                    dispatcher.startTracking(event, this);
                }
                return true;
            }
        }
        return false;
    }

    private KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    protected boolean onKeyUp(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher;
        KeyEvent.DispatcherState dispatcherState = dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: {
                int flags = 4116;
                if (this.mMediaController != null) {
                    this.mMediaController.adjustVolume(0, 4116);
                } else {
                    MediaSessionLegacyHelper.getHelper(this.getContext()).sendAdjustVolumeBy(this.mVolumeControlStreamType, 0, 4116);
                }
                return true;
            }
            case 164: {
                this.getAudioManager().handleKeyUp(event, this.mVolumeControlStreamType);
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEvent(event);
            }
            case 82: {
                this.onKeyUpPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                PanelFeatureState st;
                if (featureId < 0 || !event.isTracking() || event.isCanceled()) break;
                if (featureId == 0 && (st = this.getPanelState(featureId, false)) != null && st.isInExpandedMode) {
                    this.reopenMenu(true);
                    return true;
                }
                this.closePanel(featureId);
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.launchDefaultSearch(event);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onActive() {
    }

    @Override
    public View getDecorView() {
        if (this.mDecor == null) {
            this.installDecor();
        }
        return this.mDecor;
    }

    @Override
    public View peekDecorView() {
        return this.mDecor;
    }

    @Override
    public Bundle saveHierarchyState() {
        Bundle outState = new Bundle();
        if (this.mContentParent == null) {
            return outState;
        }
        SparseArray<Parcelable> states = new SparseArray<Parcelable>();
        this.mContentParent.saveHierarchyState(states);
        outState.putSparseParcelableArray(VIEWS_TAG, states);
        View focusedView = this.mContentParent.findFocus();
        if (focusedView != null && focusedView.getId() != -1) {
            outState.putInt(FOCUSED_ID_TAG, focusedView.getId());
        }
        SparseArray<Parcelable> panelStates = new SparseArray<Parcelable>();
        this.savePanelState(panelStates);
        if (panelStates.size() > 0) {
            outState.putSparseParcelableArray(PANELS_TAG, panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = new SparseArray<Parcelable>();
            this.mDecorContentParent.saveToolbarHierarchyState(actionBarStates);
            outState.putSparseParcelableArray(ACTION_BAR_TAG, actionBarStates);
        }
        return outState;
    }

    @Override
    public void restoreHierarchyState(Bundle savedInstanceState) {
        SparseArray<Parcelable> panelStates;
        int focusedViewId;
        if (this.mContentParent == null) {
            return;
        }
        SparseArray<Parcelable> savedStates = savedInstanceState.getSparseParcelableArray(VIEWS_TAG);
        if (savedStates != null) {
            this.mContentParent.restoreHierarchyState(savedStates);
        }
        if ((focusedViewId = savedInstanceState.getInt(FOCUSED_ID_TAG, -1)) != -1) {
            View needsFocus = this.mContentParent.findViewById(focusedViewId);
            if (needsFocus != null) {
                needsFocus.requestFocus();
            } else {
                Log.w(TAG, "Previously focused view reported id " + focusedViewId + " during save, but can't be found during restore.");
            }
        }
        if ((panelStates = savedInstanceState.getSparseParcelableArray(PANELS_TAG)) != null) {
            this.restorePanelState(panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = savedInstanceState.getSparseParcelableArray(ACTION_BAR_TAG);
            if (actionBarStates != null) {
                this.doPendingInvalidatePanelMenu();
                this.mDecorContentParent.restoreToolbarHierarchyState(actionBarStates);
            } else {
                Log.w(TAG, "Missing saved instance states for action bar views! State will not be restored.");
            }
        }
    }

    private void savePanelState(SparseArray<Parcelable> icicles) {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int curFeatureId = panels.length - 1; curFeatureId >= 0; --curFeatureId) {
            if (panels[curFeatureId] == null) continue;
            icicles.put(curFeatureId, panels[curFeatureId].onSaveInstanceState());
        }
    }

    private void restorePanelState(SparseArray<Parcelable> icicles) {
        for (int i = icicles.size() - 1; i >= 0; --i) {
            int curFeatureId = icicles.keyAt(i);
            PanelFeatureState st = this.getPanelState(curFeatureId, false);
            if (st == null) continue;
            st.onRestoreInstanceState(icicles.get(curFeatureId));
            this.invalidatePanelMenu(curFeatureId);
        }
    }

    private void openPanelsAfterRestore() {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int i = panels.length - 1; i >= 0; --i) {
            PanelFeatureState st = panels[i];
            if (st == null) continue;
            st.applyFrozenState();
            if (st.isOpen || !st.wasLastOpen) continue;
            st.isInExpandedMode = st.wasLastExpanded;
            this.openPanel(st, null);
        }
    }

    protected DecorView generateDecor() {
        return new DecorView(this.getContext(), -1);
    }

    protected void setFeatureFromAttrs(int featureId, TypedArray attrs, int drawableAttr, int alphaAttr) {
        int alpha;
        Drawable d = attrs.getDrawable(drawableAttr);
        if (d != null) {
            this.requestFeature(featureId);
            this.setFeatureDefaultDrawable(featureId, d);
        }
        if ((this.getFeatures() & 1 << featureId) != 0 && (alpha = attrs.getInt(alphaAttr, -1)) >= 0) {
            this.setFeatureDrawableAlpha(featureId, alpha);
        }
    }

    protected ViewGroup generateLayout(DecorView decor) {
        ProgressBar progress;
        TypedValue res;
        int layoutResource;
        int features;
        boolean noActionBar;
        TypedArray a = this.getWindowStyle();
        this.mIsFloating = a.getBoolean(4, false);
        int flagsToUpdate = 0x10100 & ~this.getForcedWindowFlags();
        if (this.mIsFloating) {
            this.setLayout(-2, -2);
            this.setFlags(0, flagsToUpdate);
        } else {
            this.setFlags(65792, flagsToUpdate);
        }
        if (a.getBoolean(3, false)) {
            this.requestFeature(1);
        } else if (a.getBoolean(15, false)) {
            this.requestFeature(8);
        }
        if (a.getBoolean(17, false)) {
            this.requestFeature(9);
        }
        if (a.getBoolean(16, false)) {
            this.requestFeature(10);
        }
        if (a.getBoolean(25, false)) {
            this.requestFeature(11);
        }
        if (a.getBoolean(9, false)) {
            this.setFlags(1024, 0x400 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(23, false)) {
            this.setFlags(0x4000000, 0x4000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(24, false)) {
            this.setFlags(0x8000000, 0x8000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(22, false)) {
            this.setFlags(0x2000000, 0x2000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(14, false)) {
            this.setFlags(0x100000, 0x100000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(18, this.getContext().getApplicationInfo().targetSdkVersion >= 11)) {
            this.setFlags(0x800000, 0x800000 & ~this.getForcedWindowFlags());
        }
        a.getValue(19, this.mMinWidthMajor);
        a.getValue(20, this.mMinWidthMinor);
        if (a.hasValue(49)) {
            if (this.mFixedWidthMajor == null) {
                this.mFixedWidthMajor = new TypedValue();
            }
            a.getValue(49, this.mFixedWidthMajor);
        }
        if (a.hasValue(51)) {
            if (this.mFixedWidthMinor == null) {
                this.mFixedWidthMinor = new TypedValue();
            }
            a.getValue(51, this.mFixedWidthMinor);
        }
        if (a.hasValue(52)) {
            if (this.mFixedHeightMajor == null) {
                this.mFixedHeightMajor = new TypedValue();
            }
            a.getValue(52, this.mFixedHeightMajor);
        }
        if (a.hasValue(50)) {
            if (this.mFixedHeightMinor == null) {
                this.mFixedHeightMinor = new TypedValue();
            }
            a.getValue(50, this.mFixedHeightMinor);
        }
        if (a.getBoolean(26, false)) {
            this.requestFeature(12);
        }
        if (a.getBoolean(45, false)) {
            this.requestFeature(13);
        }
        Context context = this.getContext();
        int targetSdk = context.getApplicationInfo().targetSdkVersion;
        boolean targetPreHoneycomb = targetSdk < 11;
        boolean targetPreIcs = targetSdk < 14;
        boolean targetPreL = targetSdk < 21;
        boolean targetHcNeedsOptions = context.getResources().getBoolean(17956873);
        boolean bl = noActionBar = !this.hasFeature(8) || this.hasFeature(1);
        if (targetPreHoneycomb || targetPreIcs && targetHcNeedsOptions && noActionBar) {
            this.setNeedsMenuKey(1);
        } else {
            this.setNeedsMenuKey(2);
        }
        if (!this.mIsFloating && ActivityManager.isHighEndGfx() && !targetPreL && a.getBoolean(34, false)) {
            this.setFlags(Integer.MIN_VALUE, Integer.MIN_VALUE & ~this.getForcedWindowFlags());
        }
        if (!this.mForcedStatusBarColor) {
            this.mStatusBarColor = a.getColor(35, -16777216);
        }
        if (!this.mForcedNavigationBarColor) {
            this.mNavigationBarColor = a.getColor(36, -16777216);
        }
        if (a.getBoolean(46, false)) {
            decor.setSystemUiVisibility(decor.getSystemUiVisibility() | 0x2000);
        }
        if ((this.mAlwaysReadCloseOnTouchAttr || this.getContext().getApplicationInfo().targetSdkVersion >= 11) && a.getBoolean(21, false)) {
            this.setCloseOnTouchOutsideIfNotSet(true);
        }
        WindowManager.LayoutParams params = this.getAttributes();
        if (!this.hasSoftInputMode()) {
            params.softInputMode = a.getInt(13, params.softInputMode);
        }
        if (a.getBoolean(11, this.mIsFloating)) {
            if ((this.getForcedWindowFlags() & 2) == 0) {
                params.flags |= 2;
            }
            if (!this.haveDimAmount()) {
                params.dimAmount = a.getFloat(0, 0.5f);
            }
        }
        if (params.windowAnimations == 0) {
            params.windowAnimations = a.getResourceId(8, 0);
        }
        if (this.getContainer() == null) {
            if (this.mBackgroundDrawable == null) {
                if (this.mBackgroundResource == 0) {
                    this.mBackgroundResource = a.getResourceId(1, 0);
                }
                if (this.mFrameResource == 0) {
                    this.mFrameResource = a.getResourceId(2, 0);
                }
                this.mBackgroundFallbackResource = a.getResourceId(47, 0);
            }
            this.mElevation = a.getDimension(38, 0.0f);
            this.mClipToOutline = a.getBoolean(39, false);
            this.mTextColor = a.getColor(7, 0);
        }
        if (((features = this.getLocalFeatures()) & 0x800) != 0) {
            layoutResource = 17367243;
        } else if ((features & 0x18) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(18219050, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367245;
            }
            this.removeFeature(8);
        } else if ((features & 0x24) != 0 && (features & 0x100) == 0) {
            layoutResource = 17367240;
        } else if ((features & 0x80) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(18219051, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367239;
            }
            this.removeFeature(8);
        } else if ((features & 2) == 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(18219052, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = (features & 0x100) != 0 ? a.getResourceId(48, 17367238) : 17367244;
            }
        } else {
            layoutResource = (features & 0x400) != 0 ? 17367242 : 17367241;
        }
        this.mDecor.startChanging();
        View in = this.mLayoutInflater.inflate(layoutResource, null);
        decor.addView(in, new ViewGroup.LayoutParams(-1, -1));
        this.mContentRoot = (ViewGroup)in;
        ViewGroup contentParent = (ViewGroup)this.findViewById(0x1020002);
        if (contentParent == null) {
            throw new RuntimeException("Window couldn't find content container view");
        }
        if ((features & 0x20) != 0 && (progress = this.getCircularProgressBar(false)) != null) {
            progress.setIndeterminate(true);
        }
        if ((features & 0x800) != 0) {
            this.registerSwipeCallbacks();
        }
        if (this.getContainer() == null) {
            Drawable background = this.mBackgroundResource != 0 ? this.getContext().getDrawable(this.mBackgroundResource) : this.mBackgroundDrawable;
            this.mDecor.setWindowBackground(background);
            Drawable frame = this.mFrameResource != 0 ? this.getContext().getDrawable(this.mFrameResource) : null;
            this.mDecor.setWindowFrame(frame);
            this.mDecor.setElevation(this.mElevation);
            this.mDecor.setClipToOutline(this.mClipToOutline);
            if (this.mTitle != null) {
                this.setTitle(this.mTitle);
            }
            if (this.mTitleColor == 0) {
                this.mTitleColor = this.mTextColor;
            }
            this.setTitleColor(this.mTitleColor);
        }
        this.mDecor.finishChanging();
        return contentParent;
    }

    @Override
    public void alwaysReadCloseOnTouchAttr() {
        this.mAlwaysReadCloseOnTouchAttr = true;
    }

    private void installDecor() {
        if (this.mDecor == null) {
            this.mDecor = this.generateDecor();
            this.mDecor.setDescendantFocusability(262144);
            this.mDecor.setIsRootNamespace(true);
            if (!this.mInvalidatePanelMenuPosted && this.mInvalidatePanelMenuFeatures != 0) {
                this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            }
        }
        if (this.mContentParent == null) {
            this.mContentParent = this.generateLayout(this.mDecor);
            this.mDecor.makeOptionalFitsSystemWindows();
            DecorContentParent decorContentParent = (DecorContentParent)((Object)this.mDecor.findViewById(16909230));
            if (decorContentParent != null) {
                this.mDecorContentParent = decorContentParent;
                this.mDecorContentParent.setWindowCallback(this.getCallback());
                if (this.mDecorContentParent.getTitle() == null) {
                    this.mDecorContentParent.setWindowTitle(this.mTitle);
                }
                int localFeatures = this.getLocalFeatures();
                for (int i = 0; i < 13; ++i) {
                    if ((localFeatures & 1 << i) == 0) continue;
                    this.mDecorContentParent.initFeature(i);
                }
                this.mDecorContentParent.setUiOptions(this.mUiOptions);
                if ((this.mResourcesSetFlags & 1) != 0 || this.mIconRes != 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.mIconRes);
                } else if ((this.mResourcesSetFlags & 1) == 0 && this.mIconRes == 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                    this.mResourcesSetFlags |= 4;
                }
                if ((this.mResourcesSetFlags & 2) != 0 || this.mLogoRes != 0 && !this.mDecorContentParent.hasLogo()) {
                    this.mDecorContentParent.setLogo(this.mLogoRes);
                }
                PanelFeatureState st = this.getPanelState(0, false);
                if (!(this.isDestroyed() || st != null && st.menu != null || this.mIsStartingWindow)) {
                    this.invalidatePanelMenu(8);
                }
            } else {
                this.mTitleView = (TextView)this.findViewById(16908310);
                if (this.mTitleView != null) {
                    this.mTitleView.setLayoutDirection(this.mDecor.getLayoutDirection());
                    if ((this.getLocalFeatures() & 2) != 0) {
                        View titleContainer = this.findViewById(16908353);
                        if (titleContainer != null) {
                            titleContainer.setVisibility(8);
                        } else {
                            this.mTitleView.setVisibility(8);
                        }
                        if (this.mContentParent instanceof FrameLayout) {
                            ((FrameLayout)this.mContentParent).setForeground(null);
                        }
                    } else {
                        this.mTitleView.setText(this.mTitle);
                    }
                }
            }
            if (this.mDecor.getBackground() == null && this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(this.mBackgroundFallbackResource);
            }
            if (this.hasFeature(13)) {
                if (this.mTransitionManager == null) {
                    int transitionRes = this.getWindowStyle().getResourceId(27, 0);
                    if (transitionRes != 0) {
                        TransitionInflater inflater = TransitionInflater.from(this.getContext());
                        this.mTransitionManager = inflater.inflateTransitionManager(transitionRes, this.mContentParent);
                    } else {
                        this.mTransitionManager = new TransitionManager();
                    }
                }
                this.mEnterTransition = this.getTransition(this.mEnterTransition, null, 28);
                this.mReturnTransition = this.getTransition(this.mReturnTransition, USE_DEFAULT_TRANSITION, 40);
                this.mExitTransition = this.getTransition(this.mExitTransition, null, 29);
                this.mReenterTransition = this.getTransition(this.mReenterTransition, USE_DEFAULT_TRANSITION, 41);
                this.mSharedElementEnterTransition = this.getTransition(this.mSharedElementEnterTransition, null, 30);
                this.mSharedElementReturnTransition = this.getTransition(this.mSharedElementReturnTransition, USE_DEFAULT_TRANSITION, 42);
                this.mSharedElementExitTransition = this.getTransition(this.mSharedElementExitTransition, null, 31);
                this.mSharedElementReenterTransition = this.getTransition(this.mSharedElementReenterTransition, USE_DEFAULT_TRANSITION, 43);
                if (this.mAllowEnterTransitionOverlap == null) {
                    this.mAllowEnterTransitionOverlap = this.getWindowStyle().getBoolean(33, true);
                }
                if (this.mAllowReturnTransitionOverlap == null) {
                    this.mAllowReturnTransitionOverlap = this.getWindowStyle().getBoolean(32, true);
                }
                if (this.mBackgroundFadeDurationMillis < 0L) {
                    this.mBackgroundFadeDurationMillis = this.getWindowStyle().getInteger(37, 300);
                }
                if (this.mSharedElementsUseOverlay == null) {
                    this.mSharedElementsUseOverlay = this.getWindowStyle().getBoolean(44, true);
                }
            }
        }
    }

    private Transition getTransition(Transition currentValue, Transition defaultValue, int id2) {
        TransitionInflater inflater;
        if (currentValue != defaultValue) {
            return currentValue;
        }
        int transitionId = this.getWindowStyle().getResourceId(id2, -1);
        Transition transition2 = defaultValue;
        if (transitionId != -1 && transitionId != 0x10F0000 && (transition2 = (inflater = TransitionInflater.from(this.getContext())).inflateTransition(transitionId)) instanceof TransitionSet && ((TransitionSet)transition2).getTransitionCount() == 0) {
            transition2 = null;
        }
        return transition2;
    }

    private Drawable loadImageURI(Uri uri) {
        try {
            return Drawable.createFromStream(this.getContext().getContentResolver().openInputStream(uri), null);
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to open content: " + uri);
            return null;
        }
    }

    private DrawableFeatureState getDrawableState(int featureId, boolean required) {
        DrawableFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        DrawableFeatureState[] ar = this.mDrawables;
        if (this.mDrawables == null || ar.length <= featureId) {
            DrawableFeatureState[] nar = new DrawableFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mDrawables = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new DrawableFeatureState(featureId);
        }
        return st;
    }

    private PanelFeatureState getPanelState(int featureId, boolean required) {
        return this.getPanelState(featureId, required, null);
    }

    private PanelFeatureState getPanelState(int featureId, boolean required, PanelFeatureState convertPanelState) {
        PanelFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            st = convertPanelState != null ? convertPanelState : new PanelFeatureState(featureId);
            ar[featureId] = st;
        }
        return st;
    }

    @Override
    public void setChildDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.child = drawable2;
        this.updateDrawable(featureId, st, false);
    }

    @Override
    public void setChildInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    @Override
    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(0, false);
        return st != null && st.menu != null && st.menu.isShortcutKey(keyCode, event);
    }

    private void updateDrawable(int featureId, DrawableFeatureState st, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        Drawable drawable2 = null;
        if (st != null) {
            drawable2 = st.child;
            if (drawable2 == null) {
                drawable2 = st.local;
            }
            if (drawable2 == null) {
                drawable2 = st.def;
            }
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null && (this.isActive() || fromResume)) {
                this.getContainer().setChildDrawable(featureId, drawable2);
            }
        } else if (st != null && (st.cur != drawable2 || st.curAlpha != st.alpha)) {
            st.cur = drawable2;
            st.curAlpha = st.alpha;
            this.onDrawableChanged(featureId, drawable2, st.alpha);
        }
    }

    private void updateInt(int featureId, int value, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null) {
                this.getContainer().setChildInt(featureId, value);
            }
        } else {
            this.onIntChanged(featureId, value);
        }
    }

    private ImageView getLeftIconView() {
        if (this.mLeftIconView != null) {
            return this.mLeftIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mLeftIconView = (ImageView)this.findViewById(16908350);
        return this.mLeftIconView;
    }

    @Override
    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        super.dispatchWindowAttributesChanged(attrs);
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, true);
        }
    }

    private ProgressBar getCircularProgressBar(boolean shouldInstallDecor) {
        if (this.mCircularProgressBar != null) {
            return this.mCircularProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mCircularProgressBar = (ProgressBar)this.findViewById(16909228);
        if (this.mCircularProgressBar != null) {
            this.mCircularProgressBar.setVisibility(4);
        }
        return this.mCircularProgressBar;
    }

    private ProgressBar getHorizontalProgressBar(boolean shouldInstallDecor) {
        if (this.mHorizontalProgressBar != null) {
            return this.mHorizontalProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mHorizontalProgressBar = (ProgressBar)this.findViewById(16909229);
        if (this.mHorizontalProgressBar != null) {
            this.mHorizontalProgressBar.setVisibility(4);
        }
        return this.mHorizontalProgressBar;
    }

    private ImageView getRightIconView() {
        if (this.mRightIconView != null) {
            return this.mRightIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mRightIconView = (ImageView)this.findViewById(16908352);
        return this.mRightIconView;
    }

    private void registerSwipeCallbacks() {
        SwipeDismissLayout swipeDismiss = (SwipeDismissLayout)this.findViewById(0x1020002);
        swipeDismiss.setOnDismissedListener(new SwipeDismissLayout.OnDismissedListener(){

            @Override
            public void onDismissed(SwipeDismissLayout layout2) {
                PhoneWindow.this.dispatchOnWindowDismissed();
            }
        });
        swipeDismiss.setOnSwipeProgressChangedListener(new SwipeDismissLayout.OnSwipeProgressChangedListener(){
            private static final float ALPHA_DECREASE = 0.5f;
            private boolean mIsTranslucent = false;

            @Override
            public void onSwipeProgressChanged(SwipeDismissLayout layout2, float progress, float translate) {
                WindowManager.LayoutParams newParams = PhoneWindow.this.getAttributes();
                newParams.x = (int)translate;
                newParams.alpha = 1.0f - progress * 0.5f;
                PhoneWindow.this.setAttributes(newParams);
                int flags = 0;
                flags = newParams.x == 0 ? 1024 : 512;
                PhoneWindow.this.setFlags(flags, 1536);
            }

            @Override
            public void onSwipeCancelled(SwipeDismissLayout layout2) {
                WindowManager.LayoutParams newParams = PhoneWindow.this.getAttributes();
                newParams.x = 0;
                newParams.alpha = 1.0f;
                PhoneWindow.this.setAttributes(newParams);
                PhoneWindow.this.setFlags(1024, 1536);
            }
        });
    }

    private void callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu2) {
        Window.Callback cb = this.getCallback();
        if (cb == null) {
            return;
        }
        if (menu2 == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu2 = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        if (!this.isDestroyed()) {
            cb.onPanelClosed(featureId, menu2);
        }
    }

    private boolean launchDefaultSearch(KeyEvent event) {
        boolean result;
        Window.Callback cb = this.getCallback();
        if (cb == null || this.isDestroyed()) {
            result = false;
        } else {
            this.sendCloseSystemWindows("search");
            int deviceId = event.getDeviceId();
            SearchEvent searchEvent = null;
            if (deviceId != 0) {
                searchEvent = new SearchEvent(InputDevice.getDevice(deviceId));
            }
            try {
                result = cb.onSearchRequested(searchEvent);
            }
            catch (AbstractMethodError e) {
                Log.e(TAG, "WindowCallback " + cb.getClass().getName() + " does not implement" + " method onSearchRequested(SearchEvent); fa", e);
                result = cb.onSearchRequested();
            }
        }
        if (!result && (this.getContext().getResources().getConfiguration().uiMode & 0xF) == 4) {
            Bundle args = new Bundle();
            args.putInt("android.intent.extra.ASSIST_INPUT_DEVICE_ID", event.getDeviceId());
            return ((SearchManager)this.getContext().getSystemService("search")).launchLegacyAssist(null, UserHandle.myUserId(), args);
        }
        return result;
    }

    @Override
    public void setVolumeControlStream(int streamType) {
        this.mVolumeControlStreamType = streamType;
    }

    @Override
    public int getVolumeControlStream() {
        return this.mVolumeControlStreamType;
    }

    @Override
    public void setMediaController(MediaController controller) {
        this.mMediaController = controller;
    }

    @Override
    public MediaController getMediaController() {
        return this.mMediaController;
    }

    @Override
    public void setEnterTransition(Transition enterTransition) {
        this.mEnterTransition = enterTransition;
    }

    @Override
    public void setReturnTransition(Transition transition2) {
        this.mReturnTransition = transition2;
    }

    @Override
    public void setExitTransition(Transition exitTransition) {
        this.mExitTransition = exitTransition;
    }

    @Override
    public void setReenterTransition(Transition transition2) {
        this.mReenterTransition = transition2;
    }

    @Override
    public void setSharedElementEnterTransition(Transition sharedElementEnterTransition) {
        this.mSharedElementEnterTransition = sharedElementEnterTransition;
    }

    @Override
    public void setSharedElementReturnTransition(Transition transition2) {
        this.mSharedElementReturnTransition = transition2;
    }

    @Override
    public void setSharedElementExitTransition(Transition sharedElementExitTransition) {
        this.mSharedElementExitTransition = sharedElementExitTransition;
    }

    @Override
    public void setSharedElementReenterTransition(Transition transition2) {
        this.mSharedElementReenterTransition = transition2;
    }

    @Override
    public Transition getEnterTransition() {
        return this.mEnterTransition;
    }

    @Override
    public Transition getReturnTransition() {
        return this.mReturnTransition == USE_DEFAULT_TRANSITION ? this.getEnterTransition() : this.mReturnTransition;
    }

    @Override
    public Transition getExitTransition() {
        return this.mExitTransition;
    }

    @Override
    public Transition getReenterTransition() {
        return this.mReenterTransition == USE_DEFAULT_TRANSITION ? this.getExitTransition() : this.mReenterTransition;
    }

    @Override
    public Transition getSharedElementEnterTransition() {
        return this.mSharedElementEnterTransition;
    }

    @Override
    public Transition getSharedElementReturnTransition() {
        return this.mSharedElementReturnTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementEnterTransition() : this.mSharedElementReturnTransition;
    }

    @Override
    public Transition getSharedElementExitTransition() {
        return this.mSharedElementExitTransition;
    }

    @Override
    public Transition getSharedElementReenterTransition() {
        return this.mSharedElementReenterTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementExitTransition() : this.mSharedElementReenterTransition;
    }

    @Override
    public void setAllowEnterTransitionOverlap(boolean allow) {
        this.mAllowEnterTransitionOverlap = allow;
    }

    @Override
    public boolean getAllowEnterTransitionOverlap() {
        return this.mAllowEnterTransitionOverlap == null ? true : this.mAllowEnterTransitionOverlap;
    }

    @Override
    public void setAllowReturnTransitionOverlap(boolean allowExitTransitionOverlap) {
        this.mAllowReturnTransitionOverlap = allowExitTransitionOverlap;
    }

    @Override
    public boolean getAllowReturnTransitionOverlap() {
        return this.mAllowReturnTransitionOverlap == null ? true : this.mAllowReturnTransitionOverlap;
    }

    @Override
    public long getTransitionBackgroundFadeDuration() {
        return this.mBackgroundFadeDurationMillis < 0L ? 300L : this.mBackgroundFadeDurationMillis;
    }

    @Override
    public void setTransitionBackgroundFadeDuration(long fadeDurationMillis) {
        if (fadeDurationMillis < 0L) {
            throw new IllegalArgumentException("negative durations are not allowed");
        }
        this.mBackgroundFadeDurationMillis = fadeDurationMillis;
    }

    @Override
    public void setSharedElementsUseOverlay(boolean sharedElementsUseOverlay) {
        this.mSharedElementsUseOverlay = sharedElementsUseOverlay;
    }

    @Override
    public boolean getSharedElementsUseOverlay() {
        return this.mSharedElementsUseOverlay == null ? true : this.mSharedElementsUseOverlay;
    }

    void sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), reason);
    }

    public static void sendCloseSystemWindows(Context context, String reason) {
        if (ActivityManagerNative.isSystemReady()) {
            try {
                ActivityManagerNative.getDefault().closeSystemDialogs(reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getStatusBarColor() {
        return this.mStatusBarColor;
    }

    @Override
    public void setStatusBarColor(int color2) {
        this.mStatusBarColor = color2;
        this.mForcedStatusBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    @Override
    public int getNavigationBarColor() {
        return this.mNavigationBarColor;
    }

    @Override
    public void setNavigationBarColor(int color2) {
        this.mNavigationBarColor = color2;
        this.mForcedNavigationBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    public void setIsStartingWindow(boolean isStartingWindow) {
        this.mIsStartingWindow = isStartingWindow;
    }

    private static class ColorViewState {
        View view = null;
        int targetVisibility = 4;
        boolean present = false;
        final int id;
        final int systemUiHideFlag;
        final int translucentFlag;
        final int verticalGravity;
        final int horizontalGravity;
        final String transitionName;
        final int hideWindowFlag;

        ColorViewState(int systemUiHideFlag, int translucentFlag, int verticalGravity, int horizontalGravity, String transitionName, int id2, int hideWindowFlag) {
            this.id = id2;
            this.systemUiHideFlag = systemUiHideFlag;
            this.translucentFlag = translucentFlag;
            this.verticalGravity = verticalGravity;
            this.horizontalGravity = horizontalGravity;
            this.transitionName = transitionName;
            this.hideWindowFlag = hideWindowFlag;
        }
    }

    private class DialogMenuCallback
    implements MenuBuilder.Callback,
    MenuPresenter.Callback {
        private int mFeatureId;
        private MenuDialogHelper mSubMenuHelper;

        public DialogMenuCallback(int featureId) {
            this.mFeatureId = featureId;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            if (menu2.getRootMenu() != menu2) {
                this.onCloseSubMenu(menu2);
            }
            if (allMenusAreClosing) {
                Window.Callback callback = PhoneWindow.this.getCallback();
                if (callback != null && !PhoneWindow.this.isDestroyed()) {
                    callback.onPanelClosed(this.mFeatureId, menu2);
                }
                if (menu2 == PhoneWindow.this.mContextMenu) {
                    PhoneWindow.this.dismissContextMenu();
                }
                if (this.mSubMenuHelper != null) {
                    this.mSubMenuHelper.dismiss();
                    this.mSubMenuHelper = null;
                }
            }
        }

        public void onCloseSubMenu(MenuBuilder menu2) {
            Window.Callback callback = PhoneWindow.this.getCallback();
            if (callback != null && !PhoneWindow.this.isDestroyed()) {
                callback.onPanelClosed(this.mFeatureId, menu2.getRootMenu());
            }
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            Window.Callback callback = PhoneWindow.this.getCallback();
            return callback != null && !PhoneWindow.this.isDestroyed() && callback.onMenuItemSelected(this.mFeatureId, item);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menu2) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            subMenu.setCallback(this);
            this.mSubMenuHelper = new MenuDialogHelper(subMenu);
            this.mSubMenuHelper.show(null);
            return true;
        }
    }

    static class RotationWatcher
    extends IRotationWatcher.Stub {
        private Handler mHandler;
        private final Runnable mRotationChanged = new Runnable(){

            @Override
            public void run() {
                RotationWatcher.this.dispatchRotationChanged();
            }
        };
        private final ArrayList<WeakReference<PhoneWindow>> mWindows = new ArrayList();
        private boolean mIsWatching;

        RotationWatcher() {
        }

        @Override
        public void onRotationChanged(int rotation) throws RemoteException {
            this.mHandler.post(this.mRotationChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                if (!this.mIsWatching) {
                    try {
                        WindowManagerHolder.sWindowManager.watchRotation(this);
                        this.mHandler = new Handler();
                        this.mIsWatching = true;
                    }
                    catch (RemoteException ex) {
                        Log.e(PhoneWindow.TAG, "Couldn't start watching for device rotation", ex);
                    }
                }
                this.mWindows.add(new WeakReference<PhoneWindow>(phoneWindow));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win == null || win == phoneWindow) {
                        this.mWindows.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchRotationChanged() {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win != null) {
                        win.onOptionsPanelRotationChanged();
                        ++i;
                        continue;
                    }
                    this.mWindows.remove(i);
                }
            }
        }
    }

    private static class PanelFeatureState {
        int featureId;
        int background;
        int fullBackground;
        int gravity;
        int x;
        int y;
        int windowAnimations;
        DecorView decorView;
        View createdPanelView;
        View shownPanelView;
        MenuBuilder menu;
        IconMenuPresenter iconMenuPresenter;
        ListMenuPresenter listMenuPresenter;
        boolean isCompact;
        int listPresenterTheme;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        boolean isInExpandedMode;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        boolean wasLastExpanded;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        PanelFeatureState(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        public boolean isInListMode() {
            return this.isInExpandedMode || this.isCompact;
        }

        public boolean hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            if (this.isCompact || this.isInExpandedMode) {
                return this.listMenuPresenter.getAdapter().getCount() > 0;
            }
            return ((ViewGroup)this.shownPanelView).getChildCount() > 0;
        }

        public void clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.iconMenuPresenter = null;
            this.listMenuPresenter = null;
        }

        void setStyle(Context context) {
            TypedArray a = context.obtainStyledAttributes(R.styleable.Theme);
            this.background = a.getResourceId(46, 0);
            this.fullBackground = a.getResourceId(47, 0);
            this.windowAnimations = a.getResourceId(93, 0);
            this.isCompact = a.getBoolean(289, false);
            this.listPresenterTheme = a.getResourceId(291, 16974967);
            a.recycle();
        }

        void setMenu(MenuBuilder menu2) {
            if (menu2 == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.menu = menu2;
            if (menu2 != null) {
                if (this.iconMenuPresenter != null) {
                    menu2.addMenuPresenter(this.iconMenuPresenter);
                }
                if (this.listMenuPresenter != null) {
                    menu2.addMenuPresenter(this.listMenuPresenter);
                }
            }
        }

        MenuView getListMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (!this.isCompact) {
                this.getIconMenuView(context, cb);
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(17367158, this.listPresenterTheme);
                this.listMenuPresenter.setCallback(cb);
                this.listMenuPresenter.setId(16908362);
                this.menu.addMenuPresenter(this.listMenuPresenter);
            }
            if (this.iconMenuPresenter != null) {
                this.listMenuPresenter.setItemIndexOffset(this.iconMenuPresenter.getNumActualItemsShown());
            }
            MenuView result = this.listMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        MenuView getIconMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.iconMenuPresenter == null) {
                this.iconMenuPresenter = new IconMenuPresenter(context);
                this.iconMenuPresenter.setCallback(cb);
                this.iconMenuPresenter.setId(16908361);
                this.menu.addMenuPresenter(this.iconMenuPresenter);
            }
            MenuView result = this.iconMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            savedState.isInExpandedMode = this.isInExpandedMode;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.wasLastExpanded = savedState.isInExpandedMode;
            this.frozenMenuState = savedState.menuState;
            this.createdPanelView = null;
            this.shownPanelView = null;
            this.decorView = null;
        }

        void applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        private static class SavedState
        implements Parcelable {
            int featureId;
            boolean isOpen;
            boolean isInExpandedMode;
            Bundle menuState;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                @Override
                public SavedState createFromParcel(Parcel in) {
                    return SavedState.readFromParcel(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            private SavedState() {
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                dest.writeInt(this.isInExpandedMode ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            private static SavedState readFromParcel(Parcel source) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                savedState.isOpen = source.readInt() == 1;
                boolean bl = savedState.isInExpandedMode = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle();
                }
                return savedState;
            }
        }
    }

    private static class DrawableFeatureState {
        final int featureId;
        int resid;
        Uri uri;
        Drawable local;
        Drawable child;
        Drawable def;
        Drawable cur;
        int alpha = 255;
        int curAlpha = 255;

        DrawableFeatureState(int _featureId) {
            this.featureId = _featureId;
        }
    }

    private class DecorView
    extends FrameLayout
    implements RootViewSurfaceTaker {
        int mDefaultOpacity;
        private final int mFeatureId;
        private final Rect mDrawingBounds;
        private final Rect mBackgroundPadding;
        private final Rect mFramePadding;
        private final Rect mFrameOffsets;
        private boolean mChanging;
        private Drawable mMenuBackground;
        private boolean mWatchingForMenu;
        private int mDownY;
        private ActionMode mPrimaryActionMode;
        private ActionMode mFloatingActionMode;
        private ActionBarContextView mPrimaryActionModeView;
        private PopupWindow mPrimaryActionModePopup;
        private Runnable mShowPrimaryActionModePopup;
        private ViewTreeObserver.OnPreDrawListener mFloatingToolbarPreDrawListener;
        private View mFloatingActionModeOriginatingView;
        private FloatingToolbar mFloatingToolbar;
        private ObjectAnimator mFadeAnim;
        private View mStatusGuard;
        private View mNavigationGuard;
        private final ColorViewState mStatusColorViewState;
        private final ColorViewState mNavigationColorViewState;
        private final Interpolator mShowInterpolator;
        private final Interpolator mHideInterpolator;
        private final int mBarEnterExitDuration;
        private final BackgroundFallback mBackgroundFallback;
        private int mLastTopInset;
        private int mLastBottomInset;
        private int mLastRightInset;
        private boolean mLastHasTopStableInset;
        private boolean mLastHasBottomStableInset;
        private boolean mLastHasRightStableInset;
        private int mLastWindowFlags;
        private int mRootScrollY;

        public DecorView(Context context, int featureId) {
            super(context);
            this.mDefaultOpacity = -1;
            this.mDrawingBounds = new Rect();
            this.mBackgroundPadding = new Rect();
            this.mFramePadding = new Rect();
            this.mFrameOffsets = new Rect();
            this.mStatusColorViewState = new ColorViewState(4, 0x4000000, 48, 3, "android:status:background", 16908335, 1024);
            this.mNavigationColorViewState = new ColorViewState(2, 0x8000000, 80, 5, "android:navigation:background", 16908336, 0);
            this.mBackgroundFallback = new BackgroundFallback();
            this.mLastTopInset = 0;
            this.mLastBottomInset = 0;
            this.mLastRightInset = 0;
            this.mLastHasTopStableInset = false;
            this.mLastHasBottomStableInset = false;
            this.mLastHasRightStableInset = false;
            this.mLastWindowFlags = 0;
            this.mRootScrollY = 0;
            this.mFeatureId = featureId;
            this.mShowInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
            this.mHideInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
            this.mBarEnterExitDuration = context.getResources().getInteger(17694903);
        }

        public void setBackgroundFallback(int resId) {
            this.mBackgroundFallback.setDrawable(resId != 0 ? this.getContext().getDrawable(resId) : null);
            this.setWillNotDraw(this.getBackground() == null && !this.mBackgroundFallback.hasFallback());
        }

        @Override
        public void onDraw(Canvas c) {
            super.onDraw(c);
            this.mBackgroundFallback.draw(PhoneWindow.this.mContentRoot, c, PhoneWindow.this.mContentParent);
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent event) {
            boolean isDown;
            int keyCode = event.getKeyCode();
            int action = event.getAction();
            boolean bl = isDown = action == 0;
            if (isDown && event.getRepeatCount() == 0) {
                boolean handled;
                if (PhoneWindow.this.mPanelChordingKey > 0 && PhoneWindow.this.mPanelChordingKey != keyCode && (handled = this.dispatchKeyShortcutEvent(event))) {
                    return true;
                }
                if (PhoneWindow.this.mPreparedPanel != null && ((PhoneWindow)PhoneWindow.this).mPreparedPanel.isOpen && PhoneWindow.this.performPanelShortcut(PhoneWindow.this.mPreparedPanel, keyCode, event, 0)) {
                    return true;
                }
            }
            if (!PhoneWindow.this.isDestroyed()) {
                boolean handled;
                Window.Callback cb = PhoneWindow.this.getCallback();
                boolean bl2 = handled = cb != null && this.mFeatureId < 0 ? cb.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
                if (handled) {
                    return true;
                }
            }
            return isDown ? PhoneWindow.this.onKeyDown(this.mFeatureId, event.getKeyCode(), event) : PhoneWindow.this.onKeyUp(this.mFeatureId, event.getKeyCode(), event);
        }

        @Override
        public boolean dispatchKeyShortcutEvent(KeyEvent ev) {
            boolean handled;
            if (PhoneWindow.this.mPreparedPanel != null && (handled = PhoneWindow.this.performPanelShortcut(PhoneWindow.this.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
                if (PhoneWindow.this.mPreparedPanel != null) {
                    ((PhoneWindow)PhoneWindow.this).mPreparedPanel.isHandled = true;
                }
                return true;
            }
            Window.Callback cb = PhoneWindow.this.getCallback();
            boolean bl = handled = cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchKeyShortcutEvent(ev) : super.dispatchKeyShortcutEvent(ev);
            if (handled) {
                return true;
            }
            PanelFeatureState st = PhoneWindow.this.getPanelState(0, false);
            if (st != null && PhoneWindow.this.mPreparedPanel == null) {
                PhoneWindow.this.preparePanel(st, ev);
                handled = PhoneWindow.this.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
                st.isPrepared = false;
                if (handled) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTouchEvent(ev) : super.dispatchTouchEvent(ev);
        }

        @Override
        public boolean dispatchTrackballEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTrackballEvent(ev) : super.dispatchTrackballEvent(ev);
        }

        @Override
        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            return cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchGenericMotionEvent(ev) : super.dispatchGenericMotionEvent(ev);
        }

        public boolean superDispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 4) {
                int action = event.getAction();
                if (this.mPrimaryActionMode != null) {
                    if (action == 1) {
                        this.mPrimaryActionMode.finish();
                    }
                    return true;
                }
            }
            return super.dispatchKeyEvent(event);
        }

        public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
            return super.dispatchKeyShortcutEvent(event);
        }

        public boolean superDispatchTouchEvent(MotionEvent event) {
            return super.dispatchTouchEvent(event);
        }

        public boolean superDispatchTrackballEvent(MotionEvent event) {
            return super.dispatchTrackballEvent(event);
        }

        public boolean superDispatchGenericMotionEvent(MotionEvent event) {
            return super.dispatchGenericMotionEvent(event);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            return this.onInterceptTouchEvent(event);
        }

        private boolean isOutOfBounds(int x, int y) {
            return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
        }

        @Override
        public boolean onInterceptTouchEvent(MotionEvent event) {
            int y;
            int x;
            int action = event.getAction();
            if (this.mFeatureId >= 0 && action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
                PhoneWindow.this.closePanel(this.mFeatureId);
                return true;
            }
            return false;
        }

        @Override
        public void sendAccessibilityEvent(int eventType) {
            if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                return;
            }
            if ((this.mFeatureId == 0 || this.mFeatureId == 6 || this.mFeatureId == 2 || this.mFeatureId == 5) && this.getChildCount() == 1) {
                this.getChildAt(0).sendAccessibilityEvent(eventType);
            } else {
                super.sendAccessibilityEvent(eventType);
            }
        }

        @Override
        public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && !PhoneWindow.this.isDestroyed() && cb.dispatchPopulateAccessibilityEvent(event)) {
                return true;
            }
            return super.dispatchPopulateAccessibilityEventInternal(event);
        }

        @Override
        protected boolean setFrame(int l, int t, int r, int b) {
            boolean changed = super.setFrame(l, t, r, b);
            if (changed) {
                Drawable bg;
                Rect drawingBounds = this.mDrawingBounds;
                this.getDrawingRect(drawingBounds);
                Drawable fg = this.getForeground();
                if (fg != null) {
                    Rect frameOffsets = this.mFrameOffsets;
                    drawingBounds.left += frameOffsets.left;
                    drawingBounds.top += frameOffsets.top;
                    drawingBounds.right -= frameOffsets.right;
                    drawingBounds.bottom -= frameOffsets.bottom;
                    fg.setBounds(drawingBounds);
                    Rect framePadding = this.mFramePadding;
                    drawingBounds.left += framePadding.left - frameOffsets.left;
                    drawingBounds.top += framePadding.top - frameOffsets.top;
                    drawingBounds.right -= framePadding.right - frameOffsets.right;
                    drawingBounds.bottom -= framePadding.bottom - frameOffsets.bottom;
                }
                if ((bg = this.getBackground()) != null) {
                    bg.setBounds(drawingBounds);
                }
            }
            return changed;
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int mode;
            DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
            boolean isPortrait = metrics.widthPixels < metrics.heightPixels;
            int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
            boolean fixedWidth = false;
            if (widthMode == Integer.MIN_VALUE) {
                int w;
                TypedValue tvw;
                TypedValue typedValue = tvw = isPortrait ? PhoneWindow.this.mFixedWidthMinor : PhoneWindow.this.mFixedWidthMajor;
                if (tvw != null && tvw.type != 0 && (w = tvw.type == 5 ? (int)tvw.getDimension(metrics) : (tvw.type == 6 ? (int)tvw.getFraction(metrics.widthPixels, metrics.widthPixels) : 0)) > 0) {
                    int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(w, widthSize), 0x40000000);
                    fixedWidth = true;
                }
            }
            if (heightMode == Integer.MIN_VALUE) {
                int h;
                TypedValue tvh;
                TypedValue typedValue = tvh = isPortrait ? PhoneWindow.this.mFixedHeightMajor : PhoneWindow.this.mFixedHeightMinor;
                if (tvh != null && tvh.type != 0 && (h = tvh.type == 5 ? (int)tvh.getDimension(metrics) : (tvh.type == 6 ? (int)tvh.getFraction(metrics.heightPixels, metrics.heightPixels) : 0)) > 0) {
                    int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(h, heightSize), 0x40000000);
                }
            }
            this.getOutsets(PhoneWindow.this.mOutsets);
            if ((((PhoneWindow)PhoneWindow.this).mOutsets.top > 0 || ((PhoneWindow)PhoneWindow.this).mOutsets.bottom > 0) && (mode = View.MeasureSpec.getMode(heightMeasureSpec)) != 0) {
                int height = View.MeasureSpec.getSize(heightMeasureSpec);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height + ((PhoneWindow)PhoneWindow.this).mOutsets.top + ((PhoneWindow)PhoneWindow.this).mOutsets.bottom, mode);
            }
            if ((((PhoneWindow)PhoneWindow.this).mOutsets.left > 0 || ((PhoneWindow)PhoneWindow.this).mOutsets.right > 0) && (mode = View.MeasureSpec.getMode(widthMeasureSpec)) != 0) {
                int width = View.MeasureSpec.getSize(widthMeasureSpec);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width + ((PhoneWindow)PhoneWindow.this).mOutsets.left + ((PhoneWindow)PhoneWindow.this).mOutsets.right, mode);
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int width = this.getMeasuredWidth();
            boolean measure = false;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
            if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
                int min;
                TypedValue tv;
                TypedValue typedValue = tv = isPortrait ? PhoneWindow.this.mMinWidthMinor : PhoneWindow.this.mMinWidthMajor;
                if (tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction(metrics.widthPixels, metrics.widthPixels) : 0))) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(min, 0x40000000);
                    measure = true;
                }
            }
            if (measure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        @Override
        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            this.getOutsets(PhoneWindow.this.mOutsets);
            if (((PhoneWindow)PhoneWindow.this).mOutsets.left > 0) {
                this.offsetLeftAndRight(-((PhoneWindow)PhoneWindow.this).mOutsets.left);
            }
            if (((PhoneWindow)PhoneWindow.this).mOutsets.top > 0) {
                this.offsetTopAndBottom(-((PhoneWindow)PhoneWindow.this).mOutsets.top);
            }
        }

        @Override
        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mMenuBackground != null) {
                this.mMenuBackground.draw(canvas);
            }
        }

        @Override
        public boolean showContextMenuForChild(View originalView) {
            if (PhoneWindow.this.mContextMenu == null) {
                PhoneWindow.this.mContextMenu = new ContextMenuBuilder(this.getContext());
                PhoneWindow.this.mContextMenu.setCallback(PhoneWindow.this.mContextMenuCallback);
            } else {
                PhoneWindow.this.mContextMenu.clearAll();
            }
            MenuDialogHelper helper = PhoneWindow.this.mContextMenu.show(originalView, originalView.getWindowToken());
            if (helper != null) {
                helper.setPresenterCallback(PhoneWindow.this.mContextMenuCallback);
            } else if (PhoneWindow.this.mContextMenuHelper != null) {
                PhoneWindow.this.mContextMenuHelper.dismiss();
            }
            PhoneWindow.this.mContextMenuHelper = helper;
            return helper != null;
        }

        @Override
        public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
            return this.startActionModeForChild(originalView, callback, 0);
        }

        @Override
        public ActionMode startActionModeForChild(View child, ActionMode.Callback callback, int type) {
            return this.startActionMode(child, callback, type);
        }

        @Override
        public ActionMode startActionMode(ActionMode.Callback callback) {
            return this.startActionMode(callback, 0);
        }

        @Override
        public ActionMode startActionMode(ActionMode.Callback callback, int type) {
            return this.startActionMode(this, callback, type);
        }

        private ActionMode startActionMode(View originatingView, ActionMode.Callback callback, int type) {
            ActionMode mode;
            ActionModeCallback2Wrapper wrappedCallback;
            block16: {
                wrappedCallback = new ActionModeCallback2Wrapper(callback);
                mode = null;
                if (PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                    try {
                        mode = PhoneWindow.this.getCallback().onWindowStartingActionMode(wrappedCallback, type);
                    }
                    catch (AbstractMethodError ame) {
                        if (type != 0) break block16;
                        try {
                            mode = PhoneWindow.this.getCallback().onWindowStartingActionMode(wrappedCallback);
                        }
                        catch (AbstractMethodError abstractMethodError) {
                            // empty catch block
                        }
                    }
                }
            }
            if (mode != null) {
                if (mode.getType() == 0) {
                    this.cleanupPrimaryActionMode();
                    this.mPrimaryActionMode = mode;
                } else if (mode.getType() == 1) {
                    if (this.mFloatingActionMode != null) {
                        this.mFloatingActionMode.finish();
                    }
                    this.mFloatingActionMode = mode;
                }
            } else {
                mode = this.createActionMode(type, wrappedCallback, originatingView);
                if (mode != null && wrappedCallback.onCreateActionMode(mode, mode.getMenu())) {
                    this.setHandledActionMode(mode);
                } else {
                    mode = null;
                }
            }
            if (mode != null && PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                try {
                    PhoneWindow.this.getCallback().onActionModeStarted(mode);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            return mode;
        }

        private void cleanupPrimaryActionMode() {
            if (this.mPrimaryActionMode != null) {
                this.mPrimaryActionMode.finish();
                this.mPrimaryActionMode = null;
            }
            if (this.mPrimaryActionModeView != null) {
                this.mPrimaryActionModeView.killMode();
            }
        }

        private void cleanupFloatingActionModeViews() {
            if (this.mFloatingToolbar != null) {
                this.mFloatingToolbar.dismiss();
                this.mFloatingToolbar = null;
            }
            if (this.mFloatingActionModeOriginatingView != null) {
                if (this.mFloatingToolbarPreDrawListener != null) {
                    this.mFloatingActionModeOriginatingView.getViewTreeObserver().removeOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
                    this.mFloatingToolbarPreDrawListener = null;
                }
                this.mFloatingActionModeOriginatingView = null;
            }
        }

        public void startChanging() {
            this.mChanging = true;
        }

        public void finishChanging() {
            this.mChanging = false;
            this.drawableChanged();
        }

        public void setWindowBackground(Drawable drawable2) {
            if (this.getBackground() != drawable2) {
                this.setBackgroundDrawable(drawable2);
                if (drawable2 != null) {
                    drawable2.getPadding(this.mBackgroundPadding);
                } else {
                    this.mBackgroundPadding.setEmpty();
                }
                this.drawableChanged();
            }
        }

        @Override
        public void setBackgroundDrawable(Drawable d) {
            super.setBackgroundDrawable(d);
            if (this.getWindowToken() != null) {
                this.updateWindowResizeState();
            }
        }

        public void setWindowFrame(Drawable drawable2) {
            if (this.getForeground() != drawable2) {
                this.setForeground(drawable2);
                if (drawable2 != null) {
                    drawable2.getPadding(this.mFramePadding);
                } else {
                    this.mFramePadding.setEmpty();
                }
                this.drawableChanged();
            }
        }

        @Override
        public void onWindowSystemUiVisibilityChanged(int visible) {
            this.updateColorViews(null, true);
        }

        @Override
        public WindowInsets onApplyWindowInsets(WindowInsets insets) {
            this.mFrameOffsets.set(insets.getSystemWindowInsets());
            insets = this.updateColorViews(insets, true);
            insets = this.updateStatusGuard(insets);
            this.updateNavigationGuard(insets);
            if (this.getForeground() != null) {
                this.drawableChanged();
            }
            return insets;
        }

        @Override
        public boolean isTransitionGroup() {
            return false;
        }

        private WindowInsets updateColorViews(WindowInsets insets, boolean animate) {
            int consumedBottom;
            WindowManager.LayoutParams attrs = PhoneWindow.this.getAttributes();
            int sysUiVisibility = attrs.systemUiVisibility | this.getWindowSystemUiVisibility();
            if (!PhoneWindow.this.mIsFloating && ActivityManager.isHighEndGfx()) {
                boolean disallowAnimate = !this.isLaidOut();
                disallowAnimate |= ((this.mLastWindowFlags ^ attrs.flags) & Integer.MIN_VALUE) != 0;
                this.mLastWindowFlags = attrs.flags;
                if (insets != null) {
                    this.mLastTopInset = Math.min(insets.getStableInsetTop(), insets.getSystemWindowInsetTop());
                    this.mLastBottomInset = Math.min(insets.getStableInsetBottom(), insets.getSystemWindowInsetBottom());
                    this.mLastRightInset = Math.min(insets.getStableInsetRight(), insets.getSystemWindowInsetRight());
                    boolean hasTopStableInset = insets.getStableInsetTop() != 0;
                    disallowAnimate |= hasTopStableInset != this.mLastHasTopStableInset;
                    this.mLastHasTopStableInset = hasTopStableInset;
                    boolean hasBottomStableInset = insets.getStableInsetBottom() != 0;
                    disallowAnimate |= hasBottomStableInset != this.mLastHasBottomStableInset;
                    this.mLastHasBottomStableInset = hasBottomStableInset;
                    boolean hasRightStableInset = insets.getStableInsetRight() != 0;
                    disallowAnimate |= hasRightStableInset != this.mLastHasRightStableInset;
                    this.mLastHasRightStableInset = hasRightStableInset;
                }
                boolean navBarToRightEdge = this.mLastBottomInset == 0 && this.mLastRightInset > 0;
                int navBarSize = navBarToRightEdge ? this.mLastRightInset : this.mLastBottomInset;
                this.updateColorViewInt(this.mNavigationColorViewState, sysUiVisibility, PhoneWindow.this.mNavigationBarColor, navBarSize, navBarToRightEdge, 0, animate && !disallowAnimate);
                boolean statusBarNeedsRightInset = navBarToRightEdge && this.mNavigationColorViewState.present;
                int statusBarRightInset = statusBarNeedsRightInset ? this.mLastRightInset : 0;
                this.updateColorViewInt(this.mStatusColorViewState, sysUiVisibility, PhoneWindow.this.mStatusBarColor, this.mLastTopInset, false, statusBarRightInset, animate && !disallowAnimate);
            }
            boolean consumingNavBar = (attrs.flags & Integer.MIN_VALUE) != 0 && (sysUiVisibility & 0x200) == 0 && (sysUiVisibility & 2) == 0;
            int consumedRight = consumingNavBar ? this.mLastRightInset : 0;
            int n = consumedBottom = consumingNavBar ? this.mLastBottomInset : 0;
            if (PhoneWindow.this.mContentRoot != null && PhoneWindow.this.mContentRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)PhoneWindow.this.mContentRoot.getLayoutParams();
                if (lp.rightMargin != consumedRight || lp.bottomMargin != consumedBottom) {
                    lp.rightMargin = consumedRight;
                    lp.bottomMargin = consumedBottom;
                    PhoneWindow.this.mContentRoot.setLayoutParams(lp);
                    if (insets == null) {
                        this.requestApplyInsets();
                    }
                }
                if (insets != null) {
                    insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight() - consumedRight, insets.getSystemWindowInsetBottom() - consumedBottom);
                }
            }
            if (insets != null) {
                insets = insets.consumeStableInsets();
            }
            return insets;
        }

        private void updateColorViewInt(final ColorViewState state, int sysUiVis, int color2, int size, boolean verticalBar, int rightMargin, boolean animate) {
            int resolvedGravity;
            state.present = size > 0 && (sysUiVis & state.systemUiHideFlag) == 0 && (PhoneWindow.this.getAttributes().flags & state.hideWindowFlag) == 0 && (PhoneWindow.this.getAttributes().flags & Integer.MIN_VALUE) != 0;
            boolean show = state.present && (color2 & 0xFF000000) != 0 && (PhoneWindow.this.getAttributes().flags & state.translucentFlag) == 0;
            boolean visibilityChanged = false;
            View view = state.view;
            int resolvedHeight = verticalBar ? -1 : size;
            int resolvedWidth = verticalBar ? size : -1;
            int n = resolvedGravity = verticalBar ? state.horizontalGravity : state.verticalGravity;
            if (view == null) {
                if (show) {
                    state.view = view = new View(this.mContext);
                    view.setBackgroundColor(color2);
                    view.setTransitionName(state.transitionName);
                    view.setId(state.id);
                    visibilityChanged = true;
                    view.setVisibility(4);
                    state.targetVisibility = 0;
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(resolvedWidth, resolvedHeight, resolvedGravity);
                    lp.rightMargin = rightMargin;
                    this.addView(view, lp);
                    this.updateColorViewTranslations();
                }
            } else {
                int vis = show ? 0 : 4;
                visibilityChanged = state.targetVisibility != vis;
                state.targetVisibility = vis;
                if (show) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
                    if (lp.height != resolvedHeight || lp.width != resolvedWidth || lp.gravity != resolvedGravity || lp.rightMargin != rightMargin) {
                        lp.height = resolvedHeight;
                        lp.width = resolvedWidth;
                        lp.gravity = resolvedGravity;
                        lp.rightMargin = rightMargin;
                        view.setLayoutParams(lp);
                    }
                    view.setBackgroundColor(color2);
                }
            }
            if (visibilityChanged) {
                view.animate().cancel();
                if (animate) {
                    if (show) {
                        if (view.getVisibility() != 0) {
                            view.setVisibility(0);
                            view.setAlpha(0.0f);
                        }
                        view.animate().alpha(1.0f).setInterpolator(this.mShowInterpolator).setDuration(this.mBarEnterExitDuration);
                    } else {
                        view.animate().alpha(0.0f).setInterpolator(this.mHideInterpolator).setDuration(this.mBarEnterExitDuration).withEndAction(new Runnable(){

                            @Override
                            public void run() {
                                state.view.setAlpha(1.0f);
                                state.view.setVisibility(4);
                            }
                        });
                    }
                } else {
                    view.setAlpha(1.0f);
                    view.setVisibility(show ? 0 : 4);
                }
            }
        }

        private void updateColorViewTranslations() {
            int rootScrollY = this.mRootScrollY;
            if (this.mStatusColorViewState.view != null) {
                this.mStatusColorViewState.view.setTranslationY(rootScrollY > 0 ? (float)rootScrollY : 0.0f);
            }
            if (this.mNavigationColorViewState.view != null) {
                this.mNavigationColorViewState.view.setTranslationY(rootScrollY < 0 ? (float)rootScrollY : 0.0f);
            }
        }

        private WindowInsets updateStatusGuard(WindowInsets insets) {
            boolean showStatusGuard = false;
            if (this.mPrimaryActionModeView != null && this.mPrimaryActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mPrimaryActionModeView.getLayoutParams();
                boolean mlpChanged = false;
                if (this.mPrimaryActionModeView.isShown()) {
                    int newMargin;
                    if (PhoneWindow.this.mTempRect == null) {
                        PhoneWindow.this.mTempRect = new Rect();
                    }
                    Rect rect = PhoneWindow.this.mTempRect;
                    PhoneWindow.this.mContentParent.computeSystemWindowInsets(insets, rect);
                    int n = newMargin = rect.top == 0 ? insets.getSystemWindowInsetTop() : 0;
                    if (mlp.topMargin != newMargin) {
                        mlpChanged = true;
                        mlp.topMargin = insets.getSystemWindowInsetTop();
                        if (this.mStatusGuard == null) {
                            this.mStatusGuard = new View(this.mContext);
                            this.mStatusGuard.setBackgroundColor(this.mContext.getColor(17170482));
                            this.addView(this.mStatusGuard, this.indexOfChild(this.mStatusColorViewState.view), new FrameLayout.LayoutParams(-1, mlp.topMargin, 0x800033));
                        } else {
                            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mStatusGuard.getLayoutParams();
                            if (lp.height != mlp.topMargin) {
                                lp.height = mlp.topMargin;
                                this.mStatusGuard.setLayoutParams(lp);
                            }
                        }
                    }
                    showStatusGuard = this.mStatusGuard != null;
                    boolean nonOverlay = (PhoneWindow.this.getLocalFeatures() & 0x400) == 0;
                    insets = insets.consumeSystemWindowInsets(false, nonOverlay && showStatusGuard, false, false);
                } else if (mlp.topMargin != 0) {
                    mlpChanged = true;
                    mlp.topMargin = 0;
                }
                if (mlpChanged) {
                    this.mPrimaryActionModeView.setLayoutParams(mlp);
                }
            }
            if (this.mStatusGuard != null) {
                this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
            }
            return insets;
        }

        private void updateNavigationGuard(WindowInsets insets) {
            if (PhoneWindow.this.getAttributes().type == 2011) {
                if (PhoneWindow.this.mContentParent != null && PhoneWindow.this.mContentParent.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)PhoneWindow.this.mContentParent.getLayoutParams();
                    mlp.bottomMargin = insets.getSystemWindowInsetBottom();
                    PhoneWindow.this.mContentParent.setLayoutParams(mlp);
                }
                if (this.mNavigationGuard == null) {
                    this.mNavigationGuard = new View(this.mContext);
                    this.mNavigationGuard.setBackgroundColor(this.mContext.getColor(17170482));
                    this.addView(this.mNavigationGuard, this.indexOfChild(this.mNavigationColorViewState.view), new FrameLayout.LayoutParams(-1, insets.getSystemWindowInsetBottom(), 8388691));
                } else {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mNavigationGuard.getLayoutParams();
                    lp.height = insets.getSystemWindowInsetBottom();
                    this.mNavigationGuard.setLayoutParams(lp);
                }
            }
        }

        private void drawableChanged() {
            if (this.mChanging) {
                return;
            }
            this.setPadding(this.mFramePadding.left + this.mBackgroundPadding.left, this.mFramePadding.top + this.mBackgroundPadding.top, this.mFramePadding.right + this.mBackgroundPadding.right, this.mFramePadding.bottom + this.mBackgroundPadding.bottom);
            this.requestLayout();
            this.invalidate();
            int opacity = -1;
            Drawable bg = this.getBackground();
            Drawable fg = this.getForeground();
            if (bg != null) {
                if (fg == null) {
                    opacity = bg.getOpacity();
                } else if (this.mFramePadding.left <= 0 && this.mFramePadding.top <= 0 && this.mFramePadding.right <= 0 && this.mFramePadding.bottom <= 0) {
                    int fop = fg.getOpacity();
                    int bop = bg.getOpacity();
                    opacity = fop == -1 || bop == -1 ? -1 : (fop == 0 ? bop : (bop == 0 ? fop : Drawable.resolveOpacity(fop, bop)));
                } else {
                    opacity = -3;
                }
            }
            this.mDefaultOpacity = opacity;
            if (this.mFeatureId < 0) {
                PhoneWindow.this.setDefaultWindowFormat(opacity);
            }
        }

        @Override
        public void onWindowFocusChanged(boolean hasWindowFocus) {
            Window.Callback cb;
            super.onWindowFocusChanged(hasWindowFocus);
            if (PhoneWindow.this.hasFeature(0) && !hasWindowFocus && PhoneWindow.this.mPanelChordingKey != 0) {
                PhoneWindow.this.closePanel(0);
            }
            if ((cb = PhoneWindow.this.getCallback()) != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0) {
                cb.onWindowFocusChanged(hasWindowFocus);
            }
            if (this.mPrimaryActionMode != null) {
                this.mPrimaryActionMode.onWindowFocusChanged(hasWindowFocus);
            }
            if (this.mFloatingActionMode != null) {
                this.mFloatingActionMode.onWindowFocusChanged(hasWindowFocus);
            }
        }

        void updateWindowResizeState() {
            Drawable bg = this.getBackground();
            this.hackTurnOffWindowResizeAnim(bg == null || bg.getOpacity() != -1);
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.updateWindowResizeState();
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && !PhoneWindow.this.isDestroyed() && this.mFeatureId < 0) {
                cb.onAttachedToWindow();
            }
            if (this.mFeatureId == -1) {
                PhoneWindow.this.openPanelsAfterRestore();
            }
        }

        @Override
        protected void onDetachedFromWindow() {
            PanelFeatureState st;
            super.onDetachedFromWindow();
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null && this.mFeatureId < 0) {
                cb.onDetachedFromWindow();
            }
            if (PhoneWindow.this.mDecorContentParent != null) {
                PhoneWindow.this.mDecorContentParent.dismissPopups();
            }
            if (this.mPrimaryActionModePopup != null) {
                this.removeCallbacks(this.mShowPrimaryActionModePopup);
                if (this.mPrimaryActionModePopup.isShowing()) {
                    this.mPrimaryActionModePopup.dismiss();
                }
                this.mPrimaryActionModePopup = null;
            }
            if (this.mFloatingToolbar != null) {
                this.mFloatingToolbar.dismiss();
                this.mFloatingToolbar = null;
            }
            if ((st = PhoneWindow.this.getPanelState(0, false)) != null && st.menu != null && this.mFeatureId < 0) {
                st.menu.close();
            }
        }

        @Override
        public void onCloseSystemDialogs(String reason) {
            if (this.mFeatureId >= 0) {
                PhoneWindow.this.closeAllPanels();
            }
        }

        @Override
        public SurfaceHolder.Callback2 willYouTakeTheSurface() {
            return this.mFeatureId < 0 ? PhoneWindow.this.mTakeSurfaceCallback : null;
        }

        @Override
        public InputQueue.Callback willYouTakeTheInputQueue() {
            return this.mFeatureId < 0 ? PhoneWindow.this.mTakeInputQueueCallback : null;
        }

        @Override
        public void setSurfaceType(int type) {
            PhoneWindow.this.setType(type);
        }

        @Override
        public void setSurfaceFormat(int format) {
            PhoneWindow.this.setFormat(format);
        }

        @Override
        public void setSurfaceKeepScreenOn(boolean keepOn) {
            if (keepOn) {
                PhoneWindow.this.addFlags(128);
            } else {
                PhoneWindow.this.clearFlags(128);
            }
        }

        @Override
        public void onRootViewScrollYChanged(int rootScrollY) {
            this.mRootScrollY = rootScrollY;
            this.updateColorViewTranslations();
        }

        private ActionMode createActionMode(int type, ActionMode.Callback2 callback, View originatingView) {
            switch (type) {
                default: {
                    return this.createStandaloneActionMode(callback);
                }
                case 1: 
            }
            return this.createFloatingActionMode(originatingView, callback);
        }

        private void setHandledActionMode(ActionMode mode) {
            if (mode.getType() == 0) {
                this.setHandledPrimaryActionMode(mode);
            } else if (mode.getType() == 1) {
                this.setHandledFloatingActionMode(mode);
            }
        }

        private ActionMode createStandaloneActionMode(ActionMode.Callback callback) {
            this.endOnGoingFadeAnimation();
            this.cleanupPrimaryActionMode();
            if (this.mPrimaryActionModeView == null) {
                if (PhoneWindow.this.isFloating()) {
                    Context actionBarContext;
                    TypedValue outValue = new TypedValue();
                    Resources.Theme baseTheme = this.mContext.getTheme();
                    baseTheme.resolveAttribute(16843825, outValue, true);
                    if (outValue.resourceId != 0) {
                        Resources.Theme actionBarTheme = this.mContext.getResources().newTheme();
                        actionBarTheme.setTo(baseTheme);
                        actionBarTheme.applyStyle(outValue.resourceId, true);
                        actionBarContext = new ContextThemeWrapper(this.mContext, 0);
                        actionBarContext.getTheme().setTo(actionBarTheme);
                    } else {
                        actionBarContext = this.mContext;
                    }
                    this.mPrimaryActionModeView = new ActionBarContextView(actionBarContext);
                    this.mPrimaryActionModePopup = new PopupWindow(actionBarContext, null, 18219040);
                    this.mPrimaryActionModePopup.setWindowLayoutType(2);
                    this.mPrimaryActionModePopup.setContentView(this.mPrimaryActionModeView);
                    this.mPrimaryActionModePopup.setWidth(-1);
                    actionBarContext.getTheme().resolveAttribute(16843499, outValue, true);
                    int height = TypedValue.complexToDimensionPixelSize(outValue.data, actionBarContext.getResources().getDisplayMetrics());
                    this.mPrimaryActionModeView.setContentHeight(height);
                    this.mPrimaryActionModePopup.setHeight(-2);
                    this.mShowPrimaryActionModePopup = new Runnable(){

                        @Override
                        public void run() {
                            DecorView.this.mPrimaryActionModePopup.showAtLocation(DecorView.this.mPrimaryActionModeView.getApplicationWindowToken(), 55, 0, 0);
                            DecorView.this.endOnGoingFadeAnimation();
                            DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
                            DecorView.this.mFadeAnim.addListener(new Animator.AnimatorListener(){

                                @Override
                                public void onAnimationStart(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setVisibility(0);
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                                    DecorView.this.mFadeAnim = null;
                                }

                                @Override
                                public void onAnimationCancel(Animator animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animator animation) {
                                }
                            });
                            DecorView.this.mFadeAnim.start();
                        }
                    };
                } else {
                    ViewStub stub = (ViewStub)this.findViewById(16909225);
                    if (stub != null) {
                        this.mPrimaryActionModeView = (ActionBarContextView)stub.inflate();
                    }
                }
            }
            if (this.mPrimaryActionModeView != null) {
                this.mPrimaryActionModeView.killMode();
                StandaloneActionMode mode = new StandaloneActionMode(this.mPrimaryActionModeView.getContext(), this.mPrimaryActionModeView, callback, this.mPrimaryActionModePopup == null);
                return mode;
            }
            return null;
        }

        private void endOnGoingFadeAnimation() {
            if (this.mFadeAnim != null) {
                this.mFadeAnim.end();
            }
        }

        private void setHandledPrimaryActionMode(ActionMode mode) {
            this.endOnGoingFadeAnimation();
            this.mPrimaryActionMode = mode;
            this.mPrimaryActionMode.invalidate();
            this.mPrimaryActionModeView.initForMode(this.mPrimaryActionMode);
            if (this.mPrimaryActionModePopup != null) {
                this.post(this.mShowPrimaryActionModePopup);
            } else {
                this.mFadeAnim = ObjectAnimator.ofFloat(this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
                this.mFadeAnim.addListener(new Animator.AnimatorListener(){

                    @Override
                    public void onAnimationStart(Animator animation) {
                        DecorView.this.mPrimaryActionModeView.setVisibility(0);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                        DecorView.this.mFadeAnim = null;
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mFadeAnim.start();
            }
            this.mPrimaryActionModeView.sendAccessibilityEvent(32);
        }

        private ActionMode createFloatingActionMode(View originatingView, ActionMode.Callback2 callback) {
            if (this.mFloatingActionMode != null) {
                this.mFloatingActionMode.finish();
            }
            this.cleanupFloatingActionModeViews();
            final FloatingActionMode mode = new FloatingActionMode(this.mContext, callback, originatingView);
            this.mFloatingActionModeOriginatingView = originatingView;
            this.mFloatingToolbarPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    mode.updateViewLocationInWindow();
                    return true;
                }
            };
            return mode;
        }

        private void setHandledFloatingActionMode(ActionMode mode) {
            this.mFloatingActionMode = mode;
            this.mFloatingToolbar = new FloatingToolbar(this.mContext, PhoneWindow.this);
            ((FloatingActionMode)this.mFloatingActionMode).setFloatingToolbar(this.mFloatingToolbar);
            this.mFloatingActionMode.invalidate();
            this.mFloatingActionModeOriginatingView.getViewTreeObserver().addOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
        }

        private class ActionModeCallback2Wrapper
        extends ActionMode.Callback2 {
            private final ActionMode.Callback mWrapped;

            public ActionModeCallback2Wrapper(ActionMode.Callback wrapped) {
                this.mWrapped = wrapped;
            }

            @Override
            public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
                return this.mWrapped.onCreateActionMode(mode, menu2);
            }

            @Override
            public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
                DecorView.this.requestFitSystemWindows();
                return this.mWrapped.onPrepareActionMode(mode, menu2);
            }

            @Override
            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return this.mWrapped.onActionItemClicked(mode, item);
            }

            @Override
            public void onDestroyActionMode(ActionMode mode) {
                boolean isFloating;
                boolean isPrimary;
                boolean isMncApp;
                this.mWrapped.onDestroyActionMode(mode);
                boolean bl = isMncApp = ((DecorView)DecorView.this).mContext.getApplicationInfo().targetSdkVersion >= 23;
                if (isMncApp) {
                    isPrimary = mode == DecorView.this.mPrimaryActionMode;
                    boolean bl2 = isFloating = mode == DecorView.this.mFloatingActionMode;
                    if (!isPrimary && mode.getType() == 0) {
                        Log.e(PhoneWindow.TAG, "Destroying unexpected ActionMode instance of TYPE_PRIMARY; " + mode + " was not the current primary action mode! Expected " + DecorView.this.mPrimaryActionMode);
                    }
                    if (!isFloating && mode.getType() == 1) {
                        Log.e(PhoneWindow.TAG, "Destroying unexpected ActionMode instance of TYPE_FLOATING; " + mode + " was not the current floating action mode! Expected " + DecorView.this.mFloatingActionMode);
                    }
                } else {
                    isPrimary = mode.getType() == 0;
                    boolean bl3 = isFloating = mode.getType() == 1;
                }
                if (isPrimary) {
                    if (DecorView.this.mPrimaryActionModePopup != null) {
                        DecorView.this.removeCallbacks(DecorView.this.mShowPrimaryActionModePopup);
                    }
                    if (DecorView.this.mPrimaryActionModeView != null) {
                        DecorView.this.endOnGoingFadeAnimation();
                        DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 1.0f, 0.0f);
                        DecorView.this.mFadeAnim.addListener(new Animator.AnimatorListener(){

                            @Override
                            public void onAnimationStart(Animator animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                DecorView.this.mPrimaryActionModeView.setVisibility(8);
                                if (DecorView.this.mPrimaryActionModePopup != null) {
                                    DecorView.this.mPrimaryActionModePopup.dismiss();
                                }
                                DecorView.this.mPrimaryActionModeView.removeAllViews();
                                DecorView.this.mFadeAnim = null;
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {
                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                        DecorView.this.mFadeAnim.start();
                    }
                    DecorView.this.mPrimaryActionMode = null;
                } else if (isFloating) {
                    DecorView.this.cleanupFloatingActionModeViews();
                    DecorView.this.mFloatingActionMode = null;
                }
                if (PhoneWindow.this.getCallback() != null && !PhoneWindow.this.isDestroyed()) {
                    try {
                        PhoneWindow.this.getCallback().onActionModeFinished(mode);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
                DecorView.this.requestFitSystemWindows();
            }

            @Override
            public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
                if (this.mWrapped instanceof ActionMode.Callback2) {
                    ((ActionMode.Callback2)this.mWrapped).onGetContentRect(mode, view, outRect);
                } else {
                    super.onGetContentRect(mode, view, outRect);
                }
            }
        }
    }

    private class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        private ActionMenuPresenterCallback() {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null) {
                cb.onMenuOpened(8, subMenu);
                return true;
            }
            return false;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            PhoneWindow.this.checkCloseActionMenu(menu2);
        }
    }

    private class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        private PanelMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu2.getRootMenu();
            boolean isSubMenu = parentMenu != menu2;
            PanelFeatureState panel = PhoneWindow.this.findMenuPanel(isSubMenu ? parentMenu : menu2);
            if (panel != null) {
                if (isSubMenu) {
                    PhoneWindow.this.callOnPanelClosed(panel.featureId, panel, parentMenu);
                    PhoneWindow.this.closePanel(panel, true);
                } else {
                    PhoneWindow.this.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb;
            if (subMenu == null && PhoneWindow.this.hasFeature(8) && (cb = PhoneWindow.this.getCallback()) != null && !PhoneWindow.this.isDestroyed()) {
                cb.onMenuOpened(8, subMenu);
            }
            return true;
        }
    }

    static class WindowManagerHolder {
        static final IWindowManager sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));

        WindowManagerHolder() {
        }
    }
}

