/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.text.TextUtils;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class KernelCpuSpeedReader {
    private static final String TAG = "KernelCpuSpeedReader";
    private static final String sProcFile = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state";
    private static final int MAX_SPEEDS = 60;
    private long[] mLastSpeedTimes = new long[60];
    private long[] mDeltaSpeedTimes = new long[60];

    public long[] readDelta() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sProcFile));
            Throwable throwable = null;
            try {
                String line;
                TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
                int speedIndex = 0;
                while ((line = reader.readLine()) != null) {
                    splitter.setString(line);
                    Long.parseLong(splitter.next());
                    long time = Long.parseLong(splitter.next()) * 10L;
                    this.mDeltaSpeedTimes[speedIndex] = time - this.mLastSpeedTimes[speedIndex];
                    this.mLastSpeedTimes[speedIndex] = time;
                    ++speedIndex;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read cpu-freq", e);
            Arrays.fill(this.mDeltaSpeedTimes, 0L);
        }
        return this.mDeltaSpeedTimes;
    }
}

