/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class BluetoothPowerCalculator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "BluetoothPowerCalculator";
    private final double mIdleMa;
    private final double mRxMa;
    private final double mTxMa;

    public BluetoothPowerCalculator(PowerProfile profile) {
        this.mIdleMa = profile.getAveragePower("bluetooth.controller.idle");
        this.mRxMa = profile.getAveragePower("bluetooth.controller.rx");
        this.mTxMa = profile.getAveragePower("bluetooth.controller.tx");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long idleTimeMs = stats.getBluetoothControllerActivity(0, statsType);
        long txTimeMs = stats.getBluetoothControllerActivity(2, statsType);
        long rxTimeMs = stats.getBluetoothControllerActivity(1, statsType);
        long totalTimeMs = idleTimeMs + txTimeMs + rxTimeMs;
        double powerMah = (double)stats.getBluetoothControllerActivity(3, statsType) / 3600000.0;
        if (powerMah == 0.0) {
            powerMah = ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
        }
        app.usagePowerMah = powerMah;
        app.usageTimeMs = totalTimeMs;
    }
}

