/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkStats;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ProcFileReader;
import com.android.server.NetworkManagementSocketTagger;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.AutoCloseable;
import com.android.tools.layoutlib.java.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import libcore.io.IoUtils;

public class NetworkStatsFactory {
    private static final String TAG = "NetworkStatsFactory";
    private static final boolean USE_NATIVE_PARSING = true;
    private static final boolean SANITY_CHECK_NATIVE = false;
    private final File mStatsXtIfaceAll;
    private final File mStatsXtIfaceFmt;
    private final File mStatsXtUid;
    @GuardedBy(value="sStackedIfaces")
    private static final ArrayMap<String, String> sStackedIfaces = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteStackedIface(String stackedIface, String baseIface) {
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            if (baseIface != null) {
                sStackedIfaces.put(stackedIface, baseIface);
            } else {
                sStackedIfaces.remove(stackedIface);
            }
        }
    }

    public NetworkStatsFactory() {
        this(new File("/proc/"));
    }

    public NetworkStatsFactory(File procRoot) {
        this.mStatsXtIfaceAll = new File(procRoot, "net/xt_qtaguid/iface_stat_all");
        this.mStatsXtIfaceFmt = new File(procRoot, "net/xt_qtaguid/iface_stat_fmt");
        this.mStatsXtUid = new File(procRoot, "net/xt_qtaguid/stats");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsSummaryDev() throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceAll));
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                boolean active = reader.nextInt() != 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (active) {
                    entry.rxBytes += reader.nextLong();
                    entry.rxPackets += reader.nextLong();
                    entry.txBytes += reader.nextLong();
                    entry.txPackets += reader.nextLong();
                }
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing stats", (Throwable)e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing stats", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)((Object)reader));
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkStats readNetworkStatsSummaryXt() throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        if (!this.mStatsXtIfaceFmt.exists()) {
            return null;
        }
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceFmt));
            reader.finishLine();
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing stats", (Throwable)e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing stats", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)((Object)reader));
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public NetworkStats readNetworkStatsDetail() throws IOException {
        return this.readNetworkStatsDetail(-1, null, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStats readNetworkStatsDetail(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        NetworkStats stats = this.readNetworkStatsDetailInternal(limitUid, limitIfaces, limitTag, lastStats);
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            int size = sStackedIfaces.size();
            for (int i = 0; i < size; ++i) {
                String stackedIface = sStackedIfaces.keyAt(i);
                String baseIface = sStackedIfaces.valueAt(i);
                NetworkStats.Entry adjust = new NetworkStats.Entry(baseIface, 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
                NetworkStats.Entry entry = null;
                for (int j = 0; j < stats.size(); ++j) {
                    entry = stats.getValues(j, entry);
                    if (!Objects.equals(entry.iface, stackedIface)) continue;
                    adjust.txBytes -= entry.txBytes;
                    adjust.txPackets -= entry.txPackets;
                }
                stats.combineValues(adjust);
            }
        }
        NetworkStats.Entry entry = null;
        for (int i = 0; i < stats.size(); ++i) {
            entry = stats.getValues(i, entry);
            if (entry.iface == null || !entry.iface.startsWith("clat")) continue;
            entry.rxBytes = entry.rxPackets * 20L;
            entry.rxPackets = 0L;
            entry.txBytes = 0L;
            entry.txPackets = 0L;
            stats.combineValues(entry);
        }
        return stats;
    }

    private NetworkStats readNetworkStatsDetailInternal(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        NetworkStats stats;
        if (lastStats != null) {
            stats = lastStats;
            stats.setElapsedRealtime(SystemClock.elapsedRealtime());
        } else {
            stats = new NetworkStats(SystemClock.elapsedRealtime(), -1);
        }
        if (NetworkStatsFactory.nativeReadNetworkStatsDetail(stats, this.mStatsXtUid.getAbsolutePath(), limitUid, limitIfaces, limitTag) != 0) {
            throw new IOException("Failed to parse network stats");
        }
        return stats;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkStats javaReadNetworkStatsDetail(File detailPath, int limitUid, String[] limitIfaces, int limitTag) throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 24);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        int idx = 1;
        int lastIdx = 1;
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(detailPath));
            reader.finishLine();
            while (reader.hasMoreData()) {
                idx = reader.nextInt();
                if (idx != lastIdx + 1) {
                    throw new ProtocolException("inconsistent idx=" + idx + " after lastIdx=" + lastIdx);
                }
                lastIdx = idx;
                entry.iface = reader.nextString();
                entry.tag = NetworkManagementSocketTagger.kernelToTag(reader.nextString());
                entry.uid = reader.nextInt();
                entry.set = reader.nextInt();
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (!(limitIfaces != null && !ArrayUtils.contains(limitIfaces, entry.iface) || limitUid != -1 && limitUid != entry.uid || limitTag != -1 && limitTag != entry.tag)) {
                    stats.addValues(entry);
                }
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing idx " + idx, (Throwable)e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing idx " + idx, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)((Object)reader));
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public void assertEquals(NetworkStats expected, NetworkStats actual) {
        if (expected.size() != actual.size()) {
            throw new AssertionError((Object)("Expected size " + expected.size() + ", actual size " + actual.size()));
        }
        NetworkStats.Entry expectedRow = null;
        NetworkStats.Entry actualRow = null;
        for (int i = 0; i < expected.size(); ++i) {
            if (!(expectedRow = expected.getValues(i, expectedRow)).equals(actualRow = actual.getValues(i, actualRow))) {
                throw new AssertionError((Object)("Expected row " + i + ": " + expectedRow + ", actual row " + actualRow));
            }
        }
    }

    public static int nativeReadNetworkStatsDetail(NetworkStats networkStats, String string2, int n, String[] stringArray, int n2) {
        return OverrideMethod.invokeI("com.android.internal.net.NetworkStatsFactory#nativeReadNetworkStatsDetail(Landroid/net/NetworkStats;Ljava/lang/String;I[Ljava/lang/String;I)I", true, null);
    }
}

