/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.app.PendingIntent;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.UndoOperation;
import android.content.UndoOwner;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableParcel;
import android.os.SystemClock;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.WordIterator;
import android.text.style.EasyEditSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.ActionMode;
import android.view.DisplayListCanvas;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpellChecker;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.EditableInputConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class Editor {
    private static final String TAG = "Editor";
    private static final boolean DEBUG_UNDO = false;
    static final int BLINK = 500;
    private static final float[] TEMP_POSITION = new float[2];
    private static int DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
    private static final float LINE_SLOP_MULTIPLIER_FOR_HANDLEVIEWS = 0.5f;
    private static final int UNSET_X_VALUE = -1;
    private static final int UNSET_LINE = -1;
    private static final String UNDO_OWNER_TAG = "Editor";
    private static final int MENU_ITEM_ORDER_CUT = 1;
    private static final int MENU_ITEM_ORDER_COPY = 2;
    private static final int MENU_ITEM_ORDER_PASTE = 3;
    private static final int MENU_ITEM_ORDER_SHARE = 4;
    private static final int MENU_ITEM_ORDER_SELECT_ALL = 5;
    private static final int MENU_ITEM_ORDER_REPLACE = 6;
    private static final int MENU_ITEM_ORDER_PROCESS_TEXT_INTENT_ACTIONS_START = 10;
    private final UndoManager mUndoManager = new UndoManager();
    private UndoOwner mUndoOwner = this.mUndoManager.getOwner("Editor", this);
    final UndoInputFilter mUndoInputFilter = new UndoInputFilter(this);
    boolean mAllowUndo = true;
    InsertionPointCursorController mInsertionPointCursorController;
    SelectionModifierCursorController mSelectionModifierCursorController;
    ActionMode mTextActionMode;
    boolean mInsertionControllerEnabled;
    boolean mSelectionControllerEnabled;
    CorrectionHighlighter mCorrectionHighlighter;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    TextRenderNode[] mTextRenderNodes;
    boolean mFrozenWithFocus;
    boolean mSelectionMoved;
    boolean mTouchFocusSelected;
    KeyListener mKeyListener;
    int mInputType = 0;
    boolean mDiscardNextActionUp;
    boolean mIgnoreActionUpEvent;
    long mShowCursor;
    Blink mBlink;
    boolean mCursorVisible = true;
    boolean mSelectAllOnFocus;
    boolean mTextIsSelectable;
    CharSequence mError;
    boolean mErrorWasChanged;
    ErrorPopup mErrorPopup;
    boolean mShowErrorAfterAttach;
    boolean mInBatchEditControllers;
    boolean mShowSoftInputOnFocus = true;
    boolean mPreserveDetachedSelection;
    boolean mTemporaryDetach;
    SuggestionsPopupWindow mSuggestionsPopupWindow;
    SuggestionRangeSpan mSuggestionRangeSpan;
    Runnable mShowSuggestionRunnable;
    final Drawable[] mCursorDrawable = new Drawable[2];
    int mCursorCount;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private PositionListener mPositionListener;
    float mLastDownPositionX;
    float mLastDownPositionY;
    ActionMode.Callback mCustomSelectionActionModeCallback;
    ActionMode.Callback mCustomInsertionActionModeCallback;
    boolean mCreatedWithASelection;
    boolean mDoubleTap = false;
    private Runnable mInsertionActionModeRunnable;
    private SpanController mSpanController;
    WordIterator mWordIterator;
    SpellChecker mSpellChecker;
    private WordIterator mWordIteratorWithText;
    private boolean mUpdateWordIteratorText;
    private Rect mTempRect;
    private TextView mTextView;
    final ProcessTextIntentActionsHandler mProcessTextIntentActionsHandler;
    final CursorAnchorInfoNotifier mCursorAnchorInfoNotifier = new CursorAnchorInfoNotifier();
    private final Runnable mShowFloatingToolbar = new Runnable(){

        @Override
        public void run() {
            if (Editor.this.mTextActionMode != null) {
                Editor.this.mTextActionMode.hide(0L);
            }
        }
    };
    boolean mIsInsertionActionModeStartPending = false;
    static final int EXTRACT_NOTHING = -2;
    static final int EXTRACT_UNKNOWN = -1;

    Editor(TextView textView) {
        this.mTextView = textView;
        this.mTextView.setFilters(this.mTextView.getFilters());
        this.mProcessTextIntentActionsHandler = new ProcessTextIntentActionsHandler(this);
    }

    ParcelableParcel saveInstanceState() {
        ParcelableParcel state = new ParcelableParcel(this.getClass().getClassLoader());
        Parcel parcel = state.getParcel();
        this.mUndoManager.saveInstanceState(parcel);
        this.mUndoInputFilter.saveInstanceState(parcel);
        return state;
    }

    void restoreInstanceState(ParcelableParcel state) {
        Parcel parcel = state.getParcel();
        this.mUndoManager.restoreInstanceState(parcel, state.getClassLoader());
        this.mUndoInputFilter.restoreInstanceState(parcel);
        this.mUndoOwner = this.mUndoManager.getOwner("Editor", this);
    }

    void forgetUndoRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.forgetUndos(owners, -1);
        this.mUndoManager.forgetRedos(owners, -1);
    }

    boolean canUndo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countUndos(owners) > 0;
    }

    boolean canRedo() {
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        return this.mAllowUndo && this.mUndoManager.countRedos(owners) > 0;
    }

    void undo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.undo(owners, 1);
    }

    void redo() {
        if (!this.mAllowUndo) {
            return;
        }
        UndoOwner[] owners = new UndoOwner[]{this.mUndoOwner};
        this.mUndoManager.redo(owners, 1);
    }

    void replace() {
        int middle = (this.mTextView.getSelectionStart() + this.mTextView.getSelectionEnd()) / 2;
        this.stopTextActionMode();
        Selection.setSelection((Spannable)this.mTextView.getText(), middle);
        this.showSuggestions();
    }

    void onAttachedToWindow() {
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        this.mTemporaryDetach = false;
        ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
        if (this.mInsertionPointCursorController != null) {
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        this.updateSpellCheckSpans(0, this.mTextView.getText().length(), true);
        if (this.mTextView.hasTransientState() && this.mTextView.getSelectionStart() != this.mTextView.getSelectionEnd()) {
            this.mTextView.setHasTransientState(false);
            this.startSelectionActionMode();
        }
        this.getPositionListener().addSubscriber(this.mCursorAnchorInfoNotifier, true);
        this.resumeBlink();
    }

    void onDetachedFromWindow() {
        this.getPositionListener().removeSubscriber(this.mCursorAnchorInfoNotifier);
        if (this.mError != null) {
            this.hideError();
        }
        this.suspendBlink();
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
        }
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        this.mTextView.removeCallbacks(this.mShowFloatingToolbar);
        this.destroyDisplayListsData();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
        this.mPreserveDetachedSelection = true;
        this.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        this.mPreserveDetachedSelection = false;
        this.mTemporaryDetach = false;
    }

    private void destroyDisplayListsData() {
        if (this.mTextRenderNodes != null) {
            for (int i = 0; i < this.mTextRenderNodes.length; ++i) {
                RenderNode displayList;
                RenderNode renderNode = displayList = this.mTextRenderNodes[i] != null ? this.mTextRenderNodes[i].renderNode : null;
                if (displayList == null || !displayList.isValid()) continue;
                displayList.destroyDisplayListData();
            }
        }
    }

    private void showError() {
        if (this.mTextView.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mErrorPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mTextView.getContext());
            TextView err = (TextView)inflater.inflate(17367279, null);
            float scale = this.mTextView.getResources().getDisplayMetrics().density;
            this.mErrorPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mErrorPopup.setFocusable(false);
            this.mErrorPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mErrorPopup.getContentView();
        this.chooseSize(this.mErrorPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mErrorPopup.showAsDropDown(this.mTextView, this.getErrorX(), this.getErrorY());
        this.mErrorPopup.fixDirection(this.mErrorPopup.isAboveAnchor());
    }

    public void setError(CharSequence error, Drawable icon) {
        this.mError = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        if (this.mError == null) {
            this.setErrorIcon(null);
            if (this.mErrorPopup != null) {
                if (this.mErrorPopup.isShowing()) {
                    this.mErrorPopup.dismiss();
                }
                this.mErrorPopup = null;
            }
            this.mShowErrorAfterAttach = false;
        } else {
            this.setErrorIcon(icon);
            if (this.mTextView.isFocused()) {
                this.showError();
            }
        }
    }

    private void setErrorIcon(Drawable icon) {
        TextView.Drawables dr = this.mTextView.mDrawables;
        if (dr == null) {
            this.mTextView.mDrawables = dr = new TextView.Drawables(this.mTextView.getContext());
        }
        dr.setErrorDrawable(icon, this.mTextView);
        this.mTextView.resetResolvedDrawables();
        this.mTextView.invalidate();
        this.mTextView.requestLayout();
    }

    private void hideError() {
        if (this.mErrorPopup != null && this.mErrorPopup.isShowing()) {
            this.mErrorPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private int getErrorX() {
        int errorX;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                int offset = -(dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getWidth() - this.mErrorPopup.getWidth() - this.mTextView.getPaddingRight() + offset;
                break;
            }
            case 1: {
                int offset = (dr != null ? dr.mDrawableSizeLeft : 0) / 2 - (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getPaddingLeft() + offset;
            }
        }
        return errorX;
    }

    private int getErrorY() {
        int height;
        int compoundPaddingTop = this.mTextView.getCompoundPaddingTop();
        int vspace = this.mTextView.getBottom() - this.mTextView.getTop() - this.mTextView.getCompoundPaddingBottom() - compoundPaddingTop;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                height = dr != null ? dr.mDrawableHeightRight : 0;
                break;
            }
            case 1: {
                height = dr != null ? dr.mDrawableHeightLeft : 0;
            }
        }
        int icontop = compoundPaddingTop + (vspace - height) / 2;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        return icontop + height - this.mTextView.getHeight() - (int)(2.0f * scale + 0.5f);
    }

    void createInputContentTypeIfNeeded() {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
    }

    void createInputMethodStateIfNeeded() {
        if (this.mInputMethodState == null) {
            this.mInputMethodState = new InputMethodState();
        }
    }

    boolean isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    void prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.mTextView.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        boolean enabled = windowSupportsHandles && this.mTextView.getLayout() != null;
        this.mInsertionControllerEnabled = enabled && this.isCursorVisible();
        boolean bl = this.mSelectionControllerEnabled = enabled && this.mTextView.textCanBeSelected();
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopTextActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    void hideCursorAndSpanControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    private void hideSpanControllers() {
        if (this.mSpanController != null) {
            this.mSpanController.hide();
        }
    }

    private void hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && (this.mTextView.isInExtractedMode() || !this.mSuggestionsPopupWindow.isShowingUp())) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
    }

    private void updateSpellCheckSpans(int start, int end, boolean createSpellChecker) {
        this.mTextView.removeAdjacentSuggestionSpans(start);
        this.mTextView.removeAdjacentSuggestionSpans(end);
        if (this.mTextView.isTextEditable() && this.mTextView.isSuggestionsEnabled() && !this.mTextView.isInExtractedMode()) {
            if (this.mSpellChecker == null && createSpellChecker) {
                this.mSpellChecker = new SpellChecker(this.mTextView);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(start, end);
            }
        }
    }

    void onScreenStateChanged(int screenState) {
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    void adjustInputType(boolean password, boolean passwordInputType, boolean webPasswordInputType, boolean numberPasswordInputType) {
        if ((this.mInputType & 0xF) == 1) {
            if (password || passwordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
            }
            if (webPasswordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0xE0;
            }
        } else if ((this.mInputType & 0xF) == 2 && numberPasswordInputType) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x10;
        }
    }

    private void chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int defaultWidthInPixels = this.mTextView.getResources().getDimensionPixelSize(17104978);
        StaticLayout l = new StaticLayout(text, tv.getPaint(), defaultWidthInPixels, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float max = 0.0f;
        for (int i = 0; i < ((Layout)l).getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    void setFrame() {
        if (this.mErrorPopup != null) {
            TextView tv = (TextView)this.mErrorPopup.getContentView();
            this.chooseSize(this.mErrorPopup, this.mError, tv);
            this.mErrorPopup.update(this.mTextView, this.getErrorX(), this.getErrorY(), this.mErrorPopup.getWidth(), this.mErrorPopup.getHeight());
        }
    }

    private int getWordStart(int offset) {
        int retOffset = this.getWordIteratorWithText().prevBoundary(offset);
        retOffset = this.getWordIteratorWithText().isOnPunctuation(retOffset) ? this.getWordIteratorWithText().getPunctuationBeginning(offset) : this.getWordIteratorWithText().getPrevWordBeginningOnTwoWordsBoundary(offset);
        if (retOffset == -1) {
            return offset;
        }
        return retOffset;
    }

    private int getWordEnd(int offset) {
        int retOffset = this.getWordIteratorWithText().nextBoundary(offset);
        retOffset = this.getWordIteratorWithText().isAfterPunctuation(retOffset) ? this.getWordIteratorWithText().getPunctuationEnd(offset) : this.getWordIteratorWithText().getNextWordEndOnTwoWordBoundary(offset);
        if (retOffset == -1) {
            return offset;
        }
        return retOffset;
    }

    private boolean selectCurrentWord() {
        int selectionEnd;
        int selectionStart;
        if (!this.mTextView.canSelectText()) {
            return false;
        }
        if (this.mTextView.hasPasswordTransformationMethod()) {
            return this.mTextView.selectAllText();
        }
        int inputType = this.mTextView.getInputType();
        int klass = inputType & 0xF;
        int variation = inputType & 0xFF0;
        if (klass == 2 || klass == 3 || klass == 4 || variation == 16 || variation == 32 || variation == 208 || variation == 176) {
            return this.mTextView.selectAllText();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minOffset = TextUtils.unpackRangeStartFromLong(lastTouchOffsets);
        int maxOffset = TextUtils.unpackRangeEndFromLong(lastTouchOffsets);
        if (minOffset < 0 || minOffset >= this.mTextView.getText().length()) {
            return false;
        }
        if (maxOffset < 0 || maxOffset >= this.mTextView.getText().length()) {
            return false;
        }
        URLSpan[] urlSpans = ((Spanned)this.mTextView.getText()).getSpans(minOffset, maxOffset, URLSpan.class);
        if (urlSpans.length >= 1) {
            URLSpan urlSpan = urlSpans[0];
            selectionStart = ((Spanned)this.mTextView.getText()).getSpanStart(urlSpan);
            selectionEnd = ((Spanned)this.mTextView.getText()).getSpanEnd(urlSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mTextView.getText(), minOffset, maxOffset);
            selectionStart = wordIterator.getBeginning(minOffset);
            selectionEnd = wordIterator.getEnd(maxOffset);
            if (selectionStart == -1 || selectionEnd == -1 || selectionStart == selectionEnd) {
                long range = this.getCharClusterRange(minOffset);
                selectionStart = TextUtils.unpackRangeStartFromLong(range);
                selectionEnd = TextUtils.unpackRangeEndFromLong(range);
            }
        }
        Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        return selectionEnd > selectionStart;
    }

    void onLocaleChanged() {
        this.mWordIterator = null;
        this.mWordIteratorWithText = null;
    }

    public WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    private WordIterator getWordIteratorWithText() {
        if (this.mWordIteratorWithText == null) {
            this.mWordIteratorWithText = new WordIterator(this.mTextView.getTextServicesLocale());
            this.mUpdateWordIteratorText = true;
        }
        if (this.mUpdateWordIteratorText) {
            CharSequence text = this.mTextView.getText();
            this.mWordIteratorWithText.setCharSequence(text, 0, text.length());
            this.mUpdateWordIteratorText = false;
        }
        return this.mWordIteratorWithText;
    }

    private int getNextCursorOffset(int offset, boolean findAfterGivenOffset) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return offset;
        }
        CharSequence text = this.mTextView.getText();
        int nextOffset = layout2.getPaint().getTextRunCursor(text, 0, text.length(), layout2.isRtlCharAt(offset) ? 1 : 0, offset, findAfterGivenOffset ? 0 : 2);
        return nextOffset == -1 ? offset : nextOffset;
    }

    private long getCharClusterRange(int offset) {
        int textLength = this.mTextView.getText().length();
        if (offset < textLength) {
            return TextUtils.packRangeInLong(offset, this.getNextCursorOffset(offset, true));
        }
        if (offset - 1 >= 0) {
            return TextUtils.packRangeInLong(this.getNextCursorOffset(offset, false), offset);
        }
        return TextUtils.packRangeInLong(offset, offset);
    }

    private boolean touchPositionIsInSelection() {
        int selectionEnd;
        int selectionStart = this.mTextView.getSelectionStart();
        if (selectionStart == (selectionEnd = this.mTextView.getSelectionEnd())) {
            return false;
        }
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
            Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        }
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return minOffset >= selectionStart && maxOffset < selectionEnd;
    }

    private PositionListener getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener();
        }
        return this.mPositionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPositionVisible(float positionX, float positionY) {
        float[] fArray = TEMP_POSITION;
        synchronized (TEMP_POSITION) {
            float[] position = TEMP_POSITION;
            position[0] = positionX;
            position[1] = positionY;
            View view = this.mTextView;
            while (view != null) {
                if (view != this.mTextView) {
                    position[0] = position[0] - (float)view.getScrollX();
                    position[1] = position[1] - (float)view.getScrollY();
                }
                if (position[0] < 0.0f || position[1] < 0.0f || position[0] > (float)view.getWidth() || position[1] > (float)view.getHeight()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(position);
                }
                position[0] = position[0] + (float)view.getLeft();
                position[1] = position[1] + (float)view.getTop();
                ViewParent parent = view.getParent();
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    continue;
                }
                view = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private boolean isOffsetVisible(int offset) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = layout2.getLineForOffset(offset);
        int lineBottom = layout2.getLineBottom(line);
        int primaryHorizontal = (int)layout2.getPrimaryHorizontal(offset);
        return this.isPositionVisible(primaryHorizontal + this.mTextView.viewportToContentHorizontalOffset(), lineBottom + this.mTextView.viewportToContentVerticalOffset());
    }

    private boolean isPositionOnText(float x, float y) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = this.mTextView.getLineAtCoordinate(y);
        if ((x = this.mTextView.convertToLocalHorizontalCoordinate(x)) < layout2.getLineLeft(line)) {
            return false;
        }
        return !(x > layout2.getLineRight(line));
    }

    public boolean performLongClick(boolean handled) {
        if (!handled && !this.isPositionOnText(this.mLastDownPositionX, this.mLastDownPositionY) && this.mInsertionControllerEnabled) {
            int offset = this.mTextView.getOffsetForPosition(this.mLastDownPositionX, this.mLastDownPositionY);
            this.stopTextActionMode();
            Selection.setSelection((Spannable)this.mTextView.getText(), offset);
            this.getInsertionController().show();
            this.mIsInsertionActionModeStartPending = true;
            handled = true;
        }
        if (!handled && this.mTextActionMode != null) {
            if (this.touchPositionIsInSelection() && !this.mTextView.isInExtractedMode()) {
                int start = this.mTextView.getSelectionStart();
                int end = this.mTextView.getSelectionEnd();
                CharSequence selectedText = this.mTextView.getTransformedText(start, end);
                ClipData data = ClipData.newPlainText(null, selectedText);
                DragLocalState localState = new DragLocalState(this.mTextView, start, end);
                this.mTextView.startDrag(data, this.getTextThumbnailBuilder(selectedText), localState, 1);
                this.stopTextActionMode();
            } else {
                this.stopTextActionMode();
                this.selectCurrentWordAndStartDrag();
            }
            handled = true;
        }
        if (!handled) {
            handled = this.selectCurrentWordAndStartDrag();
        }
        return handled;
    }

    private long getLastTouchOffsets() {
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return TextUtils.packRangeInLong(minOffset, maxOffset);
    }

    void onFocusChanged(boolean focused, int direction) {
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.mTextView.getSelectionStart();
            int selEnd = this.mTextView.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mTextView.getText().length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.mTextView.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                MovementMethod mMovement;
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), lastTapPosition);
                }
                if ((mMovement = this.mTextView.getMovementMethod()) != null) {
                    mMovement.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), direction);
                }
                if ((this.mTextView.isInExtractedMode() || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    this.mTextView.selectAllText();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mError != null) {
                this.showError();
            }
            this.makeBlink();
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.mTextView.onEndBatchEdit();
            if (this.mTextView.isInExtractedMode()) {
                int selStart = this.mTextView.getSelectionStart();
                int selEnd = this.mTextView.getSelectionEnd();
                this.hideCursorAndSpanControllers();
                this.stopTextActionMode();
                Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
            } else {
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = true;
                }
                this.hideCursorAndSpanControllers();
                this.stopTextActionMode();
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = false;
                }
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
            }
        }
    }

    private void downgradeEasyCorrectionSpans() {
        CharSequence text = this.mTextView.getText();
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpans.length; ++i) {
                int flags = suggestionSpans[i].getFlags();
                if ((flags & 1) == 0 || (flags & 2) != 0) continue;
                suggestionSpans[i].setFlags(flags &= 0xFFFFFFFE);
            }
        }
    }

    void sendOnTextChanged(int start, int after) {
        this.updateSpellCheckSpans(start, start + after, false);
        this.mUpdateWordIteratorText = true;
        this.hideCursorControllers();
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
        }
        this.stopTextActionMode();
    }

    private int getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mTextView.getText().length()) {
                lastTapPosition = this.mTextView.getText().length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            InputMethodManager imm;
            boolean immFullScreen;
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
            boolean bl = immFullScreen = (imm = InputMethodManager.peekInstance()) != null && imm.isFullscreenMode();
            if (this.mSelectionModifierCursorController != null && this.mTextView.hasSelection() && !immFullScreen && this.mTextActionMode != null) {
                this.mSelectionModifierCursorController.show();
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideCursorAndSpanControllers();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.hide();
            }
            if (this.mSuggestionsPopupWindow != null) {
                this.mSuggestionsPopupWindow.onParentLostFocus();
            }
            this.ensureEndedBatchEdit();
        }
    }

    void onTouchEvent(MotionEvent event) {
        this.updateFloatingToolbarVisibility(event);
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
            this.mShowSuggestionRunnable = null;
        }
        if (event.getActionMasked() == 0) {
            this.mLastDownPositionX = event.getX();
            this.mLastDownPositionY = event.getY();
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    private void updateFloatingToolbarVisibility(MotionEvent event) {
        if (this.mTextActionMode != null) {
            switch (event.getActionMasked()) {
                case 2: {
                    this.hideFloatingToolbar();
                    break;
                }
                case 1: 
                case 3: {
                    this.showFloatingToolbar();
                }
            }
        }
    }

    private void hideFloatingToolbar() {
        if (this.mTextActionMode != null) {
            this.mTextView.removeCallbacks(this.mShowFloatingToolbar);
            this.mTextActionMode.hide(-1L);
        }
    }

    private void showFloatingToolbar() {
        if (this.mTextActionMode != null) {
            int delay = ViewConfiguration.getDoubleTapTimeout();
            this.mTextView.postDelayed(this.mShowFloatingToolbar, delay);
        }
    }

    public void beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mTextView.getText().length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.mUndoInputFilter.beginBatchEdit();
            this.mTextView.onBeginBatchEdit();
        }
    }

    public void endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    void ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    void finishBatchEdit(InputMethodState ims) {
        this.mTextView.onEndBatchEdit();
        this.mUndoInputFilter.endBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.mTextView.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.mTextView.invalidateCursor();
        }
        this.sendUpdateSelection();
    }

    boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    private boolean extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        if (request == null || outText == null) {
            return false;
        }
        CharSequence content = this.mTextView.getText();
        if (content == null) {
            return false;
        }
        if (partialStartOffset != -2) {
            int N = content.length();
            if (partialStartOffset < 0) {
                outText.partialEndOffset = -1;
                outText.partialStartOffset = -1;
                partialStartOffset = 0;
                partialEndOffset = N;
            } else {
                partialEndOffset += delta;
                if (content instanceof Spanned) {
                    Spanned spanned = (Spanned)content;
                    ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                    int i = spans.length;
                    while (i > 0) {
                        int j;
                        if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                            partialStartOffset = j;
                        }
                        if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                        partialEndOffset = j;
                    }
                }
                outText.partialStartOffset = partialStartOffset;
                outText.partialEndOffset = partialEndOffset - delta;
                if (partialStartOffset > N) {
                    partialStartOffset = N;
                } else if (partialStartOffset < 0) {
                    partialStartOffset = 0;
                }
                if (partialEndOffset > N) {
                    partialEndOffset = N;
                } else if (partialEndOffset < 0) {
                    partialEndOffset = 0;
                }
            }
            outText.text = (request.flags & 1) != 0 ? content.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content, partialStartOffset, partialEndOffset);
        } else {
            outText.partialStartOffset = 0;
            outText.partialEndOffset = 0;
            outText.text = "";
        }
        outText.flags = 0;
        if (MetaKeyKeyListener.getMetaState(content, 2048) != 0) {
            outText.flags |= 2;
        }
        if (this.mTextView.isSingleLine()) {
            outText.flags |= 1;
        }
        outText.startOffset = 0;
        outText.selectionStart = this.mTextView.getSelectionStart();
        outText.selectionEnd = this.mTextView.getSelectionEnd();
        return true;
    }

    boolean reportExtractedText() {
        boolean contentChanged;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ((contentChanged = ims.mContentChanged) || ims.mSelectionModeChanged)) {
            InputMethodManager imm;
            ims.mContentChanged = false;
            ims.mSelectionModeChanged = false;
            ExtractedTextRequest req = ims.mExtractedTextRequest;
            if (req != null && (imm = InputMethodManager.peekInstance()) != null) {
                if (ims.mChangedStart < 0 && !contentChanged) {
                    ims.mChangedStart = -2;
                }
                if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mExtractedText)) {
                    imm.updateExtractedText(this.mTextView, req.token, ims.mExtractedText);
                    ims.mChangedStart = -1;
                    ims.mChangedEnd = -1;
                    ims.mChangedDelta = 0;
                    ims.mContentChanged = false;
                    return true;
                }
            }
        }
        return false;
    }

    private void sendUpdateSelection() {
        InputMethodManager imm;
        if (null != this.mInputMethodState && this.mInputMethodState.mBatchEditNesting <= 0 && null != (imm = InputMethodManager.peekInstance())) {
            int selectionStart = this.mTextView.getSelectionStart();
            int selectionEnd = this.mTextView.getSelectionEnd();
            int candStart = -1;
            int candEnd = -1;
            if (this.mTextView.getText() instanceof Spannable) {
                Spannable sp = (Spannable)this.mTextView.getText();
                candStart = EditableInputConnection.getComposingSpanStart(sp);
                candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            }
            imm.updateSelection(this.mTextView, selectionStart, selectionEnd, candStart, candEnd);
        }
    }

    void onDraw(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        InputMethodManager imm;
        int selectionStart = this.mTextView.getSelectionStart();
        int selectionEnd = this.mTextView.getSelectionEnd();
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting == 0 && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this.mTextView) && (ims.mContentChanged || ims.mSelectionModeChanged)) {
            this.reportExtractedText();
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, cursorOffsetVertical);
        }
        if (highlight != null && selectionStart == selectionEnd && this.mCursorCount > 0) {
            this.drawCursor(canvas, cursorOffsetVertical);
            highlight = null;
        }
        if (this.mTextView.canHaveDisplayList() && canvas.isHardwareAccelerated()) {
            this.drawHardwareAccelerated(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, highlightPaint, cursorOffsetVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawHardwareAccelerated(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = layout2.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        layout2.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        if (layout2 instanceof DynamicLayout) {
            if (this.mTextRenderNodes == null) {
                this.mTextRenderNodes = ArrayUtils.emptyArray(TextRenderNode.class);
            }
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            int indexFirstChangedBlock = dynamicLayout.getIndexFirstChangedBlock();
            int endOfPreviousBlock = -1;
            int searchStartIndex = 0;
            for (int i = 0; i < numberOfBlocks; ++i) {
                boolean blockIsInvalid;
                int blockEndLine = blockEndLines[i];
                int blockIndex = blockIndices[i];
                boolean bl = blockIsInvalid = blockIndex == -1;
                if (blockIsInvalid) {
                    blockIndices[i] = blockIndex = this.getAvailableDisplayListIndex(blockIndices, numberOfBlocks, searchStartIndex);
                    if (this.mTextRenderNodes[blockIndex] != null) {
                        this.mTextRenderNodes[blockIndex].isDirty = true;
                    }
                    searchStartIndex = blockIndex + 1;
                }
                if (this.mTextRenderNodes[blockIndex] == null) {
                    this.mTextRenderNodes[blockIndex] = new TextRenderNode("Text " + blockIndex);
                }
                boolean blockDisplayListIsInvalid = this.mTextRenderNodes[blockIndex].needsRecord();
                RenderNode blockDisplayList = this.mTextRenderNodes[blockIndex].renderNode;
                if (i >= indexFirstChangedBlock || blockDisplayListIsInvalid) {
                    int blockBeginLine = endOfPreviousBlock + 1;
                    int top = layout2.getLineTop(blockBeginLine);
                    int bottom = layout2.getLineBottom(blockEndLine);
                    int left = 0;
                    int right = this.mTextView.getWidth();
                    if (this.mTextView.getHorizontallyScrolling()) {
                        float min = Float.MAX_VALUE;
                        float max = Float.MIN_VALUE;
                        for (int line = blockBeginLine; line <= blockEndLine; ++line) {
                            min = Math.min(min, layout2.getLineLeft(line));
                            max = Math.max(max, layout2.getLineRight(line));
                        }
                        left = (int)min;
                        right = (int)(max + 0.5f);
                    }
                    if (blockDisplayListIsInvalid) {
                        DisplayListCanvas displayListCanvas = blockDisplayList.start(right - left, bottom - top);
                        try {
                            displayListCanvas.translate(-left, -top);
                            layout2.drawText(displayListCanvas, blockBeginLine, blockEndLine);
                            this.mTextRenderNodes[blockIndex].isDirty = false;
                        }
                        finally {
                            blockDisplayList.end(displayListCanvas);
                            blockDisplayList.setClipToBounds(false);
                        }
                    }
                    blockDisplayList.setLeftTopRightBottom(left, top, right, bottom);
                }
                ((DisplayListCanvas)canvas).drawRenderNode(blockDisplayList);
                endOfPreviousBlock = blockEndLine;
            }
            dynamicLayout.setIndexFirstChangedBlock(numberOfBlocks);
        } else {
            layout2.drawText(canvas, firstLine, lastLine);
        }
    }

    private int getAvailableDisplayListIndex(int[] blockIndices, int numberOfBlocks, int searchStartIndex) {
        int length = this.mTextRenderNodes.length;
        for (int i = searchStartIndex; i < length; ++i) {
            boolean blockIndexFound = false;
            for (int j = 0; j < numberOfBlocks; ++j) {
                if (blockIndices[j] != i) continue;
                blockIndexFound = true;
                break;
            }
            if (blockIndexFound) continue;
            return i;
        }
        this.mTextRenderNodes = GrowingArrayUtils.append(this.mTextRenderNodes, length, null);
        return length;
    }

    private void drawCursor(Canvas canvas, int cursorOffsetVertical) {
        boolean translate;
        boolean bl = translate = cursorOffsetVertical != 0;
        if (translate) {
            canvas.translate(0.0f, cursorOffsetVertical);
        }
        for (int i = 0; i < this.mCursorCount; ++i) {
            this.mCursorDrawable[i].draw(canvas);
        }
        if (translate) {
            canvas.translate(0.0f, -cursorOffsetVertical);
        }
    }

    void invalidateTextDisplayList(Layout layout2, int start, int end) {
        if (this.mTextRenderNodes != null && layout2 instanceof DynamicLayout) {
            int i;
            int firstLine = layout2.getLineForOffset(start);
            int lastLine = layout2.getLineForOffset(end);
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            for (i = 0; i < numberOfBlocks && blockEndLines[i] < firstLine; ++i) {
            }
            while (i < numberOfBlocks) {
                int blockIndex = blockIndices[i];
                if (blockIndex != -1) {
                    this.mTextRenderNodes[blockIndex].isDirty = true;
                }
                if (blockEndLines[i] >= lastLine) break;
                ++i;
            }
        }
    }

    void invalidateTextDisplayList() {
        if (this.mTextRenderNodes != null) {
            for (int i = 0; i < this.mTextRenderNodes.length; ++i) {
                if (this.mTextRenderNodes[i] == null) continue;
                this.mTextRenderNodes[i].isDirty = true;
            }
        }
    }

    void updateCursorsPositions() {
        if (this.mTextView.mCursorDrawableRes == 0) {
            this.mCursorCount = 0;
            return;
        }
        Layout layout2 = this.getActiveLayout();
        int offset = this.mTextView.getSelectionStart();
        int line = layout2.getLineForOffset(offset);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        this.mCursorCount = layout2.isLevelBoundary(offset) ? 2 : 1;
        int middle = bottom;
        if (this.mCursorCount == 2) {
            middle = top + bottom >> 1;
        }
        boolean clamped = layout2.shouldClampCursor(line);
        this.updateCursorPosition(0, top, middle, layout2.getPrimaryHorizontal(offset, clamped));
        if (this.mCursorCount == 2) {
            this.updateCursorPosition(1, middle, bottom, layout2.getSecondaryHorizontal(offset, clamped));
        }
    }

    void startInsertionActionMode() {
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        if (this.extractedTextModeWillBeStarted()) {
            return;
        }
        this.stopTextActionMode();
        TextActionModeCallback actionModeCallback = new TextActionModeCallback(false);
        this.mTextActionMode = this.mTextView.startActionMode(actionModeCallback, 1);
        if (this.mTextActionMode != null && this.getInsertionController() != null) {
            this.getInsertionController().show();
        }
    }

    boolean startSelectionActionMode() {
        boolean selectionStarted = this.startSelectionActionModeInternal();
        if (selectionStarted) {
            this.getSelectionController().show();
        } else if (this.getInsertionController() != null) {
            this.getInsertionController().show();
        }
        return selectionStarted;
    }

    private boolean selectCurrentWordAndStartDrag() {
        if (this.mInsertionActionModeRunnable != null) {
            this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
        }
        if (this.extractedTextModeWillBeStarted()) {
            return false;
        }
        if (this.mTextActionMode != null) {
            this.mTextActionMode.finish();
        }
        if (!this.checkFieldAndSelectCurrentWord()) {
            return false;
        }
        this.mPreserveDetachedSelection = true;
        this.stopTextActionMode();
        this.mPreserveDetachedSelection = false;
        this.getSelectionController().enterDrag();
        return true;
    }

    boolean checkFieldAndSelectCurrentWord() {
        if (!this.mTextView.canSelectText() || !this.mTextView.requestFocus()) {
            Log.w("TextView", "TextView does not support text selection. Selection cancelled.");
            return false;
        }
        if (!this.mTextView.hasSelection()) {
            return this.selectCurrentWord();
        }
        return true;
    }

    private boolean startSelectionActionModeInternal() {
        InputMethodManager imm;
        boolean selectionStarted;
        if (this.mTextActionMode != null) {
            this.mTextActionMode.invalidate();
            return false;
        }
        if (!this.checkFieldAndSelectCurrentWord()) {
            return false;
        }
        boolean willExtract = this.extractedTextModeWillBeStarted();
        if (!willExtract) {
            TextActionModeCallback actionModeCallback = new TextActionModeCallback(true);
            this.mTextActionMode = this.mTextView.startActionMode(actionModeCallback, 1);
        }
        boolean bl = selectionStarted = this.mTextActionMode != null || willExtract;
        if (selectionStarted && !this.mTextView.isTextSelectable() && this.mShowSoftInputOnFocus && (imm = InputMethodManager.peekInstance()) != null) {
            imm.showSoftInput(this.mTextView, 0, null);
        }
        return selectionStarted;
    }

    boolean extractedTextModeWillBeStarted() {
        if (!this.mTextView.isInExtractedMode()) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            return imm != null && imm.isFullscreenMode();
        }
        return false;
    }

    private boolean shouldOfferToShowSuggestions() {
        int selectionEnd;
        CharSequence text = this.mTextView.getText();
        if (!(text instanceof Spannable)) {
            return false;
        }
        Spannable spannable = (Spannable)text;
        int selectionStart = this.mTextView.getSelectionStart();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(selectionStart, selectionEnd = this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        if (suggestionSpans.length == 0) {
            return false;
        }
        if (selectionStart == selectionEnd) {
            for (int i = 0; i < suggestionSpans.length; ++i) {
                if (suggestionSpans[i].getSuggestions().length <= 0) continue;
                return true;
            }
            return false;
        }
        int minSpanStart = this.mTextView.getText().length();
        int maxSpanEnd = 0;
        int unionOfSpansCoveringSelectionStartStart = this.mTextView.getText().length();
        int unionOfSpansCoveringSelectionStartEnd = 0;
        boolean hasValidSuggestions = false;
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int spanStart = spannable.getSpanStart(suggestionSpans[i]);
            int spanEnd = spannable.getSpanEnd(suggestionSpans[i]);
            minSpanStart = Math.min(minSpanStart, spanStart);
            maxSpanEnd = Math.max(maxSpanEnd, spanEnd);
            if (selectionStart < spanStart || selectionStart > spanEnd) continue;
            hasValidSuggestions = hasValidSuggestions || suggestionSpans[i].getSuggestions().length > 0;
            unionOfSpansCoveringSelectionStartStart = Math.min(unionOfSpansCoveringSelectionStartStart, spanStart);
            unionOfSpansCoveringSelectionStartEnd = Math.max(unionOfSpansCoveringSelectionStartEnd, spanEnd);
        }
        if (!hasValidSuggestions) {
            return false;
        }
        if (unionOfSpansCoveringSelectionStartStart >= unionOfSpansCoveringSelectionStartEnd) {
            return false;
        }
        return minSpanStart >= unionOfSpansCoveringSelectionStartStart && maxSpanEnd <= unionOfSpansCoveringSelectionStartEnd;
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        Spannable spannable = (Spannable)this.mTextView.getText();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            if ((suggestionSpans[i].getFlags() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    void onTouchUpEvent(MotionEvent event) {
        boolean selectAllGotFocus = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        this.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        CharSequence text = this.mTextView.getText();
        if (!selectAllGotFocus && text.length() > 0) {
            int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            Selection.setSelection((Spannable)text, offset);
            if (this.mSpellChecker != null) {
                this.mSpellChecker.onSelectionChanged();
            }
            if (!this.extractedTextModeWillBeStarted()) {
                if (this.isCursorInsideEasyCorrectionSpan()) {
                    if (this.mInsertionActionModeRunnable != null) {
                        this.mTextView.removeCallbacks(this.mInsertionActionModeRunnable);
                    }
                    this.mShowSuggestionRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Editor.this.showSuggestions();
                        }
                    };
                    this.mTextView.postDelayed(this.mShowSuggestionRunnable, ViewConfiguration.getDoubleTapTimeout());
                } else if (this.hasInsertionController()) {
                    this.getInsertionController().show();
                }
            }
        }
    }

    protected void stopTextActionMode() {
        if (this.mTextActionMode != null) {
            this.mTextActionMode.finish();
        }
    }

    boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    InsertionPointCursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    SelectionModifierCursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    private void updateCursorPosition(int cursorIndex, int top, int bottom, float horizontal) {
        if (this.mCursorDrawable[cursorIndex] == null) {
            this.mCursorDrawable[cursorIndex] = this.mTextView.getContext().getDrawable(this.mTextView.mCursorDrawableRes);
        }
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        this.mCursorDrawable[cursorIndex].getPadding(this.mTempRect);
        int width = this.mCursorDrawable[cursorIndex].getIntrinsicWidth();
        horizontal = Math.max(0.5f, horizontal - 0.5f);
        int left = (int)horizontal - this.mTempRect.left;
        this.mCursorDrawable[cursorIndex].setBounds(left, top - this.mTempRect.top, left + width, bottom + this.mTempRect.bottom);
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter();
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(info);
    }

    void showSuggestions() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow();
        }
        this.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        this.mSuggestionsPopupWindow.show();
    }

    void onScrollChanged() {
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
        if (this.mTextActionMode != null) {
            this.mTextActionMode.invalidateContentRect();
        }
    }

    private boolean shouldBlink() {
        if (!this.isCursorVisible() || !this.mTextView.isFocused()) {
            return false;
        }
        int start = this.mTextView.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.mTextView.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    void makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = SystemClock.uptimeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.mBlink.removeCallbacks(this.mBlink);
            this.mBlink.postAtTime(this.mBlink, this.mShowCursor + 500L);
        } else if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(CharSequence text) {
        TextView shadowView = (TextView)View.inflate(this.mTextView.getContext(), 17367271, null);
        if (shadowView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (text.length() > DRAG_SHADOW_MAX_TEXT_LENGTH) {
            text = text.subSequence(0, DRAG_SHADOW_MAX_TEXT_LENGTH);
        }
        shadowView.setText(text);
        shadowView.setTextColor(this.mTextView.getTextColors());
        shadowView.setTextAppearance(16);
        shadowView.setGravity(17);
        shadowView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int size = View.MeasureSpec.makeMeasureSpec(0, 0);
        shadowView.measure(size, size);
        shadowView.layout(0, 0, shadowView.getMeasuredWidth(), shadowView.getMeasuredHeight());
        shadowView.invalidate();
        return new View.DragShadowBuilder(shadowView);
    }

    void onDrop(DragEvent event) {
        boolean dragDropIntoItself;
        StringBuilder content = new StringBuilder("");
        ClipData clipData = event.getClipData();
        int itemCount = clipData.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ClipData.Item item = clipData.getItemAt(i);
            content.append(item.coerceToStyledText(this.mTextView.getContext()));
        }
        int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
        Object localState = event.getLocalState();
        DragLocalState dragLocalState = null;
        if (localState instanceof DragLocalState) {
            dragLocalState = (DragLocalState)localState;
        }
        boolean bl = dragDropIntoItself = dragLocalState != null && dragLocalState.sourceTextView == this.mTextView;
        if (dragDropIntoItself && offset >= dragLocalState.start && offset < dragLocalState.end) {
            return;
        }
        int originalLength = this.mTextView.getText().length();
        int min = offset;
        int max = offset;
        Selection.setSelection((Spannable)this.mTextView.getText(), max);
        this.mTextView.replaceText_internal(min, max, content);
        if (dragDropIntoItself) {
            CharSequence t;
            int dragSourceStart = dragLocalState.start;
            int dragSourceEnd = dragLocalState.end;
            if (max <= dragSourceStart) {
                int shift = this.mTextView.getText().length() - originalLength;
                dragSourceStart += shift;
                dragSourceEnd += shift;
            }
            this.mTextView.deleteText_internal(dragSourceStart, dragSourceEnd);
            int prevCharIdx = Math.max(0, dragSourceStart - 1);
            int nextCharIdx = Math.min(this.mTextView.getText().length(), dragSourceStart + 1);
            if (nextCharIdx > prevCharIdx + 1 && Character.isSpaceChar((t = this.mTextView.getTransformedText(prevCharIdx, nextCharIdx)).charAt(0)) && Character.isSpaceChar(t.charAt(1))) {
                this.mTextView.deleteText_internal(prevCharIdx, prevCharIdx + 1);
            }
        }
    }

    public void addSpanWatchers(Spannable text) {
        int textLength = text.length();
        if (this.mKeyListener != null) {
            text.setSpan(this.mKeyListener, 0, textLength, 18);
        }
        if (this.mSpanController == null) {
            this.mSpanController = new SpanController();
        }
        text.setSpan(this.mSpanController, 0, textLength, 18);
    }

    private Layout getActiveLayout() {
        Layout layout2 = this.mTextView.getLayout();
        Layout hintLayout = this.mTextView.getHintLayout();
        if (TextUtils.isEmpty(layout2.getText()) && hintLayout != null && !TextUtils.isEmpty(hintLayout.getText())) {
            layout2 = hintLayout;
        }
        return layout2;
    }

    private int getCurrentLineAdjustedForSlop(Layout layout2, int prevLine, float y) {
        int trueLine = this.mTextView.getLineAtCoordinate(y);
        if (layout2 == null || prevLine > layout2.getLineCount() || layout2.getLineCount() <= 0 || prevLine < 0) {
            return trueLine;
        }
        if (Math.abs(trueLine - prevLine) >= 2) {
            return trueLine;
        }
        float verticalOffset = this.mTextView.viewportToContentVerticalOffset();
        int lineCount = layout2.getLineCount();
        float slop = (float)this.mTextView.getLineHeight() * 0.5f;
        float firstLineTop = (float)layout2.getLineTop(0) + verticalOffset;
        float prevLineTop = (float)layout2.getLineTop(prevLine) + verticalOffset;
        float yTopBound = Math.max(prevLineTop - slop, firstLineTop + slop);
        float lastLineBottom = (float)layout2.getLineBottom(lineCount - 1) + verticalOffset;
        float prevLineBottom = (float)layout2.getLineBottom(prevLine) + verticalOffset;
        float yBottomBound = Math.min(prevLineBottom + slop, lastLineBottom - slop);
        int currLine = y <= yTopBound ? Math.max(prevLine - 1, 0) : (y >= yBottomBound ? Math.min(prevLine + 1, lineCount - 1) : prevLine);
        return currLine;
    }

    private static boolean isValidRange(CharSequence text, int start, int end) {
        return 0 <= start && start <= end && end <= text.length();
    }

    static class ProcessTextIntentActionsHandler {
        private final Editor mEditor;
        private final TextView mTextView;
        private final PackageManager mPackageManager;
        private final SparseArray<Intent> mAccessibilityIntents = new SparseArray();
        private final SparseArray<AccessibilityNodeInfo.AccessibilityAction> mAccessibilityActions = new SparseArray();

        private ProcessTextIntentActionsHandler(Editor editor) {
            this.mEditor = Preconditions.checkNotNull(editor);
            this.mTextView = Preconditions.checkNotNull(this.mEditor.mTextView);
            this.mPackageManager = Preconditions.checkNotNull(this.mTextView.getContext().getPackageManager());
        }

        public void onInitializeMenu(Menu menu2) {
            int i = 0;
            for (ResolveInfo resolveInfo : this.getSupportedActivities()) {
                menu2.add(0, 0, 10 + i++, this.getLabel(resolveInfo)).setIntent(this.createProcessTextIntentForResolveInfo(resolveInfo)).setShowAsAction(1);
            }
        }

        public boolean performMenuItemAction(MenuItem item) {
            return this.fireIntent(item.getIntent());
        }

        public void initializeAccessibilityActions() {
            this.mAccessibilityIntents.clear();
            this.mAccessibilityActions.clear();
            int i = 0;
            for (ResolveInfo resolveInfo : this.getSupportedActivities()) {
                int actionId = 0x10000100 + i++;
                this.mAccessibilityActions.put(actionId, new AccessibilityNodeInfo.AccessibilityAction(actionId, this.getLabel(resolveInfo)));
                this.mAccessibilityIntents.put(actionId, this.createProcessTextIntentForResolveInfo(resolveInfo));
            }
        }

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo nodeInfo) {
            for (int i = 0; i < this.mAccessibilityActions.size(); ++i) {
                nodeInfo.addAction(this.mAccessibilityActions.valueAt(i));
            }
        }

        public boolean performAccessibilityAction(int actionId) {
            return this.fireIntent(this.mAccessibilityIntents.get(actionId));
        }

        private boolean fireIntent(Intent intent) {
            if (intent != null && "android.intent.action.PROCESS_TEXT".equals(intent.getAction())) {
                intent.putExtra("android.intent.extra.PROCESS_TEXT", this.mTextView.getSelectedText());
                this.mEditor.mPreserveDetachedSelection = true;
                this.mTextView.startActivityForResult(intent, 100);
                return true;
            }
            return false;
        }

        private List<ResolveInfo> getSupportedActivities() {
            PackageManager packageManager = this.mTextView.getContext().getPackageManager();
            return packageManager.queryIntentActivities(this.createProcessTextIntent(), 0);
        }

        private Intent createProcessTextIntentForResolveInfo(ResolveInfo info) {
            return this.createProcessTextIntent().putExtra("android.intent.extra.PROCESS_TEXT_READONLY", !this.mTextView.isTextEditable()).setClassName(info.activityInfo.packageName, info.activityInfo.name);
        }

        private Intent createProcessTextIntent() {
            return new Intent().setAction("android.intent.action.PROCESS_TEXT").setType("text/plain");
        }

        private CharSequence getLabel(ResolveInfo resolveInfo) {
            return resolveInfo.loadLabel(this.mPackageManager);
        }
    }

    public static class EditOperation
    extends UndoOperation<Editor> {
        private static final int TYPE_INSERT = 0;
        private static final int TYPE_DELETE = 1;
        private static final int TYPE_REPLACE = 2;
        private int mType;
        private String mOldText;
        private int mOldTextStart;
        private String mNewText;
        private int mNewTextStart;
        private int mOldCursorPos;
        private int mNewCursorPos;
        public static final Parcelable.ClassLoaderCreator<EditOperation> CREATOR = new Parcelable.ClassLoaderCreator<EditOperation>(){

            @Override
            public EditOperation createFromParcel(Parcel in) {
                return new EditOperation(in, null);
            }

            @Override
            public EditOperation createFromParcel(Parcel in, ClassLoader loader) {
                return new EditOperation(in, loader);
            }

            public EditOperation[] newArray(int size) {
                return new EditOperation[size];
            }
        };

        public EditOperation(Editor editor, String oldText, int dstart, String newText) {
            super(editor.mUndoOwner);
            this.mOldText = oldText;
            this.mNewText = newText;
            if (this.mNewText.length() > 0 && this.mOldText.length() == 0) {
                this.mType = 0;
                this.mNewTextStart = dstart;
            } else if (this.mNewText.length() == 0 && this.mOldText.length() > 0) {
                this.mType = 1;
                this.mOldTextStart = dstart;
            } else {
                this.mType = 2;
                this.mOldTextStart = this.mNewTextStart = dstart;
            }
            this.mOldCursorPos = editor.mTextView.getSelectionStart();
            this.mNewCursorPos = dstart + this.mNewText.length();
        }

        public EditOperation(Parcel src, ClassLoader loader) {
            super(src, loader);
            this.mType = src.readInt();
            this.mOldText = src.readString();
            this.mOldTextStart = src.readInt();
            this.mNewText = src.readString();
            this.mNewTextStart = src.readInt();
            this.mOldCursorPos = src.readInt();
            this.mNewCursorPos = src.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeString(this.mOldText);
            dest.writeInt(this.mOldTextStart);
            dest.writeString(this.mNewText);
            dest.writeInt(this.mNewTextStart);
            dest.writeInt(this.mOldCursorPos);
            dest.writeInt(this.mNewCursorPos);
        }

        private int getNewTextEnd() {
            return this.mNewTextStart + this.mNewText.length();
        }

        private int getOldTextEnd() {
            return this.mOldTextStart + this.mOldText.length();
        }

        @Override
        public void commit() {
        }

        @Override
        public void undo() {
            Editor editor = (Editor)this.getOwnerData();
            Editable text = (Editable)editor.mTextView.getText();
            EditOperation.modifyText(text, this.mNewTextStart, this.getNewTextEnd(), this.mOldText, this.mOldTextStart, this.mOldCursorPos);
        }

        @Override
        public void redo() {
            Editor editor = (Editor)this.getOwnerData();
            Editable text = (Editable)editor.mTextView.getText();
            EditOperation.modifyText(text, this.mOldTextStart, this.getOldTextEnd(), this.mNewText, this.mNewTextStart, this.mNewCursorPos);
        }

        private boolean mergeWith(EditOperation edit) {
            switch (this.mType) {
                case 0: {
                    return this.mergeInsertWith(edit);
                }
                case 1: {
                    return this.mergeDeleteWith(edit);
                }
                case 2: {
                    return this.mergeReplaceWith(edit);
                }
            }
            return false;
        }

        private boolean mergeInsertWith(EditOperation edit) {
            if (edit.mType != 0) {
                return false;
            }
            if (this.getNewTextEnd() != edit.mNewTextStart) {
                return false;
            }
            this.mNewText = this.mNewText + edit.mNewText;
            this.mNewCursorPos = edit.mNewCursorPos;
            return true;
        }

        private boolean mergeDeleteWith(EditOperation edit) {
            if (edit.mType != 1) {
                return false;
            }
            if (this.mOldTextStart != edit.getOldTextEnd()) {
                return false;
            }
            this.mOldTextStart = edit.mOldTextStart;
            this.mOldText = edit.mOldText + this.mOldText;
            this.mNewCursorPos = edit.mNewCursorPos;
            return true;
        }

        private boolean mergeReplaceWith(EditOperation edit) {
            if (edit.mType != 0 || this.getNewTextEnd() != edit.mNewTextStart) {
                return false;
            }
            this.mOldText = this.mOldText + edit.mOldText;
            this.mNewText = this.mNewText + edit.mNewText;
            this.mNewCursorPos = edit.mNewCursorPos;
            return true;
        }

        public void forceMergeWith(EditOperation edit) {
            Editor editor = (Editor)this.getOwnerData();
            Editable editable = (Editable)editor.mTextView.getText();
            SpannableStringBuilder originalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(originalText, this.mNewTextStart, this.getNewTextEnd(), this.mOldText, this.mOldTextStart, this.mOldCursorPos);
            SpannableStringBuilder finalText = new SpannableStringBuilder(editable.toString());
            EditOperation.modifyText(finalText, edit.mOldTextStart, edit.getOldTextEnd(), edit.mNewText, edit.mNewTextStart, edit.mNewCursorPos);
            this.mType = 2;
            this.mNewText = ((Object)finalText).toString();
            this.mNewTextStart = 0;
            this.mOldText = ((Object)originalText).toString();
            this.mOldTextStart = 0;
            this.mNewCursorPos = edit.mNewCursorPos;
        }

        private static void modifyText(Editable text, int deleteFrom, int deleteTo, CharSequence newText, int newTextInsertAt, int newCursorPos) {
            if (Editor.isValidRange(text, deleteFrom, deleteTo) && newTextInsertAt <= text.length() - (deleteTo - deleteFrom)) {
                if (deleteFrom != deleteTo) {
                    text.delete(deleteFrom, deleteTo);
                }
                if (newText.length() != 0) {
                    text.insert(newTextInsertAt, newText);
                }
            }
            if (0 <= newCursorPos && newCursorPos <= text.length()) {
                Selection.setSelection(text, newCursorPos);
            }
        }

        private String getTypeString() {
            switch (this.mType) {
                case 0: {
                    return "insert";
                }
                case 1: {
                    return "delete";
                }
                case 2: {
                    return "replace";
                }
            }
            return "";
        }

        public String toString() {
            return "[mType=" + this.getTypeString() + ", " + "mOldText=" + this.mOldText + ", " + "mOldTextStart=" + this.mOldTextStart + ", " + "mNewText=" + this.mNewText + ", " + "mNewTextStart=" + this.mNewTextStart + ", " + "mOldCursorPos=" + this.mOldCursorPos + ", " + "mNewCursorPos=" + this.mNewCursorPos + "]";
        }
    }

    public static class UndoInputFilter
    implements InputFilter {
        private final Editor mEditor;
        private boolean mIsUserEdit;
        private boolean mHasComposition;

        public UndoInputFilter(Editor editor) {
            this.mEditor = editor;
        }

        public void saveInstanceState(Parcel parcel) {
            parcel.writeInt(this.mIsUserEdit ? 1 : 0);
            parcel.writeInt(this.mHasComposition ? 1 : 0);
        }

        public void restoreInstanceState(Parcel parcel) {
            this.mIsUserEdit = parcel.readInt() != 0;
            this.mHasComposition = parcel.readInt() != 0;
        }

        public void beginBatchEdit() {
            this.mIsUserEdit = true;
        }

        public void endBatchEdit() {
            this.mIsUserEdit = false;
        }

        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!this.canUndoEdit(source, start, end, dest, dstart, dend)) {
                return null;
            }
            if (this.handleCompositionEdit(source, start, end, dstart)) {
                return null;
            }
            this.handleKeyboardEdit(source, start, end, dest, dstart, dend);
            return null;
        }

        private boolean handleCompositionEdit(CharSequence source, int start, int end, int dstart) {
            if (this.isComposition(source)) {
                this.mHasComposition = true;
                return true;
            }
            boolean hadComposition = this.mHasComposition;
            this.mHasComposition = false;
            if (hadComposition) {
                if (start == end) {
                    return true;
                }
                String newText = TextUtils.substring(source, start, end);
                EditOperation edit = new EditOperation(this.mEditor, "", dstart, newText);
                this.recordEdit(edit, false);
                return true;
            }
            return false;
        }

        private void handleKeyboardEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            boolean forceMerge = this.isInTextWatcher();
            String newText = TextUtils.substring(source, start, end);
            String oldText = TextUtils.substring(dest, dstart, dend);
            EditOperation edit = new EditOperation(this.mEditor, oldText, dstart, newText);
            this.recordEdit(edit, forceMerge);
        }

        private void recordEdit(EditOperation edit, boolean forceMerge) {
            UndoManager um = this.mEditor.mUndoManager;
            um.beginUpdate("Edit text");
            EditOperation lastEdit = um.getLastOperation(EditOperation.class, this.mEditor.mUndoOwner, 1);
            if (lastEdit == null) {
                um.addOperation(edit, 0);
            } else if (forceMerge) {
                lastEdit.forceMergeWith(edit);
            } else if (!this.mIsUserEdit) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            } else if (!lastEdit.mergeWith(edit)) {
                um.commitState(this.mEditor.mUndoOwner);
                um.addOperation(edit, 0);
            }
            um.endUpdate();
        }

        private boolean canUndoEdit(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!this.mEditor.mAllowUndo) {
                return false;
            }
            if (this.mEditor.mUndoManager.isInUndo()) {
                return false;
            }
            if (!Editor.isValidRange(source, start, end) || !Editor.isValidRange(dest, dstart, dend)) {
                return false;
            }
            return start != end || dstart != dend;
        }

        private boolean isComposition(CharSequence source) {
            int composeEnd;
            if (!(source instanceof Spannable)) {
                return false;
            }
            Spannable text = (Spannable)source;
            int composeBegin = EditableInputConnection.getComposingSpanStart(text);
            return composeBegin < (composeEnd = EditableInputConnection.getComposingSpanEnd(text));
        }

        private boolean isInTextWatcher() {
            CharSequence text = this.mEditor.mTextView.getText();
            return text instanceof SpannableStringBuilder && ((SpannableStringBuilder)text).getTextWatcherDepth() > 0;
        }
    }

    static class InputMethodState {
        ExtractedTextRequest mExtractedTextRequest;
        final ExtractedText mExtractedText = new ExtractedText();
        int mBatchEditNesting;
        boolean mCursorChanged;
        boolean mSelectionModeChanged;
        boolean mContentChanged;
        int mChangedStart;
        int mChangedEnd;
        int mChangedDelta;

        InputMethodState() {
        }
    }

    static class InputContentType {
        int imeOptions = 0;
        String privateImeOptions;
        CharSequence imeActionLabel;
        int imeActionId;
        Bundle extras;
        TextView.OnEditorActionListener onEditorActionListener;
        boolean enterDown;

        InputContentType() {
        }
    }

    private static class ErrorPopup
    extends PopupWindow {
        private boolean mAbove = false;
        private final TextView mView;
        private int mPopupInlineErrorBackgroundId = 0;
        private int mPopupInlineErrorAboveBackgroundId = 0;

        ErrorPopup(TextView v, int width, int height) {
            super(v, width, height);
            this.mView = v;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 275);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        void fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 276);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 275);
            }
            this.mView.setBackgroundResource(above ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId);
        }

        private int getResourceId(int currentId, int index) {
            if (currentId == 0) {
                TypedArray styledAttributes = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                currentId = styledAttributes.getResourceId(index, 0);
                styledAttributes.recycle();
            }
            return currentId;
        }

        @Override
        public void update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }
    }

    private class CorrectionHighlighter {
        private final Path mPath = new Path();
        private final Paint mPaint = new Paint(1);
        private int mStart;
        private int mEnd;
        private long mFadingStartTime;
        private RectF mTempRectF;
        private static final int FADE_OUT_DURATION = 400;

        public CorrectionHighlighter() {
            this.mPaint.setCompatibilityScaling(((Editor)Editor.this).mTextView.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        public void highlight(CorrectionInfo info) {
            this.mStart = info.getOffset();
            this.mEnd = this.mStart + info.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }

        public void draw(Canvas canvas, int cursorOffsetVertical) {
            if (this.updatePath() && this.updatePaint()) {
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, cursorOffsetVertical);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, -cursorOffsetVertical);
                }
                this.invalidate(true);
            } else {
                this.stopAnimation();
                this.invalidate(false);
            }
        }

        private boolean updatePaint() {
            long duration = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (duration > 400L) {
                return false;
            }
            float coef = 1.0f - (float)duration / 400.0f;
            int highlightColorAlpha = Color.alpha(((Editor)Editor.this).mTextView.mHighlightColor);
            int color2 = (((Editor)Editor.this).mTextView.mHighlightColor & 0xFFFFFF) + ((int)((float)highlightColorAlpha * coef) << 24);
            this.mPaint.setColor(color2);
            return true;
        }

        private boolean updatePath() {
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return false;
            }
            int length = Editor.this.mTextView.getText().length();
            int start = Math.min(length, this.mStart);
            int end = Math.min(length, this.mEnd);
            this.mPath.reset();
            layout2.getSelectionPath(start, end, this.mPath);
            return true;
        }

        private void invalidate(boolean delayed) {
            if (Editor.this.mTextView.getLayout() == null) {
                return;
            }
            if (this.mTempRectF == null) {
                this.mTempRectF = new RectF();
            }
            this.mPath.computeBounds(this.mTempRectF, false);
            int left = Editor.this.mTextView.getCompoundPaddingLeft();
            int top = Editor.this.mTextView.getExtendedPaddingTop() + Editor.this.mTextView.getVerticalOffset(true);
            if (delayed) {
                Editor.this.mTextView.postInvalidateOnAnimation(left + (int)this.mTempRectF.left, top + (int)this.mTempRectF.top, left + (int)this.mTempRectF.right, top + (int)this.mTempRectF.bottom);
            } else {
                Editor.this.mTextView.postInvalidate((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
            }
        }

        private void stopAnimation() {
            Editor.this.mCorrectionHighlighter = null;
        }
    }

    class SelectionModifierCursorController
    implements CursorController {
        private SelectionStartHandleView mStartHandle;
        private SelectionEndHandleView mEndHandle;
        private int mMinTouchOffset;
        private int mMaxTouchOffset;
        private float mDownPositionX;
        private float mDownPositionY;
        private boolean mGestureStayedInTapRegion;
        private int mStartOffset = -1;
        private boolean mDragAcceleratorActive;
        private boolean mHaventMovedEnoughToStartDrag;
        private int mLineSelectionIsOn = -1;
        private boolean mSwitchedLines = false;

        SelectionModifierCursorController() {
            this.resetTouchOffsets();
        }

        @Override
        public void show() {
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return;
            }
            this.initDrawables();
            this.initHandles();
            Editor.this.hideInsertionPointCursorController();
        }

        private void initDrawables() {
            if (Editor.this.mSelectHandleLeft == null) {
                Editor.this.mSelectHandleLeft = Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleLeftRes);
            }
            if (Editor.this.mSelectHandleRight == null) {
                Editor.this.mSelectHandleRight = Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRightRes);
            }
        }

        private void initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionStartHandleView(Editor.this.mSelectHandleLeft, Editor.this.mSelectHandleRight);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionEndHandleView(Editor.this.mSelectHandleRight, Editor.this.mSelectHandleLeft);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            Editor.this.hideInsertionPointCursorController();
        }

        @Override
        public void hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        public void enterDrag() {
            this.show();
            this.mDragAcceleratorActive = true;
            this.mStartOffset = Editor.this.mTextView.getOffsetForPosition(Editor.this.mLastDownPositionX, Editor.this.mLastDownPositionY);
            this.mLineSelectionIsOn = Editor.this.mTextView.getLineAtCoordinate(Editor.this.mLastDownPositionY);
            this.hide();
            Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(true);
        }

        public void onTouchEvent(MotionEvent event) {
            float eventX = event.getX();
            float eventY = event.getY();
            switch (event.getActionMasked()) {
                case 0: {
                    if (Editor.this.extractedTextModeWillBeStarted()) {
                        this.hide();
                        break;
                    }
                    this.mMinTouchOffset = this.mMaxTouchOffset = Editor.this.mTextView.getOffsetForPosition(eventX, eventY);
                    if (this.mGestureStayedInTapRegion && Editor.this.mDoubleTap) {
                        boolean stayedInArea;
                        float deltaX = eventX - this.mDownPositionX;
                        float deltaY = eventY - this.mDownPositionY;
                        float distanceSquared = deltaX * deltaX + deltaY * deltaY;
                        ViewConfiguration viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext());
                        int doubleTapSlop = viewConfiguration.getScaledDoubleTapSlop();
                        boolean bl = stayedInArea = distanceSquared < (float)(doubleTapSlop * doubleTapSlop);
                        if (stayedInArea && Editor.this.isPositionOnText(eventX, eventY)) {
                            Editor.this.selectCurrentWordAndStartDrag();
                            Editor.this.mDiscardNextActionUp = true;
                        }
                    }
                    this.mDownPositionX = eventX;
                    this.mDownPositionY = eventY;
                    this.mGestureStayedInTapRegion = true;
                    this.mHaventMovedEnoughToStartDrag = true;
                    break;
                }
                case 5: 
                case 6: {
                    if (!Editor.this.mTextView.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                    this.updateMinAndMaxOffsets(event);
                    break;
                }
                case 2: {
                    int startOffset;
                    ViewConfiguration viewConfig = ViewConfiguration.get(Editor.this.mTextView.getContext());
                    int touchSlop = viewConfig.getScaledTouchSlop();
                    if (this.mGestureStayedInTapRegion || this.mHaventMovedEnoughToStartDrag) {
                        float deltaX = eventX - this.mDownPositionX;
                        float deltaY = eventY - this.mDownPositionY;
                        float distanceSquared = deltaX * deltaX + deltaY * deltaY;
                        if (this.mGestureStayedInTapRegion) {
                            int doubleTapTouchSlop = viewConfig.getScaledDoubleTapTouchSlop();
                            boolean bl = this.mGestureStayedInTapRegion = distanceSquared <= (float)(doubleTapTouchSlop * doubleTapTouchSlop);
                        }
                        if (this.mHaventMovedEnoughToStartDrag) {
                            boolean bl = this.mHaventMovedEnoughToStartDrag = distanceSquared <= (float)(touchSlop * touchSlop);
                        }
                    }
                    if (this.mStartHandle != null && this.mStartHandle.isShowing() || this.mStartOffset == -1 || Editor.this.mTextView.getLayout() == null || this.mHaventMovedEnoughToStartDrag) break;
                    float y = eventY;
                    if (this.mSwitchedLines) {
                        float fingerOffset = this.mStartHandle != null ? this.mStartHandle.getIdealVerticalOffset() : (float)touchSlop;
                        y = eventY - fingerOffset;
                    }
                    int currLine = Editor.this.getCurrentLineAdjustedForSlop(Editor.this.mTextView.getLayout(), this.mLineSelectionIsOn, y);
                    if (!this.mSwitchedLines && currLine != this.mLineSelectionIsOn) {
                        this.mSwitchedLines = true;
                        break;
                    }
                    int offset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, eventX);
                    if (this.mStartOffset < offset) {
                        offset = Editor.this.getWordEnd(offset);
                        startOffset = Editor.this.getWordStart(this.mStartOffset);
                    } else {
                        offset = Editor.this.getWordStart(offset);
                        startOffset = Editor.this.getWordEnd(this.mStartOffset);
                    }
                    this.mLineSelectionIsOn = currLine;
                    Selection.setSelection((Spannable)Editor.this.mTextView.getText(), startOffset, offset);
                    break;
                }
                case 1: {
                    if (!this.mDragAcceleratorActive) break;
                    Editor.this.mTextView.getParent().requestDisallowInterceptTouchEvent(false);
                    this.show();
                    int startOffset = Editor.this.mTextView.getSelectionStart();
                    int endOffset = Editor.this.mTextView.getSelectionEnd();
                    if (endOffset < startOffset) {
                        int tmp = endOffset;
                        endOffset = startOffset;
                        startOffset = tmp;
                        Selection.setSelection((Spannable)Editor.this.mTextView.getText(), startOffset, endOffset);
                    }
                    this.mStartHandle.showAtLocation(startOffset);
                    this.mEndHandle.showAtLocation(endOffset);
                    if (!Editor.this.mTextView.isInExtractedMode()) {
                        Editor.this.startSelectionActionMode();
                    }
                    this.mDragAcceleratorActive = false;
                    this.mStartOffset = -1;
                    this.mSwitchedLines = false;
                }
            }
        }

        private void updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int offset = Editor.this.mTextView.getOffsetForPosition(event.getX(index), event.getY(index));
                if (offset < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset;
                }
                if (offset <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset;
            }
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
            this.mStartOffset = -1;
            this.mDragAcceleratorActive = false;
            this.mSwitchedLines = false;
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        public boolean isDragAcceleratorActive() {
            return this.mDragAcceleratorActive;
        }

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        @Override
        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }
    }

    private class InsertionPointCursorController
    implements CursorController {
        private InsertionHandleView mHandle;

        private InsertionPointCursorController() {
        }

        @Override
        public void show() {
            this.getHandle().show();
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
        }

        @Override
        public void hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        private InsertionHandleView getHandle() {
            if (Editor.this.mSelectHandleCenter == null) {
                Editor.this.mSelectHandleCenter = Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRes);
            }
            if (this.mHandle == null) {
                this.mHandle = new InsertionHandleView(Editor.this.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        @Override
        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public void show();

        public void hide();

        public void onDetached();
    }

    private class SelectionEndHandleView
    extends HandleView {
        private boolean mInWord;
        private float mTouchWordDelta;
        private float mPrevX;
        private boolean mLanguageDirectionChanged;
        private final float mTextViewEdgeSlop;
        private final int[] mTextViewLocation;

        public SelectionEndHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
            this.mInWord = false;
            this.mLanguageDirectionChanged = false;
            this.mTextViewLocation = new int[2];
            ViewConfiguration viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext());
            this.mTextViewEdgeSlop = viewConfiguration.getScaledTouchSlop() * 4;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() * 3 / 4;
            }
            return drawable2.getIntrinsicWidth() / 4;
        }

        @Override
        protected int getHorizontalGravity(boolean isRtlRun) {
            return isRtlRun ? 5 : 3;
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionEnd();
        }

        @Override
        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionStart(), offset);
            if (Editor.this.mTextActionMode != null) {
                Editor.this.mTextActionMode.invalidate();
            }
            this.updateDrawable();
        }

        @Override
        public void updatePosition(float x, float y) {
            boolean isExpanding;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                this.positionAndAdjustForCrossingHandles(Editor.this.mTextView.getOffsetForPosition(x, y));
                return;
            }
            if (this.mPreviousLineTouched == -1) {
                this.mPreviousLineTouched = Editor.this.mTextView.getLineAtCoordinate(y);
            }
            boolean positionCursor = false;
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            int currLine = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPreviousLineTouched, y);
            int initialOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x);
            if (initialOffset <= selectionStart) {
                currLine = layout2.getLineForOffset(selectionStart);
                initialOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x);
            }
            int offset = initialOffset;
            int end = Editor.this.getWordEnd(offset);
            int start = Editor.this.getWordStart(offset);
            if (this.mPrevX == -1.0f) {
                this.mPrevX = x;
            }
            int selectionEnd = Editor.this.mTextView.getSelectionEnd();
            boolean selectionEndRtl = layout2.isRtlCharAt(selectionEnd);
            boolean atRtl = layout2.isRtlCharAt(offset);
            boolean isLvlBoundary = layout2.isLevelBoundary(offset);
            if (isLvlBoundary || selectionEndRtl && !atRtl || !selectionEndRtl && atRtl) {
                this.mLanguageDirectionChanged = true;
                this.mTouchWordDelta = 0.0f;
                this.positionAndAdjustForCrossingHandles(offset);
                return;
            }
            if (this.mLanguageDirectionChanged && !isLvlBoundary) {
                this.positionAndAdjustForCrossingHandles(offset);
                this.mTouchWordDelta = 0.0f;
                this.mLanguageDirectionChanged = false;
                return;
            }
            float xDiff = x - this.mPrevX;
            if (atRtl) {
                isExpanding = xDiff < 0.0f || currLine < this.mPreviousLineTouched;
            } else {
                boolean bl = isExpanding = xDiff > 0.0f || currLine > this.mPreviousLineTouched;
            }
            if (Editor.this.mTextView.getHorizontallyScrolling() && this.positionNearEdgeOfScrollingView(x, atRtl) && Editor.this.mTextView.canScrollHorizontally(atRtl ? -1 : 1) && (isExpanding && offset > selectionEnd || !isExpanding)) {
                this.mTouchWordDelta = 0.0f;
                int nextOffset = atRtl ? layout2.getOffsetToLeftOf(this.mPreviousOffset) : layout2.getOffsetToRightOf(this.mPreviousOffset);
                this.positionAndAdjustForCrossingHandles(nextOffset);
                return;
            }
            if (isExpanding) {
                if (!this.mInWord || currLine > this.mPrevLine) {
                    int offsetThresholdToSnap;
                    int wordEndOnCurrLine = end;
                    if (layout2 != null && layout2.getLineForOffset(end) != currLine) {
                        wordEndOnCurrLine = layout2.getLineEnd(currLine);
                    }
                    offset = offset >= (offsetThresholdToSnap = start + (wordEndOnCurrLine - start) / 2) || currLine > this.mPrevLine ? end : this.mPreviousOffset;
                }
                if (offset > initialOffset) {
                    float adjustedX = layout2.getPrimaryHorizontal(offset);
                    this.mTouchWordDelta = adjustedX - Editor.this.mTextView.convertToLocalHorizontalCoordinate(x);
                } else {
                    this.mTouchWordDelta = 0.0f;
                }
                positionCursor = true;
            } else {
                int adjustedOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x + this.mTouchWordDelta);
                if (adjustedOffset < this.mPreviousOffset || currLine < this.mPrevLine) {
                    if (currLine < this.mPrevLine) {
                        offset = end;
                        if (offset > initialOffset) {
                            float adjustedX = layout2.getPrimaryHorizontal(offset);
                            this.mTouchWordDelta = adjustedX - Editor.this.mTextView.convertToLocalHorizontalCoordinate(x);
                        } else {
                            this.mTouchWordDelta = 0.0f;
                        }
                    } else {
                        offset = adjustedOffset;
                    }
                    positionCursor = true;
                } else if (adjustedOffset > this.mPreviousOffset) {
                    this.mTouchWordDelta = layout2.getPrimaryHorizontal(this.mPreviousOffset) - Editor.this.mTextView.convertToLocalHorizontalCoordinate(x);
                }
            }
            if (positionCursor) {
                this.mPreviousLineTouched = currLine;
                this.positionAndAdjustForCrossingHandles(offset);
            }
            this.mPrevX = x;
        }

        private void positionAndAdjustForCrossingHandles(int offset) {
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            if (offset <= selectionStart) {
                offset = Editor.this.getNextCursorOffset(selectionStart, true);
                this.mTouchWordDelta = 0.0f;
            }
            this.positionAtCursorOffset(offset, false);
        }

        @Override
        protected void positionAtCursorOffset(int offset, boolean parentScrolled) {
            super.positionAtCursorOffset(offset, parentScrolled);
            this.mInWord = !Editor.this.getWordIteratorWithText().isBoundary(offset);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            boolean superResult = super.onTouchEvent(event);
            if (event.getActionMasked() == 0) {
                this.mTouchWordDelta = 0.0f;
                this.mPrevX = -1.0f;
            }
            return superResult;
        }

        private boolean positionNearEdgeOfScrollingView(float x, boolean atRtl) {
            int rightEdge;
            int leftEdge;
            Editor.this.mTextView.getLocationOnScreen(this.mTextViewLocation);
            boolean nearEdge = atRtl ? x < (float)(leftEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getPaddingLeft()) + this.mTextViewEdgeSlop : x > (float)(rightEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getWidth() - Editor.this.mTextView.getPaddingRight()) - this.mTextViewEdgeSlop;
            return nearEdge;
        }
    }

    private class SelectionStartHandleView
    extends HandleView {
        private boolean mInWord;
        private float mTouchWordDelta;
        private float mPrevX;
        private boolean mLanguageDirectionChanged;
        private final float mTextViewEdgeSlop;
        private final int[] mTextViewLocation;

        public SelectionStartHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
            this.mInWord = false;
            this.mLanguageDirectionChanged = false;
            this.mTextViewLocation = new int[2];
            ViewConfiguration viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext());
            this.mTextViewEdgeSlop = viewConfiguration.getScaledTouchSlop() * 4;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() * 3 / 4;
        }

        @Override
        protected int getHorizontalGravity(boolean isRtlRun) {
            return isRtlRun ? 3 : 5;
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset, Editor.this.mTextView.getSelectionEnd());
            this.updateDrawable();
            if (Editor.this.mTextActionMode != null) {
                Editor.this.mTextActionMode.invalidate();
            }
        }

        @Override
        public void updatePosition(float x, float y) {
            boolean isExpanding;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                this.positionAndAdjustForCrossingHandles(Editor.this.mTextView.getOffsetForPosition(x, y));
                return;
            }
            if (this.mPreviousLineTouched == -1) {
                this.mPreviousLineTouched = Editor.this.mTextView.getLineAtCoordinate(y);
            }
            boolean positionCursor = false;
            int selectionEnd = Editor.this.mTextView.getSelectionEnd();
            int currLine = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPreviousLineTouched, y);
            int initialOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x);
            if (initialOffset >= selectionEnd) {
                currLine = layout2.getLineForOffset(selectionEnd);
                initialOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x);
            }
            int offset = initialOffset;
            int end = Editor.this.getWordEnd(offset);
            int start = Editor.this.getWordStart(offset);
            if (this.mPrevX == -1.0f) {
                this.mPrevX = x;
            }
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            boolean selectionStartRtl = layout2.isRtlCharAt(selectionStart);
            boolean atRtl = layout2.isRtlCharAt(offset);
            boolean isLvlBoundary = layout2.isLevelBoundary(offset);
            if (isLvlBoundary || selectionStartRtl && !atRtl || !selectionStartRtl && atRtl) {
                this.mLanguageDirectionChanged = true;
                this.mTouchWordDelta = 0.0f;
                this.positionAndAdjustForCrossingHandles(offset);
                return;
            }
            if (this.mLanguageDirectionChanged && !isLvlBoundary) {
                this.positionAndAdjustForCrossingHandles(offset);
                this.mTouchWordDelta = 0.0f;
                this.mLanguageDirectionChanged = false;
                return;
            }
            float xDiff = x - this.mPrevX;
            if (atRtl) {
                isExpanding = xDiff > 0.0f || currLine > this.mPreviousLineTouched;
            } else {
                boolean bl = isExpanding = xDiff < 0.0f || currLine < this.mPreviousLineTouched;
            }
            if (Editor.this.mTextView.getHorizontallyScrolling() && this.positionNearEdgeOfScrollingView(x, atRtl) && Editor.this.mTextView.getScrollX() != 0 && (isExpanding && offset < selectionStart || !isExpanding)) {
                this.mTouchWordDelta = 0.0f;
                int nextOffset = atRtl ? layout2.getOffsetToRightOf(this.mPreviousOffset) : layout2.getOffsetToLeftOf(this.mPreviousOffset);
                this.positionAndAdjustForCrossingHandles(nextOffset);
                return;
            }
            if (isExpanding) {
                if (!this.mInWord || currLine < this.mPrevLine) {
                    int offsetThresholdToSnap;
                    int wordStartOnCurrLine = start;
                    if (layout2 != null && layout2.getLineForOffset(start) != currLine) {
                        wordStartOnCurrLine = layout2.getLineStart(currLine);
                    }
                    offset = offset <= (offsetThresholdToSnap = end - (end - wordStartOnCurrLine) / 2) || currLine < this.mPrevLine ? start : this.mPreviousOffset;
                }
                if (layout2 != null && offset < initialOffset) {
                    float adjustedX = layout2.getPrimaryHorizontal(offset);
                    this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - adjustedX;
                } else {
                    this.mTouchWordDelta = 0.0f;
                }
                positionCursor = true;
            } else {
                int adjustedOffset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x - this.mTouchWordDelta);
                if (adjustedOffset > this.mPreviousOffset || currLine > this.mPrevLine) {
                    if (currLine > this.mPrevLine) {
                        offset = start;
                        if (layout2 != null && offset < initialOffset) {
                            float adjustedX = layout2.getPrimaryHorizontal(offset);
                            this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - adjustedX;
                        } else {
                            this.mTouchWordDelta = 0.0f;
                        }
                    } else {
                        offset = adjustedOffset;
                    }
                    positionCursor = true;
                } else if (adjustedOffset < this.mPreviousOffset) {
                    this.mTouchWordDelta = Editor.this.mTextView.convertToLocalHorizontalCoordinate(x) - layout2.getPrimaryHorizontal(this.mPreviousOffset);
                }
            }
            if (positionCursor) {
                this.mPreviousLineTouched = currLine;
                this.positionAndAdjustForCrossingHandles(offset);
            }
            this.mPrevX = x;
        }

        private void positionAndAdjustForCrossingHandles(int offset) {
            int selectionEnd = Editor.this.mTextView.getSelectionEnd();
            if (offset >= selectionEnd) {
                offset = Editor.this.getNextCursorOffset(selectionEnd, false);
                this.mTouchWordDelta = 0.0f;
            }
            this.positionAtCursorOffset(offset, false);
        }

        @Override
        protected void positionAtCursorOffset(int offset, boolean parentScrolled) {
            super.positionAtCursorOffset(offset, parentScrolled);
            this.mInWord = !Editor.this.getWordIteratorWithText().isBoundary(offset);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            boolean superResult = super.onTouchEvent(event);
            if (event.getActionMasked() == 0) {
                this.mTouchWordDelta = 0.0f;
                this.mPrevX = -1.0f;
            }
            return superResult;
        }

        private boolean positionNearEdgeOfScrollingView(float x, boolean atRtl) {
            int leftEdge;
            int rightEdge;
            Editor.this.mTextView.getLocationOnScreen(this.mTextViewLocation);
            boolean nearEdge = atRtl ? x > (float)(rightEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getWidth() - Editor.this.mTextView.getPaddingRight()) - this.mTextViewEdgeSlop : x < (float)(leftEdge = this.mTextViewLocation[0] + Editor.this.mTextView.getPaddingLeft()) + this.mTextViewEdgeSlop;
            return nearEdge;
        }
    }

    private class InsertionHandleView
    extends HandleView {
        private static final int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
        private static final int RECENT_CUT_COPY_DURATION = 15000;
        private float mDownPositionX;
        private float mDownPositionY;
        private Runnable mHider;

        public InsertionHandleView(Drawable drawable2) {
            super(drawable2, drawable2);
        }

        @Override
        public void show() {
            super.show();
            long durationSinceCutOrCopy = SystemClock.uptimeMillis() - TextView.sLastCutCopyOrTextChangedTime;
            if (Editor.this.mInsertionActionModeRunnable != null && (Editor.this.mDoubleTap || Editor.this.isCursorInsideEasyCorrectionSpan())) {
                Editor.this.mTextView.removeCallbacks(Editor.this.mInsertionActionModeRunnable);
            }
            if (!Editor.this.mDoubleTap && !Editor.this.isCursorInsideEasyCorrectionSpan() && durationSinceCutOrCopy < 15000L && Editor.this.mTextActionMode == null) {
                if (Editor.this.mInsertionActionModeRunnable == null) {
                    Editor.this.mInsertionActionModeRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Editor.this.startInsertionActionMode();
                        }
                    };
                }
                Editor.this.mTextView.postDelayed(Editor.this.mInsertionActionModeRunnable, ViewConfiguration.getDoubleTapTimeout() + 1);
            }
            this.hideAfterDelay();
        }

        private void hideAfterDelay() {
            if (this.mHider == null) {
                this.mHider = new Runnable(){

                    @Override
                    public void run() {
                        InsertionHandleView.this.hide();
                    }
                };
            } else {
                this.removeHiderCallback();
            }
            Editor.this.mTextView.postDelayed(this.mHider, 4000L);
        }

        private void removeHiderCallback() {
            if (this.mHider != null) {
                Editor.this.mTextView.removeCallbacks(this.mHider);
            }
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        @Override
        protected int getHorizontalGravity(boolean isRtlRun) {
            return 1;
        }

        @Override
        protected int getCursorOffset() {
            Drawable cursor;
            int offset = super.getCursorOffset();
            Drawable drawable2 = cursor = Editor.this.mCursorCount > 0 ? Editor.this.mCursorDrawable[0] : null;
            if (cursor != null) {
                cursor.getPadding(Editor.this.mTempRect);
                offset += (cursor.getIntrinsicWidth() - ((Editor)Editor.this).mTempRect.left - ((Editor)Editor.this).mTempRect.right) / 2;
            }
            return offset;
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            boolean result = super.onTouchEvent(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDownPositionX = ev.getRawX();
                    this.mDownPositionY = ev.getRawY();
                    break;
                }
                case 1: {
                    if (!this.offsetHasBeenChanged()) {
                        ViewConfiguration viewConfiguration;
                        int touchSlop;
                        float deltaY;
                        float deltaX = this.mDownPositionX - ev.getRawX();
                        float distanceSquared = deltaX * deltaX + (deltaY = this.mDownPositionY - ev.getRawY()) * deltaY;
                        if (distanceSquared < (float)((touchSlop = (viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext())).getScaledTouchSlop()) * touchSlop)) {
                            if (Editor.this.mTextActionMode != null) {
                                Editor.this.mTextActionMode.finish();
                            } else {
                                Editor.this.startInsertionActionMode();
                            }
                        }
                    } else if (Editor.this.mTextActionMode != null) {
                        Editor.this.mTextActionMode.invalidateContentRect();
                    }
                    this.hideAfterDelay();
                    break;
                }
                case 3: {
                    this.hideAfterDelay();
                    break;
                }
            }
            return result;
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset);
        }

        @Override
        public void updatePosition(float x, float y) {
            int offset;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 != null) {
                if (this.mPreviousLineTouched == -1) {
                    this.mPreviousLineTouched = Editor.this.mTextView.getLineAtCoordinate(y);
                }
                int currLine = Editor.this.getCurrentLineAdjustedForSlop(layout2, this.mPreviousLineTouched, y);
                offset = Editor.this.mTextView.getOffsetAtCoordinate(currLine, x);
                this.mPreviousLineTouched = currLine;
            } else {
                offset = Editor.this.mTextView.getOffsetForPosition(x, y);
            }
            this.positionAtCursorOffset(offset, false);
            if (Editor.this.mTextActionMode != null) {
                Editor.this.mTextActionMode.invalidate();
            }
        }

        @Override
        void onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        @Override
        public void onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }
    }

    private abstract class HandleView
    extends View
    implements TextViewPositionListener {
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        private final PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private boolean mIsDragging;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;
        protected int mHotspotX;
        protected int mHorizontalGravity;
        private float mTouchOffsetY;
        private float mIdealVerticalOffset;
        private int mLastParentX;
        private int mLastParentY;
        protected int mPreviousOffset;
        private boolean mPositionHasChanged;
        private int mMinSize;
        protected int mPrevLine;
        protected int mPreviousLineTouched;
        private static final int HISTORY_SIZE = 5;
        private static final int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static final int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private final long[] mPreviousOffsetsTimes;
        private final int[] mPreviousOffsets;
        private int mPreviousOffsetIndex;
        private int mNumberPreviousOffsets;

        public HandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(Editor.this.mTextView.getContext());
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPrevLine = -1;
            this.mPreviousLineTouched = -1;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.mContainer = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setWidth(-2);
            this.mContainer.setHeight(-2);
            this.mContainer.setContentView(this);
            this.mDrawableLtr = drawableLtr;
            this.mDrawableRtl = drawableRtl;
            this.mMinSize = Editor.this.mTextView.getContext().getResources().getDimensionPixelSize(17105039);
            this.updateDrawable();
            int handleHeight = this.getPreferredHeight();
            this.mTouchOffsetY = -0.3f * (float)handleHeight;
            this.mIdealVerticalOffset = 0.7f * (float)handleHeight;
        }

        public float getIdealVerticalOffset() {
            return this.mIdealVerticalOffset;
        }

        protected void updateDrawable() {
            if (this.mIsDragging) {
                return;
            }
            int offset = this.getCurrentCursorOffset();
            boolean isRtlCharAtOffset = Editor.this.mTextView.getLayout().isRtlCharAt(offset);
            Drawable oldDrawable = this.mDrawable;
            this.mDrawable = isRtlCharAtOffset ? this.mDrawableRtl : this.mDrawableLtr;
            this.mHotspotX = this.getHotspotX(this.mDrawable, isRtlCharAtOffset);
            this.mHorizontalGravity = this.getHorizontalGravity(isRtlCharAtOffset);
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 != null && oldDrawable != this.mDrawable && this.isShowing()) {
                this.mPositionX = (int)(layout2.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
                this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
                this.mPositionHasChanged = true;
                this.updatePosition(this.mLastParentX, this.mLastParentY, false, false);
                this.postInvalidate();
            }
        }

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        protected abstract int getHorizontalGravity(boolean var1);

        private void startTouchUpFilter(int offset) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(offset);
        }

        private void addPositionToTouchUpFilter(int offset) {
            this.mPreviousOffsetIndex = (this.mPreviousOffsetIndex + 1) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = offset;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            ++this.mNumberPreviousOffsets;
        }

        private void filterOnTouchUp() {
            long now = SystemClock.uptimeMillis();
            int i = 0;
            int index = this.mPreviousOffsetIndex;
            int iMax = Math.min(this.mNumberPreviousOffsets, 5);
            while (i < iMax && now - this.mPreviousOffsetsTimes[index] < 150L) {
                index = (this.mPreviousOffsetIndex - ++i + 5) % 5;
            }
            if (i > 0 && i < iMax && now - this.mPreviousOffsetsTimes[index] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[index], false);
            }
        }

        public boolean offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.getPreferredWidth(), this.getPreferredHeight());
        }

        private int getPreferredWidth() {
            return Math.max(this.mDrawable.getIntrinsicWidth(), this.mMinSize);
        }

        private int getPreferredHeight() {
            return Math.max(this.mDrawable.getIntrinsicHeight(), this.mMinSize);
        }

        public void show() {
            if (this.isShowing()) {
                return;
            }
            Editor.this.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false);
        }

        protected void dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        public void hide() {
            this.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        private boolean isVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return false;
            }
            return Editor.this.isPositionVisible(this.mPositionX + this.mHotspotX + this.getHorizontalOffset(), this.mPositionY);
        }

        public abstract int getCurrentCursorOffset();

        protected abstract void updateSelection(int var1);

        public abstract void updatePosition(float var1, float var2);

        protected void positionAtCursorOffset(int offset, boolean parentScrolled) {
            boolean offsetChanged;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                Editor.this.prepareCursorControllers();
                return;
            }
            layout2 = Editor.this.getActiveLayout();
            boolean bl = offsetChanged = offset != this.mPreviousOffset;
            if (offsetChanged || parentScrolled) {
                int line;
                if (offsetChanged) {
                    this.updateSelection(offset);
                    this.addPositionToTouchUpFilter(offset);
                }
                this.mPrevLine = line = layout2.getLineForOffset(offset);
                this.mPositionX = (int)(layout2.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
                this.mPositionY = layout2.getLineBottom(line);
                this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
                this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
                this.mPreviousOffset = offset;
                this.mPositionHasChanged = true;
            }
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), parentScrolled);
            if (parentPositionChanged || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (parentPositionX != this.mLastParentX || parentPositionY != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(parentPositionX - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(parentPositionY - this.mLastParentY);
                        this.mLastParentX = parentPositionX;
                        this.mLastParentY = parentPositionY;
                    }
                    this.onHandleMoved();
                }
                if (this.isVisible()) {
                    int positionX = parentPositionX + this.mPositionX;
                    int positionY = parentPositionY + this.mPositionY;
                    if (this.isShowing()) {
                        this.mContainer.update(positionX, positionY, -1, -1);
                    } else {
                        this.mContainer.showAtLocation(Editor.this.mTextView, 0, positionX, positionY);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        public void showAtLocation(int offset) {
            int[] tmpCords = new int[2];
            Editor.this.mTextView.getLocationInWindow(tmpCords);
            Layout layout2 = Editor.this.mTextView.getLayout();
            int posX = tmpCords[0];
            int posY = tmpCords[1];
            int line = layout2.getLineForOffset(offset);
            int startX = (int)(layout2.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
            int startY = layout2.getLineBottom(line);
            this.mContainer.showAtLocation(Editor.this.mTextView, 0, (startX += Editor.this.mTextView.viewportToContentHorizontalOffset()) + posX, (startY += Editor.this.mTextView.viewportToContentVerticalOffset()) + posY);
        }

        @Override
        protected void onDraw(Canvas c) {
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            int left = this.getHorizontalOffset();
            this.mDrawable.setBounds(left, 0, left + drawWidth, this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(c);
        }

        private int getHorizontalOffset() {
            int left;
            int width = this.getPreferredWidth();
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            switch (this.mHorizontalGravity) {
                case 3: {
                    left = 0;
                    break;
                }
                default: {
                    left = (width - drawWidth) / 2;
                    break;
                }
                case 5: {
                    left = width - drawWidth;
                }
            }
            return left;
        }

        protected int getCursorOffset() {
            return 0;
        }

        @Override
        public boolean onTouchEvent(MotionEvent ev) {
            Editor.this.updateFloatingToolbarVisibility(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    this.mTouchToWindowOffsetX = ev.getRawX() - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = ev.getRawY() - (float)this.mPositionY;
                    PositionListener positionListener = Editor.this.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mIsDragging = true;
                    this.mPreviousLineTouched = -1;
                    break;
                }
                case 2: {
                    float newVerticalOffset;
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    float previousVerticalOffset = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float currentVerticalOffset = rawY - (float)this.mPositionY - (float)this.mLastParentY;
                    if (previousVerticalOffset < this.mIdealVerticalOffset) {
                        newVerticalOffset = Math.min(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.max(newVerticalOffset, previousVerticalOffset);
                    } else {
                        newVerticalOffset = Math.max(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.min(newVerticalOffset, previousVerticalOffset);
                    }
                    this.mTouchToWindowOffsetY = newVerticalOffset + (float)this.mLastParentY;
                    float newPosX = rawX - this.mTouchToWindowOffsetX + (float)this.mHotspotX + (float)this.getHorizontalOffset();
                    float newPosY = rawY - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(newPosX, newPosY);
                    break;
                }
                case 1: {
                    this.filterOnTouchUp();
                    this.mIsDragging = false;
                    this.updateDrawable();
                    break;
                }
                case 3: {
                    this.mIsDragging = false;
                    this.updateDrawable();
                }
            }
            return true;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        void onHandleMoved() {
        }

        public void onDetached() {
        }
    }

    private class CursorAnchorInfoNotifier
    implements TextViewPositionListener {
        final CursorAnchorInfo.Builder mSelectionInfoBuilder = new CursorAnchorInfo.Builder();
        final int[] mTmpIntOffset = new int[2];
        final Matrix mViewToScreenMatrix = new Matrix();

        private CursorAnchorInfoNotifier() {
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            InputMethodState ims = Editor.this.mInputMethodState;
            if (ims == null || ims.mBatchEditNesting > 0) {
                return;
            }
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (null == imm) {
                return;
            }
            if (!imm.isActive(Editor.this.mTextView)) {
                return;
            }
            if (!imm.isCursorAnchorInfoEnabled()) {
                return;
            }
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return;
            }
            CursorAnchorInfo.Builder builder = this.mSelectionInfoBuilder;
            builder.reset();
            int selectionStart = Editor.this.mTextView.getSelectionStart();
            builder.setSelectionRange(selectionStart, Editor.this.mTextView.getSelectionEnd());
            this.mViewToScreenMatrix.set(Editor.this.mTextView.getMatrix());
            Editor.this.mTextView.getLocationOnScreen(this.mTmpIntOffset);
            this.mViewToScreenMatrix.postTranslate(this.mTmpIntOffset[0], this.mTmpIntOffset[1]);
            builder.setMatrix(this.mViewToScreenMatrix);
            float viewportToContentHorizontalOffset = Editor.this.mTextView.viewportToContentHorizontalOffset();
            float viewportToContentVerticalOffset = Editor.this.mTextView.viewportToContentVerticalOffset();
            CharSequence text = Editor.this.mTextView.getText();
            if (text instanceof Spannable) {
                boolean hasComposingText;
                Spannable sp = (Spannable)text;
                int composingTextStart = EditableInputConnection.getComposingSpanStart(sp);
                int composingTextEnd = EditableInputConnection.getComposingSpanEnd(sp);
                if (composingTextEnd < composingTextStart) {
                    int temp = composingTextEnd;
                    composingTextEnd = composingTextStart;
                    composingTextStart = temp;
                }
                boolean bl = hasComposingText = 0 <= composingTextStart && composingTextStart < composingTextEnd;
                if (hasComposingText) {
                    CharSequence composingText = text.subSequence(composingTextStart, composingTextEnd);
                    builder.setComposingText(composingTextStart, composingText);
                    int minLine = layout2.getLineForOffset(composingTextStart);
                    int maxLine = layout2.getLineForOffset(composingTextEnd - 1);
                    for (int line = minLine; line <= maxLine; ++line) {
                        int lineStart = layout2.getLineStart(line);
                        int lineEnd = layout2.getLineEnd(line);
                        int offsetStart = Math.max(lineStart, composingTextStart);
                        int offsetEnd = Math.min(lineEnd, composingTextEnd);
                        boolean ltrLine = layout2.getParagraphDirection(line) == 1;
                        float[] widths = new float[offsetEnd - offsetStart];
                        layout2.getPaint().getTextWidths(text, offsetStart, offsetEnd, widths);
                        float top = layout2.getLineTop(line);
                        float bottom = layout2.getLineBottom(line);
                        for (int offset = offsetStart; offset < offsetEnd; ++offset) {
                            float right;
                            float left;
                            float charWidth = widths[offset - offsetStart];
                            boolean isRtl = layout2.isRtlCharAt(offset);
                            float primary = layout2.getPrimaryHorizontal(offset);
                            float secondary = layout2.getSecondaryHorizontal(offset);
                            if (ltrLine) {
                                if (isRtl) {
                                    left = secondary - charWidth;
                                    right = secondary;
                                } else {
                                    left = primary;
                                    right = primary + charWidth;
                                }
                            } else if (!isRtl) {
                                left = secondary;
                                right = secondary + charWidth;
                            } else {
                                left = primary - charWidth;
                                right = primary;
                            }
                            float localLeft = left + viewportToContentHorizontalOffset;
                            float localRight = right + viewportToContentHorizontalOffset;
                            float localTop = top + viewportToContentVerticalOffset;
                            float localBottom = bottom + viewportToContentVerticalOffset;
                            boolean isTopLeftVisible = Editor.this.isPositionVisible(localLeft, localTop);
                            boolean isBottomRightVisible = Editor.this.isPositionVisible(localRight, localBottom);
                            int characterBoundsFlags = 0;
                            if (isTopLeftVisible || isBottomRightVisible) {
                                characterBoundsFlags |= 1;
                            }
                            if (!isTopLeftVisible || !isBottomRightVisible) {
                                characterBoundsFlags |= 2;
                            }
                            if (isRtl) {
                                characterBoundsFlags |= 4;
                            }
                            builder.addCharacterBounds(offset, localLeft, localTop, localRight, localBottom, characterBoundsFlags);
                        }
                    }
                }
            }
            if (0 <= selectionStart) {
                int offset = selectionStart;
                int line = layout2.getLineForOffset(offset);
                float insertionMarkerX = layout2.getPrimaryHorizontal(offset) + viewportToContentHorizontalOffset;
                float insertionMarkerTop = (float)layout2.getLineTop(line) + viewportToContentVerticalOffset;
                float insertionMarkerBaseline = (float)layout2.getLineBaseline(line) + viewportToContentVerticalOffset;
                float insertionMarkerBottom = (float)layout2.getLineBottom(line) + viewportToContentVerticalOffset;
                boolean isTopVisible = Editor.this.isPositionVisible(insertionMarkerX, insertionMarkerTop);
                boolean isBottomVisible = Editor.this.isPositionVisible(insertionMarkerX, insertionMarkerBottom);
                int insertionMarkerFlags = 0;
                if (isTopVisible || isBottomVisible) {
                    insertionMarkerFlags |= 1;
                }
                if (!isTopVisible || !isBottomVisible) {
                    insertionMarkerFlags |= 2;
                }
                if (layout2.isRtlCharAt(offset)) {
                    insertionMarkerFlags |= 4;
                }
                builder.setInsertionMarkerLocation(insertionMarkerX, insertionMarkerTop, insertionMarkerBaseline, insertionMarkerBottom, insertionMarkerFlags);
            }
            imm.updateCursorAnchorInfo(Editor.this.mTextView, builder.build());
        }
    }

    private class TextActionModeCallback
    extends ActionMode.Callback2 {
        private final Path mSelectionPath = new Path();
        private final RectF mSelectionBounds = new RectF();
        private final boolean mHasSelection;
        private int mHandleHeight;

        public TextActionModeCallback(boolean hasSelection) {
            this.mHasSelection = hasSelection;
            if (this.mHasSelection) {
                SelectionModifierCursorController selectionController = Editor.this.getSelectionController();
                if (selectionController.mStartHandle == null) {
                    selectionController.initDrawables();
                    selectionController.initHandles();
                    selectionController.hide();
                }
                this.mHandleHeight = Math.max(Editor.this.mSelectHandleLeft.getMinimumHeight(), Editor.this.mSelectHandleRight.getMinimumHeight());
            } else {
                InsertionPointCursorController insertionController = Editor.this.getInsertionController();
                if (insertionController != null) {
                    insertionController.getHandle();
                    this.mHandleHeight = Editor.this.mSelectHandleCenter.getMinimumHeight();
                }
            }
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            mode.setTitle(null);
            mode.setSubtitle(null);
            mode.setTitleOptionalHint(true);
            this.populateMenuWithItems(menu2);
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null && !customCallback.onCreateActionMode(mode, menu2)) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
                return false;
            }
            if (Editor.this.mTextView.canProcessText()) {
                Editor.this.mProcessTextIntentActionsHandler.onInitializeMenu(menu2);
            }
            if (menu2.hasVisibleItems() || mode.getCustomView() != null) {
                Editor.this.mTextView.setHasTransientState(true);
                return true;
            }
            return false;
        }

        private ActionMode.Callback getCustomCallback() {
            return this.mHasSelection ? Editor.this.mCustomSelectionActionModeCallback : Editor.this.mCustomInsertionActionModeCallback;
        }

        private void populateMenuWithItems(Menu menu2) {
            if (Editor.this.mTextView.canCut()) {
                menu2.add(0, 0x1020020, 1, 17039363).setAlphabeticShortcut('x').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canCopy()) {
                menu2.add(0, 0x1020021, 2, 0x1040001).setAlphabeticShortcut('c').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canPaste()) {
                menu2.add(0, 0x1020022, 3, 17039371).setAlphabeticShortcut('v').setShowAsAction(2);
            }
            if (Editor.this.mTextView.canShare()) {
                menu2.add(0, 16908341, 4, 17040456).setShowAsAction(1);
            }
            this.updateSelectAllItem(menu2);
            this.updateReplaceItem(menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            this.updateSelectAllItem(menu2);
            this.updateReplaceItem(menu2);
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null) {
                return customCallback.onPrepareActionMode(mode, menu2);
            }
            return true;
        }

        private void updateSelectAllItem(Menu menu2) {
            boolean selectAllItemExists;
            boolean canSelectAll = Editor.this.mTextView.canSelectAllText();
            boolean bl = selectAllItemExists = menu2.findItem(16908319) != null;
            if (canSelectAll && !selectAllItemExists) {
                menu2.add(0, 16908319, 5, 17039373).setShowAsAction(1);
            } else if (!canSelectAll && selectAllItemExists) {
                menu2.removeItem(16908319);
            }
        }

        private void updateReplaceItem(Menu menu2) {
            boolean replaceItemExists;
            boolean canReplace = Editor.this.mTextView.isSuggestionsEnabled() && Editor.this.shouldOfferToShowSuggestions() && (!Editor.this.mTextView.isInExtractedMode() || !Editor.this.mTextView.hasSelection());
            boolean bl = replaceItemExists = menu2.findItem(16908340) != null;
            if (canReplace && !replaceItemExists) {
                menu2.add(0, 16908340, 6, 17040184).setShowAsAction(1);
            } else if (!canReplace && replaceItemExists) {
                menu2.removeItem(16908340);
            }
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            if (Editor.this.mProcessTextIntentActionsHandler.performMenuItemAction(item)) {
                return true;
            }
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null && customCallback.onActionItemClicked(mode, item)) {
                return true;
            }
            return Editor.this.mTextView.onTextContextMenuItem(item.getItemId());
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            ActionMode.Callback customCallback = this.getCustomCallback();
            if (customCallback != null) {
                customCallback.onDestroyActionMode(mode);
            }
            if (!Editor.this.mPreserveDetachedSelection) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
                Editor.this.mTextView.setHasTransientState(false);
            }
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
            Editor.this.mTextActionMode = null;
        }

        @Override
        public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
            if (!view.equals(Editor.this.mTextView) || Editor.this.mTextView.getLayout() == null) {
                super.onGetContentRect(mode, view, outRect);
                return;
            }
            if (Editor.this.mTextView.getSelectionStart() != Editor.this.mTextView.getSelectionEnd()) {
                this.mSelectionPath.reset();
                Editor.this.mTextView.getLayout().getSelectionPath(Editor.this.mTextView.getSelectionStart(), Editor.this.mTextView.getSelectionEnd(), this.mSelectionPath);
                this.mSelectionPath.computeBounds(this.mSelectionBounds, true);
                this.mSelectionBounds.bottom += (float)this.mHandleHeight;
            } else if (Editor.this.mCursorCount == 2) {
                Rect firstCursorBounds = Editor.this.mCursorDrawable[0].getBounds();
                Rect secondCursorBounds = Editor.this.mCursorDrawable[1].getBounds();
                this.mSelectionBounds.set(Math.min(firstCursorBounds.left, secondCursorBounds.left), Math.min(firstCursorBounds.top, secondCursorBounds.top), Math.max(firstCursorBounds.right, secondCursorBounds.right), Math.max(firstCursorBounds.bottom, secondCursorBounds.bottom) + this.mHandleHeight);
            } else {
                Layout layout2 = Editor.this.getActiveLayout();
                int line = layout2.getLineForOffset(Editor.this.mTextView.getSelectionStart());
                float primaryHorizontal = layout2.getPrimaryHorizontal(Editor.this.mTextView.getSelectionStart());
                this.mSelectionBounds.set(primaryHorizontal, layout2.getLineTop(line), primaryHorizontal, layout2.getLineTop(line + 1) + this.mHandleHeight);
            }
            int textHorizontalOffset = Editor.this.mTextView.viewportToContentHorizontalOffset();
            int textVerticalOffset = Editor.this.mTextView.viewportToContentVerticalOffset();
            outRect.set((int)Math.floor(this.mSelectionBounds.left + (float)textHorizontalOffset), (int)Math.floor(this.mSelectionBounds.top + (float)textVerticalOffset), (int)Math.ceil(this.mSelectionBounds.right + (float)textHorizontalOffset), (int)Math.ceil(this.mSelectionBounds.bottom + (float)textVerticalOffset));
        }
    }

    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener {
        private static final int MAX_NUMBER_SUGGESTIONS = 5;
        private static final int ADD_TO_DICTIONARY = -1;
        private static final int DELETE_TEXT = -2;
        private SuggestionInfo[] mSuggestionInfos;
        private int mNumberOfSuggestions;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp;
        private SuggestionAdapter mSuggestionsAdapter;
        private final Comparator<SuggestionSpan> mSuggestionSpanComparator;
        private final HashMap<SuggestionSpan, Integer> mSpansLengths;

        public SuggestionsPopupWindow() {
            this.mIsShowingUp = false;
            this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
            this.mSuggestionSpanComparator = new SuggestionSpanComparator();
            this.mSpansLengths = new HashMap();
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow(Editor.this.mTextView.getContext(), 16843635);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        @Override
        protected void initContentView() {
            ListView listView = new ListView(Editor.this.mTextView.getContext());
            this.mSuggestionsAdapter = new SuggestionAdapter();
            listView.setAdapter(this.mSuggestionsAdapter);
            listView.setOnItemClickListener(this);
            this.mContentView = listView;
            this.mSuggestionInfos = new SuggestionInfo[7];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo();
            }
        }

        public boolean isShowingUp() {
            return this.mIsShowingUp;
        }

        public void onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        private SuggestionSpan[] getSuggestionSpans() {
            int pos = Editor.this.mTextView.getSelectionStart();
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = spannable.getSpans(pos, pos, SuggestionSpan.class);
            this.mSpansLengths.clear();
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int start = spannable.getSpanStart(suggestionSpan);
                int end = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, end - start);
            }
            Arrays.sort(suggestionSpans, this.mSuggestionSpanComparator);
            return suggestionSpans;
        }

        @Override
        public void show() {
            if (!(Editor.this.mTextView.getText() instanceof Editable)) {
                return;
            }
            if (this.updateSuggestions()) {
                this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
                Editor.this.mTextView.setCursorVisible(false);
                this.mIsShowingUp = true;
                super.show();
            }
        }

        @Override
        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int horizontalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int verticalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int width = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, view.getMeasuredWidth());
            }
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), verticalMeasure);
            Drawable popupBackground = this.mPopupWindow.getBackground();
            if (popupBackground != null) {
                if (Editor.this.mTempRect == null) {
                    Editor.this.mTempRect = new Rect();
                }
                popupBackground.getPadding(Editor.this.mTempRect);
                width += ((Editor)Editor.this).mTempRect.left + ((Editor)Editor.this).mTempRect.right;
            }
            this.mPopupWindow.setWidth(width);
        }

        @Override
        protected int getTextOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            return Editor.this.mTextView.getLayout().getLineBottom(line);
        }

        @Override
        protected int clipVertically(int positionY) {
            int height = this.mContentView.getMeasuredHeight();
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            return Math.min(positionY, displayMetrics.heightPixels - height);
        }

        @Override
        public void hide() {
            super.hide();
        }

        private boolean updateSuggestions() {
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = this.getSuggestionSpans();
            int nbSpans = suggestionSpans.length;
            if (nbSpans == 0) {
                return false;
            }
            this.mNumberOfSuggestions = 0;
            int spanUnionStart = Editor.this.mTextView.getText().length();
            int spanUnionEnd = 0;
            SuggestionSpan misspelledSpan = null;
            int underlineColor = 0;
            block0: for (int spanIndex = 0; spanIndex < nbSpans; ++spanIndex) {
                SuggestionSpan suggestionSpan = suggestionSpans[spanIndex];
                int spanStart = spannable.getSpanStart(suggestionSpan);
                int spanEnd = spannable.getSpanEnd(suggestionSpan);
                spanUnionStart = Math.min(spanStart, spanUnionStart);
                spanUnionEnd = Math.max(spanEnd, spanUnionEnd);
                if ((suggestionSpan.getFlags() & 2) != 0) {
                    misspelledSpan = suggestionSpan;
                }
                if (spanIndex == 0) {
                    underlineColor = suggestionSpan.getUnderlineColor();
                }
                String[] suggestions = suggestionSpan.getSuggestions();
                int nbSuggestions = suggestions.length;
                for (int suggestionIndex = 0; suggestionIndex < nbSuggestions; ++suggestionIndex) {
                    String suggestion = suggestions[suggestionIndex];
                    boolean suggestionIsDuplicate = false;
                    for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                        if (!this.mSuggestionInfos[i].text.toString().equals(suggestion)) continue;
                        SuggestionSpan otherSuggestionSpan = this.mSuggestionInfos[i].suggestionSpan;
                        int otherSpanStart = spannable.getSpanStart(otherSuggestionSpan);
                        int otherSpanEnd = spannable.getSpanEnd(otherSuggestionSpan);
                        if (spanStart != otherSpanStart || spanEnd != otherSpanEnd) continue;
                        suggestionIsDuplicate = true;
                        break;
                    }
                    if (suggestionIsDuplicate) continue;
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = suggestionSpan;
                    suggestionInfo.suggestionIndex = suggestionIndex;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), suggestion);
                    ++this.mNumberOfSuggestions;
                    if (this.mNumberOfSuggestions != 5) continue;
                    spanIndex = nbSpans;
                    continue block0;
                }
            }
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                this.highlightTextDifferences(this.mSuggestionInfos[i], spanUnionStart, spanUnionEnd);
            }
            if (misspelledSpan != null) {
                int misspelledStart = spannable.getSpanStart(misspelledSpan);
                int misspelledEnd = spannable.getSpanEnd(misspelledSpan);
                if (misspelledStart >= 0 && misspelledEnd > misspelledStart) {
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = misspelledSpan;
                    suggestionInfo.suggestionIndex = -1;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040187));
                    suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                    ++this.mNumberOfSuggestions;
                }
            }
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
            suggestionInfo.suggestionSpan = null;
            suggestionInfo.suggestionIndex = -2;
            suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040188));
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
            ++this.mNumberOfSuggestions;
            if (Editor.this.mSuggestionRangeSpan == null) {
                Editor.this.mSuggestionRangeSpan = new SuggestionRangeSpan();
            }
            if (underlineColor == 0) {
                Editor.this.mSuggestionRangeSpan.setBackgroundColor(((Editor)Editor.this).mTextView.mHighlightColor);
            } else {
                float BACKGROUND_TRANSPARENCY = 0.4f;
                int newAlpha = (int)((float)Color.alpha(underlineColor) * 0.4f);
                Editor.this.mSuggestionRangeSpan.setBackgroundColor((underlineColor & 0xFFFFFF) + (newAlpha << 24));
            }
            spannable.setSpan(Editor.this.mSuggestionRangeSpan, spanUnionStart, spanUnionEnd, 33);
            this.mSuggestionsAdapter.notifyDataSetChanged();
            return true;
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int unionStart, int unionEnd) {
            Spannable text = (Spannable)Editor.this.mTextView.getText();
            int spanStart = text.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = text.getSpanEnd(suggestionInfo.suggestionSpan);
            suggestionInfo.suggestionStart = spanStart - unionStart;
            suggestionInfo.suggestionEnd = suggestionInfo.suggestionStart + suggestionInfo.text.length();
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, suggestionInfo.text.length(), 33);
            String textAsString = text.toString();
            suggestionInfo.text.insert(0, textAsString.substring(unionStart, spanStart));
            suggestionInfo.text.append(textAsString.substring(spanEnd, unionEnd));
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[position];
            if (suggestionInfo.suggestionIndex == -2) {
                int spanUnionStart = editable.getSpanStart(Editor.this.mSuggestionRangeSpan);
                int spanUnionEnd = editable.getSpanEnd(Editor.this.mSuggestionRangeSpan);
                if (spanUnionStart >= 0 && spanUnionEnd > spanUnionStart) {
                    if (spanUnionEnd < editable.length() && Character.isSpaceChar(editable.charAt(spanUnionEnd)) && (spanUnionStart == 0 || Character.isSpaceChar(editable.charAt(spanUnionStart - 1)))) {
                        ++spanUnionEnd;
                    }
                    Editor.this.mTextView.deleteText_internal(spanUnionStart, spanUnionEnd);
                }
                this.hide();
                return;
            }
            int spanStart = editable.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = editable.getSpanEnd(suggestionInfo.suggestionSpan);
            if (spanStart < 0 || spanEnd <= spanStart) {
                this.hide();
                return;
            }
            String originalText = editable.toString().substring(spanStart, spanEnd);
            if (suggestionInfo.suggestionIndex == -1) {
                Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                intent.putExtra("word", originalText);
                intent.putExtra("locale", Editor.this.mTextView.getTextServicesLocale().toString());
                intent.setFlags(intent.getFlags() | 0x10000000);
                Editor.this.mTextView.getContext().startActivity(intent);
                editable.removeSpan(suggestionInfo.suggestionSpan);
                Selection.setSelection(editable, spanEnd);
                Editor.this.updateSpellCheckSpans(spanStart, spanEnd, false);
            } else {
                SuggestionSpan[] suggestionSpans = editable.getSpans(spanStart, spanEnd, SuggestionSpan.class);
                int length = suggestionSpans.length;
                int[] suggestionSpansStarts = new int[length];
                int[] suggestionSpansEnds = new int[length];
                int[] suggestionSpansFlags = new int[length];
                for (int i = 0; i < length; ++i) {
                    SuggestionSpan suggestionSpan = suggestionSpans[i];
                    suggestionSpansStarts[i] = editable.getSpanStart(suggestionSpan);
                    suggestionSpansEnds[i] = editable.getSpanEnd(suggestionSpan);
                    suggestionSpansFlags[i] = editable.getSpanFlags(suggestionSpan);
                    int suggestionSpanFlags = suggestionSpan.getFlags();
                    if ((suggestionSpanFlags & 2) <= 0) continue;
                    suggestionSpanFlags &= 0xFFFFFFFD;
                    suggestionSpan.setFlags(suggestionSpanFlags &= 0xFFFFFFFE);
                }
                int suggestionStart = suggestionInfo.suggestionStart;
                int suggestionEnd = suggestionInfo.suggestionEnd;
                String suggestion = suggestionInfo.text.subSequence(suggestionStart, suggestionEnd).toString();
                Editor.this.mTextView.replaceText_internal(spanStart, spanEnd, suggestion);
                suggestionInfo.suggestionSpan.notifySelection(Editor.this.mTextView.getContext(), originalText, suggestionInfo.suggestionIndex);
                String[] suggestions = suggestionInfo.suggestionSpan.getSuggestions();
                suggestions[suggestionInfo.suggestionIndex] = originalText;
                int lengthDifference = suggestion.length() - (spanEnd - spanStart);
                for (int i = 0; i < length; ++i) {
                    if (suggestionSpansStarts[i] > spanStart || suggestionSpansEnds[i] < spanEnd) continue;
                    Editor.this.mTextView.setSpan_internal(suggestionSpans[i], suggestionSpansStarts[i], suggestionSpansEnds[i] + lengthDifference, suggestionSpansFlags[i]);
                }
                int newCursorPosition = spanEnd + lengthDifference;
                Editor.this.mTextView.setCursorPosition_internal(newCursorPosition, newCursorPosition);
            }
            this.hide();
        }

        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            private SuggestionSpanComparator() {
            }

            @Override
            public int compare(SuggestionSpan span1, SuggestionSpan span2) {
                int flag2;
                int flag1 = span1.getFlags();
                if (flag1 != (flag2 = span2.getFlags())) {
                    boolean misspelled2;
                    boolean easy1 = (flag1 & 1) != 0;
                    boolean easy2 = (flag2 & 1) != 0;
                    boolean misspelled1 = (flag1 & 2) != 0;
                    boolean bl = misspelled2 = (flag2 & 2) != 0;
                    if (easy1 && !misspelled1) {
                        return -1;
                    }
                    if (easy2 && !misspelled2) {
                        return 1;
                    }
                    if (misspelled1) {
                        return -1;
                    }
                    if (misspelled2) {
                        return 1;
                    }
                }
                return (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span1) - (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span2);
            }
        }

        private class SuggestionAdapter
        extends BaseAdapter {
            private LayoutInflater mInflater;

            private SuggestionAdapter() {
                this.mInflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            }

            @Override
            public int getCount() {
                return SuggestionsPopupWindow.this.mNumberOfSuggestions;
            }

            @Override
            public Object getItem(int position) {
                return SuggestionsPopupWindow.this.mSuggestionInfos[position];
            }

            @Override
            public long getItemId(int position) {
                return position;
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                TextView textView = (TextView)convertView;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(((Editor)Editor.this).mTextView.mTextEditSuggestionItemLayout, parent, false);
                }
                SuggestionInfo suggestionInfo = SuggestionsPopupWindow.this.mSuggestionInfos[position];
                textView.setText(suggestionInfo.text);
                if (suggestionInfo.suggestionIndex == -1 || suggestionInfo.suggestionIndex == -2) {
                    textView.setBackgroundColor(0);
                } else {
                    textView.setBackgroundColor(-1);
                }
                return textView;
            }
        }

        private class SuggestionInfo {
            int suggestionStart;
            int suggestionEnd;
            SuggestionSpan suggestionSpan;
            int suggestionIndex;
            SpannableStringBuilder text = new SpannableStringBuilder();
            TextAppearanceSpan highlightSpan;

            private SuggestionInfo() {
                this.highlightSpan = new TextAppearanceSpan(Editor.this.mTextView.getContext(), 16974104);
            }
        }

        private class CustomPopupWindow
        extends PopupWindow {
            public CustomPopupWindow(Context context, int defStyleAttr) {
                super(context, null, defStyleAttr);
            }

            @Override
            public void dismiss() {
                super.dismiss();
                Editor.this.getPositionListener().removeSubscriber(SuggestionsPopupWindow.this);
                ((Spannable)Editor.this.mTextView.getText()).removeSpan(Editor.this.mSuggestionRangeSpan);
                Editor.this.mTextView.setCursorVisible(SuggestionsPopupWindow.this.mCursorWasVisibleBeforeSuggestions);
                if (Editor.this.hasInsertionController()) {
                    Editor.this.getInsertionController().show();
                }
            }
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener {
        protected PopupWindow mPopupWindow;
        protected ViewGroup mContentView;
        int mPositionX;
        int mPositionY;

        protected abstract void createPopupWindow();

        protected abstract void initContentView();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        protected abstract int clipVertically(int var1);

        public PinnedPopupWindow() {
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1005);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(wrapContent);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        public void show() {
            Editor.this.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = Editor.this.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        private void computeLocalPosition() {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int offset = this.getTextOffset();
            this.mPositionX = (int)(Editor.this.mTextView.getLayout().getPrimaryHorizontal(offset) - (float)width / 2.0f);
            this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
            int line = Editor.this.mTextView.getLayout().getLineForOffset(offset);
            this.mPositionY = this.getVerticalLocalPosition(line);
            this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
        }

        private void updatePosition(int parentPositionX, int parentPositionY) {
            int positionX = parentPositionX + this.mPositionX;
            int positionY = parentPositionY + this.mPositionY;
            positionY = this.clipVertically(positionY);
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int width = this.mContentView.getMeasuredWidth();
            positionX = Math.min(displayMetrics.widthPixels - width, positionX);
            positionX = Math.max(0, positionX);
            if (this.isShowing()) {
                this.mPopupWindow.update(positionX, positionY, -1, -1);
            } else {
                this.mPopupWindow.showAtLocation(Editor.this.mTextView, 0, positionX, positionY);
            }
        }

        public void hide() {
            this.mPopupWindow.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        @Override
        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            if (this.isShowing() && Editor.this.isOffsetVisible(this.getTextOffset())) {
                if (parentScrolled) {
                    this.computeLocalPosition();
                }
                this.updatePosition(parentPositionX, parentPositionY);
            } else {
                this.hide();
            }
        }

        public boolean isShowing() {
            return this.mPopupWindow.isShowing();
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final int MAXIMUM_NUMBER_OF_LISTENERS = 7;
        private TextViewPositionListener[] mPositionListeners = new TextViewPositionListener[7];
        private boolean[] mCanMove = new boolean[7];
        private boolean mPositionHasChanged = true;
        private int mPositionX;
        private int mPositionY;
        private int mNumberOfListeners;
        private boolean mScrollHasChanged;
        final int[] mTempCoords = new int[2];

        private PositionListener() {
        }

        public void addSubscriber(TextViewPositionListener positionListener, boolean canMove) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.addOnPreDrawListener(this);
            }
            int emptySlotIndex = -1;
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener listener = this.mPositionListeners[i];
                if (listener == positionListener) {
                    return;
                }
                if (emptySlotIndex >= 0 || listener != null) continue;
                emptySlotIndex = i;
            }
            this.mPositionListeners[emptySlotIndex] = positionListener;
            this.mCanMove[emptySlotIndex] = canMove;
            ++this.mNumberOfListeners;
        }

        public void removeSubscriber(TextViewPositionListener positionListener) {
            for (int i = 0; i < 7; ++i) {
                if (this.mPositionListeners[i] != positionListener) continue;
                this.mPositionListeners[i] = null;
                --this.mNumberOfListeners;
                break;
            }
            if (this.mNumberOfListeners == 0) {
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.removeOnPreDrawListener(this);
            }
        }

        public int getPositionX() {
            return this.mPositionX;
        }

        public int getPositionY() {
            return this.mPositionY;
        }

        @Override
        public boolean onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener positionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (positionListener = this.mPositionListeners[i]) == null) continue;
                positionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        private void updatePosition() {
            Editor.this.mTextView.getLocationInWindow(this.mTempCoords);
            this.mPositionHasChanged = this.mTempCoords[0] != this.mPositionX || this.mTempCoords[1] != this.mPositionY;
            this.mPositionX = this.mTempCoords[0];
            this.mPositionY = this.mTempCoords[1];
        }

        public void onScrollChanged() {
            this.mScrollHasChanged = true;
        }
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367272;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;
        private EasyEditDeleteListener mOnDeleteListener;

        private EasyEditPopupWindow() {
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        @Override
        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303274);
            LayoutInflater inflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)inflater.inflate(17367272, null);
            this.mDeleteTextView.setLayoutParams(wrapContent);
            this.mDeleteTextView.setText(17040185);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        public void setEasyEditSpan(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
        }

        private void setOnDeleteListener(EasyEditDeleteListener listener) {
            this.mOnDeleteListener = listener;
        }

        @Override
        public void onClick(View view) {
            if (view == this.mDeleteTextView && this.mEasyEditSpan != null && this.mEasyEditSpan.isDeleteEnabled() && this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onDeleteClick(this.mEasyEditSpan);
            }
        }

        @Override
        public void hide() {
            if (this.mEasyEditSpan != null) {
                this.mEasyEditSpan.setDeleteEnabled(false);
            }
            this.mOnDeleteListener = null;
            super.hide();
        }

        @Override
        protected int getTextOffset() {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            return editable.getSpanEnd(this.mEasyEditSpan);
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            return Editor.this.mTextView.getLayout().getLineBottom(line);
        }

        @Override
        protected int clipVertically(int positionY) {
            return positionY;
        }
    }

    private static interface EasyEditDeleteListener {
        public void onDeleteClick(EasyEditSpan var1);
    }

    class SpanController
    implements SpanWatcher {
        private static final int DISPLAY_TIMEOUT_MS = 3000;
        private EasyEditPopupWindow mPopupWindow;
        private Runnable mHidePopup;

        SpanController() {
        }

        private boolean isNonIntermediateSelectionSpan(Spannable text, Object span) {
            return (Selection.SELECTION_START == span || Selection.SELECTION_END == span) && (text.getSpanFlags(span) & 0x200) == 0;
        }

        @Override
        public void onSpanAdded(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (span instanceof EasyEditSpan) {
                if (this.mPopupWindow == null) {
                    this.mPopupWindow = new EasyEditPopupWindow();
                    this.mHidePopup = new Runnable(){

                        @Override
                        public void run() {
                            SpanController.this.hide();
                        }
                    };
                }
                if (this.mPopupWindow.mEasyEditSpan != null) {
                    this.mPopupWindow.mEasyEditSpan.setDeleteEnabled(false);
                }
                this.mPopupWindow.setEasyEditSpan((EasyEditSpan)span);
                this.mPopupWindow.setOnDeleteListener(new EasyEditDeleteListener(){

                    @Override
                    public void onDeleteClick(EasyEditSpan span) {
                        Editable editable = (Editable)Editor.this.mTextView.getText();
                        int start = editable.getSpanStart(span);
                        int end = editable.getSpanEnd(span);
                        if (start >= 0 && end >= 0) {
                            SpanController.this.sendEasySpanNotification(1, span);
                            Editor.this.mTextView.deleteText_internal(start, end);
                        }
                        editable.removeSpan(span);
                    }
                });
                if (Editor.this.mTextView.getWindowVisibility() != 0) {
                    return;
                }
                if (Editor.this.mTextView.getLayout() == null) {
                    return;
                }
                if (Editor.this.extractedTextModeWillBeStarted()) {
                    return;
                }
                this.mPopupWindow.show();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
                Editor.this.mTextView.postDelayed(this.mHidePopup, 3000L);
            }
        }

        @Override
        public void onSpanRemoved(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span == this.mPopupWindow.mEasyEditSpan) {
                this.hide();
            }
        }

        @Override
        public void onSpanChanged(Spannable text, Object span, int previousStart, int previousEnd, int newStart, int newEnd) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span instanceof EasyEditSpan) {
                EasyEditSpan easyEditSpan = (EasyEditSpan)span;
                this.sendEasySpanNotification(2, easyEditSpan);
                text.removeSpan(easyEditSpan);
            }
        }

        public void hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
            }
        }

        private void sendEasySpanNotification(int textChangedType, EasyEditSpan span) {
            try {
                PendingIntent pendingIntent = span.getPendingIntent();
                if (pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("android.text.style.EXTRA_TEXT_CHANGED_TYPE", textChangedType);
                    pendingIntent.send(Editor.this.mTextView.getContext(), 0, intent);
                }
            }
            catch (PendingIntent.CanceledException e) {
                Log.w("Editor", "PendingIntent for notification cannot be sent", e);
            }
        }
    }

    private static class DragLocalState {
        public TextView sourceTextView;
        public int start;
        public int end;

        public DragLocalState(TextView sourceTextView, int start, int end) {
            this.sourceTextView = sourceTextView;
            this.start = start;
            this.end = end;
        }
    }

    private class Blink
    extends Handler
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            this.removeCallbacks(this);
            if (Editor.this.shouldBlink()) {
                if (Editor.this.mTextView.getLayout() != null) {
                    Editor.this.mTextView.invalidateCursorPath();
                }
                this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            }
        }

        void cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }

    private static interface TextViewPositionListener {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }

    private static class TextRenderNode {
        RenderNode renderNode;
        boolean isDirty = true;

        public TextRenderNode(String name) {
            this.renderNode = RenderNode.create(name, null);
        }

        boolean needsRecord() {
            return this.isDirty || !this.renderNode.isValid();
        }
    }
}

