/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.util.Log;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.GraphicBuffer;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IAssetAtlas;
import android.view.IGraphicsStats;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class ThreadedRenderer
extends HardwareRenderer {
    private static final String LOGTAG = "ThreadedRenderer";
    private static final int SYNC_OK = 0;
    private static final int SYNC_INVALIDATE_REQUIRED = 1;
    private static final int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    private static final String[] VISUALIZERS = new String[]{"visual_bars"};
    private static final int FLAG_DUMP_FRAMESTATS = 1;
    private static final int FLAG_DUMP_RESET = 2;
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private final float mLightY;
    private final float mLightZ;
    private final float mLightRadius;
    private final int mAmbientShadowAlpha;
    private final int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized = false;
    private RenderNode mRootNode;
    private Choreographer mChoreographer;
    private boolean mRootNodeNeedsUpdate;

    ThreadedRenderer(Context context, boolean translucent) {
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(2, 0.0f);
        this.mLightZ = a.getDimension(3, 0.0f);
        this.mLightRadius = a.getDimension(4, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        ProcessInitializer.sInstance.init(context, this.mNativeProxy);
        this.loadSystemProperties();
    }

    @Override
    void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy);
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    @Override
    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        this.mInitialized = true;
        this.updateEnabledState(surface);
        boolean status = ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        return status;
    }

    @Override
    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    @Override
    boolean pauseSurface(Surface surface) {
        return ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    @Override
    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ThreadedRenderer.destroyResources(group.getChildAt(i));
            }
        }
    }

    @Override
    void invalidate(Surface surface) {
        this.updateSurface(surface);
    }

    @Override
    void detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    @Override
    void setup(int width, int height, View.AttachInfo attachInfo, Rect surfaceInsets) {
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && (surfaceInsets.left != 0 || surfaceInsets.right != 0 || surfaceInsets.top != 0 || surfaceInsets.bottom != 0)) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mSurfaceWidth, this.mSurfaceHeight, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
        this.setLightCenter(attachInfo);
    }

    @Override
    void setLightCenter(View.AttachInfo attachInfo) {
        Point displaySize = attachInfo.mPoint;
        attachInfo.mDisplay.getRealSize(displaySize);
        float lightX = (float)displaySize.x / 2.0f - (float)attachInfo.mWindowLeft;
        float lightY = this.mLightY - (float)attachInfo.mWindowTop;
        ThreadedRenderer.nSetLightCenter(this.mNativeProxy, lightX, lightY, this.mLightZ);
    }

    @Override
    void setOpaque(boolean opaque) {
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, opaque && !this.mHasInsets);
    }

    @Override
    int getWidth() {
        return this.mWidth;
    }

    @Override
    int getHeight() {
        return this.mHeight;
    }

    @Override
    void dumpGfxInfo(PrintWriter pw, FileDescriptor fd, String[] args) {
        pw.flush();
        int flags = 0;
        block8: for (int i = 0; i < args.length; ++i) {
            String string2 = args[i];
            int n = -1;
            switch (string2.hashCode()) {
                case -252053678: {
                    if (!string2.equals("framestats")) break;
                    n = 0;
                    break;
                }
                case 108404047: {
                    if (!string2.equals("reset")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    flags |= 1;
                    continue block8;
                }
                case 1: {
                    flags |= 2;
                }
            }
        }
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd, flags);
    }

    @Override
    boolean loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        if (changed) {
            this.invalidateRoot();
        }
        return changed;
    }

    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.updateDisplayListIfDirty();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootDisplayList(View view, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        Trace.traceBegin(8L, "Record View#draw()");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            DisplayListCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onHardwarePreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.updateDisplayListIfDirty());
                canvas.insertInorderBarrier();
                callbacks.onHardwarePostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    @Override
    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    @Override
    void draw(View view, View.AttachInfo attachInfo, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        long[] frameInfo;
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        Choreographer choreographer = attachInfo.mViewRootImpl.mChoreographer;
        choreographer.mFrameInfo.markDrawStart();
        this.updateRootDisplayList(view, callbacks);
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo = choreographer.mFrameInfo.mFrameInfo, frameInfo.length)) & 2) != 0) {
            this.setEnabled(false);
            attachInfo.mViewRootImpl.mSurface.release();
            attachInfo.mViewRootImpl.invalidate();
        }
        if ((syncResult & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    static void invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    @Override
    HardwareLayer createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    @Override
    void buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    @Override
    boolean copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap);
    }

    @Override
    void pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    @Override
    void onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    @Override
    void setName(String name) {
        ThreadedRenderer.nSetName(this.mNativeProxy, name);
    }

    @Override
    void fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    @Override
    void stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    @Override
    public void notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    @Override
    void registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    static void trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    public static void overrideProperty(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        ThreadedRenderer.nOverrideProperty(name, value);
    }

    public static void dumpProfileData(byte[] data, FileDescriptor fd) {
        ThreadedRenderer.nDumpProfileData(data, fd);
    }

    static void setupShadersDiskCache(String string2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#setupShadersDiskCache(Ljava/lang/String;)V", true, null);
    }

    private static void nSetAtlas(long l, GraphicBuffer graphicBuffer, long[] lArray) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetAtlas(JLandroid/view/GraphicBuffer;[J)V", true, null);
    }

    private static void nSetProcessStatsBuffer(long l, int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetProcessStatsBuffer(JI)V", true, null);
    }

    private static long nCreateRootRenderNode() {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateRootRenderNode()J", true, null);
    }

    private static long nCreateProxy(boolean bl, long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateProxy(ZJ)J", true, null);
    }

    private static void nDeleteProxy(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDeleteProxy(J)V", true, null);
    }

    private static boolean nLoadSystemProperties(long l) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nLoadSystemProperties(J)Z", true, null) != 0;
    }

    private static void nSetName(long l, String string2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetName(JLjava/lang/String;)V", true, null);
    }

    private static boolean nInitialize(long l, Surface surface) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nInitialize(JLandroid/view/Surface;)Z", true, null) != 0;
    }

    private static void nUpdateSurface(long l, Surface surface) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nUpdateSurface(JLandroid/view/Surface;)V", true, null);
    }

    private static boolean nPauseSurface(long l, Surface surface) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nPauseSurface(JLandroid/view/Surface;)Z", true, null) != 0;
    }

    private static void nSetup(long l, int n, int n2, float f, int n3, int n4) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetup(JIIFII)V", true, null);
    }

    private static void nSetLightCenter(long l, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetLightCenter(JFFF)V", true, null);
    }

    private static void nSetOpaque(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetOpaque(JZ)V", true, null);
    }

    private static int nSyncAndDrawFrame(long l, long[] lArray, int n) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nSyncAndDrawFrame(J[JI)I", true, null);
    }

    private static void nDestroy(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroy(J)V", true, null);
    }

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRegisterAnimatingRenderNode(JJ)V", true, null);
    }

    private static void nInvokeFunctor(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nInvokeFunctor(JZ)V", true, null);
    }

    private static long nCreateTextureLayer(long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateTextureLayer(J)J", true, null);
    }

    private static void nBuildLayer(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nBuildLayer(JJ)V", true, null);
    }

    private static boolean nCopyLayerInto(long l, long l2, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nCopyLayerInto(JJLandroid/graphics/Bitmap;)Z", true, null) != 0;
    }

    private static void nPushLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nPushLayerUpdate(JJ)V", true, null);
    }

    private static void nCancelLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nCancelLayerUpdate(JJ)V", true, null);
    }

    private static void nDetachSurfaceTexture(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDetachSurfaceTexture(JJ)V", true, null);
    }

    private static void nDestroyHardwareResources(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroyHardwareResources(J)V", true, null);
    }

    private static void nTrimMemory(int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nTrimMemory(I)V", true, null);
    }

    private static void nOverrideProperty(String string2, String string3) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nOverrideProperty(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void nFence(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nFence(J)V", true, null);
    }

    private static void nStopDrawing(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nStopDrawing(J)V", true, null);
    }

    private static void nNotifyFramePending(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nNotifyFramePending(J)V", true, null);
    }

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor, int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDumpProfileInfo(JLjava/io/FileDescriptor;I)V", true, null);
    }

    private static void nDumpProfileData(byte[] byArray, FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDumpProfileData([BLjava/io/FileDescriptor;)V", true, null);
    }

    private static class ProcessInitializer {
        static ProcessInitializer sInstance = new ProcessInitializer();
        private static IBinder sProcToken;
        private boolean mInitialized = false;

        private ProcessInitializer() {
        }

        synchronized void init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            ProcessInitializer.initGraphicsStats(context, renderProxy);
            ProcessInitializer.initAssetAtlas(context, renderProxy);
        }

        private static void initGraphicsStats(Context context, long renderProxy) {
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                IGraphicsStats graphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                sProcToken = new Binder();
                String pkg = context.getApplicationInfo().packageName;
                ParcelFileDescriptor pfd = graphicsStatsService.requestBufferForProcess(pkg, sProcToken);
                ThreadedRenderer.nSetProcessStatsBuffer(renderProxy, pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w("HardwareRenderer", "Could not acquire gfx stats buffer", t);
            }
        }

        private static void initAssetAtlas(Context context, long renderProxy) {
            IBinder binder = ServiceManager.getService("assetatlas");
            if (binder == null) {
                return;
            }
            IAssetAtlas atlas = IAssetAtlas.Stub.asInterface(binder);
            try {
                GraphicBuffer buffer;
                if (atlas.isCompatible(Process.myPpid()) && (buffer = atlas.getBuffer()) != null) {
                    long[] map = atlas.getMap();
                    if (map != null) {
                        ThreadedRenderer.nSetAtlas(renderProxy, buffer, map);
                    }
                    if (atlas.getClass() != binder.getClass()) {
                        buffer.destroy();
                    }
                }
            }
            catch (RemoteException e) {
                Log.w("HardwareRenderer", "Could not acquire atlas", e);
            }
        }
    }
}

