/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.view.RenderNode;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class RenderNode_Delegate {
    private static final DelegateManager<RenderNode_Delegate> sManager = new DelegateManager<RenderNode_Delegate>(RenderNode_Delegate.class);
    private float mLift;
    private float mTranslationX;
    private float mTranslationY;
    private float mTranslationZ;
    private float mRotation;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mPivotX;
    private float mPivotY;
    private boolean mPivotExplicitlySet;
    private int mLeft;
    private int mRight;
    private int mTop;
    private int mBottom;
    private String mName;

    @LayoutlibDelegate
    static long nCreate(String name) {
        RenderNode_Delegate renderNodeDelegate = new RenderNode_Delegate();
        renderNodeDelegate.mName = name;
        return sManager.addNewDelegate(renderNodeDelegate);
    }

    @LayoutlibDelegate
    static void nDestroyRenderNode(long renderNode) {
        sManager.removeJavaReferenceFor(renderNode);
    }

    @LayoutlibDelegate
    static boolean nSetElevation(long renderNode, float lift) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mLift != lift) {
            delegate.mLift = lift;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetElevation(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mLift;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetTranslationX(long renderNode, float translationX) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mTranslationX != translationX) {
            delegate.mTranslationX = translationX;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetTranslationX(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mTranslationX;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetTranslationY(long renderNode, float translationY) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mTranslationY != translationY) {
            delegate.mTranslationY = translationY;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetTranslationY(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mTranslationY;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetTranslationZ(long renderNode, float translationZ) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mTranslationZ != translationZ) {
            delegate.mTranslationZ = translationZ;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetTranslationZ(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mTranslationZ;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetRotation(long renderNode, float rotation) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mRotation != rotation) {
            delegate.mRotation = rotation;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetRotation(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mRotation;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static void getMatrix(RenderNode renderNode, Matrix outMatrix) {
        outMatrix.reset();
        if (renderNode != null) {
            float rotation = renderNode.getRotation();
            float translationX = renderNode.getTranslationX();
            float translationY = renderNode.getTranslationY();
            float pivotX = renderNode.getPivotX();
            float pivotY = renderNode.getPivotY();
            float scaleX = renderNode.getScaleX();
            float scaleY = renderNode.getScaleY();
            outMatrix.setTranslate(translationX, translationY);
            outMatrix.preRotate(rotation, pivotX, pivotY);
            outMatrix.preScale(scaleX, scaleY, pivotX, pivotY);
        }
    }

    @LayoutlibDelegate
    static boolean nSetLeft(long renderNode, int left) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mLeft != left) {
            delegate.mLeft = left;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nSetTop(long renderNode, int top) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mTop != top) {
            delegate.mTop = top;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nSetRight(long renderNode, int right) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mRight != right) {
            delegate.mRight = right;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nSetBottom(long renderNode, int bottom) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mBottom != bottom) {
            delegate.mBottom = bottom;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nSetLeftTopRightBottom(long renderNode, int left, int top, int right, int bottom) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && (delegate.mLeft != left || delegate.mTop != top || delegate.mRight != right || delegate.mBottom != bottom)) {
            delegate.mLeft = left;
            delegate.mTop = top;
            delegate.mRight = right;
            delegate.mBottom = bottom;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static boolean nIsPivotExplicitlySet(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        return delegate != null && delegate.mPivotExplicitlySet;
    }

    @LayoutlibDelegate
    static boolean nSetPivotX(long renderNode, float pivotX) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            delegate.mPivotX = pivotX;
            delegate.mPivotExplicitlySet = true;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetPivotX(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            if (delegate.mPivotExplicitlySet) {
                return delegate.mPivotX;
            }
            return (float)(delegate.mRight - delegate.mLeft) / 2.0f;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetPivotY(long renderNode, float pivotY) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            delegate.mPivotY = pivotY;
            delegate.mPivotExplicitlySet = true;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetPivotY(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            if (delegate.mPivotExplicitlySet) {
                return delegate.mPivotY;
            }
            return (float)(delegate.mBottom - delegate.mTop) / 2.0f;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetScaleX(long renderNode, float scaleX) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mScaleX != scaleX) {
            delegate.mScaleX = scaleX;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetScaleX(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mScaleX;
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static boolean nSetScaleY(long renderNode, float scaleY) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null && delegate.mScaleY != scaleY) {
            delegate.mScaleY = scaleY;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetScaleY(long renderNode) {
        RenderNode_Delegate delegate = sManager.getDelegate(renderNode);
        if (delegate != null) {
            return delegate.mScaleY;
        }
        return 0.0f;
    }
}

