/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Pools;
import android.view.HardwareLayer;
import android.view.RenderNode;
import com.android.tools.layoutlib.create.OverrideMethod;

public class DisplayListCanvas
extends Canvas {
    private static final int POOL_LIMIT = 25;
    private static final Pools.SynchronizedPool<DisplayListCanvas> sPool = new Pools.SynchronizedPool(25);
    RenderNode mNode;
    private int mWidth;
    private int mHeight;
    private static boolean sIsAvailable = DisplayListCanvas.nIsAvailable();

    static DisplayListCanvas obtain(RenderNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        DisplayListCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new DisplayListCanvas();
        }
        canvas.mNode = node;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return DisplayListCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    private static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nIsAvailable()Z", true, null) != 0;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    private DisplayListCanvas() {
        super(DisplayListCanvas.nCreateDisplayListCanvas());
        this.mDensity = 0;
    }

    private static long nCreateDisplayListCanvas() {
        return OverrideMethod.invokeL("android.view.DisplayListCanvas#nCreateDisplayListCanvas()J", true, null);
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return DisplayListCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return DisplayListCanvas.nGetMaximumTextureHeight();
    }

    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nGetMaximumTextureWidth()I", true, null);
    }

    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.view.DisplayListCanvas#nGetMaximumTextureHeight()I", true, null);
    }

    long getRenderer() {
        return this.mNativeCanvasWrapper;
    }

    @Override
    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        DisplayListCanvas.nSetViewport(this.mNativeCanvasWrapper, width, height);
    }

    private static void nSetViewport(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nSetViewport(JII)V", true, null);
    }

    @Override
    public void setHighContrastText(boolean highContrastText) {
        DisplayListCanvas.nSetHighContrastText(this.mNativeCanvasWrapper, highContrastText);
    }

    private static void nSetHighContrastText(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nSetHighContrastText(JZ)V", true, null);
    }

    @Override
    public void insertReorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void insertInorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    private static void nInsertReorderBarrier(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nInsertReorderBarrier(JZ)V", true, null);
    }

    public void onPreDraw(Rect dirty) {
        if (dirty != null) {
            DisplayListCanvas.nPrepareDirty(this.mNativeCanvasWrapper, dirty.left, dirty.top, dirty.right, dirty.bottom);
        } else {
            DisplayListCanvas.nPrepare(this.mNativeCanvasWrapper);
        }
    }

    private static void nPrepare(long l) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nPrepare(J)V", true, null);
    }

    private static void nPrepareDirty(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nPrepareDirty(JIIII)V", true, null);
    }

    public void onPostDraw() {
        DisplayListCanvas.nFinish(this.mNativeCanvasWrapper);
    }

    private static void nFinish(long l) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nFinish(J)V", true, null);
    }

    public void callDrawGLFunction2(long drawGLFunction) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction);
    }

    private static void nCallDrawGLFunction(long l, long l2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nCallDrawGLFunction(JJ)V", true, null);
    }

    protected static long nFinishRecording(long l) {
        return OverrideMethod.invokeL("android.view.DisplayListCanvas#nFinishRecording(J)J", true, null);
    }

    public void drawRenderNode(RenderNode renderNode) {
        DisplayListCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.getNativeDisplayList());
    }

    private static void nDrawRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawRenderNode(JJ)V", true, null);
    }

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        DisplayListCanvas.nDrawLayer(this.mNativeCanvasWrapper, layer.getLayerHandle(), x, y);
    }

    private static void nDrawLayer(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawLayer(JJFF)V", true, null);
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        DisplayListCanvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        DisplayListCanvas.nDrawPatch(this.mNativeCanvasWrapper, bitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        DisplayListCanvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        DisplayListCanvas.nDrawPatch(this.mNativeCanvasWrapper, bitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static void nDrawPatch(long l, Bitmap bitmap, long l2, float f, float f2, float f3, float f4, long l3) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawPatch(JLandroid/graphics/Bitmap;JFFFFJ)V", true, null);
    }

    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawCircle(long l, long l2, long l3, long l4, long l5) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawCircle(JJJJJ)V", true, null);
    }

    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    private static void nDrawRoundRect(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawRoundRect(JJJJJJJJ)V", true, null);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath) {
            if (path.rects != null) {
                DisplayListCanvas.nDrawRects(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
            }
        } else {
            super.drawPath(path, paint);
        }
    }

    private static void nDrawRects(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.DisplayListCanvas#nDrawRects(JJJ)V", true, null);
    }
}

