/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;

public class Fade
extends Visibility {
    private static boolean DBG = false;
    private static final String LOG_TAG = "Fade";
    public static final int IN = 1;
    public static final int OUT = 2;

    public Fade() {
    }

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    public Fade(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Fade);
        int fadingMode = a.getInt(0, this.getMode());
        this.setMode(fadingMode);
    }

    private Animator createAnimation(final View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        view.setTransitionAlpha(startAlpha);
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)view, "transitionAlpha", endAlpha);
        if (DBG) {
            Log.d(LOG_TAG, "Created animator " + anim2);
        }
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim2.addListener(listener);
        anim2.addPauseListener(listener);
        this.addListener(new Transition.TransitionListenerAdapter(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                view.setTransitionAlpha(1.0f);
            }
        });
        return anim2;
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (DBG) {
            View startView = startValues != null ? startValues.view : null;
            Log.d(LOG_TAG, "Fade.onAppear: startView, startVis, endView, endVis = " + startView + ", " + view);
        }
        return this.createAnimation(view, 0.0f, 1.0f);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimation(view, 1.0f, 0.0f);
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter {
        private final View mView;
        private float mPausedAlpha = -1.0f;
        private boolean mLayerTypeChanged = false;

        public FadeAnimatorListener(View view) {
            this.mView = view;
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            if (this.mView.hasOverlappingRendering() && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            this.mView.setTransitionAlpha(1.0f);
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
        }

        @Override
        public void onAnimationPause(Animator animator2) {
            this.mPausedAlpha = this.mView.getTransitionAlpha();
            this.mView.setTransitionAlpha(1.0f);
        }

        @Override
        public void onAnimationResume(Animator animator2) {
            this.mView.setTransitionAlpha(this.mPausedAlpha);
        }
    }
}

