/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.os.Parcel;
import android.os.PersistableBundle;
import android.text.ParcelableSpan;
import java.text.NumberFormat;
import java.util.Locale;

public class TtsSpan
implements ParcelableSpan {
    private final String mType;
    private final PersistableBundle mArgs;
    public static final String TYPE_TEXT = "android.type.text";
    public static final String TYPE_CARDINAL = "android.type.cardinal";
    public static final String TYPE_ORDINAL = "android.type.ordinal";
    public static final String TYPE_DECIMAL = "android.type.decimal";
    public static final String TYPE_FRACTION = "android.type.fraction";
    public static final String TYPE_MEASURE = "android.type.measure";
    public static final String TYPE_TIME = "android.type.time";
    public static final String TYPE_DATE = "android.type.date";
    public static final String TYPE_TELEPHONE = "android.type.telephone";
    public static final String TYPE_ELECTRONIC = "android.type.electronic";
    public static final String TYPE_MONEY = "android.type.money";
    public static final String TYPE_DIGITS = "android.type.digits";
    public static final String TYPE_VERBATIM = "android.type.verbatim";
    public static final String ARG_GENDER = "android.arg.gender";
    public static final String GENDER_NEUTRAL = "android.neutral";
    public static final String GENDER_MALE = "android.male";
    public static final String GENDER_FEMALE = "android.female";
    public static final String ARG_ANIMACY = "android.arg.animacy";
    public static final String ANIMACY_ANIMATE = "android.animate";
    public static final String ANIMACY_INANIMATE = "android.inanimate";
    public static final String ARG_MULTIPLICITY = "android.arg.multiplicity";
    public static final String MULTIPLICITY_SINGLE = "android.single";
    public static final String MULTIPLICITY_DUAL = "android.dual";
    public static final String MULTIPLICITY_PLURAL = "android.plural";
    public static final String ARG_CASE = "android.arg.case";
    public static final String CASE_NOMINATIVE = "android.nominative";
    public static final String CASE_ACCUSATIVE = "android.accusative";
    public static final String CASE_DATIVE = "android.dative";
    public static final String CASE_ABLATIVE = "android.ablative";
    public static final String CASE_GENITIVE = "android.genitive";
    public static final String CASE_VOCATIVE = "android.vocative";
    public static final String CASE_LOCATIVE = "android.locative";
    public static final String CASE_INSTRUMENTAL = "android.instrumental";
    public static final String ARG_TEXT = "android.arg.text";
    public static final String ARG_NUMBER = "android.arg.number";
    public static final String ARG_INTEGER_PART = "android.arg.integer_part";
    public static final String ARG_FRACTIONAL_PART = "android.arg.fractional_part";
    public static final String ARG_QUANTITY = "android.arg.quantity";
    public static final String ARG_NUMERATOR = "android.arg.numerator";
    public static final String ARG_DENOMINATOR = "android.arg.denominator";
    public static final String ARG_UNIT = "android.arg.unit";
    public static final String ARG_HOURS = "android.arg.hours";
    public static final String ARG_MINUTES = "android.arg.minutes";
    public static final String ARG_WEEKDAY = "android.arg.weekday";
    public static final int WEEKDAY_SUNDAY = 1;
    public static final int WEEKDAY_MONDAY = 2;
    public static final int WEEKDAY_TUESDAY = 3;
    public static final int WEEKDAY_WEDNESDAY = 4;
    public static final int WEEKDAY_THURSDAY = 5;
    public static final int WEEKDAY_FRIDAY = 6;
    public static final int WEEKDAY_SATURDAY = 7;
    public static final String ARG_DAY = "android.arg.day";
    public static final String ARG_MONTH = "android.arg.month";
    public static final int MONTH_JANUARY = 0;
    public static final int MONTH_FEBRUARY = 1;
    public static final int MONTH_MARCH = 2;
    public static final int MONTH_APRIL = 3;
    public static final int MONTH_MAY = 4;
    public static final int MONTH_JUNE = 5;
    public static final int MONTH_JULY = 6;
    public static final int MONTH_AUGUST = 7;
    public static final int MONTH_SEPTEMBER = 8;
    public static final int MONTH_OCTOBER = 9;
    public static final int MONTH_NOVEMBER = 10;
    public static final int MONTH_DECEMBER = 11;
    public static final String ARG_YEAR = "android.arg.year";
    public static final String ARG_COUNTRY_CODE = "android.arg.country_code";
    public static final String ARG_NUMBER_PARTS = "android.arg.number_parts";
    public static final String ARG_EXTENSION = "android.arg.extension";
    public static final String ARG_PROTOCOL = "android.arg.protocol";
    public static final String ARG_USERNAME = "android.arg.username";
    public static final String ARG_PASSWORD = "android.arg.password";
    public static final String ARG_DOMAIN = "android.arg.domain";
    public static final String ARG_PORT = "android.arg.port";
    public static final String ARG_PATH = "android.arg.path";
    public static final String ARG_QUERY_STRING = "android.arg.query_string";
    public static final String ARG_FRAGMENT_ID = "android.arg.fragment_id";
    public static final String ARG_CURRENCY = "android.arg.money";
    public static final String ARG_DIGITS = "android.arg.digits";
    public static final String ARG_VERBATIM = "android.arg.verbatim";

    public TtsSpan(String type, PersistableBundle args) {
        this.mType = type;
        this.mArgs = args;
    }

    public TtsSpan(Parcel src) {
        this.mType = src.readString();
        this.mArgs = src.readPersistableBundle();
    }

    public String getType() {
        return this.mType;
    }

    public PersistableBundle getArgs() {
        return this.mArgs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeString(this.mType);
        dest.writePersistableBundle(this.mArgs);
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 24;
    }

    public static class VerbatimBuilder
    extends SemioticClassBuilder<VerbatimBuilder> {
        public VerbatimBuilder() {
            super(TtsSpan.TYPE_VERBATIM);
        }

        public VerbatimBuilder(String verbatim) {
            this();
            this.setVerbatim(verbatim);
        }

        public VerbatimBuilder setVerbatim(String verbatim) {
            return (VerbatimBuilder)this.setStringArgument(TtsSpan.ARG_VERBATIM, verbatim);
        }
    }

    public static class DigitsBuilder
    extends SemioticClassBuilder<DigitsBuilder> {
        public DigitsBuilder() {
            super(TtsSpan.TYPE_DIGITS);
        }

        public DigitsBuilder(String digits) {
            this();
            this.setDigits(digits);
        }

        public DigitsBuilder setDigits(String digits) {
            return (DigitsBuilder)this.setStringArgument(TtsSpan.ARG_DIGITS, digits);
        }
    }

    public static class ElectronicBuilder
    extends SemioticClassBuilder<ElectronicBuilder> {
        public ElectronicBuilder() {
            super(TtsSpan.TYPE_ELECTRONIC);
        }

        public ElectronicBuilder setEmailArguments(String username, String domain) {
            return this.setDomain(domain).setUsername(username);
        }

        public ElectronicBuilder setProtocol(String protocol) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_PROTOCOL, protocol);
        }

        public ElectronicBuilder setUsername(String username) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_USERNAME, username);
        }

        public ElectronicBuilder setPassword(String password) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_PASSWORD, password);
        }

        public ElectronicBuilder setDomain(String domain) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_DOMAIN, domain);
        }

        public ElectronicBuilder setPort(int port) {
            return (ElectronicBuilder)this.setIntArgument(TtsSpan.ARG_PORT, port);
        }

        public ElectronicBuilder setPath(String path) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_PATH, path);
        }

        public ElectronicBuilder setQueryString(String queryString) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_QUERY_STRING, queryString);
        }

        public ElectronicBuilder setFragmentId(String fragmentId) {
            return (ElectronicBuilder)this.setStringArgument(TtsSpan.ARG_FRAGMENT_ID, fragmentId);
        }
    }

    public static class TelephoneBuilder
    extends SemioticClassBuilder<TelephoneBuilder> {
        public TelephoneBuilder() {
            super(TtsSpan.TYPE_TELEPHONE);
        }

        public TelephoneBuilder(String numberParts) {
            this();
            this.setNumberParts(numberParts);
        }

        public TelephoneBuilder setCountryCode(String countryCode) {
            return (TelephoneBuilder)this.setStringArgument(TtsSpan.ARG_COUNTRY_CODE, countryCode);
        }

        public TelephoneBuilder setNumberParts(String numberParts) {
            return (TelephoneBuilder)this.setStringArgument(TtsSpan.ARG_NUMBER_PARTS, numberParts);
        }

        public TelephoneBuilder setExtension(String extension) {
            return (TelephoneBuilder)this.setStringArgument(TtsSpan.ARG_EXTENSION, extension);
        }
    }

    public static class MoneyBuilder
    extends SemioticClassBuilder<MoneyBuilder> {
        public MoneyBuilder() {
            super(TtsSpan.TYPE_MONEY);
        }

        public MoneyBuilder setIntegerPart(long integerPart) {
            return this.setIntegerPart(String.valueOf(integerPart));
        }

        public MoneyBuilder setIntegerPart(String integerPart) {
            return (MoneyBuilder)this.setStringArgument(TtsSpan.ARG_INTEGER_PART, integerPart);
        }

        public MoneyBuilder setFractionalPart(String fractionalPart) {
            return (MoneyBuilder)this.setStringArgument(TtsSpan.ARG_FRACTIONAL_PART, fractionalPart);
        }

        public MoneyBuilder setCurrency(String currency) {
            return (MoneyBuilder)this.setStringArgument(TtsSpan.ARG_CURRENCY, currency);
        }

        public MoneyBuilder setQuantity(String quantity) {
            return (MoneyBuilder)this.setStringArgument(TtsSpan.ARG_QUANTITY, quantity);
        }
    }

    public static class DateBuilder
    extends SemioticClassBuilder<DateBuilder> {
        public DateBuilder() {
            super(TtsSpan.TYPE_DATE);
        }

        public DateBuilder(Integer weekday, Integer day, Integer month, Integer year) {
            this();
            if (weekday != null) {
                this.setWeekday(weekday);
            }
            if (day != null) {
                this.setDay(day);
            }
            if (month != null) {
                this.setMonth(month);
            }
            if (year != null) {
                this.setYear(year);
            }
        }

        public DateBuilder setWeekday(int weekday) {
            return (DateBuilder)this.setIntArgument(TtsSpan.ARG_WEEKDAY, weekday);
        }

        public DateBuilder setDay(int day) {
            return (DateBuilder)this.setIntArgument(TtsSpan.ARG_DAY, day);
        }

        public DateBuilder setMonth(int month) {
            return (DateBuilder)this.setIntArgument(TtsSpan.ARG_MONTH, month);
        }

        public DateBuilder setYear(int year) {
            return (DateBuilder)this.setIntArgument(TtsSpan.ARG_YEAR, year);
        }
    }

    public static class TimeBuilder
    extends SemioticClassBuilder<TimeBuilder> {
        public TimeBuilder() {
            super(TtsSpan.TYPE_TIME);
        }

        public TimeBuilder(int hours, int minutes) {
            this();
            this.setHours(hours);
            this.setMinutes(minutes);
        }

        public TimeBuilder setHours(int hours) {
            return (TimeBuilder)this.setIntArgument(TtsSpan.ARG_HOURS, hours);
        }

        public TimeBuilder setMinutes(int minutes) {
            return (TimeBuilder)this.setIntArgument(TtsSpan.ARG_MINUTES, minutes);
        }
    }

    public static class MeasureBuilder
    extends SemioticClassBuilder<MeasureBuilder> {
        public MeasureBuilder() {
            super(TtsSpan.TYPE_MEASURE);
        }

        public MeasureBuilder setNumber(long number) {
            return this.setNumber(String.valueOf(number));
        }

        public MeasureBuilder setNumber(String number) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_NUMBER, number);
        }

        public MeasureBuilder setIntegerPart(long integerPart) {
            return this.setNumber(String.valueOf(integerPart));
        }

        public MeasureBuilder setIntegerPart(String integerPart) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_INTEGER_PART, integerPart);
        }

        public MeasureBuilder setFractionalPart(String fractionalPart) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_FRACTIONAL_PART, fractionalPart);
        }

        public MeasureBuilder setNumerator(long numerator) {
            return this.setNumerator(String.valueOf(numerator));
        }

        public MeasureBuilder setNumerator(String numerator) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_NUMERATOR, numerator);
        }

        public MeasureBuilder setDenominator(long denominator) {
            return this.setDenominator(String.valueOf(denominator));
        }

        public MeasureBuilder setDenominator(String denominator) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_DENOMINATOR, denominator);
        }

        public MeasureBuilder setUnit(String unit) {
            return (MeasureBuilder)this.setStringArgument(TtsSpan.ARG_UNIT, unit);
        }
    }

    public static class FractionBuilder
    extends SemioticClassBuilder<FractionBuilder> {
        public FractionBuilder() {
            super(TtsSpan.TYPE_FRACTION);
        }

        public FractionBuilder(long integerPart, long numerator, long denominator) {
            this();
            this.setIntegerPart(integerPart);
            this.setNumerator(numerator);
            this.setDenominator(denominator);
        }

        public FractionBuilder setIntegerPart(long integerPart) {
            return this.setIntegerPart(String.valueOf(integerPart));
        }

        public FractionBuilder setIntegerPart(String integerPart) {
            return (FractionBuilder)this.setStringArgument(TtsSpan.ARG_INTEGER_PART, integerPart);
        }

        public FractionBuilder setNumerator(long numerator) {
            return this.setNumerator(String.valueOf(numerator));
        }

        public FractionBuilder setNumerator(String numerator) {
            return (FractionBuilder)this.setStringArgument(TtsSpan.ARG_NUMERATOR, numerator);
        }

        public FractionBuilder setDenominator(long denominator) {
            return this.setDenominator(String.valueOf(denominator));
        }

        public FractionBuilder setDenominator(String denominator) {
            return (FractionBuilder)this.setStringArgument(TtsSpan.ARG_DENOMINATOR, denominator);
        }
    }

    public static class DecimalBuilder
    extends SemioticClassBuilder<DecimalBuilder> {
        public DecimalBuilder() {
            super(TtsSpan.TYPE_DECIMAL);
        }

        public DecimalBuilder(double number, int minimumFractionDigits, int maximumFractionDigits) {
            this();
            this.setArgumentsFromDouble(number, minimumFractionDigits, maximumFractionDigits);
        }

        public DecimalBuilder(String integerPart, String fractionalPart) {
            this();
            this.setIntegerPart(integerPart);
            this.setFractionalPart(fractionalPart);
        }

        public DecimalBuilder setArgumentsFromDouble(double number, int minimumFractionDigits, int maximumFractionDigits) {
            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
            formatter.setMinimumFractionDigits(maximumFractionDigits);
            formatter.setMaximumFractionDigits(maximumFractionDigits);
            formatter.setGroupingUsed(false);
            String str = formatter.format(number);
            int i = str.indexOf(46);
            if (i >= 0) {
                this.setIntegerPart(str.substring(0, i));
                this.setFractionalPart(str.substring(i + 1));
            } else {
                this.setIntegerPart(str);
            }
            return this;
        }

        public DecimalBuilder setIntegerPart(long integerPart) {
            return this.setIntegerPart(String.valueOf(integerPart));
        }

        public DecimalBuilder setIntegerPart(String integerPart) {
            return (DecimalBuilder)this.setStringArgument(TtsSpan.ARG_INTEGER_PART, integerPart);
        }

        public DecimalBuilder setFractionalPart(String fractionalPart) {
            return (DecimalBuilder)this.setStringArgument(TtsSpan.ARG_FRACTIONAL_PART, fractionalPart);
        }
    }

    public static class OrdinalBuilder
    extends SemioticClassBuilder<OrdinalBuilder> {
        public OrdinalBuilder() {
            super(TtsSpan.TYPE_ORDINAL);
        }

        public OrdinalBuilder(long number) {
            this();
            this.setNumber(number);
        }

        public OrdinalBuilder(String number) {
            this();
            this.setNumber(number);
        }

        public OrdinalBuilder setNumber(long number) {
            return this.setNumber(String.valueOf(number));
        }

        public OrdinalBuilder setNumber(String number) {
            return (OrdinalBuilder)this.setStringArgument(TtsSpan.ARG_NUMBER, number);
        }
    }

    public static class CardinalBuilder
    extends SemioticClassBuilder<CardinalBuilder> {
        public CardinalBuilder() {
            super(TtsSpan.TYPE_CARDINAL);
        }

        public CardinalBuilder(long number) {
            this();
            this.setNumber(number);
        }

        public CardinalBuilder(String number) {
            this();
            this.setNumber(number);
        }

        public CardinalBuilder setNumber(long number) {
            return this.setNumber(String.valueOf(number));
        }

        public CardinalBuilder setNumber(String number) {
            return (CardinalBuilder)this.setStringArgument(TtsSpan.ARG_NUMBER, number);
        }
    }

    public static class TextBuilder
    extends SemioticClassBuilder<TextBuilder> {
        public TextBuilder() {
            super(TtsSpan.TYPE_TEXT);
        }

        public TextBuilder(String text) {
            this();
            this.setText(text);
        }

        public TextBuilder setText(String text) {
            return (TextBuilder)this.setStringArgument(TtsSpan.ARG_TEXT, text);
        }
    }

    public static class SemioticClassBuilder<C extends SemioticClassBuilder<?>>
    extends Builder<C> {
        public SemioticClassBuilder(String type) {
            super(type);
        }

        public C setGender(String gender) {
            return (C)((SemioticClassBuilder)this.setStringArgument(TtsSpan.ARG_GENDER, gender));
        }

        public C setAnimacy(String animacy) {
            return (C)((SemioticClassBuilder)this.setStringArgument(TtsSpan.ARG_ANIMACY, animacy));
        }

        public C setMultiplicity(String multiplicity) {
            return (C)((SemioticClassBuilder)this.setStringArgument(TtsSpan.ARG_MULTIPLICITY, multiplicity));
        }

        public C setCase(String grammaticalCase) {
            return (C)((SemioticClassBuilder)this.setStringArgument(TtsSpan.ARG_CASE, grammaticalCase));
        }
    }

    public static class Builder<C extends Builder<?>> {
        private final String mType;
        private PersistableBundle mArgs = new PersistableBundle();

        public Builder(String type) {
            this.mType = type;
        }

        public TtsSpan build() {
            return new TtsSpan(this.mType, this.mArgs);
        }

        public C setStringArgument(String arg, String value) {
            this.mArgs.putString(arg, value);
            return (C)this;
        }

        public C setIntArgument(String arg, int value) {
            this.mArgs.putInt(arg, value);
            return (C)this;
        }

        public C setLongArgument(String arg, long value) {
            this.mArgs.putLong(arg, value);
            return (C)this;
        }
    }
}

