/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.res.Resources;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.nio.CharBuffer;
import java.util.Formatter;
import java.util.Locale;
import libcore.icu.LocaleData;
import libcore.util.ZoneInfo;

class TimeFormatter {
    private static final int FORCE_LOWER_CASE = -1;
    private static final int SECSPERMIN = 60;
    private static final int MINSPERHOUR = 60;
    private static final int DAYSPERWEEK = 7;
    private static final int MONSPERYEAR = 12;
    private static final int HOURSPERDAY = 24;
    private static final int DAYSPERLYEAR = 366;
    private static final int DAYSPERNYEAR = 365;
    private static Locale sLocale;
    private static LocaleData sLocaleData;
    private static String sTimeOnlyFormat;
    private static String sDateOnlyFormat;
    private static String sDateTimeFormat;
    private final LocaleData localeData;
    private final String dateTimeFormat;
    private final String timeOnlyFormat;
    private final String dateOnlyFormat;
    private StringBuilder outputBuilder;
    private Formatter numberFormatter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeFormatter() {
        Class<TimeFormatter> clazz = TimeFormatter.class;
        synchronized (TimeFormatter.class) {
            Locale locale = AndroidLocale.getDefault();
            if (sLocale == null || !locale.equals(sLocale)) {
                sLocale = locale;
                sLocaleData = LocaleData.get(locale);
                Resources r = Resources.getSystem();
                sTimeOnlyFormat = r.getString(17039441);
                sDateOnlyFormat = r.getString(17039440);
                sDateTimeFormat = r.getString(17039442);
            }
            this.dateTimeFormat = sDateTimeFormat;
            this.timeOnlyFormat = sTimeOnlyFormat;
            this.dateOnlyFormat = sDateOnlyFormat;
            this.localeData = sLocaleData;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String pattern, ZoneInfo.WallTime wallTime, ZoneInfo zoneInfo) {
        try {
            StringBuilder stringBuilder;
            this.outputBuilder = stringBuilder = new StringBuilder();
            this.numberFormatter = new Formatter(stringBuilder, Locale.US);
            this.formatInternal(pattern, wallTime, zoneInfo);
            String result = stringBuilder.toString();
            if (this.localeData.zeroDigit != '0') {
                result = this.localizeDigits(result);
            }
            String string2 = result;
            return string2;
        }
        finally {
            this.outputBuilder = null;
            this.numberFormatter = null;
        }
    }

    private String localizeDigits(String s) {
        int length = s.length();
        int offsetToLocalizedDigits = this.localeData.zeroDigit - 48;
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                ch = (char)(ch + offsetToLocalizedDigits);
            }
            result.append(ch);
        }
        return result.toString();
    }

    private void formatInternal(String pattern, ZoneInfo.WallTime wallTime, ZoneInfo zoneInfo) {
        CharBuffer formatBuffer = CharBuffer.wrap(pattern);
        while (formatBuffer.remaining() > 0) {
            boolean outputCurrentChar = true;
            char currentChar = formatBuffer.get(formatBuffer.position());
            if (currentChar == '%') {
                outputCurrentChar = this.handleToken(formatBuffer, wallTime, zoneInfo);
            }
            if (outputCurrentChar) {
                this.outputBuilder.append(formatBuffer.get(formatBuffer.position()));
            }
            formatBuffer.position(formatBuffer.position() + 1);
        }
    }

    private boolean handleToken(CharBuffer formatBuffer, ZoneInfo.WallTime wallTime, ZoneInfo zoneInfo) {
        char modifier = '\u0000';
        block43: while (formatBuffer.remaining() > 1) {
            formatBuffer.position(formatBuffer.position() + 1);
            char currentChar = formatBuffer.get(formatBuffer.position());
            switch (currentChar) {
                case 'A': {
                    this.modifyAndAppend(wallTime.getWeekDay() < 0 || wallTime.getWeekDay() >= 7 ? "?" : this.localeData.longWeekdayNames[wallTime.getWeekDay() + 1], modifier);
                    return false;
                }
                case 'a': {
                    this.modifyAndAppend(wallTime.getWeekDay() < 0 || wallTime.getWeekDay() >= 7 ? "?" : this.localeData.shortWeekdayNames[wallTime.getWeekDay() + 1], modifier);
                    return false;
                }
                case 'B': {
                    if (modifier == '-') {
                        this.modifyAndAppend(wallTime.getMonth() < 0 || wallTime.getMonth() >= 12 ? "?" : this.localeData.longStandAloneMonthNames[wallTime.getMonth()], modifier);
                    } else {
                        this.modifyAndAppend(wallTime.getMonth() < 0 || wallTime.getMonth() >= 12 ? "?" : this.localeData.longMonthNames[wallTime.getMonth()], modifier);
                    }
                    return false;
                }
                case 'b': 
                case 'h': {
                    this.modifyAndAppend(wallTime.getMonth() < 0 || wallTime.getMonth() >= 12 ? "?" : this.localeData.shortMonthNames[wallTime.getMonth()], modifier);
                    return false;
                }
                case 'C': {
                    this.outputYear(wallTime.getYear(), true, false, modifier);
                    return false;
                }
                case 'c': {
                    this.formatInternal(this.dateTimeFormat, wallTime, zoneInfo);
                    return false;
                }
                case 'D': {
                    this.formatInternal("%m/%d/%y", wallTime, zoneInfo);
                    return false;
                }
                case 'd': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), wallTime.getMonthDay());
                    return false;
                }
                case 'E': 
                case 'O': {
                    continue block43;
                }
                case '#': 
                case '-': 
                case '0': 
                case '^': 
                case '_': {
                    modifier = currentChar;
                    continue block43;
                }
                case 'e': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%2d", "%2d", "%d", "%02d"), wallTime.getMonthDay());
                    return false;
                }
                case 'F': {
                    this.formatInternal("%Y-%m-%d", wallTime, zoneInfo);
                    return false;
                }
                case 'H': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), wallTime.getHour());
                    return false;
                }
                case 'I': {
                    int hour = wallTime.getHour() % 12 != 0 ? wallTime.getHour() % 12 : 12;
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), hour);
                    return false;
                }
                case 'j': {
                    int yearDay = wallTime.getYearDay() + 1;
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%03d", "%3d", "%d", "%03d"), yearDay);
                    return false;
                }
                case 'k': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%2d", "%2d", "%d", "%02d"), wallTime.getHour());
                    return false;
                }
                case 'l': {
                    int n2 = wallTime.getHour() % 12 != 0 ? wallTime.getHour() % 12 : 12;
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%2d", "%2d", "%d", "%02d"), n2);
                    return false;
                }
                case 'M': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), wallTime.getMinute());
                    return false;
                }
                case 'm': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), wallTime.getMonth() + 1);
                    return false;
                }
                case 'n': {
                    this.outputBuilder.append('\n');
                    return false;
                }
                case 'p': {
                    this.modifyAndAppend(wallTime.getHour() >= 12 ? this.localeData.amPm[1] : this.localeData.amPm[0], modifier);
                    return false;
                }
                case 'P': {
                    this.modifyAndAppend(wallTime.getHour() >= 12 ? this.localeData.amPm[1] : this.localeData.amPm[0], -1);
                    return false;
                }
                case 'R': {
                    this.formatInternal("%H:%M", wallTime, zoneInfo);
                    return false;
                }
                case 'r': {
                    this.formatInternal("%I:%M:%S %p", wallTime, zoneInfo);
                    return false;
                }
                case 'S': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), wallTime.getSecond());
                    return false;
                }
                case 's': {
                    int timeInSeconds = wallTime.mktime(zoneInfo);
                    this.outputBuilder.append(Integer.toString(timeInSeconds));
                    return false;
                }
                case 'T': {
                    this.formatInternal("%H:%M:%S", wallTime, zoneInfo);
                    return false;
                }
                case 't': {
                    this.outputBuilder.append('\t');
                    return false;
                }
                case 'U': {
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), (wallTime.getYearDay() + 7 - wallTime.getWeekDay()) / 7);
                    return false;
                }
                case 'u': {
                    int day = wallTime.getWeekDay() == 0 ? 7 : wallTime.getWeekDay();
                    this.numberFormatter.format("%d", day);
                    return false;
                }
                case 'G': 
                case 'V': 
                case 'g': {
                    int w;
                    int year = wallTime.getYear();
                    int yday = wallTime.getYearDay();
                    int wday = wallTime.getWeekDay();
                    while (true) {
                        int len;
                        int bot;
                        int top;
                        if ((top = (bot = (yday + 11 - wday) % 7 - 3) - (len = TimeFormatter.isLeap(year) ? 366 : 365) % 7) < -3) {
                            top += 7;
                        }
                        if (yday >= (top += len)) {
                            ++year;
                            w = 1;
                            break;
                        }
                        if (yday >= bot) {
                            w = 1 + (yday - bot) / 7;
                            break;
                        }
                        yday += TimeFormatter.isLeap(--year) ? 366 : 365;
                    }
                    if (currentChar == 'V') {
                        this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), w);
                    } else if (currentChar == 'g') {
                        this.outputYear(year, false, true, modifier);
                    } else {
                        this.outputYear(year, true, true, modifier);
                    }
                    return false;
                }
                case 'v': {
                    this.formatInternal("%e-%b-%Y", wallTime, zoneInfo);
                    return false;
                }
                case 'W': {
                    int n = (wallTime.getYearDay() + 7 - (wallTime.getWeekDay() != 0 ? wallTime.getWeekDay() - 1 : 6)) / 7;
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), n);
                    return false;
                }
                case 'w': {
                    this.numberFormatter.format("%d", wallTime.getWeekDay());
                    return false;
                }
                case 'X': {
                    this.formatInternal(this.timeOnlyFormat, wallTime, zoneInfo);
                    return false;
                }
                case 'x': {
                    this.formatInternal(this.dateOnlyFormat, wallTime, zoneInfo);
                    return false;
                }
                case 'y': {
                    this.outputYear(wallTime.getYear(), false, true, modifier);
                    return false;
                }
                case 'Y': {
                    this.outputYear(wallTime.getYear(), true, true, modifier);
                    return false;
                }
                case 'Z': {
                    if (wallTime.getIsDst() < 0) {
                        return false;
                    }
                    boolean isDst = wallTime.getIsDst() != 0;
                    this.modifyAndAppend(zoneInfo.getDisplayName(isDst, 0), modifier);
                    return false;
                }
                case 'z': {
                    char sign;
                    if (wallTime.getIsDst() < 0) {
                        return false;
                    }
                    int diff = wallTime.getGmtOffset();
                    if (diff < 0) {
                        sign = '-';
                        diff = -diff;
                    } else {
                        sign = '+';
                    }
                    this.outputBuilder.append(sign);
                    diff /= 60;
                    diff = diff / 60 * 100 + diff % 60;
                    this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%04d", "%4d", "%d", "%04d"), diff);
                    return false;
                }
                case '+': {
                    this.formatInternal("%a %b %e %H:%M:%S %Z %Y", wallTime, zoneInfo);
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private void modifyAndAppend(CharSequence str, int modifier) {
        switch (modifier) {
            case -1: {
                for (int i = 0; i < str.length(); ++i) {
                    this.outputBuilder.append(TimeFormatter.brokenToLower(str.charAt(i)));
                }
                break;
            }
            case 94: {
                for (int i = 0; i < str.length(); ++i) {
                    this.outputBuilder.append(TimeFormatter.brokenToUpper(str.charAt(i)));
                }
                break;
            }
            case 35: {
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (TimeFormatter.brokenIsUpper(c)) {
                        c = TimeFormatter.brokenToLower(c);
                    } else if (TimeFormatter.brokenIsLower(c)) {
                        c = TimeFormatter.brokenToUpper(c);
                    }
                    this.outputBuilder.append(c);
                }
                break;
            }
            default: {
                this.outputBuilder.append(str);
            }
        }
    }

    private void outputYear(int value, boolean outputTop, boolean outputBottom, int modifier) {
        int DIVISOR = 100;
        int trail = value % 100;
        int lead = value / 100 + trail / 100;
        if ((trail %= 100) < 0 && lead > 0) {
            trail += 100;
            --lead;
        } else if (lead < 0 && trail > 0) {
            trail -= 100;
            ++lead;
        }
        if (outputTop) {
            if (lead == 0 && trail < 0) {
                this.outputBuilder.append("-0");
            } else {
                this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), lead);
            }
        }
        if (outputBottom) {
            int n = trail < 0 ? -trail : trail;
            this.numberFormatter.format(TimeFormatter.getFormat(modifier, "%02d", "%2d", "%d", "%02d"), n);
        }
    }

    private static String getFormat(int modifier, String normal, String underscore, String dash, String zero) {
        switch (modifier) {
            case 95: {
                return underscore;
            }
            case 45: {
                return dash;
            }
            case 48: {
                return zero;
            }
        }
        return normal;
    }

    private static boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static boolean brokenIsUpper(char toCheck) {
        return toCheck >= 'A' && toCheck <= 'Z';
    }

    private static boolean brokenIsLower(char toCheck) {
        return toCheck >= 'a' && toCheck <= 'z';
    }

    private static char brokenToLower(char input) {
        if (input >= 'A' && input <= 'Z') {
            return (char)(input - 65 + 97);
        }
        return input;
    }

    private static char brokenToUpper(char input) {
        if (input >= 'a' && input <= 'z') {
            return (char)(input - 97 + 65);
        }
        return input;
    }
}

