/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Hyphenator_Delegate;
import android.text.StaticLayout;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import libcore.io.IoUtils;

public class Hyphenator {
    private static String TAG = "Hyphenator";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final HashMap<Locale, Hyphenator> sMap = new HashMap();
    static final Hyphenator sEmptyHyphenator = new Hyphenator(StaticLayout.nLoadHyphenator(""));
    private final long mNativePtr;
    private static final String[][] LOCALE_FALLBACK_DATA = new String[][]{{"en-AS", "en-US"}, {"en-GU", "en-US"}, {"en-MH", "en-US"}, {"en-MP", "en-US"}, {"en-PR", "en-US"}, {"en-UM", "en-US"}, {"en-VI", "en-US"}, {"no", "nb"}, {"am", "und-Ethi"}, {"byn", "und-Ethi"}, {"gez", "und-Ethi"}, {"ti", "und-Ethi"}, {"wal", "und-Ethi"}};

    private Hyphenator(long nativePtr) {
        this.mNativePtr = nativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long get(Locale locale) {
        Object object = sLock;
        synchronized (object) {
            Locale scriptOnlyLocale;
            Hyphenator result = sMap.get(locale);
            if (result != null) {
                return result.mNativePtr;
            }
            Locale languageOnlyLocale = new Locale(locale.getLanguage());
            result = sMap.get(languageOnlyLocale);
            if (result != null) {
                sMap.put(locale, result);
                return result.mNativePtr;
            }
            String script = AndroidLocale.getScript(locale);
            if (!script.equals("") && (result = sMap.get(scriptOnlyLocale = new Locale.Builder().setLanguage("und").setScript(script).build())) != null) {
                sMap.put(locale, result);
                return result.mNativePtr;
            }
            sMap.put(locale, sEmptyHyphenator);
        }
        return Hyphenator.sEmptyHyphenator.mNativePtr;
    }

    private static Hyphenator loadHyphenator(String languageTag) {
        String patternFilename = "hyph-" + languageTag.toLowerCase(Locale.US) + ".pat.txt";
        File patternFile = new File(Hyphenator.getSystemHyphenatorLocation(), patternFilename);
        try {
            String patternData = IoUtils.readFileAsString(patternFile.getAbsolutePath());
            long nativePtr = StaticLayout.nLoadHyphenator(patternData);
            return new Hyphenator(nativePtr);
        }
        catch (IOException e) {
            Log.e(TAG, "error loading hyphenation " + patternFile, e);
            return null;
        }
    }

    static File getSystemHyphenatorLocation_Original() {
        return new File("/system/usr/hyphen-data");
    }

    @LayoutlibDelegate
    private static File getSystemHyphenatorLocation() {
        return Hyphenator_Delegate.getSystemHyphenatorLocation();
    }

    public static void init() {
        int i;
        sMap.put(null, null);
        String[] availableLanguages = new String[]{"en-US", "eu", "hu", "hy", "nb", "nn", "sa", "und-Ethi"};
        for (i = 0; i < availableLanguages.length; ++i) {
            String languageTag = availableLanguages[i];
            Hyphenator h = Hyphenator.loadHyphenator(languageTag);
            if (h == null) continue;
            sMap.put(AndroidLocale.forLanguageTag(languageTag), h);
        }
        for (i = 0; i < LOCALE_FALLBACK_DATA.length; ++i) {
            String language = LOCALE_FALLBACK_DATA[i][0];
            String fallback = LOCALE_FALLBACK_DATA[i][1];
            sMap.put(AndroidLocale.forLanguageTag(language), sMap.get(AndroidLocale.forLanguageTag(fallback)));
        }
    }
}

