/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.cdma;

import android.os.Bundle;
import android.telephony.CellLocation;

public class CdmaCellLocation
extends CellLocation {
    private int mBaseStationId = -1;
    public static final int INVALID_LAT_LONG = Integer.MAX_VALUE;
    private int mBaseStationLatitude = Integer.MAX_VALUE;
    private int mBaseStationLongitude = Integer.MAX_VALUE;
    private int mSystemId = -1;
    private int mNetworkId = -1;

    public CdmaCellLocation() {
        this.mBaseStationId = -1;
        this.mBaseStationLatitude = Integer.MAX_VALUE;
        this.mBaseStationLongitude = Integer.MAX_VALUE;
        this.mSystemId = -1;
        this.mNetworkId = -1;
    }

    public CdmaCellLocation(Bundle bundle) {
        this.mBaseStationId = bundle.getInt("baseStationId", this.mBaseStationId);
        this.mBaseStationLatitude = bundle.getInt("baseStationLatitude", this.mBaseStationLatitude);
        this.mBaseStationLongitude = bundle.getInt("baseStationLongitude", this.mBaseStationLongitude);
        this.mSystemId = bundle.getInt("systemId", this.mSystemId);
        this.mNetworkId = bundle.getInt("networkId", this.mNetworkId);
    }

    public int getBaseStationId() {
        return this.mBaseStationId;
    }

    public int getBaseStationLatitude() {
        return this.mBaseStationLatitude;
    }

    public int getBaseStationLongitude() {
        return this.mBaseStationLongitude;
    }

    public int getSystemId() {
        return this.mSystemId;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public void setStateInvalid() {
        this.mBaseStationId = -1;
        this.mBaseStationLatitude = Integer.MAX_VALUE;
        this.mBaseStationLongitude = Integer.MAX_VALUE;
        this.mSystemId = -1;
        this.mNetworkId = -1;
    }

    public void setCellLocationData(int baseStationId, int baseStationLatitude, int baseStationLongitude) {
        this.mBaseStationId = baseStationId;
        this.mBaseStationLatitude = baseStationLatitude;
        this.mBaseStationLongitude = baseStationLongitude;
    }

    public void setCellLocationData(int baseStationId, int baseStationLatitude, int baseStationLongitude, int systemId, int networkId) {
        this.mBaseStationId = baseStationId;
        this.mBaseStationLatitude = baseStationLatitude;
        this.mBaseStationLongitude = baseStationLongitude;
        this.mSystemId = systemId;
        this.mNetworkId = networkId;
    }

    public int hashCode() {
        return this.mBaseStationId ^ this.mBaseStationLatitude ^ this.mBaseStationLongitude ^ this.mSystemId ^ this.mNetworkId;
    }

    public boolean equals(Object o) {
        CdmaCellLocation s;
        try {
            s = (CdmaCellLocation)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return CdmaCellLocation.equalsHandlesNulls(this.mBaseStationId, s.mBaseStationId) && CdmaCellLocation.equalsHandlesNulls(this.mBaseStationLatitude, s.mBaseStationLatitude) && CdmaCellLocation.equalsHandlesNulls(this.mBaseStationLongitude, s.mBaseStationLongitude) && CdmaCellLocation.equalsHandlesNulls(this.mSystemId, s.mSystemId) && CdmaCellLocation.equalsHandlesNulls(this.mNetworkId, s.mNetworkId);
    }

    public String toString() {
        return "[" + this.mBaseStationId + "," + this.mBaseStationLatitude + "," + this.mBaseStationLongitude + "," + this.mSystemId + "," + this.mNetworkId + "]";
    }

    private static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public void fillInNotifierBundle(Bundle bundleToFill) {
        bundleToFill.putInt("baseStationId", this.mBaseStationId);
        bundleToFill.putInt("baseStationLatitude", this.mBaseStationLatitude);
        bundleToFill.putInt("baseStationLongitude", this.mBaseStationLongitude);
        bundleToFill.putInt("systemId", this.mSystemId);
        bundleToFill.putInt("networkId", this.mNetworkId);
    }

    @Override
    public boolean isEmpty() {
        return this.mBaseStationId == -1 && this.mBaseStationLatitude == Integer.MAX_VALUE && this.mBaseStationLongitude == Integer.MAX_VALUE && this.mSystemId == -1 && this.mNetworkId == -1;
    }

    public static double convertQuartSecToDecDegrees(int quartSec) {
        if (Double.isNaN(quartSec) || quartSec < -2592000 || quartSec > 2592000) {
            throw new IllegalArgumentException("Invalid coordiante value:" + quartSec);
        }
        return (double)quartSec / 14400.0;
    }
}

