/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.RILConstants;

public class RadioAccessFamily
implements Parcelable {
    public static final int RAF_UNKNOWN = 1;
    public static final int RAF_GPRS = 2;
    public static final int RAF_EDGE = 4;
    public static final int RAF_UMTS = 8;
    public static final int RAF_IS95A = 16;
    public static final int RAF_IS95B = 32;
    public static final int RAF_1xRTT = 64;
    public static final int RAF_EVDO_0 = 128;
    public static final int RAF_EVDO_A = 256;
    public static final int RAF_HSDPA = 512;
    public static final int RAF_HSUPA = 1024;
    public static final int RAF_HSPA = 2048;
    public static final int RAF_EVDO_B = 4096;
    public static final int RAF_EHRPD = 8192;
    public static final int RAF_LTE = 16384;
    public static final int RAF_HSPAP = 32768;
    public static final int RAF_GSM = 65536;
    public static final int RAF_TD_SCDMA = 131072;
    private static final int GSM = 65542;
    private static final int HS = 36352;
    private static final int CDMA = 112;
    private static final int EVDO = 12672;
    private static final int WCDMA = 36360;
    private int mPhoneId;
    private int mRadioAccessFamily;
    public static final Parcelable.Creator<RadioAccessFamily> CREATOR = new Parcelable.Creator<RadioAccessFamily>(){

        @Override
        public RadioAccessFamily createFromParcel(Parcel in) {
            int phoneId = in.readInt();
            int radioAccessFamily = in.readInt();
            return new RadioAccessFamily(phoneId, radioAccessFamily);
        }

        public RadioAccessFamily[] newArray(int size) {
            return new RadioAccessFamily[size];
        }
    };

    public RadioAccessFamily(int phoneId, int radioAccessFamily) {
        this.mPhoneId = phoneId;
        this.mRadioAccessFamily = radioAccessFamily;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public int getRadioAccessFamily() {
        return this.mRadioAccessFamily;
    }

    public String toString() {
        String ret = "{ mPhoneId = " + this.mPhoneId + ", mRadioAccessFamily = " + this.mRadioAccessFamily + "}";
        return ret;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel outParcel, int flags) {
        outParcel.writeInt(this.mPhoneId);
        outParcel.writeInt(this.mRadioAccessFamily);
    }

    public static int getRafFromNetworkType(int type) {
        int raf;
        switch (type) {
            case 0: {
                raf = 101902;
                break;
            }
            case 1: {
                raf = 65542;
                break;
            }
            case 2: {
                raf = 36360;
                break;
            }
            case 3: {
                raf = 101902;
                break;
            }
            case 4: {
                raf = 12784;
                break;
            }
            case 8: {
                raf = 29168;
                break;
            }
            case 9: {
                raf = 118286;
                break;
            }
            case 10: {
                raf = 131070;
                break;
            }
            case 11: {
                raf = 16384;
                break;
            }
            case 12: {
                raf = 52744;
                break;
            }
            case 5: {
                raf = 112;
                break;
            }
            case 6: {
                raf = 12672;
                break;
            }
            case 7: {
                raf = 114686;
                break;
            }
            default: {
                raf = 1;
            }
        }
        return raf;
    }

    private static int getAdjustedRaf(int raf) {
        raf = (0x10006 & raf) > 0 ? 0x10006 | raf : raf;
        raf = (0x8E08 & raf) > 0 ? 0x8E08 | raf : raf;
        raf = (0x70 & raf) > 0 ? 0x70 | raf : raf;
        raf = (0x3180 & raf) > 0 ? 0x3180 | raf : raf;
        return raf;
    }

    public static int getNetworkTypeFromRaf(int raf) {
        int type;
        raf = RadioAccessFamily.getAdjustedRaf(raf);
        switch (raf) {
            case 101902: {
                type = 0;
                break;
            }
            case 65542: {
                type = 1;
                break;
            }
            case 36360: {
                type = 2;
                break;
            }
            case 12784: {
                type = 4;
                break;
            }
            case 29168: {
                type = 8;
                break;
            }
            case 118286: {
                type = 9;
                break;
            }
            case 131070: {
                type = 10;
                break;
            }
            case 16384: {
                type = 11;
                break;
            }
            case 52744: {
                type = 12;
                break;
            }
            case 112: {
                type = 5;
                break;
            }
            case 12672: {
                type = 6;
                break;
            }
            case 114686: {
                type = 7;
                break;
            }
            default: {
                type = RILConstants.PREFERRED_NETWORK_MODE;
            }
        }
        return type;
    }

    public static int singleRafTypeFromString(String rafString) {
        String string2 = rafString;
        int n = -1;
        switch (string2.hashCode()) {
            case 2194666: {
                if (!string2.equals("GPRS")) break;
                n = 0;
                break;
            }
            case 2123197: {
                if (!string2.equals("EDGE")) break;
                n = 1;
                break;
            }
            case 2608919: {
                if (!string2.equals("UMTS")) break;
                n = 2;
                break;
            }
            case 69946171: {
                if (!string2.equals("IS95A")) break;
                n = 3;
                break;
            }
            case 69946172: {
                if (!string2.equals("IS95B")) break;
                n = 4;
                break;
            }
            case 47955627: {
                if (!string2.equals("1XRTT")) break;
                n = 5;
                break;
            }
            case 2056938925: {
                if (!string2.equals("EVDO_0")) break;
                n = 6;
                break;
            }
            case 2056938942: {
                if (!string2.equals("EVDO_A")) break;
                n = 7;
                break;
            }
            case 69034058: {
                if (!string2.equals("HSDPA")) break;
                n = 8;
                break;
            }
            case 69050395: {
                if (!string2.equals("HSUPA")) break;
                n = 9;
                break;
            }
            case 2227260: {
                if (!string2.equals("HSPA")) break;
                n = 10;
                break;
            }
            case 2056938943: {
                if (!string2.equals("EVDO_B")) break;
                n = 11;
                break;
            }
            case 0x3EE4E43: {
                if (!string2.equals("EHRPD")) break;
                n = 12;
                break;
            }
            case 75709: {
                if (!string2.equals("LTE")) break;
                n = 13;
                break;
            }
            case 69045140: {
                if (!string2.equals("HSPAP")) break;
                n = 14;
                break;
            }
            case 70881: {
                if (!string2.equals("GSM")) break;
                n = 15;
                break;
            }
            case -908593671: {
                if (!string2.equals("TD_SCDMA")) break;
                n = 16;
                break;
            }
            case 2315: {
                if (!string2.equals("HS")) break;
                n = 17;
                break;
            }
            case 2063797: {
                if (!string2.equals("CDMA")) break;
                n = 18;
                break;
            }
            case 2140412: {
                if (!string2.equals("EVDO")) break;
                n = 19;
                break;
            }
            case 82410124: {
                if (!string2.equals("WCDMA")) break;
                n = 20;
            }
        }
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 256;
            }
            case 8: {
                return 512;
            }
            case 9: {
                return 1024;
            }
            case 10: {
                return 2048;
            }
            case 11: {
                return 4096;
            }
            case 12: {
                return 8192;
            }
            case 13: {
                return 16384;
            }
            case 14: {
                return 32768;
            }
            case 15: {
                return 65536;
            }
            case 16: {
                return 131072;
            }
            case 17: {
                return 36352;
            }
            case 18: {
                return 112;
            }
            case 19: {
                return 12672;
            }
            case 20: {
                return 36360;
            }
        }
        return 1;
    }

    public static int rafTypeFromString(String rafList) {
        rafList = rafList.toUpperCase();
        String[] rafs = rafList.split("\\|");
        int result = 0;
        for (String raf : rafs) {
            int rafType = RadioAccessFamily.singleRafTypeFromString(raf.trim());
            if (rafType == 1) {
                return rafType;
            }
            result |= rafType;
        }
        return result;
    }
}

