/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.AndroidKeyStorePublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public class AndroidKeyStoreECPublicKey
extends AndroidKeyStorePublicKey
implements ECPublicKey {
    private final ECParameterSpec mParams;
    private final ECPoint mW;

    public AndroidKeyStoreECPublicKey(String alias, byte[] x509EncodedForm, ECParameterSpec params, ECPoint w) {
        super(alias, "EC", x509EncodedForm);
        this.mParams = params;
        this.mW = w;
    }

    public AndroidKeyStoreECPublicKey(String alias, ECPublicKey info) {
        this(alias, info.getEncoded(), info.getParams(), info.getW());
        if (!"X.509".equalsIgnoreCase(info.getFormat())) {
            throw new IllegalArgumentException("Unsupported key export format: " + info.getFormat());
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.mParams;
    }

    @Override
    public ECPoint getW() {
        return this.mW;
    }
}

