/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.util.Slog;
import android.view.IWindowManager;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.HexDump;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class StrictMode {
    private static final String TAG = "StrictMode";
    private static final boolean LOG_V = Log.isLoggable("StrictMode", 2);
    private static final boolean IS_USER_BUILD = "user".equals(Build.TYPE);
    private static final boolean IS_ENG_BUILD = "eng".equals(Build.TYPE);
    public static final String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    public static final String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static final String CLEARTEXT_PROPERTY = "persist.sys.strictmode.clear";
    private static final long MIN_LOG_INTERVAL_MS = 1000L;
    private static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static final int MAX_SPAN_TAGS = 20;
    private static final int MAX_OFFENSES_PER_LOOP = 10;
    public static final int DETECT_DISK_WRITE = 1;
    public static final int DETECT_DISK_READ = 2;
    public static final int DETECT_NETWORK = 4;
    public static final int DETECT_CUSTOM = 8;
    public static final int DETECT_RESOURCE_MISMATCH = 16;
    private static final int ALL_THREAD_DETECT_BITS = 31;
    public static final int DETECT_VM_CURSOR_LEAKS = 256;
    public static final int DETECT_VM_CLOSABLE_LEAKS = 512;
    public static final int DETECT_VM_ACTIVITY_LEAKS = 1024;
    private static final int DETECT_VM_INSTANCE_LEAKS = 2048;
    public static final int DETECT_VM_REGISTRATION_LEAKS = 4096;
    private static final int DETECT_VM_FILE_URI_EXPOSURE = 8192;
    private static final int DETECT_VM_CLEARTEXT_NETWORK = 16384;
    private static final int ALL_VM_DETECT_BITS = 32512;
    public static final int PENALTY_LOG = 65536;
    public static final int PENALTY_DIALOG = 131072;
    public static final int PENALTY_DEATH = 262144;
    public static final int PENALTY_DEATH_ON_NETWORK = 524288;
    public static final int PENALTY_FLASH = 0x100000;
    public static final int PENALTY_DROPBOX = 0x200000;
    public static final int PENALTY_GATHER = 0x400000;
    public static final int PENALTY_DEATH_ON_CLEARTEXT_NETWORK = 0x800000;
    private static final int THREAD_PENALTY_MASK = 0x7F0000;
    private static final int VM_PENALTY_MASK = 0xA50000;
    public static final int NETWORK_POLICY_ACCEPT = 0;
    public static final int NETWORK_POLICY_LOG = 1;
    public static final int NETWORK_POLICY_REJECT = 2;
    private static final HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP = new HashMap();
    private static volatile int sVmPolicyMask = 0;
    private static volatile VmPolicy sVmPolicy = VmPolicy.LAX;
    private static final AtomicInteger sDropboxCallsInFlight = new AtomicInteger(0);
    private static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

        @Override
        protected ArrayList<ViolationInfo> initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

        @Override
        protected ArrayList<ViolationInfo> initialValue() {
            return new ArrayList<ViolationInfo>();
        }
    };
    private static final ThreadLocal<Handler> threadHandler = new ThreadLocal<Handler>(){

        @Override
        protected Handler initialValue() {
            return new Handler();
        }
    };
    private static final ThreadLocal<AndroidBlockGuardPolicy> threadAndroidPolicy = new ThreadLocal<AndroidBlockGuardPolicy>(){

        @Override
        protected AndroidBlockGuardPolicy initialValue() {
            return new AndroidBlockGuardPolicy(0);
        }
    };
    private static long sLastInstanceCountCheckMillis = 0L;
    private static boolean sIsIdlerRegistered = false;
    private static final MessageQueue.IdleHandler sProcessIdleHandler = new MessageQueue.IdleHandler(){

        @Override
        public boolean queueIdle() {
            long now = SystemClock.uptimeMillis();
            if (now - sLastInstanceCountCheckMillis > 30000L) {
                sLastInstanceCountCheckMillis = now;
                StrictMode.conditionallyCheckInstanceCounts();
            }
            return true;
        }
    };
    private static final HashMap<Integer, Long> sLastVmViolationTime = new HashMap();
    private static final Span NO_OP_SPAN = new Span(){

        @Override
        public void finish() {
        }
    };
    private static final ThreadLocal<ThreadSpanState> sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){

        @Override
        protected ThreadSpanState initialValue() {
            return new ThreadSpanState();
        }
    };
    private static Singleton<IWindowManager> sWindowManager = new Singleton<IWindowManager>(){

        @Override
        protected IWindowManager create() {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        }
    };
    private static final HashMap<Class, Integer> sExpectedActivityInstanceCount = new HashMap();

    private StrictMode() {
    }

    public static void setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
    }

    private static void setThreadPolicyMask(int policyMask) {
        StrictMode.setBlockGuardPolicy(policyMask);
        Binder.setThreadStrictModePolicy(policyMask);
    }

    private static void setBlockGuardPolicy(int policyMask) {
        AndroidBlockGuardPolicy androidPolicy;
        if (policyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidPolicy = threadAndroidPolicy.get();
            BlockGuard.setThreadPolicy(androidPolicy);
        }
        androidPolicy.setPolicyMask(policyMask);
    }

    private static void setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter());
        }
        CloseGuard.setEnabled(enabled);
    }

    public static int getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    public static ThreadPolicy getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask());
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask);
    }

    public static ThreadPolicy allowThreadDiskReads() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask);
    }

    private static boolean amTheSystemServerProcess() {
        if (Process.myUid() != 1000) {
            return false;
        }
        Throwable stack = new Throwable();
        stack.fillInStackTrace();
        for (StackTraceElement ste : stack.getStackTrace()) {
            String clsName = ste.getClassName();
            if (clsName == null || !clsName.startsWith("com.android.server.")) continue;
            return true;
        }
        return false;
    }

    public static boolean conditionallyEnableDebugLogging() {
        boolean doFlashes = SystemProperties.getBoolean(VISUAL_PROPERTY, false) && !StrictMode.amTheSystemServerProcess();
        boolean suppress = SystemProperties.getBoolean(DISABLE_PROPERTY, false);
        if (!doFlashes && (IS_USER_BUILD || suppress)) {
            StrictMode.setCloseGuardEnabled(false);
            return false;
        }
        if (IS_ENG_BUILD) {
            doFlashes = true;
        }
        int threadPolicyMask = 7;
        if (!IS_USER_BUILD) {
            threadPolicyMask |= 0x200000;
        }
        if (doFlashes) {
            threadPolicyMask |= 0x100000;
        }
        StrictMode.setThreadPolicyMask(threadPolicyMask);
        if (IS_USER_BUILD) {
            StrictMode.setCloseGuardEnabled(false);
        } else {
            VmPolicy.Builder policyBuilder = new VmPolicy.Builder().detectAll().penaltyDropBox();
            if (IS_ENG_BUILD) {
                policyBuilder.penaltyLog();
            }
            StrictMode.setVmPolicy(policyBuilder.build());
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
        }
        return true;
    }

    public static void enableDeathOnNetwork() {
        int oldPolicy = StrictMode.getThreadPolicyMask();
        int newPolicy = oldPolicy | 4 | 0x80000;
        StrictMode.setThreadPolicyMask(newPolicy);
    }

    private static int parsePolicyFromMessage(String message) {
        if (message == null || !message.startsWith("policy=")) {
            return 0;
        }
        int spaceIndex = message.indexOf(32);
        if (spaceIndex == -1) {
            return 0;
        }
        String policyString = message.substring(7, spaceIndex);
        try {
            return Integer.valueOf(policyString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int parseViolationFromMessage(String message) {
        if (message == null) {
            return 0;
        }
        int violationIndex = message.indexOf("violation=");
        if (violationIndex == -1) {
            return 0;
        }
        int numberStartIndex = violationIndex + "violation=".length();
        int numberEndIndex = message.indexOf(32, numberStartIndex);
        if (numberEndIndex == -1) {
            numberEndIndex = message.length();
        }
        String violationString = message.substring(numberStartIndex, numberEndIndex);
        try {
            return Integer.valueOf(violationString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static boolean tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    private static void executeDeathPenalty(ViolationInfo info) {
        int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
        throw new StrictModeViolation(info.policy, violationBit, null);
    }

    private static void dropboxViolationAsync(final int violationMaskSubset, final ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d(TAG, "Dropboxing async; in-flight=" + outstanding);
        }
        new Thread("callActivityManagerForStrictModeDropbox"){

            @Override
            public void run() {
                Process.setThreadPriority(10);
                try {
                    IActivityManager am = ActivityManagerNative.getDefault();
                    if (am == null) {
                        Log.d(StrictMode.TAG, "No activity manager; failed to Dropbox violation.");
                    } else {
                        am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                    }
                }
                catch (RemoteException e) {
                    Log.e(StrictMode.TAG, "RemoteException handling StrictMode violation", e);
                }
                int outstanding = sDropboxCallsInFlight.decrementAndGet();
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Dropbox complete; in-flight=" + outstanding);
                }
            }
        }.start();
    }

    static boolean hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    public static void conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        if (policy.classInstanceLimit.size() == 0) {
            return;
        }
        System.gc();
        System.runFinalization();
        System.gc();
        for (Map.Entry<Class, Integer> entry : policy.classInstanceLimit.entrySet()) {
            Class klass = entry.getKey();
            int limit = entry.getValue();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances <= (long)limit) continue;
            InstanceCountViolation tr = new InstanceCountViolation(klass, instances, limit);
            StrictMode.onVmPolicyViolation(tr.getMessage(), tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            INetworkManagementService netd;
            sVmPolicy = policy;
            sVmPolicyMask = policy.mask;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (sVmPolicyMask & 0xA50000) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            int networkPolicy = 0;
            if ((sVmPolicyMask & 0x4000) != 0) {
                networkPolicy = (sVmPolicyMask & 0x40000) != 0 || (sVmPolicyMask & 0x800000) != 0 ? 2 : 1;
            }
            if ((netd = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"))) != null) {
                try {
                    netd.setUidCleartextNetworkPolicy(Process.myUid(), networkPolicy);
                }
                catch (RemoteException remoteException) {}
            } else if (networkPolicy != 0) {
                Log.w(TAG, "Dropping requested network policy due to missing service!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VmPolicy getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x100) != 0;
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x200) != 0;
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (sVmPolicyMask & 0x1000) != 0;
    }

    public static boolean vmFileUriExposureEnabled() {
        return (sVmPolicyMask & 0x2000) != 0;
    }

    public static boolean vmCleartextNetworkEnabled() {
        return (sVmPolicyMask & 0x4000) != 0;
    }

    public static void onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(message, originStack);
    }

    public static void onWebViewMethodCalledOnWrongThread(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    public static void onIntentReceiverLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    public static void onServiceConnectionLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(null, originStack);
    }

    public static void onFileUriExposed(String location) {
        String message = "file:// Uri exposed through " + location;
        StrictMode.onVmPolicyViolation(null, new Throwable(message));
    }

    public static void onCleartextNetworkDetected(byte[] firstPacket) {
        byte[] rawAddr = null;
        if (firstPacket != null) {
            if (firstPacket.length >= 20 && (firstPacket[0] & 0xF0) == 64) {
                rawAddr = new byte[4];
                System.arraycopy(firstPacket, 16, rawAddr, 0, 4);
            } else if (firstPacket.length >= 40 && (firstPacket[0] & 0xF0) == 96) {
                rawAddr = new byte[16];
                System.arraycopy(firstPacket, 24, rawAddr, 0, 16);
            }
        }
        int uid = Process.myUid();
        String msg = "Detected cleartext network traffic from UID " + uid;
        if (rawAddr != null) {
            try {
                msg = "Detected cleartext network traffic from UID " + uid + " to " + InetAddress.getByAddress(rawAddr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        boolean forceDeath = (sVmPolicyMask & 0x800000) != 0;
        StrictMode.onVmPolicyViolation(HexDump.dumpHexString(firstPacket).trim(), new Throwable(msg), forceDeath);
    }

    public static void onVmPolicyViolation(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(message, originStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVmPolicyViolation(String message, Throwable originStack, boolean forceDeath) {
        boolean penaltyDropbox = (sVmPolicyMask & 0x200000) != 0;
        boolean penaltyDeath = (sVmPolicyMask & 0x40000) != 0 || forceDeath;
        boolean penaltyLog = (sVmPolicyMask & 0x10000) != 0;
        ViolationInfo info = new ViolationInfo(message, originStack, sVmPolicyMask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long lastViolationTime = 0L;
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        synchronized (hashMap) {
            if (sLastVmViolationTime.containsKey(fingerprint)) {
                lastViolationTime = sLastVmViolationTime.get(fingerprint);
                timeSinceLastViolationMillis = now - lastViolationTime;
            }
            if (timeSinceLastViolationMillis > 1000L) {
                sLastVmViolationTime.put(fingerprint, now);
            }
        }
        if (penaltyLog && timeSinceLastViolationMillis > 1000L) {
            Log.e(TAG, message, originStack);
        }
        int violationMaskSubset = 0x200000 | 0x7F00 & sVmPolicyMask;
        if (penaltyDropbox && !penaltyDeath) {
            StrictMode.dropboxViolationAsync(violationMaskSubset, info);
            return;
        }
        if (penaltyDropbox && lastViolationTime == 0L) {
            int savedPolicyMask = StrictMode.getThreadPolicyMask();
            try {
                StrictMode.setThreadPolicyMask(0);
                ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException trying to handle StrictMode violation", e);
            }
            finally {
                StrictMode.setThreadPolicyMask(savedPolicyMask);
            }
        }
        if (penaltyDeath) {
            System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
    }

    static void writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            p.writeInt(violations.size());
            for (int i = 0; i < violations.size(); ++i) {
                int start = p.dataPosition();
                violations.get(i).writeToParcel(p, 0);
                int size = p.dataPosition() - start;
                if (size <= 10240) continue;
                Slog.d(TAG, "Wrote violation #" + i + " of " + violations.size() + ": " + (p.dataPosition() - start) + " bytes");
            }
            if (LOG_V) {
                Log.d(TAG, "wrote violations to response parcel; num=" + violations.size());
            }
            violations.clear();
        }
        gatheredViolations.set(null);
    }

    static void readAndHandleBinderCallViolations(Parcel p) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
        new LogStackTrace().printStackTrace(pw);
        ((PrintWriter)pw).flush();
        String ourStack = sw.toString();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & 0x400000) != 0;
        int numViolations = p.readInt();
        for (int i = 0; i < numViolations; ++i) {
            if (LOG_V) {
                Log.d(TAG, "strict mode violation stacks read from binder call.  i=" + i);
            }
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            if (info.crashInfo.stackTrace != null && info.crashInfo.stackTrace.length() > 30000) {
                String front = info.crashInfo.stackTrace.substring(256);
                while (i < numViolations) {
                    info = new ViolationInfo(p, !currentlyGathering);
                    ++i;
                }
                StrictMode.clearGatheredViolations();
                Slog.wtfStack(TAG, "Stack is too large: numViolations=" + numViolations + " policy=#" + Integer.toHexString(policyMask) + " front=" + front);
                return;
            }
            info.crashInfo.stackTrace = info.crashInfo.stackTrace + "# via Binder call with stack:\n" + ourStack;
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    private static void onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Span enterCriticalSpan(String name) {
        if (IS_USER_BUILD) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d(TAG, "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    public static void noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    public static void noteResourceMismatch(Object tag) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onResourceMismatch(tag);
    }

    public static void noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onReadFromDisk();
    }

    public static void noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onWriteToDisk();
    }

    public static Object trackActivity(Object instance) {
        return new InstanceTracker(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            int newExpected;
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            int n = newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            int limit = newExpected + 1;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int actual = InstanceTracker.getInstanceCount(klass);
            if (actual <= limit) {
                return;
            }
            System.gc();
            System.runFinalization();
            System.gc();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances > (long)limit) {
                InstanceCountViolation tr = new InstanceCountViolation(klass, instances, limit);
                StrictMode.onVmPolicyViolation(tr.getMessage(), tr);
            }
            return;
        }
    }

    private static class InstanceTracker {
        private static final HashMap<Class<?>, Integer> sInstanceCounts = new HashMap();
        private final Class<?> mKlass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceTracker(Object instance) {
            this.mKlass = instance.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(this.mKlass);
                int newValue = value != null ? value + 1 : 1;
                sInstanceCounts.put(this.mKlass, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                synchronized (hashMap) {
                    Integer value = sInstanceCounts.get(this.mKlass);
                    if (value != null) {
                        int newValue = value - 1;
                        if (newValue > 0) {
                            sInstanceCounts.put(this.mKlass, newValue);
                        } else {
                            sInstanceCounts.remove(this.mKlass);
                        }
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getInstanceCount(Class<?> klass) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(klass);
                return value != null ? value : 0;
            }
        }
    }

    private static class InstanceCountViolation
    extends Throwable {
        final Class mClass;
        final long mInstances;
        final int mLimit;
        private static final StackTraceElement[] FAKE_STACK = new StackTraceElement[]{new StackTraceElement("android.os.StrictMode", "setClassInstanceLimit", "StrictMode.java", 1)};

        public InstanceCountViolation(Class klass, long instances, int limit) {
            super(klass.toString() + "; instances=" + instances + "; limit=" + limit);
            this.setStackTrace(FAKE_STACK);
            this.mClass = klass;
            this.mInstances = instances;
            this.mLimit = limit;
        }
    }

    public static class ViolationInfo {
        public String message;
        public final ApplicationErrorReport.CrashInfo crashInfo;
        public final int policy;
        public int durationMillis = -1;
        public int numAnimationsRunning = 0;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances = -1L;

        public ViolationInfo() {
            this.crashInfo = null;
            this.policy = 0;
        }

        public ViolationInfo(Throwable tr, int policy) {
            this(null, tr, policy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ViolationInfo(String message, Throwable tr, int policy) {
            this.message = message;
            this.crashInfo = new ApplicationErrorReport.CrashInfo(tr);
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.policy = policy;
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = (ThreadSpanState)sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).mInstances;
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.crashInfo.stackTrace.hashCode();
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        public ViolationInfo(Parcel in) {
            this(in, false);
        }

        public ViolationInfo(Parcel in, boolean unsetGatheringBit) {
            this.message = in.readString();
            this.crashInfo = new ApplicationErrorReport.CrashInfo(in);
            int rawPolicy = in.readInt();
            this.policy = unsetGatheringBit ? rawPolicy & 0xFFBFFFFF : rawPolicy;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.message);
            this.crashInfo.writeToParcel(dest, flags);
            int start = dest.dataPosition();
            dest.writeInt(this.policy);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
            int total = dest.dataPosition() - start;
            if (total > 10240) {
                Slog.d(StrictMode.TAG, "VIO: policy=" + this.policy + " dur=" + this.durationMillis + " numLoop=" + this.violationNumThisLoop + " anim=" + this.numAnimationsRunning + " uptime=" + this.violationUptimeMillis + " numInst=" + this.numInstances);
                Slog.d(StrictMode.TAG, "VIO: action=" + this.broadcastIntentAction);
                Slog.d(StrictMode.TAG, "VIO: tags=" + Arrays.toString(this.tags));
                Slog.d(StrictMode.TAG, "VIO: TOTAL BYTES WRITTEN: " + (dest.dataPosition() - start));
            }
        }

        public void dump(Printer pw, String prefix) {
            this.crashInfo.dump(pw, prefix);
            pw.println(prefix + "policy: " + this.policy);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }
    }

    private static class ThreadSpanState {
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private ThreadSpanState() {
        }
    }

    public static class Span {
        private String mName;
        private long mCreateMillis;
        private Span mNext;
        private Span mPrev;
        private final ThreadSpanState mContainerState;

        Span(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        protected Span() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }
    }

    private static class LogStackTrace
    extends Exception {
        private LogStackTrace() {
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter {
        private AndroidCloseGuardReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(message, allocationSite);
        }
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        private int mPolicyMask;
        private ArrayMap<Integer, Long> mLastViolationTime;

        public AndroidBlockGuardPolicy(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        public String toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }

        @Override
        public int getPolicyMask() {
            return this.mPolicyMask;
        }

        @Override
        public void onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskWriteViolation e = new StrictModeDiskWriteViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        void onCustomSlowCall(String name) {
            if ((this.mPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeCustomViolation e = new StrictModeCustomViolation(this.mPolicyMask, name);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        void onResourceMismatch(Object tag) {
            if ((this.mPolicyMask & 0x10) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeResourceMismatchViolation e = new StrictModeResourceMismatchViolation(this.mPolicyMask, tag);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        @Override
        public void onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskReadViolation e = new StrictModeDiskReadViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        @Override
        public void onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mPolicyMask & 0x80000) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeNetworkViolation e = new StrictModeNetworkViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        public void setPolicyMask(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        void startHandlingViolationException(BlockGuard.BlockGuardPolicyException e) {
            ViolationInfo info = new ViolationInfo(e, e.getPolicy());
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        void handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || (info.policy & 0x7F0000) == 262144) {
                info.durationMillis = -1;
                this.handleViolation(info);
                return;
            }
            final ArrayList records = (ArrayList)violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = (info.policy & 0x100000) != 0 ? (IWindowManager)sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ((Handler)threadHandler.get()).postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    long loopFinishTime = SystemClock.uptimeMillis();
                    if (windowManager != null) {
                        try {
                            windowManager.showStrictModeViolation(false);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    for (int n = 0; n < records.size(); ++n) {
                        ViolationInfo v = (ViolationInfo)records.get(n);
                        v.violationNumThisLoop = n + 1;
                        v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                        AndroidBlockGuardPolicy.this.handleViolation(v);
                    }
                    records.clear();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleViolation(ViolationInfo info) {
            long timeSinceLastViolationMillis;
            if (info == null || info.crashInfo == null || info.crashInfo.stackTrace == null) {
                Log.wtf(StrictMode.TAG, "unexpected null stacktrace");
                return;
            }
            if (LOG_V) {
                Log.d(StrictMode.TAG, "handleViolation; policy=" + info.policy);
            }
            if ((info.policy & 0x400000) != 0) {
                ArrayList<ViolationInfo> violations = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (violations == null) {
                    violations = new ArrayList<ViolationInfo>(1);
                    gatheredViolations.set(violations);
                } else if (violations.size() >= 5) {
                    return;
                }
                for (ViolationInfo previous : violations) {
                    if (!info.crashInfo.stackTrace.equals(previous.crashInfo.stackTrace)) continue;
                    return;
                }
                violations.add(info);
                return;
            }
            Integer crashFingerprint = info.hashCode();
            long lastViolationTime = 0L;
            if (this.mLastViolationTime != null) {
                Long vtime = this.mLastViolationTime.get(crashFingerprint);
                if (vtime != null) {
                    lastViolationTime = vtime;
                }
            } else {
                this.mLastViolationTime = new ArrayMap(1);
            }
            long now = SystemClock.uptimeMillis();
            this.mLastViolationTime.put(crashFingerprint, now);
            long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
            if ((info.policy & 0x10000) != 0 && timeSinceLastViolationMillis > 1000L) {
                if (info.durationMillis != -1) {
                    Log.d(StrictMode.TAG, "StrictMode policy violation; ~duration=" + info.durationMillis + " ms: " + info.crashInfo.stackTrace);
                } else {
                    Log.d(StrictMode.TAG, "StrictMode policy violation: " + info.crashInfo.stackTrace);
                }
            }
            int violationMaskSubset = 0;
            if ((info.policy & 0x20000) != 0 && timeSinceLastViolationMillis > 30000L) {
                violationMaskSubset |= 0x20000;
            }
            if ((info.policy & 0x200000) != 0 && lastViolationTime == 0L) {
                violationMaskSubset |= 0x200000;
            }
            if (violationMaskSubset != 0) {
                boolean justDropBox;
                int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
                violationMaskSubset |= violationBit;
                int savedPolicyMask = StrictMode.getThreadPolicyMask();
                boolean bl = justDropBox = (info.policy & 0x7F0000) == 0x200000;
                if (justDropBox) {
                    StrictMode.dropboxViolationAsync(violationMaskSubset, info);
                    return;
                }
                try {
                    StrictMode.setThreadPolicyMask(0);
                    ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                }
                catch (RemoteException e) {
                    Log.e(StrictMode.TAG, "RemoteException trying to handle StrictMode violation", e);
                }
                finally {
                    StrictMode.setThreadPolicyMask(savedPolicyMask);
                }
            }
            if ((info.policy & 0x40000) != 0) {
                StrictMode.executeDeathPenalty(info);
            }
        }
    }

    private static class StrictModeResourceMismatchViolation
    extends StrictModeViolation {
        public StrictModeResourceMismatchViolation(int policyMask, Object tag) {
            super(policyMask, 16, tag != null ? tag.toString() : null);
        }
    }

    private static class StrictModeCustomViolation
    extends StrictModeViolation {
        public StrictModeCustomViolation(int policyMask, String name) {
            super(policyMask, 8, name);
        }
    }

    private static class StrictModeDiskWriteViolation
    extends StrictModeViolation {
        public StrictModeDiskWriteViolation(int policyMask) {
            super(policyMask, 1, null);
        }
    }

    private static class StrictModeDiskReadViolation
    extends StrictModeViolation {
        public StrictModeDiskReadViolation(int policyMask) {
            super(policyMask, 2, null);
        }
    }

    public static class StrictModeNetworkViolation
    extends StrictModeViolation {
        public StrictModeNetworkViolation(int policyMask) {
            super(policyMask, 4, null);
        }
    }

    public static class StrictModeViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeViolation(int policyState, int policyViolated, String message) {
            super(policyState, policyViolated, message);
        }
    }

    public static class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0, StrictMode.access$100());
        final int mask;
        final HashMap<Class, Integer> classInstanceLimit;

        private VmPolicy(int mask, HashMap<Class, Integer> classInstanceLimit) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
        }

        public String toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            private int mMask;
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow = false;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(VmPolicy base) {
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
            }

            public Builder setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 0x800;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            public Builder detectActivityLeaks() {
                return this.enable(1024);
            }

            public Builder detectAll() {
                int flags = 14080;
                if (SystemProperties.getBoolean(StrictMode.CLEARTEXT_PROPERTY, false)) {
                    flags |= 0x4000;
                }
                return this.enable(flags);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(256);
            }

            public Builder detectLeakedClosableObjects() {
                return this.enable(512);
            }

            public Builder detectLeakedRegistrationObjects() {
                return this.enable(4096);
            }

            public Builder detectFileUriExposure() {
                return this.enable(8192);
            }

            public Builder detectCleartextNetwork() {
                return this.enable(16384);
            }

            public Builder penaltyDeath() {
                return this.enable(262144);
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                return this.enable(0x800000);
            }

            public Builder penaltyLog() {
                return this.enable(65536);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x200000);
            }

            private Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            public VmPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP);
            }
        }
    }

    public static class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0);
        final int mask;

        private ThreadPolicy(int mask) {
            this.mask = mask;
        }

        public String toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            private int mMask = 0;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy policy) {
                this.mMask = policy.mask;
            }

            public Builder detectAll() {
                return this.enable(31);
            }

            public Builder permitAll() {
                return this.disable(31);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder detectCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder permitCustomSlowCalls() {
                return this.disable(8);
            }

            public Builder permitResourceMismatches() {
                return this.disable(16);
            }

            public Builder detectResourceMismatches() {
                return this.enable(16);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder penaltyDialog() {
                return this.enable(131072);
            }

            public Builder penaltyDeath() {
                return this.enable(262144);
            }

            public Builder penaltyDeathOnNetwork() {
                return this.enable(524288);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(0x100000);
            }

            public Builder penaltyLog() {
                return this.enable(65536);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x200000);
            }

            private Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private Builder disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask);
            }
        }
    }
}

