/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;

public class Environment {
    private static final String TAG = "Environment";
    private static final String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static final String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static final String ENV_ANDROID_DATA = "ANDROID_DATA";
    private static final String ENV_ANDROID_STORAGE = "ANDROID_STORAGE";
    private static final String ENV_OEM_ROOT = "OEM_ROOT";
    private static final String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    public static final String DIR_ANDROID = "Android";
    private static final String DIR_DATA = "data";
    private static final String DIR_MEDIA = "media";
    private static final String DIR_OBB = "obb";
    private static final String DIR_FILES = "files";
    private static final String DIR_CACHE = "cache";
    @Deprecated
    public static final String DIRECTORY_ANDROID = "Android";
    private static final File DIR_ANDROID_ROOT = Environment.getDirectory("ANDROID_ROOT", "/system");
    private static final File DIR_ANDROID_DATA = Environment.getDirectory("ANDROID_DATA", "/data");
    private static final File DIR_ANDROID_STORAGE = Environment.getDirectory("ANDROID_STORAGE", "/storage");
    private static final File DIR_OEM_ROOT = Environment.getDirectory("OEM_ROOT", "/oem");
    private static final File DIR_VENDOR_ROOT = Environment.getDirectory("VENDOR_ROOT", "/vendor");
    private static final String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static UserEnvironment sCurrentUser;
    private static boolean sUserRequired;
    private static final File DATA_DIRECTORY;
    private static final File SECURE_DATA_DIRECTORY;
    private static final File DOWNLOAD_CACHE_DIRECTORY;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static final String MEDIA_UNKNOWN = "unknown";
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";
    public static final String MEDIA_EJECTING = "ejecting";

    public static void initForCurrentUser() {
        int userId = UserHandle.myUserId();
        sCurrentUser = new UserEnvironment(userId);
    }

    public static File getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    public static File getStorageDirectory() {
        return DIR_ANDROID_STORAGE;
    }

    public static File getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    public static File getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    public static File getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return new File(SECURE_DATA_DIRECTORY, "system");
        }
        return new File(DATA_DIRECTORY, "system");
    }

    public static File getSecureDataDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return SECURE_DATA_DIRECTORY;
        }
        return DATA_DIRECTORY;
    }

    public static File getUserSystemDirectory(int userId) {
        return new File(new File(Environment.getSystemSecureDirectory(), "users"), Integer.toString(userId));
    }

    public static File getUserConfigDirectory(int userId) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(userId));
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_EFS_ENABLED, false);
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    public static File getDataDirectory(String volumeUuid) {
        if (TextUtils.isEmpty(volumeUuid)) {
            return new File("/data");
        }
        return new File("/mnt/expand/" + volumeUuid);
    }

    public static File getDataAppDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "app");
    }

    public static File getDataUserDirectory(String volumeUuid) {
        return new File(Environment.getDataDirectory(volumeUuid), "user");
    }

    public static File getDataUserDirectory(String volumeUuid, int userId) {
        return new File(Environment.getDataUserDirectory(volumeUuid), String.valueOf(userId));
    }

    public static File getDataUserPackageDirectory(String volumeUuid, int userId, String packageName) {
        return new File(Environment.getDataUserDirectory(volumeUuid, userId), packageName);
    }

    public static File getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirs()[0];
    }

    public static File getLegacyExternalStorageDirectory() {
        return new File(System.getenv(ENV_EXTERNAL_STORAGE));
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", DIR_OBB);
    }

    public static File getExternalStoragePublicDirectory(String type) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(type)[0];
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    public static File[] buildExternalStorageAppDataDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(packageName);
    }

    public static File[] buildExternalStorageAppMediaDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(packageName);
    }

    public static File[] buildExternalStorageAppObbDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(packageName);
    }

    public static File[] buildExternalStorageAppFilesDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(packageName);
    }

    public static File[] buildExternalStorageAppCacheDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(packageName);
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static String getExternalStorageState() {
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.getExternalStorageState(externalDir);
    }

    @Deprecated
    public static String getStorageState(File path) {
        return Environment.getExternalStorageState(path);
    }

    public static String getExternalStorageState(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.getState();
        }
        return MEDIA_UNKNOWN;
    }

    public static boolean isExternalStorageRemovable() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageRemovable(externalDir);
    }

    public static boolean isExternalStorageRemovable(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    public static boolean isExternalStorageEmulated() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirs()[0];
        return Environment.isExternalStorageEmulated(externalDir);
    }

    public static boolean isExternalStorageEmulated(File path) {
        StorageVolume volume = StorageManager.getStorageVolume(path, UserHandle.myUserId());
        if (volume != null) {
            return volume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    static File getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }

    public static void setUserRequired(boolean userRequired) {
        sUserRequired = userRequired;
    }

    private static void throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf(TAG, "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    public static File[] buildPaths(File[] base, String ... segments) {
        File[] result = new File[base.length];
        for (int i = 0; i < base.length; ++i) {
            result[i] = Environment.buildPath(base[i], segments);
        }
        return result;
    }

    public static File buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            cur = cur == null ? new File(segment) : new File(cur, segment);
        }
        return cur;
    }

    private static boolean isStorageDisabled() {
        return SystemProperties.getBoolean("config.disable_storage", false);
    }

    public static File maybeTranslateEmulatedPathToInternal(File path) {
        return StorageManager.maybeTranslateEmulatedPathToInternal(path);
    }

    static {
        Environment.initForCurrentUser();
        DATA_DIRECTORY = Environment.getDirectory(ENV_ANDROID_DATA, "/data");
        SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
        DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
    }

    public static class UserEnvironment {
        private final int mUserId;

        public UserEnvironment(int userId) {
            this.mUserId = userId;
        }

        public File[] getExternalDirs() {
            StorageVolume[] volumes = StorageManager.getVolumeList(this.mUserId, 1);
            File[] files = new File[volumes.length];
            for (int i = 0; i < volumes.length; ++i) {
                files[i] = volumes[i].getPathFile();
            }
            return files;
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return this.getExternalDirs()[0];
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String type) {
            return this.buildExternalStoragePublicDirs(type)[0];
        }

        public File[] buildExternalStoragePublicDirs(String type) {
            return Environment.buildPaths(this.getExternalDirs(), type);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_OBB);
        }

        public File[] buildExternalStorageAppDataDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName);
        }

        public File[] buildExternalStorageAppMediaDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_MEDIA, packageName);
        }

        public File[] buildExternalStorageAppObbDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_OBB, packageName);
        }

        public File[] buildExternalStorageAppFilesDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName, Environment.DIR_FILES);
        }

        public File[] buildExternalStorageAppCacheDirs(String packageName) {
            return Environment.buildPaths(this.getExternalDirs(), "Android", Environment.DIR_DATA, packageName, Environment.DIR_CACHE);
        }
    }
}

