/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.SystemClock;
import com.android.tools.layoutlib.java.System_Delegate;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SntpClient {
    private static final String TAG = "SntpClient";
    private static final int REFERENCE_TIME_OFFSET = 16;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_VERSION = 3;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private long mNtpTime;
    private long mNtpTimeReference;
    private long mRoundTripTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestTime(String host, int timeout) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            InetAddress address = InetAddress.getByName(host);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            buffer[0] = 27;
            long requestTime = System_Delegate.currentTimeMillis();
            long requestTicks = SystemClock.elapsedRealtime();
            this.writeTimeStamp(buffer, 40, requestTime);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = SystemClock.elapsedRealtime();
            long responseTime = requestTime + (responseTicks - requestTicks);
            long originateTime = this.readTimeStamp(buffer, 24);
            long receiveTime = this.readTimeStamp(buffer, 32);
            long transmitTime = this.readTimeStamp(buffer, 40);
            long roundTripTime = responseTicks - requestTicks - (transmitTime - receiveTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            this.mNtpTime = responseTime + clockOffset;
            this.mNtpTimeReference = responseTicks;
            this.mRoundTripTime = roundTripTime;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return true;
    }

    public long getNtpTime() {
        return this.mNtpTime;
    }

    public long getNtpTimeReference() {
        return this.mNtpTimeReference;
    }

    public long getRoundTripTime() {
        return this.mRoundTripTime;
    }

    private long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private long readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.read32(buffer, offset);
        long fraction2 = this.read32(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction2 * 1000L / 0x100000000L;
    }

    private void writeTimeStamp(byte[] buffer, int offset, long time) {
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction2 = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction2 >> 24);
        buffer[offset++] = (byte)(fraction2 >> 16);
        buffer[offset++] = (byte)(fraction2 >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }
}

