/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class NetworkInfo
implements Parcelable {
    private static final EnumMap<DetailedState, State> stateMap = new EnumMap(DetailedState.class);
    private int mNetworkType;
    private int mSubtype;
    private String mTypeName;
    private String mSubtypeName;
    private State mState;
    private DetailedState mDetailedState;
    private String mReason;
    private String mExtraInfo;
    private boolean mIsFailover;
    private boolean mIsRoaming;
    private boolean mIsAvailable;
    public static final Parcelable.Creator<NetworkInfo> CREATOR;

    public NetworkInfo(int type, int subtype, String typeName, String subtypeName) {
        if (!ConnectivityManager.isNetworkTypeValid(type)) {
            throw new IllegalArgumentException("Invalid network type: " + type);
        }
        this.mNetworkType = type;
        this.mSubtype = subtype;
        this.mTypeName = typeName;
        this.mSubtypeName = subtypeName;
        this.setDetailedState(DetailedState.IDLE, null, null);
        this.mState = State.UNKNOWN;
        this.mIsAvailable = false;
        this.mIsRoaming = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkInfo(NetworkInfo source) {
        if (source != null) {
            NetworkInfo networkInfo = source;
            synchronized (networkInfo) {
                this.mNetworkType = source.mNetworkType;
                this.mSubtype = source.mSubtype;
                this.mTypeName = source.mTypeName;
                this.mSubtypeName = source.mSubtypeName;
                this.mState = source.mState;
                this.mDetailedState = source.mDetailedState;
                this.mReason = source.mReason;
                this.mExtraInfo = source.mExtraInfo;
                this.mIsFailover = source.mIsFailover;
                this.mIsRoaming = source.mIsRoaming;
                this.mIsAvailable = source.mIsAvailable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mNetworkType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(int type) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mNetworkType = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubtype() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mSubtype;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubtype(int subtype, String subtypeName) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mSubtype = subtype;
            this.mSubtypeName = subtypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeName() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mTypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubtypeName() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mSubtypeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedOrConnecting() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState == State.CONNECTED || this.mState == State.CONNECTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState == State.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsAvailable(boolean isAvailable) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsAvailable = isAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailover() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsFailover;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailover(boolean isFailover) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsFailover = isFailover;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoaming() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mIsRoaming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoaming(boolean isRoaming) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mIsRoaming = isRoaming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetailedState getDetailedState() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mDetailedState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailedState(DetailedState detailedState, String reason, String extraInfo) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mDetailedState = detailedState;
            this.mState = stateMap.get((Object)detailedState);
            this.mReason = reason;
            this.mExtraInfo = extraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraInfo(String extraInfo) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            this.mExtraInfo = extraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReason() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtraInfo() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            return this.mExtraInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            StringBuilder builder = new StringBuilder("[");
            builder.append("type: ").append(this.getTypeName()).append("[").append(this.getSubtypeName()).append("], state: ").append((Object)this.mState).append("/").append((Object)this.mDetailedState).append(", reason: ").append(this.mReason == null ? "(unspecified)" : this.mReason).append(", extra: ").append(this.mExtraInfo == null ? "(none)" : this.mExtraInfo).append(", roaming: ").append(this.mIsRoaming).append(", failover: ").append(this.mIsFailover).append(", isAvailable: ").append(this.mIsAvailable).append("]");
            return builder.toString();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        NetworkInfo networkInfo = this;
        synchronized (networkInfo) {
            dest.writeInt(this.mNetworkType);
            dest.writeInt(this.mSubtype);
            dest.writeString(this.mTypeName);
            dest.writeString(this.mSubtypeName);
            dest.writeString(this.mState.name());
            dest.writeString(this.mDetailedState.name());
            dest.writeInt(this.mIsFailover ? 1 : 0);
            dest.writeInt(this.mIsAvailable ? 1 : 0);
            dest.writeInt(this.mIsRoaming ? 1 : 0);
            dest.writeString(this.mReason);
            dest.writeString(this.mExtraInfo);
        }
    }

    static {
        stateMap.put(DetailedState.IDLE, State.DISCONNECTED);
        stateMap.put(DetailedState.SCANNING, State.DISCONNECTED);
        stateMap.put(DetailedState.CONNECTING, State.CONNECTING);
        stateMap.put(DetailedState.AUTHENTICATING, State.CONNECTING);
        stateMap.put(DetailedState.OBTAINING_IPADDR, State.CONNECTING);
        stateMap.put(DetailedState.VERIFYING_POOR_LINK, State.CONNECTING);
        stateMap.put(DetailedState.CAPTIVE_PORTAL_CHECK, State.CONNECTING);
        stateMap.put(DetailedState.CONNECTED, State.CONNECTED);
        stateMap.put(DetailedState.SUSPENDED, State.SUSPENDED);
        stateMap.put(DetailedState.DISCONNECTING, State.DISCONNECTING);
        stateMap.put(DetailedState.DISCONNECTED, State.DISCONNECTED);
        stateMap.put(DetailedState.FAILED, State.DISCONNECTED);
        stateMap.put(DetailedState.BLOCKED, State.DISCONNECTED);
        CREATOR = new Parcelable.Creator<NetworkInfo>(){

            @Override
            public NetworkInfo createFromParcel(Parcel in) {
                int netType = in.readInt();
                int subtype = in.readInt();
                String typeName = in.readString();
                String subtypeName = in.readString();
                NetworkInfo netInfo = new NetworkInfo(netType, subtype, typeName, subtypeName);
                netInfo.mState = State.valueOf(in.readString());
                netInfo.mDetailedState = DetailedState.valueOf(in.readString());
                netInfo.mIsFailover = in.readInt() != 0;
                netInfo.mIsAvailable = in.readInt() != 0;
                netInfo.mIsRoaming = in.readInt() != 0;
                netInfo.mReason = in.readString();
                netInfo.mExtraInfo = in.readString();
                return netInfo;
            }

            public NetworkInfo[] newArray(int size) {
                return new NetworkInfo[size];
            }
        };
    }

    public static enum DetailedState {
        IDLE,
        SCANNING,
        CONNECTING,
        AUTHENTICATING,
        OBTAINING_IPADDR,
        CONNECTED,
        SUSPENDED,
        DISCONNECTING,
        DISCONNECTED,
        FAILED,
        BLOCKED,
        VERIFYING_POOR_LINK,
        CAPTIVE_PORTAL_CHECK;

    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        SUSPENDED,
        DISCONNECTING,
        DISCONNECTED,
        UNKNOWN;

    }
}

