/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiPortImpl;
import android.media.midi.MidiReceiver;
import android.media.midi.MidiSender;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.midi.MidiDispatcher;
import com.android.tools.layoutlib.java.AutoCloseable;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public class MidiOutputPort
extends MidiSender
implements Closeable {
    private static final String TAG = "MidiOutputPort";
    private IMidiDeviceServer mDeviceServer;
    private final IBinder mToken;
    private final int mPortNumber;
    private final FileInputStream mInputStream;
    private final MidiDispatcher mDispatcher = new MidiDispatcher();
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mIsClosed;
    private final Thread mThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            try {
                block9: while (true) {
                    int count;
                    if ((count = MidiOutputPort.this.mInputStream.read(buffer)) < 0) {
                        return;
                    }
                    int packetType = MidiPortImpl.getPacketType(buffer, count);
                    switch (packetType) {
                        case 1: {
                            int offset = MidiPortImpl.getDataOffset(buffer, count);
                            int size = MidiPortImpl.getDataSize(buffer, count);
                            long timestamp = MidiPortImpl.getPacketTimestamp(buffer, count);
                            MidiOutputPort.this.mDispatcher.send(buffer, offset, size, timestamp);
                            continue block9;
                        }
                        case 2: {
                            MidiOutputPort.this.mDispatcher.flush();
                            continue block9;
                        }
                    }
                    Log.e(MidiOutputPort.TAG, "Unknown packet type " + packetType);
                }
            }
            catch (IOException e) {
                Log.e(MidiOutputPort.TAG, "read failed");
                return;
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)((Object)MidiOutputPort.this.mInputStream));
            }
        }
    };

    MidiOutputPort(IMidiDeviceServer server, IBinder token, ParcelFileDescriptor pfd, int portNumber) {
        this.mDeviceServer = server;
        this.mToken = token;
        this.mPortNumber = portNumber;
        this.mInputStream = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
        this.mThread.start();
        this.mGuard.open("close");
    }

    MidiOutputPort(ParcelFileDescriptor pfd, int portNumber) {
        this(null, null, pfd, portNumber);
    }

    public int getPortNumber() {
        return this.mPortNumber;
    }

    @Override
    public void onConnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().connect(receiver);
    }

    @Override
    public void onDisconnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().disconnect(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            this.mInputStream.close();
            if (this.mDeviceServer != null) {
                try {
                    this.mDeviceServer.closePort(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException in MidiOutputPort.close()");
                }
            }
            this.mIsClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.mGuard.warnIfOpen();
            this.mDeviceServer = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

