/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class MediaCodecList {
    private static final String TAG = "MediaCodecList";
    private static Object sInitLock = new Object();
    private static MediaCodecInfo[] sAllCodecInfos;
    private static MediaCodecInfo[] sRegularCodecInfos;
    private static Map<String, Object> sGlobalSettings;
    public static final int REGULAR_CODECS = 0;
    public static final int ALL_CODECS = 1;
    private MediaCodecInfo[] mCodecInfos;

    public static int getCodecCount() {
        MediaCodecList.initCodecList();
        return sRegularCodecInfos.length;
    }

    private static int native_getCodecCount() {
        return OverrideMethod.invokeI("android.media.MediaCodecList#native_getCodecCount()I", true, null);
    }

    public static MediaCodecInfo getCodecInfoAt(int index) {
        MediaCodecList.initCodecList();
        if (index < 0 || index > sRegularCodecInfos.length) {
            throw new IllegalArgumentException();
        }
        return sRegularCodecInfos[index];
    }

    static Map<String, Object> getGlobalSettings() {
        return sGlobalSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCodecList() {
        Object object = sInitLock;
        synchronized (object) {
            if (sRegularCodecInfos == null) {
                sGlobalSettings = MediaCodecList.native_getGlobalSettings();
                int count = MediaCodecList.native_getCodecCount();
                ArrayList<MediaCodecInfo> regulars = new ArrayList<MediaCodecInfo>();
                ArrayList<MediaCodecInfo> all = new ArrayList<MediaCodecInfo>();
                for (int index = 0; index < count; ++index) {
                    try {
                        MediaCodecInfo info = MediaCodecList.getNewCodecInfoAt(index);
                        all.add(info);
                        info = info.makeRegular();
                        if (info == null) continue;
                        regulars.add(info);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Could not get codec capabilities", e);
                    }
                }
                sRegularCodecInfos = regulars.toArray(new MediaCodecInfo[regulars.size()]);
                sAllCodecInfos = all.toArray(new MediaCodecInfo[all.size()]);
            }
        }
    }

    private static MediaCodecInfo getNewCodecInfoAt(int index) {
        String[] supportedTypes = MediaCodecList.getSupportedTypes(index);
        MediaCodecInfo.CodecCapabilities[] caps = new MediaCodecInfo.CodecCapabilities[supportedTypes.length];
        int typeIx = 0;
        for (String type : supportedTypes) {
            caps[typeIx++] = MediaCodecList.getCodecCapabilities(index, type);
        }
        return new MediaCodecInfo(MediaCodecList.getCodecName(index), MediaCodecList.isEncoder(index), caps);
    }

    static String getCodecName(int n) {
        return (String)OverrideMethod.invokeA("android.media.MediaCodecList#getCodecName(I)Ljava/lang/String;", true, null);
    }

    static boolean isEncoder(int n) {
        return OverrideMethod.invokeI("android.media.MediaCodecList#isEncoder(I)Z", true, null) != 0;
    }

    static String[] getSupportedTypes(int n) {
        return (String[])OverrideMethod.invokeA("android.media.MediaCodecList#getSupportedTypes(I)[Ljava/lang/String;", true, null);
    }

    static MediaCodecInfo.CodecCapabilities getCodecCapabilities(int n, String string2) {
        return (MediaCodecInfo.CodecCapabilities)OverrideMethod.invokeA("android.media.MediaCodecList#getCodecCapabilities(ILjava/lang/String;)Landroid/media/MediaCodecInfo$CodecCapabilities;", true, null);
    }

    static Map<String, Object> native_getGlobalSettings() {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodecList#native_getGlobalSettings()Ljava/util/Map;", true, null);
    }

    static int findCodecByName(String string2) {
        return OverrideMethod.invokeI("android.media.MediaCodecList#findCodecByName(Ljava/lang/String;)I", true, null);
    }

    public static MediaCodecInfo getInfoFor(String codec) {
        MediaCodecList.initCodecList();
        return sAllCodecInfos[MediaCodecList.findCodecByName(codec)];
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaCodecList#native_init()V", true, null);
    }

    private MediaCodecList() {
        this(0);
    }

    public MediaCodecList(int kind) {
        MediaCodecList.initCodecList();
        this.mCodecInfos = kind == 0 ? sRegularCodecInfos : sAllCodecInfos;
    }

    public MediaCodecInfo[] getCodecInfos() {
        return Arrays.copyOf(this.mCodecInfos, this.mCodecInfos.length);
    }

    public String findDecoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(false, format);
    }

    public String findEncoderForFormat(MediaFormat format) {
        return this.findCodecForFormat(true, format);
    }

    private String findCodecForFormat(boolean encoder, MediaFormat format) {
        String mime = format.getString("mime");
        for (MediaCodecInfo info : this.mCodecInfos) {
            if (info.isEncoder() != encoder) continue;
            try {
                MediaCodecInfo.CodecCapabilities caps = info.getCapabilitiesForType(mime);
                if (caps == null || !caps.isFormatSupported(format)) continue;
                return info.getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        System.loadLibrary("media_jni");
        MediaCodecList.native_init();
    }
}

