/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Image;
import android.media.ImageUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.AutoCloseable;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageReader
implements AutoCloseable {
    private static final int ACQUIRE_SUCCESS = 0;
    private static final int ACQUIRE_NO_BUFS = 1;
    private static final int ACQUIRE_MAX_IMAGES = 2;
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final int mMaxImages;
    private final int mNumPlanes;
    private final Surface mSurface;
    private int mEstimatedNativeAllocBytes;
    private final Object mListenerLock = new Object();
    private OnImageAvailableListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;

    public static ImageReader newInstance(int width, int height, int format, int maxImages) {
        return new ImageReader(width, height, format, maxImages);
    }

    protected ImageReader(int width, int height, int format, int maxImages) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = this.getNumPlanesFromFormat();
        this.nativeInit(new WeakReference<ImageReader>(this), width, height, format, maxImages);
        this.mSurface = this.nativeGetSurface();
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(width, height, format, maxImages);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getImageFormat() {
        return this.mFormat;
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public Image acquireLatestImage() {
        Image image = this.acquireNextImage();
        if (image == null) {
            return null;
        }
        try {
            while (true) {
                Image next;
                if ((next = this.acquireNextImageNoThrowISE()) == null) {
                    Image result = image;
                    image = null;
                    Image image2 = result;
                    return image2;
                }
                image.close();
                image = next;
            }
        }
        finally {
            if (image != null) {
                image.close();
            }
        }
    }

    public Image acquireNextImageNoThrowISE() {
        SurfaceImage si = new SurfaceImage(this.mFormat);
        return this.acquireNextSurfaceImage(si) == 0 ? si : null;
    }

    private int acquireNextSurfaceImage(SurfaceImage si) {
        int status = this.nativeImageSetup(si);
        switch (status) {
            case 0: {
                si.createSurfacePlanes();
                si.mIsImageValid = true;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
            }
        }
        return status;
    }

    public Image acquireNextImage() {
        SurfaceImage si = new SurfaceImage(this.mFormat);
        int status = this.acquireNextSurfaceImage(si);
        switch (status) {
            case 0: {
                return si;
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", this.mMaxImages));
            }
        }
        throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
    }

    private void releaseImage(Image i) {
        if (!(i instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage si = (SurfaceImage)i;
        if (si.getReader() != this) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        si.clearSurfacePlanes();
        this.nativeReleaseImage(i);
        si.mIsImageValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageAvailableListener(OnImageAvailableListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    @Override
    public void close() {
        this.setOnImageAvailableListener(null, null);
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.nativeClose();
        if (this.mEstimatedNativeAllocBytes > 0) {
            VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
            this.mEstimatedNativeAllocBytes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    void detachImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("input image must not be null");
        }
        if (!this.isImageOwnedbyMe(image)) {
            throw new IllegalArgumentException("Trying to detach an image that is not owned by this ImageReader");
        }
        SurfaceImage si = (SurfaceImage)image;
        si.throwISEIfImageIsInvalid();
        if (si.isAttachable()) {
            throw new IllegalStateException("Image was already detached from this ImageReader");
        }
        this.nativeDetachImage(image);
        si.setDetached(true);
    }

    private int getNumPlanesFromFormat() {
        switch (this.mFormat) {
            case 17: 
            case 35: 
            case 842094169: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 37: 
            case 256: 
            case 257: 
            case 538982489: 
            case 540422489: 
            case 1144402265: {
                return 1;
            }
            case 34: {
                return 0;
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid format specified %d", this.mFormat));
    }

    private boolean isImageOwnedbyMe(Image image) {
        if (!(image instanceof SurfaceImage)) {
            return false;
        }
        SurfaceImage si = (SurfaceImage)image;
        return si.getReader() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageReader ir = (ImageReader)weakSelf.get();
        if (ir == null) {
            return;
        }
        Object object = ir.mListenerLock;
        synchronized (object) {
            handler = ir.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private synchronized void nativeInit(Object object, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.media.ImageReader#nativeInit(Ljava/lang/Object;IIII)V", true, this);
    }

    private synchronized void nativeClose() {
        OverrideMethod.invokeV("android.media.ImageReader#nativeClose()V", true, this);
    }

    private synchronized void nativeReleaseImage(Image image) {
        OverrideMethod.invokeV("android.media.ImageReader#nativeReleaseImage(Landroid/media/Image;)V", true, this);
    }

    private synchronized Surface nativeGetSurface() {
        return (Surface)OverrideMethod.invokeA("android.media.ImageReader#nativeGetSurface()Landroid/view/Surface;", true, this);
    }

    private synchronized int nativeDetachImage(Image image) {
        return OverrideMethod.invokeI("android.media.ImageReader#nativeDetachImage(Landroid/media/Image;)I", true, this);
    }

    private synchronized int nativeImageSetup(Image image) {
        return OverrideMethod.invokeI("android.media.ImageReader#nativeImageSetup(Landroid/media/Image;)I", true, this);
    }

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.media.ImageReader#nativeClassInit()V", true, null);
    }

    static {
        System.loadLibrary("media_jni");
        ImageReader.nativeClassInit();
    }

    private class SurfaceImage
    extends Image {
        private long mNativeBuffer;
        private long mTimestamp;
        private SurfacePlane[] mPlanes;
        private int mFormat = 0;
        private AtomicBoolean mIsDetached = new AtomicBoolean(false);

        public SurfaceImage(int format) {
            this.mFormat = format;
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                ImageReader.this.releaseImage(this);
            }
        }

        public ImageReader getReader() {
            return ImageReader.this;
        }

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            int readerFormat = ImageReader.this.getImageFormat();
            this.mFormat = readerFormat == 34 ? readerFormat : this.nativeGetFormat(readerFormat);
            return this.mFormat;
        }

        @Override
        public int getWidth() {
            int width;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 256: 
                case 257: {
                    width = ImageReader.this.getWidth();
                    break;
                }
                default: {
                    width = this.nativeGetWidth(this.mFormat);
                }
            }
            return width;
        }

        @Override
        public int getHeight() {
            int height;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 256: 
                case 257: {
                    height = ImageReader.this.getHeight();
                    break;
                }
                default: {
                    height = this.nativeGetHeight(this.mFormat);
                }
            }
            return height;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public void setTimestamp(long timestampNs) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestampNs;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            return (Image.Plane[])this.mPlanes.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        @Override
        boolean isAttachable() {
            this.throwISEIfImageIsInvalid();
            return this.mIsDetached.get();
        }

        @Override
        ImageReader getOwner() {
            this.throwISEIfImageIsInvalid();
            return ImageReader.this;
        }

        @Override
        long getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        private void setDetached(boolean detached) {
            this.throwISEIfImageIsInvalid();
            this.mIsDetached.getAndSet(detached);
        }

        private void clearSurfacePlanes() {
            if (this.mIsImageValid) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private void createSurfacePlanes() {
            this.mPlanes = new SurfacePlane[ImageReader.this.mNumPlanes];
            for (int i = 0; i < ImageReader.this.mNumPlanes; ++i) {
                this.mPlanes[i] = this.nativeCreatePlane(i, ImageReader.this.mFormat);
            }
        }

        private synchronized ByteBuffer nativeImageGetBuffer(int n, int n2) {
            return (ByteBuffer)OverrideMethod.invokeA("android.media.ImageReader$SurfaceImage#nativeImageGetBuffer(II)Ljava/nio/ByteBuffer;", true, this);
        }

        private synchronized SurfacePlane nativeCreatePlane(int n, int n2) {
            return (SurfacePlane)OverrideMethod.invokeA("android.media.ImageReader$SurfaceImage#nativeCreatePlane(II)Landroid/media/ImageReader$SurfaceImage$SurfacePlane;", true, this);
        }

        private synchronized int nativeGetWidth(int n) {
            return OverrideMethod.invokeI("android.media.ImageReader$SurfaceImage#nativeGetWidth(I)I", true, this);
        }

        private synchronized int nativeGetHeight(int n) {
            return OverrideMethod.invokeI("android.media.ImageReader$SurfaceImage#nativeGetHeight(I)I", true, this);
        }

        private synchronized int nativeGetFormat(int n) {
            return OverrideMethod.invokeI("android.media.ImageReader$SurfaceImage#nativeGetFormat(I)I", true, this);
        }

        private class SurfacePlane
        extends Image.Plane {
            private final int mIndex;
            private final int mPixelStride;
            private final int mRowStride;
            private ByteBuffer mBuffer;

            private SurfacePlane(int index, int rowStride, int pixelStride) {
                this.mIndex = index;
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
            }

            @Override
            public ByteBuffer getBuffer() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                if (this.mBuffer != null) {
                    return this.mBuffer;
                }
                this.mBuffer = SurfaceImage.this.nativeImageGetBuffer(this.mIndex, ImageReader.this.mFormat);
                return this.mBuffer.order(ByteOrder.nativeOrder());
            }

            @Override
            public int getPixelStride() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mPixelStride;
            }

            @Override
            public int getRowStride() {
                SurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mRowStride;
            }

            private void clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils.freeDirectBuffer(this.mBuffer);
                }
                this.mBuffer = null;
            }
        }
    }

    private class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnImageAvailableListener listener;
            Object object = ImageReader.this.mListenerLock;
            synchronized (object) {
                listener = ImageReader.this.mListener;
            }
            if (listener != null) {
                listener.onImageAvailable(ImageReader.this);
            }
        }
    }

    public static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1);
    }
}

