/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.nio.ByteBuffer;

public abstract class Image
implements AutoCloseable {
    protected boolean mIsImageValid = false;
    private Rect mCropRect;

    protected Image() {
    }

    protected void throwISEIfImageIsInvalid() {
        if (!this.mIsImageValid) {
            throw new IllegalStateException("Image is already closed");
        }
    }

    public abstract int getFormat();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract long getTimestamp();

    public void setTimestamp(long timestamp) {
        this.throwISEIfImageIsInvalid();
    }

    public Rect getCropRect() {
        this.throwISEIfImageIsInvalid();
        if (this.mCropRect == null) {
            return new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        return new Rect(this.mCropRect);
    }

    public void setCropRect(Rect cropRect) {
        this.throwISEIfImageIsInvalid();
        if (cropRect != null && !(cropRect = new Rect(cropRect)).intersect(0, 0, this.getWidth(), this.getHeight())) {
            cropRect.setEmpty();
        }
        this.mCropRect = cropRect;
    }

    public abstract Plane[] getPlanes();

    @Override
    public abstract void close();

    boolean isAttachable() {
        this.throwISEIfImageIsInvalid();
        return false;
    }

    Object getOwner() {
        this.throwISEIfImageIsInvalid();
        return null;
    }

    long getNativeContext() {
        this.throwISEIfImageIsInvalid();
        return 0L;
    }

    public static abstract class Plane {
        protected Plane() {
        }

        public abstract int getRowStride();

        public abstract int getPixelStride();

        public abstract ByteBuffer getBuffer();
    }
}

