/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.Collection;

public class AudioTrack {
    private static final float GAIN_MIN = 0.0f;
    private static final float GAIN_MAX = 1.0f;
    private static final int SAMPLE_RATE_HZ_MIN = 4000;
    private static final int SAMPLE_RATE_HZ_MAX = 192000;
    private static final int CHANNEL_COUNT_MAX = 8;
    public static final int PLAYSTATE_STOPPED = 1;
    public static final int PLAYSTATE_PAUSED = 2;
    public static final int PLAYSTATE_PLAYING = 3;
    public static final int MODE_STATIC = 0;
    public static final int MODE_STREAM = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_NO_STATIC_DATA = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    private static final int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static final int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static final int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static final int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static final int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static final int NATIVE_EVENT_MARKER = 3;
    private static final int NATIVE_EVENT_NEW_POS = 4;
    private static final String TAG = "android.media.AudioTrack";
    public static final int WRITE_BLOCKING = 0;
    public static final int WRITE_NON_BLOCKING = 1;
    private int mState = 0;
    private int mPlayState = 1;
    private final Object mPlayStateLock = new Object();
    private int mNativeBufferSizeInBytes = 0;
    private int mNativeBufferSizeInFrames = 0;
    private NativePositionEventHandlerDelegate mEventHandlerDelegate;
    private final Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount = 1;
    private int mChannelMask = 4;
    private int mStreamType = 3;
    private final AudioAttributes mAttributes;
    private int mDataLoadMode = 1;
    private int mChannelConfiguration = 4;
    private int mChannelIndexMask = 0;
    private int mAudioFormat;
    private int mSessionId = 0;
    private final IAppOpsService mAppOps;
    private ByteBuffer mAvSyncHeader = null;
    private int mAvSyncBytesRemaining = 0;
    private long mNativeTrackInJavaObj;
    private long mJniData;
    private static final int SUPPORTED_OUT_CHANNELS = 7420;
    private AudioDeviceInfo mPreferredDevice = null;
    private ArrayMap<OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
        this(streamType, sampleRateInHz, channelConfig, audioFormat, bufferSizeInBytes, mode, 0);
    }

    public AudioTrack(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(streamType).build(), new AudioFormat.Builder().setChannelMask(channelConfig).setEncoding(audioFormat).setSampleRate(sampleRateInHz).build(), bufferSizeInBytes, mode, sessionId);
    }

    public AudioTrack(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        int rate = 0;
        if ((format.getPropertySetMask() & 2) != 0) {
            rate = format.getSampleRate();
        } else {
            rate = AudioSystem.getPrimaryOutputSamplingRate();
            if (rate <= 0) {
                rate = 44100;
            }
        }
        int channelIndexMask = 0;
        if ((format.getPropertySetMask() & 8) != 0) {
            channelIndexMask = format.getChannelIndexMask();
        }
        int channelMask = 0;
        if ((format.getPropertySetMask() & 4) != 0) {
            channelMask = format.getChannelMask();
        } else if (channelIndexMask == 0) {
            channelMask = 12;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(rate, channelMask, channelIndexMask, encoding, mode);
        this.mStreamType = -1;
        this.audioBuffSizeCheck(bufferSizeInBytes);
        this.mInitializationLooper = looper;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.mAttributes = new AudioAttributes.Builder(attributes).build();
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, this.mSampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSessionId = session[0];
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
    }

    private void audioParamCheck(int sampleRateInHz, int channelConfig, int channelIndexMask, int audioFormat, int mode) {
        if (sampleRateInHz < 4000 || sampleRateInHz > 192000) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannelMask = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannelMask = 12;
                break;
            }
            default: {
                if (channelConfig == 0 && channelIndexMask != 0) {
                    this.mChannelCount = 0;
                    break;
                }
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannelMask = channelConfig;
                this.mChannelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        this.mChannelIndexMask = channelIndexMask;
        if (this.mChannelIndexMask != 0) {
            int indexMask = 255;
            if ((channelIndexMask & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Unsupported channel index configuration " + channelIndexMask);
            }
            int channelIndexCount = Integer.bitCount(channelIndexMask);
            if (this.mChannelCount == 0) {
                this.mChannelCount = channelIndexCount;
            } else if (this.mChannelCount != channelIndexCount) {
                throw new IllegalArgumentException("Channel count must match");
            }
        }
        if (audioFormat == 1) {
            audioFormat = 2;
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = audioFormat;
        if (mode != 1 && mode != 0 || mode != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static boolean isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x1CFC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
        if (channelCount > 8) {
            AudioTrack.loge("Channel configuration contains too many channels " + channelCount + ">" + 8);
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        int sidePair = 6144;
        if ((channelConfig & 0x1800) != 0 && (channelConfig & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private void audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = AudioFormat.isEncodingLinearPcm(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public static float getMinVolume() {
        return 0.0f;
    }

    public static float getMaxVolume() {
        return 1.0f;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    public PlaybackParams getPlaybackParams() {
        return this.native_get_playback_params();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    public AudioFormat getFormat() {
        AudioFormat.Builder builder = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelConfiguration != 0) {
            builder.setChannelMask(this.mChannelConfiguration);
        }
        if (this.mChannelIndexMask != 0) {
            builder.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder.build();
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    public int getBufferSizeInFrames() {
        return this.native_get_native_frame_count();
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return this.native_get_native_frame_count();
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    public int getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    public int getLatency() {
        return this.native_get_latency();
    }

    public static int getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = AudioFormat.channelCountFromOutChannelMask(channelConfig);
            }
        }
        if (!AudioFormat.isPublicEncoding(audioFormat)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 192000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public boolean getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativePositionEventHandlerDelegate(this, listener, handler) : null;
    }

    private static float clampGainOrLevel(float gainOrLevel) {
        if (Float.isNaN(gainOrLevel)) {
            throw new IllegalArgumentException();
        }
        if (gainOrLevel < 0.0f) {
            gainOrLevel = 0.0f;
        } else if (gainOrLevel > 1.0f) {
            gainOrLevel = 1.0f;
        }
        return gainOrLevel;
    }

    public int setStereoVolume(float leftGain, float rightGain) {
        if (this.isRestricted()) {
            return 0;
        }
        if (this.mState == 0) {
            return -3;
        }
        leftGain = AudioTrack.clampGainOrLevel(leftGain);
        rightGain = AudioTrack.clampGainOrLevel(rightGain);
        this.native_setVolume(leftGain, rightGain);
        return 0;
    }

    public int setVolume(float gain) {
        return this.setStereoVolume(gain, gain);
    }

    public int setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    public void setPlaybackParams(PlaybackParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        this.native_set_playback_params(params);
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    public int setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    public int setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState == 0 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    @Deprecated
    protected void setState(int state) {
        this.mState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        if (this.isRestricted()) {
            this.setVolume(0.0f);
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_start();
            this.mPlayState = 3;
        }
    }

    private boolean isRestricted() {
        if ((this.mAttributes.getAllFlags() & 0x40) != 0) {
            return false;
        }
        try {
            int usage = AudioAttributes.usageForLegacyStreamType(this.mStreamType);
            int mode = this.mAppOps.checkAudioOperation(28, usage, Process.myUid(), ActivityThread.currentPackageName());
            return mode != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mPlayState = 1;
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.mPlayState = 2;
        }
    }

    public void flush() {
        if (this.mState == 1) {
            this.native_flush();
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
        }
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.write(audioData, offsetInBytes, sizeInBytes, 0);
    }

    public int write(byte[] audioData, int offsetInBytes, int sizeInBytes, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.write(audioData, offsetInShorts, sizeInShorts, 0);
    }

    public int write(short[] audioData, int offsetInShorts, int sizeInShorts, int writeMode) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e(TAG, "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            Log.e(TAG, "AudioTrack.write() called with invalid array, offset, or size");
            return -2;
        }
        int ret = this.native_write_float(audioData, offsetInFloats, sizeInFloats, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        int ret = 0;
        ret = audioData.isDirect() ? this.native_write_native_bytes(audioData, audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0) : this.native_write_byte(NioUtils.unsafeArray(audioData), NioUtils.unsafeArrayOffset(audioData) + audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        if (ret > 0) {
            audioData.position(audioData.position() + ret);
        }
        return ret;
    }

    public int write(ByteBuffer audioData, int sizeInBytes, int writeMode, long timestamp) {
        int sizeToWrite;
        if (this.mState == 0) {
            Log.e(TAG, "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e(TAG, "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (this.mDataLoadMode != 1) {
            Log.e(TAG, "AudioTrack.write() with timestamp called for non-streaming mode track");
            return -3;
        }
        if ((this.mAttributes.getFlags() & 0x10) == 0) {
            Log.d(TAG, "AudioTrack.write() called on a regular AudioTrack. Ignoring pts...");
            return this.write(audioData, sizeInBytes, writeMode);
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e(TAG, "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        if (this.mAvSyncHeader == null) {
            this.mAvSyncHeader = ByteBuffer.allocate(16);
            this.mAvSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.mAvSyncHeader.putInt(0x55550001);
            this.mAvSyncHeader.putInt(sizeInBytes);
            this.mAvSyncHeader.putLong(timestamp);
            this.mAvSyncHeader.position(0);
            this.mAvSyncBytesRemaining = sizeInBytes;
        }
        int ret = 0;
        if (this.mAvSyncHeader.remaining() != 0) {
            ret = this.write(this.mAvSyncHeader, this.mAvSyncHeader.remaining(), writeMode);
            if (ret < 0) {
                Log.e(TAG, "AudioTrack.write() could not write timestamp header!");
                this.mAvSyncHeader = null;
                this.mAvSyncBytesRemaining = 0;
                return ret;
            }
            if (this.mAvSyncHeader.remaining() > 0) {
                Log.v(TAG, "AudioTrack.write() partial timestamp header written.");
                return 0;
            }
        }
        if ((ret = this.write(audioData, sizeToWrite = Math.min(this.mAvSyncBytesRemaining, sizeInBytes), writeMode)) < 0) {
            Log.e(TAG, "AudioTrack.write() could not write audio data!");
            this.mAvSyncHeader = null;
            this.mAvSyncBytesRemaining = 0;
            return ret;
        }
        this.mAvSyncBytesRemaining -= ret;
        if (this.mAvSyncBytesRemaining == 0) {
            this.mAvSyncHeader = null;
        }
        return ret;
    }

    public int reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    public int attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    public int setAuxEffectSendLevel(float level) {
        if (this.isRestricted()) {
            return 0;
        }
        if (this.mState == 0) {
            return -3;
        }
        int err = this.native_setAuxEffectSendLevel(level = AudioTrack.clampGainOrLevel(level));
        return err == 0 ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSink()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setOutputDevice(preferredDeviceId);
        if (status) {
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioDeviceInfo getPreferredDevice() {
        AudioTrack audioTrack = this;
        synchronized (audioTrack) {
            return this.mPreferredDevice;
        }
    }

    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(2);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
            ArrayMap<OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
            synchronized (arrayMap) {
                if (this.mRoutingChangeListeners.size() == 0) {
                    this.native_enableDeviceCallback();
                }
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        ArrayMap<OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
            }
            if (this.mRoutingChangeListeners.size() == 0) {
                this.native_disableDeviceCallback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastRoutingChange() {
        Collection<NativeRoutingEventHandlerDelegate> values;
        ArrayMap<OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            values = this.mRoutingChangeListeners.values();
        }
        AudioManager.resetAudioPortGeneration();
        for (NativeRoutingEventHandlerDelegate delegate : values) {
            Handler handler = delegate.getHandler();
            if (handler == null) continue;
            handler.sendEmptyMessage(1000);
        }
    }

    private static void postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        if (what == 1000) {
            track.broadcastRoutingChange();
            return;
        }
        NativePositionEventHandlerDelegate delegate = track.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private int native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setup(Ljava/lang/Object;Ljava/lang/Object;IIIIII[I)I", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_finalize()V", true, this);
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_release()V", true, this);
    }

    private void native_start() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_start()V", true, this);
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_stop()V", true, this);
    }

    private void native_pause() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_pause()V", true, this);
    }

    private void native_flush() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_flush()V", true, this);
    }

    private int native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_byte([BIIIZ)I", true, this);
    }

    private int native_write_short(short[] sArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_short([SIIIZ)I", true, this);
    }

    private int native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_float([FIIIZ)I", true, this);
    }

    private int native_write_native_bytes(Object object, int n, int n2, int n3, boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_write_native_bytes(Ljava/lang/Object;IIIZ)I", true, this);
    }

    private int native_reload_static() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_reload_static()I", true, this);
    }

    private int native_get_native_frame_count() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_native_frame_count()I", true, this);
    }

    private void native_setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.AudioTrack#native_setVolume(FF)V", true, this);
    }

    private int native_set_playback_rate(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_playback_rate(I)I", true, this);
    }

    private int native_get_playback_rate() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_playback_rate()I", true, this);
    }

    private void native_set_playback_params(PlaybackParams playbackParams) {
        OverrideMethod.invokeV("android.media.AudioTrack#native_set_playback_params(Landroid/media/PlaybackParams;)V", true, this);
    }

    private PlaybackParams native_get_playback_params() {
        return (PlaybackParams)OverrideMethod.invokeA("android.media.AudioTrack#native_get_playback_params()Landroid/media/PlaybackParams;", true, this);
    }

    private int native_set_marker_pos(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_marker_pos(I)I", true, this);
    }

    private int native_get_marker_pos() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_marker_pos()I", true, this);
    }

    private int native_set_pos_update_period(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_pos_update_period(I)I", true, this);
    }

    private int native_get_pos_update_period() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_pos_update_period()I", true, this);
    }

    private int native_set_position(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_position(I)I", true, this);
    }

    private int native_get_position() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_position()I", true, this);
    }

    private int native_get_latency() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_latency()I", true, this);
    }

    private int native_get_timestamp(long[] lArray) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_timestamp([J)I", true, this);
    }

    private int native_set_loop(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_set_loop(III)I", true, this);
    }

    private static int native_get_output_sample_rate(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_output_sample_rate(I)I", true, null);
    }

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_get_min_buff_size(III)I", true, null);
    }

    private int native_attachAuxEffect(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_attachAuxEffect(I)I", true, this);
    }

    private int native_setAuxEffectSendLevel(float f) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setAuxEffectSendLevel(F)I", true, this);
    }

    private boolean native_setOutputDevice(int n) {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_setOutputDevice(I)Z", true, this) != 0;
    }

    private int native_getRoutedDeviceId() {
        return OverrideMethod.invokeI("android.media.AudioTrack#native_getRoutedDeviceId()I", true, this);
    }

    private void native_enableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_enableDeviceCallback()V", true, this);
    }

    private void native_disableDeviceCallback() {
        OverrideMethod.invokeV("android.media.AudioTrack#native_disableDeviceCallback()V", true, this);
    }

    private static void logd(String msg) {
        Log.d(TAG, msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, msg);
    }

    private class NativeRoutingEventHandlerDelegate {
        private final Handler mHandler;

        NativeRoutingEventHandlerDelegate(final AudioTrack track, final OnRoutingChangedListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    if (track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 1000: {
                            if (listener == null) break;
                            listener.onRoutingChanged(track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    private class NativePositionEventHandlerDelegate {
        private final Handler mHandler;

        NativePositionEventHandlerDelegate(final AudioTrack track, final OnPlaybackPositionUpdateListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : AudioTrack.this.mInitializationLooper;
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    if (track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (listener == null) break;
                            listener.onMarkerReached(track);
                            break;
                        }
                        case 4: {
                            if (listener == null) break;
                            listener.onPeriodicNotification(track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }
            } : null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnPlaybackPositionUpdateListener {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }

    public static interface OnRoutingChangedListener {
        public void onRoutingChanged(AudioTrack var1);
    }

    public static class Builder {
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private int mBufferSizeInBytes;
        private int mSessionId = 0;
        private int mMode = 1;

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        public Builder setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        public Builder setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        public Builder setTransferMode(int mode) throws IllegalArgumentException {
            switch (mode) {
                case 0: 
                case 1: {
                    this.mMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transfer mode " + mode);
                }
            }
            return this;
        }

        public Builder setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId != 0 && sessionId < 1) {
                throw new IllegalArgumentException("Invalid audio session ID " + sessionId);
            }
            this.mSessionId = sessionId;
            return this;
        }

        public AudioTrack build() throws UnsupportedOperationException {
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setChannelMask(12).setSampleRate(AudioSystem.getPrimaryOutputSamplingRate()).setEncoding(1).build();
            }
            try {
                AudioTrack track;
                if (this.mMode == 1 && this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((track = new AudioTrack(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mMode, this.mSessionId)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioTrack");
                }
                return track;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }
}

