/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.java.Objects;

public class AudioFocusInfo
implements Parcelable {
    private AudioAttributes mAttributes;
    private String mClientId;
    private String mPackageName;
    private int mGainRequest;
    private int mLossReceived;
    private int mFlags;
    public static final Parcelable.Creator<AudioFocusInfo> CREATOR = new Parcelable.Creator<AudioFocusInfo>(){

        @Override
        public AudioFocusInfo createFromParcel(Parcel in) {
            return new AudioFocusInfo(AudioAttributes.CREATOR.createFromParcel(in), in.readString(), in.readString(), in.readInt(), in.readInt(), in.readInt());
        }

        public AudioFocusInfo[] newArray(int size) {
            return new AudioFocusInfo[size];
        }
    };

    public AudioFocusInfo(AudioAttributes aa, String clientId, String packageName, int gainRequest, int lossReceived, int flags) {
        this.mAttributes = aa == null ? new AudioAttributes.Builder().build() : aa;
        this.mClientId = clientId == null ? "" : clientId;
        this.mPackageName = packageName == null ? "" : packageName;
        this.mGainRequest = gainRequest;
        this.mLossReceived = lossReceived;
        this.mFlags = flags;
    }

    public AudioAttributes getAttributes() {
        return this.mAttributes;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getGainRequest() {
        return this.mGainRequest;
    }

    public int getLossReceived() {
        return this.mLossReceived;
    }

    public void clearLossReceived() {
        this.mLossReceived = 0;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mAttributes.writeToParcel(dest, flags);
        dest.writeString(this.mClientId);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mGainRequest);
        dest.writeInt(this.mLossReceived);
        dest.writeInt(this.mFlags);
    }

    public int hashCode() {
        return Objects.hash(this.mAttributes, this.mClientId, this.mPackageName, this.mGainRequest, this.mFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AudioFocusInfo other = (AudioFocusInfo)obj;
        if (!this.mAttributes.equals(other.mAttributes)) {
            return false;
        }
        if (!this.mClientId.equals(other.mClientId)) {
            return false;
        }
        if (!this.mPackageName.equals(other.mPackageName)) {
            return false;
        }
        if (this.mGainRequest != other.mGainRequest) {
            return false;
        }
        if (this.mLossReceived != other.mLossReceived) {
            return false;
        }
        return this.mFlags == other.mFlags;
    }
}

