/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.NFRuleSet;
import android.icu.text.NFSubstitution;
import android.icu.text.RuleBasedNumberFormat;

class MultiplierSubstitution
extends NFSubstitution {
    double divisor;

    MultiplierSubstitution(int pos, double divisor, NFRuleSet ruleSet, RuleBasedNumberFormat formatter, String description) {
        super(pos, ruleSet, formatter, description);
        this.divisor = divisor;
        if (divisor == 0.0) {
            throw new IllegalStateException("Substitution with divisor 0 " + description.substring(0, pos) + " | " + description.substring(pos));
        }
    }

    @Override
    public void setDivisor(int radix, int exponent) {
        this.divisor = Math.pow(radix, exponent);
        if (this.divisor == 0.0) {
            throw new IllegalStateException("Substitution with divisor 0");
        }
    }

    @Override
    public boolean equals(Object that) {
        if (super.equals(that)) {
            MultiplierSubstitution that2 = (MultiplierSubstitution)that;
            return this.divisor == that2.divisor;
        }
        return false;
    }

    @Override
    public long transformNumber(long number) {
        return (long)Math.floor((double)number / this.divisor);
    }

    @Override
    public double transformNumber(double number) {
        if (this.ruleSet == null) {
            return number / this.divisor;
        }
        return Math.floor(number / this.divisor);
    }

    @Override
    public double composeRuleValue(double newRuleValue, double oldRuleValue) {
        return newRuleValue * this.divisor;
    }

    @Override
    public double calcUpperBound(double oldUpperBound) {
        return this.divisor;
    }

    @Override
    char tokenChar() {
        return '<';
    }
}

