/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.LocaleIDs;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;

public class ICUResourceTableAccess {
    public static String getTableString(String path, ULocale locale, String tableName, String itemName) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(path, locale.getBaseName());
        return ICUResourceTableAccess.getTableString(bundle, tableName, null, itemName);
    }

    public static String getTableString(ICUResourceBundle bundle, String tableName, String subtableName, String item) {
        String result = null;
        try {
            while (true) {
                String fallbackLocale;
                ICUResourceBundle table;
                if ((table = bundle.findWithFallback(tableName)) == null) {
                    return item;
                }
                ICUResourceBundle stable = table;
                if (subtableName != null) {
                    stable = table.findWithFallback(subtableName);
                }
                if (stable != null && (result = stable.findStringWithFallback(item)) != null) break;
                if (subtableName == null) {
                    String currentName = null;
                    if (tableName.equals("Countries")) {
                        currentName = LocaleIDs.getCurrentCountryID(item);
                    } else if (tableName.equals("Languages")) {
                        currentName = LocaleIDs.getCurrentLanguageID(item);
                    }
                    if (currentName != null && (result = table.findStringWithFallback(currentName)) != null) break;
                }
                if ((fallbackLocale = table.findStringWithFallback("Fallback")) == null) {
                    return item;
                }
                if (fallbackLocale.length() == 0) {
                    fallbackLocale = "root";
                }
                if (fallbackLocale.equals(table.getULocale().getName())) {
                    return item;
                }
                bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(bundle.getBaseName(), fallbackLocale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null && result.length() > 0 ? result : item;
    }
}

