/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.util.ArrayList;
import java.util.List;

public class CameraDeviceUserShim
implements ICameraDeviceUser {
    private static final String TAG = "CameraDeviceUserShim";
    private static final boolean DEBUG = false;
    private static final int OPEN_CAMERA_TIMEOUT_MS = 5000;
    private final LegacyCameraDevice mLegacyDevice;
    private final Object mConfigureLock = new Object();
    private int mSurfaceIdCounter;
    private boolean mConfiguring;
    private final SparseArray<Surface> mSurfaces;
    private final CameraCharacteristics mCameraCharacteristics;
    private final CameraLooper mCameraInit;
    private final CameraCallbackThread mCameraCallbacks;

    protected CameraDeviceUserShim(int cameraId, LegacyCameraDevice legacyCamera, CameraCharacteristics characteristics, CameraLooper cameraInit, CameraCallbackThread cameraCallbacks) {
        this.mLegacyDevice = legacyCamera;
        this.mConfiguring = false;
        this.mSurfaces = new SparseArray();
        this.mCameraCharacteristics = characteristics;
        this.mCameraInit = cameraInit;
        this.mCameraCallbacks = cameraCallbacks;
        this.mSurfaceIdCounter = 0;
    }

    public static CameraDeviceUserShim connectBinderShim(ICameraDeviceCallbacks callbacks, int cameraId) {
        CameraLooper init = new CameraLooper(cameraId);
        CameraCallbackThread threadCallbacks = new CameraCallbackThread(callbacks);
        int initErrors = init.waitForOpen(5000);
        Camera legacyCamera = init.getCamera();
        CameraBinderDecorator.throwOnError(initErrors);
        legacyCamera.disableShutterSound();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo(cameraId, info);
        Camera.Parameters legacyParameters = null;
        try {
            legacyParameters = legacyCamera.getParameters();
        }
        catch (RuntimeException e) {
            throw new CameraRuntimeException(3, "Unable to get initial parameters", e);
        }
        CameraCharacteristics characteristics = LegacyMetadataMapper.createCharacteristics(legacyParameters, info);
        LegacyCameraDevice device = new LegacyCameraDevice(cameraId, legacyCamera, characteristics, threadCallbacks);
        return new CameraDeviceUserShim(cameraId, device, characteristics, init, threadCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.mLegacyDevice.isClosed()) {
            Log.w(TAG, "Cannot disconnect, device has already been closed.");
        }
        try {
            this.mLegacyDevice.close();
        }
        finally {
            this.mCameraInit.close();
            this.mCameraCallbacks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int submitRequest(CaptureRequest request, boolean streaming, LongParcelable lastFrameNumber) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot submit request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot submit request, configuration change in progress.");
                return -38;
            }
        }
        return this.mLegacyDevice.submitRequest(request, streaming, lastFrameNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int submitRequestList(List<CaptureRequest> request, boolean streaming, LongParcelable lastFrameNumber) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot submit request list, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot submit request, configuration change in progress.");
                return -38;
            }
        }
        return this.mLegacyDevice.submitRequestList(request, streaming, lastFrameNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelRequest(int requestId, LongParcelable lastFrameNumber) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot cancel request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot cancel request, configuration change in progress.");
                return -38;
            }
        }
        long lastFrame = this.mLegacyDevice.cancelRequest(requestId);
        lastFrameNumber.setNumber(lastFrame);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int beginConfigure() {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot begin configure, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot begin configure, configuration change already in progress.");
                return -38;
            }
            this.mConfiguring = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int endConfigure(boolean isConstrainedHighSpeed) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot end configure, device has been closed.");
            return -19;
        }
        ArrayList<Surface> surfaces = null;
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot end configure, no configuration change in progress.");
                return -38;
            }
            int numSurfaces = this.mSurfaces.size();
            if (numSurfaces > 0) {
                surfaces = new ArrayList<Surface>();
                for (int i = 0; i < numSurfaces; ++i) {
                    surfaces.add(this.mSurfaces.valueAt(i));
                }
            }
            this.mConfiguring = false;
        }
        return this.mLegacyDevice.configureOutputs(surfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteStream(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot delete stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot delete stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            int index = this.mSurfaces.indexOfKey(streamId);
            if (index < 0) {
                Log.e(TAG, "Cannot delete stream, stream id " + streamId + " doesn't exist.");
                return -22;
            }
            this.mSurfaces.removeAt(index);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createStream(OutputConfiguration outputConfiguration) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot create stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot create stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            if (outputConfiguration.getRotation() != 0) {
                Log.e(TAG, "Cannot create stream, stream rotation is not supported.");
                return -38;
            }
            int id2 = ++this.mSurfaceIdCounter;
            this.mSurfaces.put(id2, outputConfiguration.getSurface());
            return id2;
        }
    }

    @Override
    public int createInputStream(int width, int height, int format) {
        Log.e(TAG, "creating input stream is not supported on legacy devices");
        return -38;
    }

    @Override
    public int getInputSurface(Surface surface) {
        Log.e(TAG, "getting input surface is not supported on legacy devices");
        return -38;
    }

    @Override
    public int createDefaultRequest(int templateId, CameraMetadataNative request) {
        CameraMetadataNative template;
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot create default request, device has been closed.");
            return -19;
        }
        try {
            template = LegacyMetadataMapper.createRequestTemplate(this.mCameraCharacteristics, templateId);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "createDefaultRequest - invalid templateId specified");
            return -22;
        }
        request.swap(template);
        return 0;
    }

    @Override
    public int getCameraInfo(CameraMetadataNative info) {
        Log.e(TAG, "getCameraInfo unimplemented.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitUntilIdle() throws RemoteException {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot wait until idle, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot wait until idle, configuration change in progress.");
                return -38;
            }
        }
        this.mLegacyDevice.waitUntilIdle();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(LongParcelable lastFrameNumber) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot flush, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot flush, configuration change in progress.");
                return -38;
            }
        }
        long lastFrame = this.mLegacyDevice.flush();
        if (lastFrameNumber != null) {
            lastFrameNumber.setNumber(lastFrame);
        }
        return 0;
    }

    @Override
    public int prepare(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot prepare stream, device has been closed.");
            return -19;
        }
        this.mCameraCallbacks.onPrepared(streamId);
        return 0;
    }

    @Override
    public int tearDown(int streamId) {
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot tear down stream, device has been closed.");
            return -19;
        }
        return 0;
    }

    @Override
    public IBinder asBinder() {
        return null;
    }

    private static class CameraCallbackThread
    implements ICameraDeviceCallbacks {
        private static final int CAMERA_ERROR = 0;
        private static final int CAMERA_IDLE = 1;
        private static final int CAPTURE_STARTED = 2;
        private static final int RESULT_RECEIVED = 3;
        private static final int PREPARED = 4;
        private final HandlerThread mHandlerThread;
        private Handler mHandler;
        private final ICameraDeviceCallbacks mCallbacks;

        public CameraCallbackThread(ICameraDeviceCallbacks callbacks) {
            this.mCallbacks = callbacks;
            this.mHandlerThread = new HandlerThread("LegacyCameraCallback");
            this.mHandlerThread.start();
        }

        public void close() {
            this.mHandlerThread.quitSafely();
        }

        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Message msg = this.getHandler().obtainMessage(0, errorCode, 0, resultExtras);
            this.getHandler().sendMessage(msg);
        }

        @Override
        public void onDeviceIdle() {
            Message msg = this.getHandler().obtainMessage(1);
            this.getHandler().sendMessage(msg);
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) {
            Message msg = this.getHandler().obtainMessage(2, (int)(timestamp & 0xFFFFFFFFL), (int)(timestamp >> 32 & 0xFFFFFFFFL), resultExtras);
            this.getHandler().sendMessage(msg);
        }

        @Override
        public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) {
            Object[] resultArray = new Object[]{result, resultExtras};
            Message msg = this.getHandler().obtainMessage(3, resultArray);
            this.getHandler().sendMessage(msg);
        }

        @Override
        public void onPrepared(int streamId) {
            Message msg = this.getHandler().obtainMessage(4, streamId, 0);
            this.getHandler().sendMessage(msg);
        }

        @Override
        public IBinder asBinder() {
            return null;
        }

        private Handler getHandler() {
            if (this.mHandler == null) {
                this.mHandler = new CallbackHandler(this.mHandlerThread.getLooper());
            }
            return this.mHandler;
        }

        private class CallbackHandler
        extends Handler {
            public CallbackHandler(Looper l) {
                super(l);
            }

            @Override
            public void handleMessage(Message msg) {
                try {
                    switch (msg.what) {
                        case 0: {
                            int errorCode = msg.arg1;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            CameraCallbackThread.this.mCallbacks.onDeviceError(errorCode, resultExtras);
                            break;
                        }
                        case 1: {
                            CameraCallbackThread.this.mCallbacks.onDeviceIdle();
                            break;
                        }
                        case 2: {
                            long timestamp = (long)msg.arg2 & 0xFFFFFFFFL;
                            timestamp = timestamp << 32 | (long)msg.arg1 & 0xFFFFFFFFL;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            CameraCallbackThread.this.mCallbacks.onCaptureStarted(resultExtras, timestamp);
                            break;
                        }
                        case 3: {
                            Object[] resultArray = (Object[])msg.obj;
                            CameraMetadataNative result = (CameraMetadataNative)resultArray[0];
                            CaptureResultExtras resultExtras = (CaptureResultExtras)resultArray[1];
                            CameraCallbackThread.this.mCallbacks.onResultReceived(result, resultExtras);
                            break;
                        }
                        case 4: {
                            int streamId = msg.arg1;
                            CameraCallbackThread.this.mCallbacks.onPrepared(streamId);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown callback message " + msg.what);
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new IllegalStateException("Received remote exception during camera callback " + msg.what, e);
                }
            }
        }
    }

    private static class CameraLooper
    implements Runnable,
    AutoCloseable {
        private final int mCameraId;
        private Looper mLooper;
        private volatile int mInitErrors;
        private final Camera mCamera = Camera.openUninitialized();
        private final ConditionVariable mStartDone = new ConditionVariable();
        private final Thread mThread;

        public CameraLooper(int cameraId) {
            this.mCameraId = cameraId;
            this.mThread = new Thread(this);
            this.mThread.start();
        }

        public Camera getCamera() {
            return this.mCamera;
        }

        @Override
        public void run() {
            Looper.prepare();
            this.mLooper = Looper.myLooper();
            this.mInitErrors = this.mCamera.cameraInitUnspecified(this.mCameraId);
            this.mStartDone.open();
            Looper.loop();
        }

        @Override
        public void close() {
            if (this.mLooper == null) {
                return;
            }
            this.mLooper.quitSafely();
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.mLooper = null;
        }

        public int waitForOpen(int timeoutMs) {
            if (!this.mStartDone.block(timeoutMs)) {
                Log.e(CameraDeviceUserShim.TAG, "waitForOpen - Camera failed to open after timeout of 5000 ms");
                try {
                    this.mCamera.release();
                }
                catch (RuntimeException e) {
                    Log.e(CameraDeviceUserShim.TAG, "connectBinderShim - Failed to release camera after timeout ", e);
                }
                throw new CameraRuntimeException(3);
            }
            return this.mInitErrors;
        }
    }
}

