/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.GetCommand;
import android.hardware.camera2.impl.SetCommand;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.marshal.impl.MarshalQueryableArray;
import android.hardware.camera2.marshal.impl.MarshalQueryableBlackLevelPattern;
import android.hardware.camera2.marshal.impl.MarshalQueryableBoolean;
import android.hardware.camera2.marshal.impl.MarshalQueryableColorSpaceTransform;
import android.hardware.camera2.marshal.impl.MarshalQueryableEnum;
import android.hardware.camera2.marshal.impl.MarshalQueryableHighSpeedVideoConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableMeteringRectangle;
import android.hardware.camera2.marshal.impl.MarshalQueryableNativeByteToInteger;
import android.hardware.camera2.marshal.impl.MarshalQueryablePair;
import android.hardware.camera2.marshal.impl.MarshalQueryableParcelable;
import android.hardware.camera2.marshal.impl.MarshalQueryablePrimitive;
import android.hardware.camera2.marshal.impl.MarshalQueryableRange;
import android.hardware.camera2.marshal.impl.MarshalQueryableRect;
import android.hardware.camera2.marshal.impl.MarshalQueryableReprocessFormatsMap;
import android.hardware.camera2.marshal.impl.MarshalQueryableRggbChannelVector;
import android.hardware.camera2.marshal.impl.MarshalQueryableSize;
import android.hardware.camera2.marshal.impl.MarshalQueryableSizeF;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfigurationDuration;
import android.hardware.camera2.marshal.impl.MarshalQueryableString;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.LensShadingMap;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

public class CameraMetadataNative
implements Parcelable {
    private static final String TAG = "CameraMetadataJV";
    private static final boolean DEBUG = false;
    public static final int NATIVE_JPEG_FORMAT = 33;
    private static final String CELLID_PROCESS = "CELLID";
    private static final String GPS_PROCESS = "GPS";
    private static final int FACE_LANDMARK_SIZE = 6;
    public static final Parcelable.Creator<CameraMetadataNative> CREATOR = new Parcelable.Creator<CameraMetadataNative>(){

        @Override
        public CameraMetadataNative createFromParcel(Parcel in) {
            CameraMetadataNative metadata = new CameraMetadataNative();
            metadata.readFromParcel(in);
            return metadata;
        }

        public CameraMetadataNative[] newArray(int size) {
            return new CameraMetadataNative[size];
        }
    };
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_INT32 = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_DOUBLE = 4;
    public static final int TYPE_RATIONAL = 5;
    public static final int NUM_TYPES = 6;
    private static final HashMap<Key<?>, GetCommand> sGetCommandMap = new HashMap();
    private static final HashMap<Key<?>, SetCommand> sSetCommandMap;
    private long mMetadataPtr;

    private static String translateLocationProviderToProcess(String provider) {
        if (provider == null) {
            return null;
        }
        String string2 = provider;
        int n = -1;
        switch (string2.hashCode()) {
            case 102570: {
                if (!string2.equals("gps")) break;
                n = 0;
                break;
            }
            case 1843485230: {
                if (!string2.equals("network")) break;
                n = 1;
            }
        }
        switch (n) {
            case 0: {
                return GPS_PROCESS;
            }
            case 1: {
                return CELLID_PROCESS;
            }
        }
        return null;
    }

    private static String translateProcessToLocationProvider(String process) {
        if (process == null) {
            return null;
        }
        String string2 = process;
        int n = -1;
        switch (string2.hashCode()) {
            case 70794: {
                if (!string2.equals(GPS_PROCESS)) break;
                n = 0;
                break;
            }
            case 1984215549: {
                if (!string2.equals(CELLID_PROCESS)) break;
                n = 1;
            }
        }
        switch (n) {
            case 0: {
                return "gps";
            }
            case 1: {
                return "network";
            }
        }
        return null;
    }

    public CameraMetadataNative() {
        this.mMetadataPtr = this.nativeAllocate();
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public CameraMetadataNative(CameraMetadataNative other) {
        this.mMetadataPtr = this.nativeAllocateCopy(other);
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public static CameraMetadataNative move(CameraMetadataNative other) {
        CameraMetadataNative newObject = new CameraMetadataNative();
        newObject.swap(other);
        return newObject;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.nativeWriteToParcel(dest);
    }

    public <T> T get(CameraCharacteristics.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureResult.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureRequest.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(Key<T> key) {
        Preconditions.checkNotNull(key, "key must not be null");
        GetCommand g = sGetCommandMap.get(key);
        if (g != null) {
            return g.getValue(this, key);
        }
        return this.getBase(key);
    }

    public void readFromParcel(Parcel in) {
        this.nativeReadFromParcel(in);
    }

    public static int nativeSetupGlobalVendorTagDescriptor() {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeSetupGlobalVendorTagDescriptor()I", true, null);
    }

    public <T> void set(Key<T> key, T value) {
        SetCommand s = sSetCommandMap.get(key);
        if (s != null) {
            s.setValue(this, value);
            return;
        }
        this.setBase(key, value);
    }

    public <T> void set(CaptureRequest.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    public <T> void set(CaptureResult.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    public <T> void set(CameraCharacteristics.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    private void close() {
        this.nativeClose();
        this.mMetadataPtr = 0L;
    }

    private <T> T getBase(CameraCharacteristics.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureResult.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureRequest.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(Key<T> key) {
        int tag = key.getTag();
        byte[] values = this.readValues(tag);
        if (values == null) {
            return null;
        }
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key);
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        return marshaler.unmarshal(buffer);
    }

    private int[] getAvailableFormats() {
        int[] availableFormats = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS);
        if (availableFormats != null) {
            for (int i = 0; i < availableFormats.length; ++i) {
                if (availableFormats[i] != 33) continue;
                availableFormats[i] = 256;
            }
        }
        return availableFormats;
    }

    private boolean setFaces(Face[] faces) {
        if (faces == null) {
            return false;
        }
        int numFaces = faces.length;
        boolean fullMode = true;
        for (Face face : faces) {
            if (face == null) {
                --numFaces;
                Log.w(TAG, "setFaces - null face detected, skipping");
                continue;
            }
            if (face.getId() != -1) continue;
            fullMode = false;
        }
        Rect[] faceRectangles = new Rect[numFaces];
        byte[] faceScores = new byte[numFaces];
        int[] faceIds = null;
        int[] faceLandmarks = null;
        if (fullMode) {
            faceIds = new int[numFaces];
            faceLandmarks = new int[numFaces * 6];
        }
        int i = 0;
        for (Face face : faces) {
            if (face == null) continue;
            faceRectangles[i] = face.getBounds();
            faceScores[i] = (byte)face.getScore();
            if (fullMode) {
                faceIds[i] = face.getId();
                int j = 0;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().x;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().y;
            }
            ++i;
        }
        this.set(CaptureResult.STATISTICS_FACE_RECTANGLES, faceRectangles);
        this.set(CaptureResult.STATISTICS_FACE_IDS, faceIds);
        this.set(CaptureResult.STATISTICS_FACE_LANDMARKS, faceLandmarks);
        this.set(CaptureResult.STATISTICS_FACE_SCORES, faceScores);
        return true;
    }

    private Face[] getFaces() {
        int i;
        int[] faceLandmarks;
        int[] faceIds;
        Rect[] faceRectangles;
        byte[] faceScores;
        Integer faceDetectMode = this.get(CaptureResult.STATISTICS_FACE_DETECT_MODE);
        if (CameraMetadataNative.areValuesAllNull(faceDetectMode, faceScores = this.get(CaptureResult.STATISTICS_FACE_SCORES), faceRectangles = this.get(CaptureResult.STATISTICS_FACE_RECTANGLES), faceIds = this.get(CaptureResult.STATISTICS_FACE_IDS), faceLandmarks = this.get(CaptureResult.STATISTICS_FACE_LANDMARKS))) {
            return null;
        }
        if (faceDetectMode == null) {
            Log.w(TAG, "Face detect mode metadata is null, assuming the mode is SIMPLE");
            faceDetectMode = 1;
        } else {
            if (faceDetectMode == 0) {
                return new Face[0];
            }
            if (faceDetectMode != 1 && faceDetectMode != 2) {
                Log.w(TAG, "Unknown face detect mode: " + faceDetectMode);
                return new Face[0];
            }
        }
        if (faceScores == null || faceRectangles == null) {
            Log.w(TAG, "Expect face scores and rectangles to be non-null");
            return new Face[0];
        }
        if (faceScores.length != faceRectangles.length) {
            Log.w(TAG, String.format("Face score size(%d) doesn match face rectangle size(%d)!", faceScores.length, faceRectangles.length));
        }
        int numFaces = Math.min(faceScores.length, faceRectangles.length);
        if (faceDetectMode == 2) {
            if (faceIds == null || faceLandmarks == null) {
                Log.w(TAG, "Expect face ids and landmarks to be non-null for FULL mode,fallback to SIMPLE mode");
                faceDetectMode = 1;
            } else {
                if (faceIds.length != numFaces || faceLandmarks.length != numFaces * 6) {
                    Log.w(TAG, String.format("Face id size(%d), or face landmark size(%d) don'tmatch face number(%d)!", faceIds.length, faceLandmarks.length * 6, numFaces));
                }
                numFaces = Math.min(numFaces, faceIds.length);
                numFaces = Math.min(numFaces, faceLandmarks.length / 6);
            }
        }
        ArrayList<Face> faceList = new ArrayList<Face>();
        if (faceDetectMode == 1) {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1) continue;
                faceList.add(new Face(faceRectangles[i], faceScores[i]));
            }
        } else {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1 || faceIds[i] < 0) continue;
                Point leftEye = new Point(faceLandmarks[i * 6], faceLandmarks[i * 6 + 1]);
                Point rightEye = new Point(faceLandmarks[i * 6 + 2], faceLandmarks[i * 6 + 3]);
                Point mouth = new Point(faceLandmarks[i * 6 + 4], faceLandmarks[i * 6 + 5]);
                Face face = new Face(faceRectangles[i], faceScores[i], faceIds[i], leftEye, rightEye, mouth);
                faceList.add(face);
            }
        }
        Face[] faces = new Face[faceList.size()];
        faceList.toArray(faces);
        return faces;
    }

    private Rect[] getFaceRectangles() {
        Rect[] faceRectangles = this.getBase(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (faceRectangles == null) {
            return null;
        }
        Rect[] fixedFaceRectangles = new Rect[faceRectangles.length];
        for (int i = 0; i < faceRectangles.length; ++i) {
            fixedFaceRectangles[i] = new Rect(faceRectangles[i].left, faceRectangles[i].top, faceRectangles[i].right - faceRectangles[i].left, faceRectangles[i].bottom - faceRectangles[i].top);
        }
        return fixedFaceRectangles;
    }

    private LensShadingMap getLensShadingMap() {
        float[] lsmArray = this.getBase(CaptureResult.STATISTICS_LENS_SHADING_MAP);
        Size s = this.get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE);
        if (lsmArray == null) {
            return null;
        }
        if (s == null) {
            Log.w(TAG, "getLensShadingMap - Lens shading map size was null.");
            return null;
        }
        LensShadingMap map = new LensShadingMap(lsmArray, s.getHeight(), s.getWidth());
        return map;
    }

    private Location getGpsLocation() {
        String processingMethod = this.get(CaptureResult.JPEG_GPS_PROCESSING_METHOD);
        double[] coords = this.get(CaptureResult.JPEG_GPS_COORDINATES);
        Long timeStamp = this.get(CaptureResult.JPEG_GPS_TIMESTAMP);
        if (CameraMetadataNative.areValuesAllNull(processingMethod, coords, timeStamp)) {
            return null;
        }
        Location l = new Location(CameraMetadataNative.translateProcessToLocationProvider(processingMethod));
        if (timeStamp != null) {
            l.setTime(timeStamp);
        } else {
            Log.w(TAG, "getGpsLocation - No timestamp for GPS location.");
        }
        if (coords != null) {
            l.setLatitude(coords[0]);
            l.setLongitude(coords[1]);
            l.setAltitude(coords[2]);
        } else {
            Log.w(TAG, "getGpsLocation - No coordinates for GPS location");
        }
        return l;
    }

    private boolean setGpsLocation(Location l) {
        if (l == null) {
            return false;
        }
        double[] coords = new double[]{l.getLatitude(), l.getLongitude(), l.getAltitude()};
        String processMethod = CameraMetadataNative.translateLocationProviderToProcess(l.getProvider());
        long timestamp = l.getTime();
        this.set(CaptureRequest.JPEG_GPS_TIMESTAMP, Long.valueOf(timestamp));
        this.set(CaptureRequest.JPEG_GPS_COORDINATES, coords);
        if (processMethod == null) {
            Log.w(TAG, "setGpsLocation - No process method, Location is not from a GPS or NETWORKprovider");
        } else {
            this.setBase(CaptureRequest.JPEG_GPS_PROCESSING_METHOD, processMethod);
        }
        return true;
    }

    private StreamConfigurationMap getStreamConfigurationMap() {
        StreamConfiguration[] configurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] minFrameDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] stallDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STALL_DURATIONS);
        StreamConfiguration[] depthConfigurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] depthMinFrameDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] depthStallDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STALL_DURATIONS);
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurations = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS);
        ReprocessFormatsMap inputOutputFormatsMap = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP);
        int[] capabilities = this.getBase(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean listHighResolution = false;
        for (int capability : capabilities) {
            if (capability != 6) continue;
            listHighResolution = true;
            break;
        }
        return new StreamConfigurationMap(configurations, minFrameDurations, stallDurations, depthConfigurations, depthMinFrameDurations, depthStallDurations, highSpeedVideoConfigurations, inputOutputFormatsMap, listHighResolution);
    }

    private <T> Integer getMaxRegions(Key<T> key) {
        boolean AE = false;
        boolean AWB = true;
        int AF = 2;
        int[] maxRegions = this.getBase(CameraCharacteristics.CONTROL_MAX_REGIONS);
        if (maxRegions == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AE)) {
            return maxRegions[0];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB)) {
            return maxRegions[1];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AF)) {
            return maxRegions[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private <T> Integer getMaxNumOutputs(Key<T> key) {
        boolean RAW = false;
        boolean PROC = true;
        int PROC_STALLING = 2;
        int[] maxNumOutputs = this.getBase(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS);
        if (maxNumOutputs == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW)) {
            return maxNumOutputs[0];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC)) {
            return maxNumOutputs[1];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING)) {
            return maxNumOutputs[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private <T> TonemapCurve getTonemapCurve() {
        float[] blue;
        float[] green;
        float[] red = this.getBase(CaptureRequest.TONEMAP_CURVE_RED);
        if (CameraMetadataNative.areValuesAllNull(red, green = this.getBase(CaptureRequest.TONEMAP_CURVE_GREEN), blue = this.getBase(CaptureRequest.TONEMAP_CURVE_BLUE))) {
            return null;
        }
        if (red == null || green == null || blue == null) {
            Log.w(TAG, "getTonemapCurve - missing tone curve components");
            return null;
        }
        TonemapCurve tc = new TonemapCurve(red, green, blue);
        return tc;
    }

    private <T> void setBase(CameraCharacteristics.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(CaptureResult.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(CaptureRequest.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(Key<T> key, T value) {
        int tag = key.getTag();
        if (value == null) {
            this.writeValues(tag, null);
            return;
        }
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key);
        int size = marshaler.calculateMarshalSize(value);
        byte[] values = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        marshaler.marshal(value, buffer);
        this.writeValues(tag, values);
    }

    private boolean setAvailableFormats(int[] value) {
        int[] availableFormat = value;
        if (value == null) {
            return false;
        }
        int[] newValues = new int[availableFormat.length];
        for (int i = 0; i < availableFormat.length; ++i) {
            newValues[i] = availableFormat[i];
            if (availableFormat[i] != 256) continue;
            newValues[i] = 33;
        }
        this.setBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS, newValues);
        return true;
    }

    private boolean setFaceRectangles(Rect[] faceRects) {
        if (faceRects == null) {
            return false;
        }
        Rect[] newFaceRects = new Rect[faceRects.length];
        for (int i = 0; i < newFaceRects.length; ++i) {
            newFaceRects[i] = new Rect(faceRects[i].left, faceRects[i].top, faceRects[i].right + faceRects[i].left, faceRects[i].bottom + faceRects[i].top);
        }
        this.setBase(CaptureResult.STATISTICS_FACE_RECTANGLES, newFaceRects);
        return true;
    }

    private <T> boolean setTonemapCurve(TonemapCurve tc) {
        if (tc == null) {
            return false;
        }
        float[][] curve = new float[3][];
        for (int i = 0; i <= 2; ++i) {
            int pointCount = tc.getPointCount(i);
            curve[i] = new float[pointCount * 2];
            tc.copyColorCurve(i, curve[i], 0);
        }
        this.setBase(CaptureRequest.TONEMAP_CURVE_RED, curve[0]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_GREEN, curve[1]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_BLUE, curve[2]);
        return true;
    }

    private long nativeAllocate() {
        return OverrideMethod.invokeL("android.hardware.camera2.impl.CameraMetadataNative#nativeAllocate()J", true, this);
    }

    private long nativeAllocateCopy(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
        return OverrideMethod.invokeL("android.hardware.camera2.impl.CameraMetadataNative#nativeAllocateCopy(Landroid/hardware/camera2/impl/CameraMetadataNative;)J", true, this);
    }

    private synchronized void nativeWriteToParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeWriteToParcel(Landroid/os/Parcel;)V", true, this);
    }

    private synchronized void nativeReadFromParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeReadFromParcel(Landroid/os/Parcel;)V", true, this);
    }

    private synchronized void nativeSwap(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeSwap(Landroid/hardware/camera2/impl/CameraMetadataNative;)V", true, this);
    }

    private synchronized void nativeClose() {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeClose()V", true, this);
    }

    private synchronized boolean nativeIsEmpty() {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeIsEmpty()Z", true, this) != 0;
    }

    private synchronized int nativeGetEntryCount() {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetEntryCount()I", true, this);
    }

    private synchronized byte[] nativeReadValues(int n) {
        return (byte[])OverrideMethod.invokeA("android.hardware.camera2.impl.CameraMetadataNative#nativeReadValues(I)[B", true, this);
    }

    private synchronized void nativeWriteValues(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeWriteValues(I[B)V", true, this);
    }

    private synchronized void nativeDump() throws IOException {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeDump()V", true, this);
    }

    private static ArrayList nativeGetAllVendorKeys(Class clazz) {
        return (ArrayList)OverrideMethod.invokeA("android.hardware.camera2.impl.CameraMetadataNative#nativeGetAllVendorKeys(Ljava/lang/Class;)Ljava/util/ArrayList;", true, null);
    }

    private static int nativeGetTagFromKey(String string2) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTagFromKey(Ljava/lang/String;)I", true, null);
    }

    private static int nativeGetTypeFromTag(int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTypeFromTag(I)I", true, null);
    }

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeClassInit()V", true, null);
    }

    public void swap(CameraMetadataNative other) {
        this.nativeSwap(other);
    }

    public int getEntryCount() {
        return this.nativeGetEntryCount();
    }

    public boolean isEmpty() {
        return this.nativeIsEmpty();
    }

    public static <K> ArrayList<K> getAllVendorKeys(Class<K> keyClass) {
        if (keyClass == null) {
            throw new NullPointerException();
        }
        return CameraMetadataNative.nativeGetAllVendorKeys(keyClass);
    }

    public static int getTag(String key) {
        return CameraMetadataNative.nativeGetTagFromKey(key);
    }

    public static int getNativeType(int tag) {
        return CameraMetadataNative.nativeGetTypeFromTag(tag);
    }

    public void writeValues(int tag, byte[] src) {
        this.nativeWriteValues(tag, src);
    }

    public byte[] readValues(int tag) {
        return this.nativeReadValues(tag);
    }

    public void dumpToLog() {
        try {
            this.nativeDump();
        }
        catch (IOException e) {
            Log.wtf(TAG, "Dump logging failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static <T> Marshaler<T> getMarshalerForKey(Key<T> key) {
        return MarshalRegistry.getMarshaler(key.getTypeReference(), CameraMetadataNative.getNativeType(key.getTag()));
    }

    private static void registerAllMarshalers() {
        MarshalQueryable[] queryList;
        for (MarshalQueryable query : queryList = new MarshalQueryable[]{new MarshalQueryablePrimitive(), new MarshalQueryableEnum(), new MarshalQueryableArray(), new MarshalQueryableBoolean(), new MarshalQueryableNativeByteToInteger(), new MarshalQueryableRect(), new MarshalQueryableSize(), new MarshalQueryableSizeF(), new MarshalQueryableString(), new MarshalQueryableReprocessFormatsMap(), new MarshalQueryableRange(), new MarshalQueryablePair(), new MarshalQueryableMeteringRectangle(), new MarshalQueryableColorSpaceTransform(), new MarshalQueryableStreamConfiguration(), new MarshalQueryableStreamConfigurationDuration(), new MarshalQueryableRggbChannelVector(), new MarshalQueryableBlackLevelPattern(), new MarshalQueryableHighSpeedVideoConfiguration(), new MarshalQueryableParcelable()}) {
            MarshalRegistry.registerMarshalQueryable(query);
        }
    }

    private static boolean areValuesAllNull(Object ... objs) {
        for (Object o : objs) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    static {
        sGetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getAvailableFormats();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaces();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaceRectangles();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getStreamConfigurationMap();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AF.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getTonemapCurve();
            }
        });
        sGetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getGpsLocation();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_LENS_SHADING_CORRECTION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getLensShadingMap();
            }
        });
        sSetCommandMap = new HashMap();
        sSetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setAvailableFormats((int[])value);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaceRectangles((Rect[])value);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaces((Face[])value);
            }
        });
        sSetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setTonemapCurve((TonemapCurve)value);
            }
        });
        sSetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setGpsLocation((Location)value);
            }
        });
        CameraMetadataNative.nativeClassInit();
        CameraMetadataNative.registerAllMarshalers();
    }

    public static class Key<T> {
        private boolean mHasTag;
        private int mTag;
        private final Class<T> mType;
        private final TypeReference<T> mTypeReference;
        private final String mName;
        private final int mHash;

        public Key(String name, Class<T> type) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (type == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = name;
            this.mType = type;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(type);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public Key(String name, TypeReference<T> typeReference) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (typeReference == null) {
                throw new NullPointerException("TypeReference needs to be non-null");
            }
            this.mName = name;
            this.mType = typeReference.getRawType();
            this.mTypeReference = typeReference;
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public String getName() {
            return this.mName;
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            Key lhs;
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            if (o instanceof CaptureResult.Key) {
                lhs = ((CaptureResult.Key)o).getNativeKey();
            } else if (o instanceof CaptureRequest.Key) {
                lhs = ((CaptureRequest.Key)o).getNativeKey();
            } else if (o instanceof CameraCharacteristics.Key) {
                lhs = ((CameraCharacteristics.Key)o).getNativeKey();
            } else if (o instanceof Key) {
                lhs = (Key)o;
            } else {
                return false;
            }
            return this.mName.equals(lhs.mName) && this.mTypeReference.equals(lhs.mTypeReference);
        }

        public int getTag() {
            if (!this.mHasTag) {
                this.mTag = CameraMetadataNative.getTag(this.mName);
                this.mHasTag = true;
            }
            return this.mTag;
        }

        public Class<T> getType() {
            return this.mType;
        }

        public TypeReference<T> getTypeReference() {
            return this.mTypeReference;
        }
    }
}

