/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.CameraInfo;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.CameraDeviceUserShim;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.BinderHolder;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.CameraServiceBinderDecorator;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;

public class CameraManager {
    private static final String TAG = "CameraManager";
    private final boolean DEBUG = false;
    private static final int USE_CALLING_UID = -1;
    private static final int API_VERSION_1 = 1;
    private static final int API_VERSION_2 = 2;
    private static final int CAMERA_TYPE_BACKWARD_COMPATIBLE = 0;
    private static final int CAMERA_TYPE_ALL = 1;
    private ArrayList<String> mDeviceIdList;
    private final Context mContext;
    private final Object mLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraManager(Context context) {
        Object object = this.mLock = new Object();
        synchronized (object) {
            this.mContext = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCameraIdList() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDeviceIdListLocked().toArray(new String[0]);
        }
    }

    public void registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, handler);
    }

    public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
        CameraManagerGlobal.get().unregisterAvailabilityCallback(callback);
    }

    public void registerTorchCallback(TorchCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        CameraManagerGlobal.get().registerTorchCallback(callback, handler);
    }

    public void unregisterTorchCallback(TorchCallback callback) {
        CameraManagerGlobal.get().unregisterTorchCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraCharacteristics getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.getOrCreateDeviceIdListLocked().contains(cameraId)) {
                throw new IllegalArgumentException(String.format("Camera id %s does not match any currently connected camera device", cameraId));
            }
            int id2 = Integer.valueOf(cameraId);
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                if (!this.supportsCamera2ApiLocked(cameraId)) {
                    String[] outParameters = new String[1];
                    cameraService.getLegacyParameters(id2, outParameters);
                    String parameters = outParameters[0];
                    CameraInfo info = new CameraInfo();
                    cameraService.getCameraInfo(id2, info);
                    characteristics = LegacyMetadataMapper.createCharacteristics(parameters, info);
                } else {
                    CameraMetadataNative info = new CameraMetadataNative();
                    cameraService.getCameraCharacteristics(id2, info);
                    characteristics = new CameraCharacteristics(info);
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        try {
            Object object = this.mLock;
            synchronized (object) {
                ICameraDeviceUser cameraUser = null;
                CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, handler, characteristics);
                BinderHolder holder = new BinderHolder();
                CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
                int id2 = Integer.parseInt(cameraId);
                try {
                    if (this.supportsCamera2ApiLocked(cameraId)) {
                        ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
                        if (cameraService == null) {
                            throw new CameraRuntimeException(2, "Camera service is currently unavailable");
                        }
                        cameraService.connectDevice(callbacks, id2, this.mContext.getOpPackageName(), -1, holder);
                        cameraUser = ICameraDeviceUser.Stub.asInterface(holder.getBinder());
                    } else {
                        Log.i(TAG, "Using legacy camera HAL.");
                        cameraUser = CameraDeviceUserShim.connectBinderShim(callbacks, id2);
                    }
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() == 1000) {
                        throw new AssertionError((Object)"Should've gone down the shim path");
                    }
                    if (e.getReason() == 4 || e.getReason() == 5 || e.getReason() == 1 || e.getReason() == 2 || e.getReason() == 3) {
                        deviceImpl.setRemoteFailure(e);
                        if (e.getReason() == 1 || e.getReason() == 2 || e.getReason() == 4) {
                            throw e.asChecked();
                        }
                    }
                    throw e;
                }
                catch (RemoteException e) {
                    CameraRuntimeException ce = new CameraRuntimeException(2, "Camera service is currently unavailable", e);
                    deviceImpl.setRemoteFailure(ce);
                    throw ce.asChecked();
                }
                deviceImpl.setRemoteDevice(cameraUser);
                device = deviceImpl;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + cameraId);
        }
        catch (CameraRuntimeException e) {
            throw e.asChecked();
        }
        return device;
    }

    public void openCamera(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (handler == null) {
            if (Looper.myLooper() != null) {
                handler = new Handler();
            } else {
                throw new IllegalArgumentException("Handler argument is null, but no looper exists in the calling thread");
            }
        }
        this.openCameraDeviceUserAsync(cameraId, callback, handler);
    }

    public void setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
        CameraManagerGlobal.get().setTorchMode(cameraId, enabled);
    }

    private ArrayList<String> getOrCreateDeviceIdListLocked() throws CameraAccessException {
        if (this.mDeviceIdList == null) {
            int numCameras = 0;
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            ArrayList<String> deviceIdList = new ArrayList<String>();
            if (cameraService == null) {
                return deviceIdList;
            }
            try {
                numCameras = cameraService.getNumberOfCameras(1);
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return deviceIdList;
            }
            CameraMetadataNative info = new CameraMetadataNative();
            for (int i = 0; i < numCameras; ++i) {
                boolean isDeviceSupported = false;
                try {
                    cameraService.getCameraCharacteristics(i, info);
                    if (info.isEmpty()) {
                        throw new AssertionError((Object)"Expected to get non-empty characteristics");
                    }
                    isDeviceSupported = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() != 2) {
                        throw e.asChecked();
                    }
                }
                catch (RemoteException e) {
                    deviceIdList.clear();
                    return deviceIdList;
                }
                if (isDeviceSupported) {
                    deviceIdList.add(String.valueOf(i));
                    continue;
                }
                Log.w(TAG, "Error querying camera device " + i + " for listing.");
            }
            this.mDeviceIdList = deviceIdList;
        }
        return this.mDeviceIdList;
    }

    private boolean supportsCamera2ApiLocked(String cameraId) {
        return this.supportsCameraApiLocked(cameraId, 2);
    }

    private boolean supportsCameraApiLocked(String cameraId, int apiVersion) {
        int id2 = Integer.parseInt(cameraId);
        try {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                return false;
            }
            int res = cameraService.supportsCameraApi(id2, apiVersion);
            if (res != 0) {
                throw new AssertionError((Object)("Unexpected value " + res));
            }
            return true;
        }
        catch (CameraRuntimeException e) {
            if (e.getReason() != 1000) {
                throw e;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private static class CameraManagerGlobal
    extends ICameraServiceListener.Stub
    implements IBinder.DeathRecipient {
        private static final String TAG = "CameraManagerGlobal";
        private final boolean DEBUG = false;
        private final int CAMERA_SERVICE_RECONNECT_DELAY_MS = 1000;
        private static final CameraManagerGlobal gCameraManager = new CameraManagerGlobal();
        private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
        public static final int STATUS_NOT_PRESENT = 0;
        public static final int STATUS_PRESENT = 1;
        public static final int STATUS_ENUMERATING = 2;
        public static final int STATUS_NOT_AVAILABLE = Integer.MIN_VALUE;
        private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();
        private final ArrayMap<AvailabilityCallback, Handler> mCallbackMap = new ArrayMap();
        public static final int TORCH_STATUS_NOT_AVAILABLE = 0;
        public static final int TORCH_STATUS_AVAILABLE_OFF = 1;
        public static final int TORCH_STATUS_AVAILABLE_ON = 2;
        private Binder mTorchClientBinder = new Binder();
        private final ArrayMap<String, Integer> mTorchStatus = new ArrayMap();
        private final ArrayMap<TorchCallback, Handler> mTorchCallbackMap = new ArrayMap();
        private final Object mLock = new Object();
        private ICameraService mCameraService;

        private CameraManagerGlobal() {
        }

        public static CameraManagerGlobal get() {
            return gCameraManager;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICameraService getCameraService() {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                if (this.mCameraService == null) {
                    Log.e(TAG, "Camera service is unavailable");
                }
                return this.mCameraService;
            }
        }

        private void connectCameraServiceLocked() {
            if (this.mCameraService != null) {
                return;
            }
            Log.i(TAG, "Connecting to camera service");
            IBinder cameraServiceBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
            if (cameraServiceBinder == null) {
                return;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                return;
            }
            ICameraService cameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
            ICameraService cameraService = CameraServiceBinderDecorator.newInstance(cameraServiceRaw);
            try {
                CameraServiceBinderDecorator.throwOnError(CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor());
            }
            catch (CameraRuntimeException e) {
                this.handleRecoverableSetupErrors(e, "Failed to set up vendor tags");
            }
            try {
                cameraService.addListener(this);
                this.mCameraService = cameraService;
            }
            catch (CameraRuntimeException e) {
                throw new IllegalStateException("Failed to register a camera service listener", e.asChecked());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
                try {
                    int n = cameraService.setTorchMode(cameraId, enabled, this.mTorchClientBinder);
                }
                catch (CameraRuntimeException e) {
                    int problem = e.getReason();
                    switch (problem) {
                        case 3: {
                            throw new IllegalArgumentException("the camera device doesn't have a flash unit.");
                        }
                    }
                    throw e.asChecked();
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
            }
        }

        private void handleRecoverableSetupErrors(CameraRuntimeException e, String msg) {
            int problem = e.getReason();
            switch (problem) {
                case 2: {
                    String errorMsg = CameraAccessException.getDefaultMessage(problem);
                    Log.w(TAG, msg + ": " + errorMsg);
                    break;
                }
                default: {
                    throw new IllegalStateException(msg, e.asChecked());
                }
            }
        }

        private boolean isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean validStatus(int status) {
            switch (status) {
                case -2147483648: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private boolean validTorchStatus(int status) {
            switch (status) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private void postSingleUpdate(final AvailabilityCallback callback, Handler handler, final String id2, int status) {
            if (this.isAvailable(status)) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraAvailable(id2);
                    }
                });
            } else {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraUnavailable(id2);
                    }
                });
            }
        }

        private void postSingleTorchUpdate(final TorchCallback callback, Handler handler, final String id2, final int status) {
            switch (status) {
                case 1: 
                case 2: {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTorchModeChanged(id2, status == 2);
                        }
                    });
                    break;
                }
                default: {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTorchModeUnavailable(id2);
                        }
                    });
                }
            }
        }

        private void updateCallbackLocked(AvailabilityCallback callback, Handler handler) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                String id2 = this.mDeviceStatus.keyAt(i);
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        private void onStatusChangedLocked(int status, String id2) {
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mDeviceStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = this.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        private void updateTorchCallbackLocked(TorchCallback callback, Handler handler) {
            for (int i = 0; i < this.mTorchStatus.size(); ++i) {
                String id2 = this.mTorchStatus.keyAt(i);
                Integer status = this.mTorchStatus.valueAt(i);
                this.postSingleTorchUpdate(callback, handler, id2, status);
            }
        }

        private void onTorchStatusChangedLocked(int status, String id2) {
            if (!this.validTorchStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s torch status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mTorchStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            int callbackCount = this.mTorchCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = this.mTorchCallbackMap.valueAt(i);
                TorchCallback callback = this.mTorchCallbackMap.keyAt(i);
                this.postSingleTorchUpdate(callback, handler, id2, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Handler oldHandler = this.mCallbackMap.put(callback, handler);
                if (oldHandler == null) {
                    this.updateCallbackLocked(callback, handler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerTorchCallback(TorchCallback callback, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Handler oldHandler = this.mTorchCallbackMap.put(callback, handler);
                if (oldHandler == null) {
                    this.updateTorchCallbackLocked(callback, handler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterTorchCallback(TorchCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTorchCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(int status, int cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(status, String.valueOf(cameraId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTorchStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onTorchStatusChangedLocked(status, cameraId);
            }
        }

        private void scheduleCameraServiceReconnectionLocked() {
            Handler handler;
            if (this.mCallbackMap.size() > 0) {
                handler = this.mCallbackMap.valueAt(0);
            } else if (this.mTorchCallbackMap.size() > 0) {
                handler = this.mTorchCallbackMap.valueAt(0);
            } else {
                return;
            }
            handler.postDelayed(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ICameraService cameraService = CameraManagerGlobal.this.getCameraService();
                    if (cameraService == null) {
                        Object object = CameraManagerGlobal.this.mLock;
                        synchronized (object) {
                            CameraManagerGlobal.this.scheduleCameraServiceReconnectionLocked();
                        }
                    }
                }
            }, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = this.mLock;
            synchronized (object) {
                String cameraId;
                int i;
                if (this.mCameraService == null) {
                    return;
                }
                this.mCameraService = null;
                for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                    cameraId = this.mDeviceStatus.keyAt(i);
                    this.onStatusChangedLocked(0, cameraId);
                }
                for (i = 0; i < this.mTorchStatus.size(); ++i) {
                    cameraId = this.mTorchStatus.keyAt(i);
                    this.onTorchStatusChangedLocked(0, cameraId);
                }
                this.scheduleCameraServiceReconnectionLocked();
            }
        }
    }

    public static abstract class TorchCallback {
        public void onTorchModeUnavailable(String cameraId) {
        }

        public void onTorchModeChanged(String cameraId, boolean enabled) {
        }
    }

    public static abstract class AvailabilityCallback {
        public void onCameraAvailable(String cameraId) {
        }

        public void onCameraUnavailable(String cameraId) {
        }
    }
}

