/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends DrawableWrapper {
    private final Rect mTmpRect = new Rect();
    private InsetState mState;

    InsetDrawable() {
        this(new InsetState(null), null);
    }

    public InsetDrawable(Drawable drawable2, int inset) {
        this(drawable2, inset, inset, inset, inset);
    }

    public InsetDrawable(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this(new InsetState(null), null);
        this.mState.mInsetLeft = insetLeft;
        this.mState.mInsetTop = insetTop;
        this.mState.mInsetRight = insetRight;
        this.mState.mInsetBottom = insetBottom;
        this.setDrawable(drawable2);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        this.updateStateFromTypedArray(a);
        this.inflateChildDrawable(r, parser, attrs, theme);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
    }

    @Override
    void updateStateFromTypedArray(TypedArray a) {
        super.updateStateFromTypedArray(a);
        InsetState state = this.mState;
        int N = a.getIndexCount();
        block8: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 1: {
                    Drawable dr = a.getDrawable(attr2);
                    if (dr == null) continue block8;
                    this.setDrawable(dr);
                    continue block8;
                }
                case 6: {
                    int inset = a.getDimensionPixelOffset(attr2, Integer.MIN_VALUE);
                    if (inset == Integer.MIN_VALUE) continue block8;
                    state.mInsetLeft = inset;
                    state.mInsetTop = inset;
                    state.mInsetRight = inset;
                    state.mInsetBottom = inset;
                    continue block8;
                }
                case 2: {
                    state.mInsetLeft = a.getDimensionPixelOffset(attr2, state.mInsetLeft);
                    continue block8;
                }
                case 4: {
                    state.mInsetTop = a.getDimensionPixelOffset(attr2, state.mInsetTop);
                    continue block8;
                }
                case 3: {
                    state.mInsetRight = a.getDimensionPixelOffset(attr2, state.mInsetRight);
                    continue block8;
                }
                case 5: {
                    state.mInsetBottom = a.getDimensionPixelOffset(attr2, state.mInsetBottom);
                }
            }
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        super.applyTheme(t);
    }

    @Override
    public boolean getPadding(Rect padding) {
        boolean pad = super.getPadding(padding);
        padding.left += this.mState.mInsetLeft;
        padding.right += this.mState.mInsetRight;
        padding.top += this.mState.mInsetTop;
        padding.bottom += this.mState.mInsetBottom;
        return pad || (this.mState.mInsetLeft | this.mState.mInsetRight | this.mState.mInsetTop | this.mState.mInsetBottom) != 0;
    }

    @Override
    public Insets getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        return Insets.of(contentInsets.left + this.mState.mInsetLeft, contentInsets.top + this.mState.mInsetTop, contentInsets.right + this.mState.mInsetRight, contentInsets.bottom + this.mState.mInsetBottom);
    }

    @Override
    public int getOpacity() {
        InsetState state = this.mState;
        int opacity = this.getDrawable().getOpacity();
        if (opacity == -1 && (state.mInsetLeft > 0 || state.mInsetTop > 0 || state.mInsetRight > 0 || state.mInsetBottom > 0)) {
            return -3;
        }
        return opacity;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mState.mInsetLeft;
        r.top += this.mState.mInsetTop;
        r.right -= this.mState.mInsetRight;
        r.bottom -= this.mState.mInsetBottom;
        super.onBoundsChange(r);
    }

    @Override
    public int getIntrinsicWidth() {
        return this.getDrawable().getIntrinsicWidth() + this.mState.mInsetLeft + this.mState.mInsetRight;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.getDrawable().getIntrinsicHeight() + this.mState.mInsetTop + this.mState.mInsetBottom;
    }

    @Override
    public void getOutline(Outline outline) {
        this.getDrawable().getOutline(outline);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new InsetState(this.mState);
        return this.mState;
    }

    private InsetDrawable(InsetState state, Resources res) {
        super(state, res);
        this.mState = state;
    }

    static class InsetState
    extends DrawableWrapper.DrawableWrapperState {
        int mInsetLeft = 0;
        int mInsetTop = 0;
        int mInsetRight = 0;
        int mInsetBottom = 0;

        InsetState(InsetState orig) {
            super(orig);
            if (orig != null) {
                this.mInsetLeft = orig.mInsetLeft;
                this.mInsetTop = orig.mInsetTop;
                this.mInsetRight = orig.mInsetRight;
                this.mInsetBottom = orig.mInsetBottom;
            }
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new InsetDrawable(this, res);
        }
    }
}

