/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimatedRotateDrawable;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.LevelListDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Drawable {
    private static final Rect ZERO_BOUNDS_RECT = new Rect();
    static final PorterDuff.Mode DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    private int[] mStateSet = StateSet.WILD_CARD;
    private int mLevel = 0;
    private int mChangingConfigurations = 0;
    private Rect mBounds = ZERO_BOUNDS_RECT;
    private WeakReference<Callback> mCallback = null;
    private boolean mVisible = true;
    private int mLayoutDirection;

    public abstract void draw(Canvas var1);

    public void setBounds(int left, int top, int right, int bottom) {
        Rect oldBounds = this.mBounds;
        if (oldBounds == ZERO_BOUNDS_RECT) {
            oldBounds = this.mBounds = new Rect();
        }
        if (oldBounds.left != left || oldBounds.top != top || oldBounds.right != right || oldBounds.bottom != bottom) {
            if (!oldBounds.isEmpty()) {
                this.invalidateSelf();
            }
            this.mBounds.set(left, top, right, bottom);
            this.onBoundsChange(this.mBounds);
        }
    }

    public void setBounds(Rect bounds) {
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void copyBounds(Rect bounds) {
        bounds.set(this.mBounds);
    }

    public Rect copyBounds() {
        return new Rect(this.mBounds);
    }

    public Rect getBounds() {
        if (this.mBounds == ZERO_BOUNDS_RECT) {
            this.mBounds = new Rect();
        }
        return this.mBounds;
    }

    public Rect getDirtyBounds() {
        return this.getBounds();
    }

    public void setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    @Deprecated
    public void setDither(boolean dither) {
    }

    public void setFilterBitmap(boolean filter) {
    }

    public boolean isFilterBitmap() {
        return false;
    }

    public void setCallback(Callback cb) {
        this.mCallback = new WeakReference<Callback>(cb);
    }

    public Callback getCallback() {
        if (this.mCallback != null) {
            return (Callback)this.mCallback.get();
        }
        return null;
    }

    public void invalidateSelf() {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    public void scheduleSelf(Runnable what, long when) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleSelf(Runnable what) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public boolean setLayoutDirection(int layoutDirection) {
        if (this.mLayoutDirection != layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this.onLayoutDirectionChanged(layoutDirection);
        }
        return false;
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        return false;
    }

    public abstract void setAlpha(int var1);

    public int getAlpha() {
        return 255;
    }

    public void setXfermode(Xfermode mode) {
    }

    public abstract void setColorFilter(ColorFilter var1);

    public void setColorFilter(int color2, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(color2, mode));
    }

    public void setTint(int tintColor) {
        this.setTintList(ColorStateList.valueOf(tintColor));
    }

    public void setTintList(ColorStateList tint) {
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
    }

    public ColorFilter getColorFilter() {
        return null;
    }

    public void clearColorFilter() {
        this.setColorFilter(null);
    }

    public void setHotspot(float x, float y) {
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
    }

    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.getBounds());
    }

    public boolean isProjected() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean setState(int[] stateSet) {
        if (!Arrays.equals(this.mStateSet, stateSet)) {
            this.mStateSet = stateSet;
            return this.onStateChange(stateSet);
        }
        return false;
    }

    public int[] getState() {
        return this.mStateSet;
    }

    public void jumpToCurrentState() {
    }

    public Drawable getCurrent() {
        return this;
    }

    public boolean setLevel(int level) {
        if (this.mLevel != level) {
            this.mLevel = level;
            return this.onLevelChange(level);
        }
        return false;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed;
        boolean bl = changed = this.mVisible != visible;
        if (changed) {
            this.mVisible = visible;
            this.invalidateSelf();
        }
        return changed;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setAutoMirrored(boolean mirrored) {
    }

    public boolean isAutoMirrored() {
        return false;
    }

    public void applyTheme(Resources.Theme t) {
    }

    public boolean canApplyTheme() {
        return false;
    }

    public abstract int getOpacity();

    public static int resolveOpacity(int op1, int op2) {
        if (op1 == op2) {
            return op1;
        }
        if (op1 == 0 || op2 == 0) {
            return 0;
        }
        if (op1 == -3 || op2 == -3) {
            return -3;
        }
        if (op1 == -2 || op2 == -2) {
            return -2;
        }
        return -1;
    }

    public Region getTransparentRegion() {
        return null;
    }

    protected boolean onStateChange(int[] state) {
        return false;
    }

    protected boolean onLevelChange(int level) {
        return false;
    }

    protected void onBoundsChange(Rect bounds) {
    }

    public int getIntrinsicWidth() {
        return -1;
    }

    public int getIntrinsicHeight() {
        return -1;
    }

    public int getMinimumWidth() {
        int intrinsicWidth = this.getIntrinsicWidth();
        return intrinsicWidth > 0 ? intrinsicWidth : 0;
    }

    public int getMinimumHeight() {
        int intrinsicHeight = this.getIntrinsicHeight();
        return intrinsicHeight > 0 ? intrinsicHeight : 0;
    }

    public boolean getPadding(Rect padding) {
        padding.set(0, 0, 0, 0);
        return false;
    }

    public Insets getOpticalInsets() {
        return Insets.NONE;
    }

    public void getOutline(Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha(0.0f);
    }

    public Drawable mutate() {
        return this;
    }

    public void clearMutated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable createFromStream(InputStream is, String srcName) {
        Trace.traceBegin(8192L, srcName != null ? srcName : "Unknown drawable");
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(null, null, is, srcName);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName) {
        Trace.traceBegin(8192L, srcName != null ? srcName : "Unknown drawable");
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(res, value, is, srcName, null);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        if (is == null) {
            return null;
        }
        Rect pad = new Rect();
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        opts.inScreenDensity = res != null ? res.getDisplayMetrics().noncompatDensityDpi : DisplayMetrics.DENSITY_DEVICE;
        Bitmap bm = BitmapFactory.decodeResourceStream(res, value, is, pad, opts);
        if (bm != null) {
            byte[] np = bm.getNinePatchChunk();
            if (np == null || !NinePatch.isNinePatchChunk(np)) {
                np = null;
                pad = null;
            }
            Rect opticalInsets = new Rect();
            bm.getOpticalInsets(opticalInsets);
            return Drawable.drawableFromBitmap(res, bm, np, pad, opticalInsets, srcName);
        }
        return null;
    }

    public static Drawable createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        return Drawable.createFromXml(r, parser, null);
    }

    public static Drawable createFromXml(Resources r, XmlPullParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable2 = Drawable.createFromXmlInner(r, parser, attrs, theme);
        if (drawable2 == null) {
            throw new RuntimeException("Unknown initial tag: " + parser.getName());
        }
        return drawable2;
    }

    public static Drawable createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        return Drawable.createFromXmlInner(r, parser, attrs, null);
    }

    public static Drawable createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable drawable2;
        String name;
        String string2 = name = parser.getName();
        int n = -1;
        switch (string2.hashCode()) {
            case 1191572447: {
                if (!string2.equals("selector")) break;
                n = 0;
                break;
            }
            case -510364471: {
                if (!string2.equals("animated-selector")) break;
                n = 1;
                break;
            }
            case 160680263: {
                if (!string2.equals("level-list")) break;
                n = 2;
                break;
            }
            case -94197862: {
                if (!string2.equals("layer-list")) break;
                n = 3;
                break;
            }
            case -1724158635: {
                if (!string2.equals("transition")) break;
                n = 4;
                break;
            }
            case -930826704: {
                if (!string2.equals("ripple")) break;
                n = 5;
                break;
            }
            case 94842723: {
                if (!string2.equals("color")) break;
                n = 6;
                break;
            }
            case 109399969: {
                if (!string2.equals("shape")) break;
                n = 7;
                break;
            }
            case -820387517: {
                if (!string2.equals("vector")) break;
                n = 8;
                break;
            }
            case 2118620333: {
                if (!string2.equals("animated-vector")) break;
                n = 9;
                break;
            }
            case 109250890: {
                if (!string2.equals("scale")) break;
                n = 10;
                break;
            }
            case 3056464: {
                if (!string2.equals("clip")) break;
                n = 11;
                break;
            }
            case -925180581: {
                if (!string2.equals("rotate")) break;
                n = 12;
                break;
            }
            case 2013827269: {
                if (!string2.equals("animated-rotate")) break;
                n = 13;
                break;
            }
            case -1493546681: {
                if (!string2.equals("animation-list")) break;
                n = 14;
                break;
            }
            case 100360477: {
                if (!string2.equals("inset")) break;
                n = 15;
                break;
            }
            case -1388777169: {
                if (!string2.equals("bitmap")) break;
                n = 16;
                break;
            }
            case -1671889043: {
                if (!string2.equals("nine-patch")) break;
                n = 17;
            }
        }
        switch (n) {
            case 0: {
                drawable2 = new StateListDrawable();
                break;
            }
            case 1: {
                drawable2 = new AnimatedStateListDrawable();
                break;
            }
            case 2: {
                drawable2 = new LevelListDrawable();
                break;
            }
            case 3: {
                drawable2 = new LayerDrawable();
                break;
            }
            case 4: {
                drawable2 = new TransitionDrawable();
                break;
            }
            case 5: {
                drawable2 = new RippleDrawable();
                break;
            }
            case 6: {
                drawable2 = new ColorDrawable();
                break;
            }
            case 7: {
                drawable2 = new GradientDrawable();
                break;
            }
            case 8: {
                drawable2 = new VectorDrawable();
                break;
            }
            case 9: {
                drawable2 = new AnimatedVectorDrawable();
                break;
            }
            case 10: {
                drawable2 = new ScaleDrawable();
                break;
            }
            case 11: {
                drawable2 = new ClipDrawable();
                break;
            }
            case 12: {
                drawable2 = new RotateDrawable();
                break;
            }
            case 13: {
                drawable2 = new AnimatedRotateDrawable();
                break;
            }
            case 14: {
                drawable2 = new AnimationDrawable();
                break;
            }
            case 15: {
                drawable2 = new InsetDrawable();
                break;
            }
            case 16: {
                drawable2 = new BitmapDrawable();
                break;
            }
            case 17: {
                drawable2 = new NinePatchDrawable();
                break;
            }
            default: {
                throw new XmlPullParserException(parser.getPositionDescription() + ": invalid drawable tag " + name);
            }
        }
        drawable2.inflate(r, parser, attrs, theme);
        return drawable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable createFromPath(String pathName) {
        if (pathName == null) {
            return null;
        }
        Trace.traceBegin(8192L, pathName);
        try {
            Bitmap bm = BitmapFactory.decodeFile(pathName);
            if (bm != null) {
                Drawable drawable2 = Drawable.drawableFromBitmap(null, bm, null, null, null, pathName);
                return drawable2;
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
        return null;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        this.inflate(r, parser, attrs, null);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Drawable, 0, 0) : r.obtainAttributes(attrs, R.styleable.Drawable);
        this.inflateWithAttributes(r, parser, a, 0);
        a.recycle();
    }

    void inflateWithAttributes(Resources r, XmlPullParser parser, TypedArray attrs, int visibleAttr) throws XmlPullParserException, IOException {
        this.mVisible = attrs.getBoolean(visibleAttr, this.mVisible);
    }

    public ConstantState getConstantState() {
        return null;
    }

    private static Drawable drawableFromBitmap(Resources res, Bitmap bm, byte[] np, Rect pad, Rect layoutBounds, String srcName) {
        if (np != null) {
            return new NinePatchDrawable(res, bm, np, pad, layoutBounds, srcName);
        }
        return new BitmapDrawable(res, bm);
    }

    PorterDuffColorFilter updateTintFilter(PorterDuffColorFilter tintFilter, ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(this.getState(), 0);
        if (tintFilter == null) {
            return new PorterDuffColorFilter(color2, tintMode);
        }
        tintFilter.setColor(color2);
        tintFilter.setMode(tintMode);
        return tintFilter;
    }

    static TypedArray obtainAttributes(Resources res, Resources.Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    public static abstract class ConstantState {
        public abstract Drawable newDrawable();

        public Drawable newDrawable(Resources res) {
            return this.newDrawable();
        }

        public Drawable newDrawable(Resources res, Resources.Theme theme) {
            return this.newDrawable(null);
        }

        public abstract int getChangingConfigurations();

        public int addAtlasableBitmaps(Collection<Bitmap> atlasList) {
            return 0;
        }

        protected boolean isAtlasable(Bitmap bitmap) {
            return bitmap != null && bitmap.getConfig() == Bitmap.Config.ARGB_8888;
        }

        public boolean canApplyTheme() {
            return false;
        }
    }

    public static interface Callback {
        public void invalidateDrawable(Drawable var1);

        public void scheduleDrawable(Drawable var1, Runnable var2, long var3);

        public void unscheduleDrawable(Drawable var1, Runnable var2);
    }
}

