/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;
import android.graphics.SweepGradient_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class SweepGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_START_AND_COLOR_END = 2;
    private int mType;
    private float mCx;
    private float mCy;
    private int[] mColors;
    private float[] mPositions;
    private int mColor0;
    private int mColor1;

    public SweepGradient(float cx, float cy, int[] colors, float[] positions) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mCx = cx;
        this.mCy = cy;
        this.mColors = colors;
        this.mPositions = positions;
        this.init(SweepGradient.nativeCreate1(cx, cy, colors, positions));
    }

    public SweepGradient(float cx, float cy, int color0, int color1) {
        this.mType = 2;
        this.mCx = cx;
        this.mCy = cy;
        this.mColor0 = color0;
        this.mColor1 = color1;
        this.init(SweepGradient.nativeCreate2(cx, cy, color0, color1));
    }

    @Override
    protected Shader copy() {
        SweepGradient copy;
        switch (this.mType) {
            case 1: {
                copy = new SweepGradient(this.mCx, this.mCy, (int[])this.mColors.clone(), this.mPositions != null ? (float[])this.mPositions.clone() : null);
                break;
            }
            case 2: {
                copy = new SweepGradient(this.mCx, this.mCy, this.mColor0, this.mColor1);
                break;
            }
            default: {
                throw new IllegalArgumentException("SweepGradient should be created with either colors and positions or start color and end color");
            }
        }
        this.copyLocalMatrix(copy);
        return copy;
    }

    @LayoutlibDelegate
    private static long nativeCreate1(float f, float f2, int[] nArray, float[] fArray) {
        return SweepGradient_Delegate.nativeCreate1(f, f2, nArray, fArray);
    }

    @LayoutlibDelegate
    private static long nativeCreate2(float f, float f2, int n, int n2) {
        return SweepGradient_Delegate.nativeCreate2(f, f2, n, n2);
    }
}

