/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private Canvas mRecordingCanvas;
    private final long mNativePicture;
    private static final int WORKING_STREAM_STORAGE = 16384;

    public Picture() {
        this(Picture.nativeConstructor(0L));
    }

    public Picture(Picture src) {
        this(Picture.nativeConstructor(src != null ? src.mNativePicture : 0L));
    }

    private Picture(long nativePicture) {
        if (nativePicture == 0L) {
            throw new RuntimeException();
        }
        this.mNativePicture = nativePicture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Picture.nativeDestructor(this.mNativePicture);
        }
        finally {
            super.finalize();
        }
    }

    public Canvas beginRecording(int width, int height) {
        long ni = Picture.nativeBeginRecording(this.mNativePicture, width, height);
        this.mRecordingCanvas = new RecordingCanvas(this, ni);
        return this.mRecordingCanvas;
    }

    public void endRecording() {
        if (this.mRecordingCanvas != null) {
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    public int getWidth() {
        return Picture.nativeGetWidth(this.mNativePicture);
    }

    public int getHeight() {
        return Picture.nativeGetHeight(this.mNativePicture);
    }

    public void draw(Canvas canvas) {
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        Picture.nativeDraw(canvas.getNativeCanvasWrapper(), this.mNativePicture);
    }

    @Deprecated
    public static Picture createFromStream(InputStream stream) {
        return new Picture(Picture.nativeCreateFromStream(stream, new byte[16384]));
    }

    @Deprecated
    public void writeToStream(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, stream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    private static long nativeConstructor(long l) {
        return OverrideMethod.invokeL("android.graphics.Picture#nativeConstructor(J)J", true, null);
    }

    private static long nativeCreateFromStream(InputStream inputStream, byte[] byArray) {
        return OverrideMethod.invokeL("android.graphics.Picture#nativeCreateFromStream(Ljava/io/InputStream;[B)J", true, null);
    }

    private static int nativeGetWidth(long l) {
        return OverrideMethod.invokeI("android.graphics.Picture#nativeGetWidth(J)I", true, null);
    }

    private static int nativeGetHeight(long l) {
        return OverrideMethod.invokeI("android.graphics.Picture#nativeGetHeight(J)I", true, null);
    }

    private static long nativeBeginRecording(long l, int n, int n2) {
        return OverrideMethod.invokeL("android.graphics.Picture#nativeBeginRecording(JII)J", true, null);
    }

    private static void nativeEndRecording(long l) {
        OverrideMethod.invokeV("android.graphics.Picture#nativeEndRecording(J)V", true, null);
    }

    private static void nativeDraw(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.Picture#nativeDraw(JJ)V", true, null);
    }

    private static boolean nativeWriteToStream(long l, OutputStream outputStream, byte[] byArray) {
        return OverrideMethod.invokeI("android.graphics.Picture#nativeWriteToStream(JLjava/io/OutputStream;[B)Z", true, null) != 0;
    }

    private static void nativeDestructor(long l) {
        OverrideMethod.invokeV("android.graphics.Picture#nativeDestructor(J)V", true, null);
    }

    private static class RecordingCanvas
    extends Canvas {
        private final Picture mPicture;

        public RecordingCanvas(Picture pict, long nativeCanvas) {
            super(nativeCanvas);
            this.mPicture = pict;
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }

        @Override
        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }
    }
}

