/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas_Delegate;
import android.graphics.Paint_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.ninepatch.NinePatchChunk;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public final class NinePatch_Delegate {
    private static final DelegateManager<NinePatch_Delegate> sManager = new DelegateManager<NinePatch_Delegate>(NinePatch_Delegate.class);
    private static final Map<byte[], SoftReference<NinePatchChunk>> sChunkCache = new HashMap<byte[], SoftReference<NinePatchChunk>>();
    private byte[] chunk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(NinePatchChunk chunk) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(chunk);
        }
        catch (IOException e) {
            Bridge.getLog().error(null, "Failed to serialize NinePatchChunk.", (Throwable)e, null);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] array2 = baos.toByteArray();
        sChunkCache.put(array2, new SoftReference<NinePatchChunk>(chunk));
        return array2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NinePatchChunk getChunk(byte[] array2) {
        SoftReference<NinePatchChunk> chunkRef = sChunkCache.get(array2);
        NinePatchChunk chunk = chunkRef.get();
        if (chunk == null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(array2);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                chunk = (NinePatchChunk)ois.readObject();
                if (chunk != null) {
                    sChunkCache.put(array2, new SoftReference<NinePatchChunk>(chunk));
                }
            }
            catch (IOException e) {
                Bridge.getLog().error("broken", "Failed to deserialize NinePatchChunk content.", (Throwable)e, null);
                NinePatchChunk ninePatchChunk = null;
                return ninePatchChunk;
            }
            catch (ClassNotFoundException e) {
                Bridge.getLog().error("broken", "Failed to deserialize NinePatchChunk class.", (Throwable)e, null);
                NinePatchChunk ninePatchChunk = null;
                return ninePatchChunk;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return chunk;
    }

    @LayoutlibDelegate
    static boolean isNinePatchChunk(byte[] chunk) {
        NinePatchChunk chunkObject = NinePatch_Delegate.getChunk(chunk);
        return chunkObject != null;
    }

    @LayoutlibDelegate
    static long validateNinePatchChunk(byte[] chunk) {
        NinePatch_Delegate newDelegate = new NinePatch_Delegate();
        newDelegate.chunk = chunk;
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void nativeFinalize(long chunk) {
        sManager.removeJavaReferenceFor(chunk);
    }

    @LayoutlibDelegate
    static void nativeDraw(long canvas_instance, RectF loc, Bitmap bitmap_instance, long chunk, long paint_instance_or_null, int destDensity, int srcDensity) {
        NinePatch_Delegate.draw(canvas_instance, (int)loc.left, (int)loc.top, (int)loc.right, (int)loc.bottom, bitmap_instance, chunk, paint_instance_or_null, destDensity, srcDensity);
    }

    @LayoutlibDelegate
    static void nativeDraw(long canvas_instance, Rect loc, Bitmap bitmap_instance, long chunk, long paint_instance_or_null, int destDensity, int srcDensity) {
        NinePatch_Delegate.draw(canvas_instance, loc.left, loc.top, loc.right, loc.bottom, bitmap_instance, chunk, paint_instance_or_null, destDensity, srcDensity);
    }

    @LayoutlibDelegate
    static long nativeGetTransparentRegion(Bitmap bitmap, long chunk, Rect location) {
        return 0L;
    }

    private static void draw(long canvas_instance, final int left, final int top, final int right, final int bottom, Bitmap bitmap_instance, long chunk, long paint_instance_or_null, final int destDensity, final int srcDensity) {
        final Bitmap_Delegate bitmap_delegate = Bitmap_Delegate.getDelegate(bitmap_instance);
        if (bitmap_delegate == null) {
            return;
        }
        byte[] c = null;
        NinePatch_Delegate delegate = sManager.getDelegate(chunk);
        if (delegate != null) {
            c = delegate.chunk;
        }
        if (c == null) {
            BufferedImage image = bitmap_delegate.getImage();
            Canvas_Delegate.native_drawBitmap(null, canvas_instance, bitmap_instance, 0.0f, 0.0f, image.getWidth(), image.getHeight(), left, top, right, bottom, paint_instance_or_null, destDensity, srcDensity);
            return;
        }
        final NinePatchChunk chunkObject = NinePatch_Delegate.getChunk(c);
        assert (chunkObject != null);
        if (chunkObject == null) {
            return;
        }
        Canvas_Delegate canvas_delegate = Canvas_Delegate.getDelegate(canvas_instance);
        if (canvas_delegate == null) {
            return;
        }
        Paint_Delegate paint_delegate = Paint_Delegate.getDelegate(paint_instance_or_null);
        canvas_delegate.getSnapshot().draw(new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                chunkObject.draw(bitmap_delegate.getImage(), graphics, left, top, right - left, bottom - top, destDensity, srcDensity);
            }
        }, paint_delegate, true, false);
    }
}

