/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    private final long mNativeMovie;

    private Movie(long nativeMovie) {
        if (nativeMovie == 0L) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = nativeMovie;
    }

    public int width() {
        return OverrideMethod.invokeI("android.graphics.Movie#width()I", true, this);
    }

    public int height() {
        return OverrideMethod.invokeI("android.graphics.Movie#height()I", true, this);
    }

    public boolean isOpaque() {
        return OverrideMethod.invokeI("android.graphics.Movie#isOpaque()Z", true, this) != 0;
    }

    public int duration() {
        return OverrideMethod.invokeI("android.graphics.Movie#duration()I", true, this);
    }

    public boolean setTime(int n) {
        return OverrideMethod.invokeI("android.graphics.Movie#setTime(I)Z", true, this) != 0;
    }

    private void nDraw(long l, float f, float f2, long l2) {
        OverrideMethod.invokeV("android.graphics.Movie#nDraw(JFFJ)V", true, this);
    }

    public void draw(Canvas canvas, float x, float y, Paint paint) {
        this.nDraw(canvas.getNativeCanvasWrapper(), x, y, paint != null ? paint.getNativeInstance() : 0L);
    }

    public void draw(Canvas canvas, float x, float y) {
        this.nDraw(canvas.getNativeCanvasWrapper(), x, y, 0L);
    }

    public static Movie decodeStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof AssetManager.AssetInputStream) {
            long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
            return Movie.nativeDecodeAsset(asset);
        }
        return Movie.nativeDecodeStream(is);
    }

    private static Movie nativeDecodeAsset(long l) {
        return (Movie)OverrideMethod.invokeA("android.graphics.Movie#nativeDecodeAsset(J)Landroid/graphics/Movie;", true, null);
    }

    private static Movie nativeDecodeStream(InputStream inputStream) {
        return (Movie)OverrideMethod.invokeA("android.graphics.Movie#nativeDecodeStream(Ljava/io/InputStream;)Landroid/graphics/Movie;", true, null);
    }

    public static Movie decodeByteArray(byte[] byArray, int n, int n2) {
        return (Movie)OverrideMethod.invokeA("android.graphics.Movie#decodeByteArray([BII)Landroid/graphics/Movie;", true, null);
    }

    private static void nativeDestructor(long l) {
        OverrideMethod.invokeV("android.graphics.Movie#nativeDestructor(J)V", true, null);
    }

    public static Movie decodeFile(String pathName) {
        FileInputStream is;
        try {
            is = new FileInputStream(pathName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return Movie.decodeTempStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Movie.nativeDestructor(this.mNativeMovie);
        }
        finally {
            super.finalize();
        }
    }

    private static Movie decodeTempStream(InputStream is) {
        Movie moov = null;
        try {
            moov = Movie.decodeStream(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moov;
    }
}

