/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BidiRenderer;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.DrawFilter_Delegate;
import android.graphics.Matrix_Delegate;
import android.graphics.Paint;
import android.graphics.Paint_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region_Delegate;
import android.graphics.TemporaryBuffer;
import android.graphics.Xfermode_Delegate;
import android.text.TextUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.layoutlib.bridge.impl.PorterDuffUtility;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class Canvas_Delegate {
    private static final DelegateManager<Canvas_Delegate> sManager = new DelegateManager<Canvas_Delegate>(Canvas_Delegate.class);
    private static final boolean[] sBoolOut = new boolean[1];
    private Bitmap_Delegate mBitmap;
    private GcSnapshot mSnapshot;
    private DrawFilter_Delegate mDrawFilter = null;

    public static Canvas_Delegate getDelegate(Canvas canvas) {
        return sManager.getDelegate(canvas.getNativeCanvasWrapper());
    }

    public static Canvas_Delegate getDelegate(long native_canvas) {
        return sManager.getDelegate(native_canvas);
    }

    public GcSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    public DrawFilter_Delegate getDrawFilter() {
        return this.mDrawFilter;
    }

    @LayoutlibDelegate
    static void freeCaches() {
    }

    @LayoutlibDelegate
    static void freeTextLayoutCaches() {
    }

    @LayoutlibDelegate
    static long initRaster(Bitmap bitmap) {
        long nativeBitmapOrZero = 0L;
        if (bitmap != null) {
            nativeBitmapOrZero = bitmap.refSkPixelRef();
        }
        if (nativeBitmapOrZero > 0L) {
            Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(nativeBitmapOrZero);
            Canvas_Delegate newDelegate = new Canvas_Delegate(bitmapDelegate);
            return sManager.addNewDelegate(newDelegate);
        }
        Canvas_Delegate newDelegate = new Canvas_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void native_setBitmap(long canvas, Bitmap bitmap) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(canvas);
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (canvasDelegate == null || bitmapDelegate == null) {
            return;
        }
        canvasDelegate.mBitmap = bitmapDelegate;
        canvasDelegate.mSnapshot = GcSnapshot.createDefaultSnapshot(bitmapDelegate);
    }

    @LayoutlibDelegate
    static boolean native_isOpaque(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.mBitmap.getConfig() == Bitmap.Config.RGB_565;
    }

    @LayoutlibDelegate
    static int native_getWidth(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getWidth();
    }

    @LayoutlibDelegate
    static int native_getHeight(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getHeight();
    }

    @LayoutlibDelegate
    static int native_save(long nativeCanvas, int saveFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.save(saveFlags);
    }

    @LayoutlibDelegate
    static int native_saveLayer(long nativeCanvas, float l, float t, float r, float b, long paint, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(paint);
        if (paintDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayer(new RectF(l, t, r, b), paintDelegate, layerFlags);
    }

    @LayoutlibDelegate
    static int native_saveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayerAlpha(new RectF(l, t, r, b), alpha, layerFlags);
    }

    @LayoutlibDelegate
    static void native_restore(long nativeCanvas, boolean throwOnUnderflow) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.restore();
    }

    @LayoutlibDelegate
    static void native_restoreToCount(long nativeCanvas, int saveCount, boolean throwOnUnderflow) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.restoreTo(saveCount);
    }

    @LayoutlibDelegate
    static int native_getSaveCount(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.getSnapshot().size();
    }

    @LayoutlibDelegate
    static void native_translate(long nativeCanvas, float dx, float dy) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().translate(dx, dy);
    }

    @LayoutlibDelegate
    static void native_scale(long nativeCanvas, float sx, float sy) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().scale(sx, sy);
    }

    @LayoutlibDelegate
    static void native_rotate(long nativeCanvas, float degrees) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().rotate(Math.toRadians(degrees));
    }

    @LayoutlibDelegate
    static void native_skew(long nativeCanvas, float kx, float ky) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        GcSnapshot g = canvasDelegate.getSnapshot();
        AffineTransform currentTx = g.getTransform();
        float[] mtx = Matrix_Delegate.getSkew(kx, ky);
        AffineTransform matrixTx = Matrix_Delegate.getAffineTransform(mtx);
        currentTx.preConcatenate(matrixTx);
        g.setTransform(currentTx);
    }

    @LayoutlibDelegate
    static void native_concat(long nCanvas, long nMatrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform currentTx = snapshot.getTransform();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        currentTx.concatenate(matrixTx);
        snapshot.setTransform(currentTx);
    }

    @LayoutlibDelegate
    static void native_setMatrix(long nCanvas, long nMatrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        snapshot.setTransform(matrixTx);
        if (matrixDelegate.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Canvas#setMatrix(android.graphics.Matrix) only supports affine transformations.", null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_clipRect(long nCanvas, float left, float top, float right, float bottom, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.clipRect(left, top, right, bottom, regionOp);
    }

    @LayoutlibDelegate
    static boolean native_clipPath(long nativeCanvas, long nativePath, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return true;
        }
        Path_Delegate pathDelegate = Path_Delegate.getDelegate(nativePath);
        if (pathDelegate == null) {
            return true;
        }
        return canvasDelegate.mSnapshot.clip(pathDelegate.getJavaShape(), regionOp);
    }

    @LayoutlibDelegate
    static boolean native_clipRegion(long nativeCanvas, long nativeRegion, int regionOp) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return true;
        }
        Region_Delegate region = Region_Delegate.getDelegate(nativeRegion);
        if (region == null) {
            return true;
        }
        return canvasDelegate.mSnapshot.clip(region.getJavaArea(), regionOp);
    }

    @LayoutlibDelegate
    static void nativeSetDrawFilter(long nativeCanvas, long nativeFilter) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mDrawFilter = DrawFilter_Delegate.getDelegate(nativeFilter);
        if (canvasDelegate.mDrawFilter != null && !canvasDelegate.mDrawFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("drawfilter", canvasDelegate.mDrawFilter.getSupportMessage(), null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_getClipBounds(long nativeCanvas, Rect bounds) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        Rectangle rect = canvasDelegate.getSnapshot().getClip().getBounds();
        if (rect != null && !rect.isEmpty()) {
            bounds.left = rect.x;
            bounds.top = rect.y;
            bounds.right = rect.x + rect.width;
            bounds.bottom = rect.y + rect.height;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void native_getCTM(long canvas, long matrix) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(canvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        AffineTransform transform = canvasDelegate.getSnapshot().getTransform();
        matrixDelegate.set(Matrix_Delegate.makeValues(transform));
    }

    @LayoutlibDelegate
    static boolean native_quickReject(long nativeCanvas, long path) {
        return false;
    }

    @LayoutlibDelegate
    static boolean native_quickReject(long nativeCanvas, float left, float top, float right, float bottom) {
        return false;
    }

    @LayoutlibDelegate
    static void native_drawColor(long nativeCanvas, final int color2, final int mode) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        final int w = canvasDelegate.mBitmap.getImage().getWidth();
        final int h = canvasDelegate.mBitmap.getImage().getHeight();
        Canvas_Delegate.draw(nativeCanvas, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                graphics.setTransform(new AffineTransform());
                graphics.setColor(new Color(color2, true));
                Composite composite = PorterDuffUtility.getComposite(PorterDuffUtility.getPorterDuffMode(mode), 255);
                if (composite != null) {
                    graphics.setComposite(composite);
                }
                graphics.fillRect(0, 0, w, h);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPaint(long nativeCanvas, long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPaint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPoint(long nativeCanvas, float x, float y, long nativePaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPoints(long nativeCanvas, float[] pts, int offset, int count, long nativePaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawLine(long nativeCanvas, final float startX, final float startY, final float stopX, final float stopY, long paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                graphics.drawLine((int)startX, (int)startY, (int)stopX, (int)stopY);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawLines(long nativeCanvas, final float[] pts, final int offset, final int count, long nativePaint) {
        Canvas_Delegate.draw(nativeCanvas, nativePaint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                for (int i = 0; i < count; i += 4) {
                    graphics.drawLine((int)pts[i + offset], (int)pts[i + offset + 1], (int)pts[i + offset + 2], (int)pts[i + offset + 3]);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawRect(long nativeCanvas, final float left, final float top, final float right, final float bottom, long paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fillRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.drawRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawOval(long nativeCanvas, final float left, final float top, final float right, final float bottom, long paint) {
        if (right > left && bottom > top) {
            Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

                @Override
                public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                    int style2 = paintDelegate.getStyle();
                    if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.fillOval((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                    }
                    if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.drawOval((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawCircle(long nativeCanvas, float cx, float cy, float radius, long paint) {
        Canvas_Delegate.native_drawOval(nativeCanvas, cx - radius, cy - radius, cx + radius, cy + radius, paint);
    }

    @LayoutlibDelegate
    static void native_drawArc(long nativeCanvas, final float left, final float top, final float right, final float bottom, final float startAngle, final float sweep, final boolean useCenter, long paint) {
        if (right > left && bottom > top) {
            Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

                @Override
                public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                    int style2 = paintDelegate.getStyle();
                    Arc2D.Float arc = new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweep, useCenter ? 2 : 0);
                    if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.fill(arc);
                    }
                    if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics.draw(arc);
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawRoundRect(long nativeCanvas, final float left, final float top, final float right, final float bottom, final float rx, final float ry, long paint) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fillRoundRect((int)left, (int)top, (int)(right - left), (int)(bottom - top), 2 * (int)rx, 2 * (int)ry);
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.drawRoundRect((int)left, (int)top, (int)(right - left), (int)(bottom - top), 2 * (int)rx, 2 * (int)ry);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPath(long nativeCanvas, long path, long paint) {
        final Path_Delegate pathDelegate = Path_Delegate.getDelegate(path);
        if (pathDelegate == null) {
            return;
        }
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                int style2;
                Shape shape = pathDelegate.getJavaShape();
                Rectangle2D bounds = shape.getBounds2D();
                if (bounds.isEmpty()) {
                    if (pathDelegate.isEmpty()) {
                        return;
                    }
                    float strokeWidth = paintDelegate.getStrokeWidth();
                    if (strokeWidth <= 0.0f) {
                        return;
                    }
                    bounds.setRect(bounds.getX(), bounds.getY(), Math.max((double)strokeWidth, bounds.getWidth()), Math.max((double)strokeWidth, bounds.getHeight()));
                }
                if ((style2 = paintDelegate.getStyle()) == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fill(shape);
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.draw(shape);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas thisCanvas, long nativeCanvas, Bitmap bitmap, float left, float top, long nativePaintOrZero, int canvasDensity, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = bitmapDelegate.getImage();
        float right = left + (float)image.getWidth();
        float bottom = top + (float)image.getHeight();
        Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), (int)left, (int)top, (int)right, (int)bottom);
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas thisCanvas, long nativeCanvas, Bitmap bitmap, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, long nativePaintOrZero, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        Canvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, (int)srcLeft, (int)srcTop, (int)srcRight, (int)srcBottom, (int)dstLeft, (int)dstTop, (int)dstRight, (int)dstBottom);
    }

    @LayoutlibDelegate
    static void native_drawBitmap(long nativeCanvas, int[] colors, int offset, int stride, final float x, final float y, int width, int height, boolean hasAlpha, long nativePaintOrZero) {
        final BufferedImage image = new BufferedImage(width, height, hasAlpha ? 2 : 1);
        image.setRGB(0, 0, width, height, colors, offset, stride);
        Canvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage((Image)image, (int)x, (int)y, null);
            }
        });
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMatrix(long nCanvas, Bitmap bitmap, long nMatrix, long nPaint) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (bitmapDelegate == null) {
            return;
        }
        final BufferedImage image = Canvas_Delegate.getImageToDraw(bitmapDelegate, paintDelegate, sBoolOut);
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        final AffineTransform mtx = matrixDelegate.getAffineTransform();
        canvasDelegate.getSnapshot().draw(new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(image, mtx, null);
            }
        }, paintDelegate, true, false);
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMesh(long nCanvas, Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, long nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawBitmapMesh is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nativeDrawVertices(long nCanvas, int mode, int n, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, long nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawVertices is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawText(long nativeCanvas, char[] text, int index, int count, float startX, float startY, int flags, long paint, long typeface) {
        Canvas_Delegate.drawText(nativeCanvas, text, index, count, startX, startY, (flags & 1) != 0, paint, typeface);
    }

    @LayoutlibDelegate
    static void native_drawText(long nativeCanvas, String text, int start, int end, float x, float y, int flags, long paint, long typeface) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        Canvas_Delegate.native_drawText(nativeCanvas, buffer, 0, count, x, y, flags, paint, typeface);
    }

    @LayoutlibDelegate
    static void native_drawTextRun(long nativeCanvas, String text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, long paint, long typeface) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        Canvas_Delegate.drawText(nativeCanvas, buffer, 0, count, x, y, isRtl, paint, typeface);
    }

    @LayoutlibDelegate
    static void native_drawTextRun(long nativeCanvas, char[] text, int start, int count, int contextStart, int contextCount, float x, float y, boolean isRtl, long paint, long typeface) {
        Canvas_Delegate.drawText(nativeCanvas, text, start, count, x, y, isRtl, paint, typeface);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(long nativeCanvas, char[] text, int index, int count, long path, float hOffset, float vOffset, int bidiFlags, long paint, long typeface) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(long nativeCanvas, String text, long path, float hOffset, float vOffset, int bidiFlags, long paint, long typeface) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void finalizer(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.dispose();
        sManager.removeJavaReferenceFor(nativeCanvas);
    }

    private static void draw(long nCanvas, long nPaint, boolean compositeOnly, boolean forceSrcMode, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        canvasDelegate.getSnapshot().draw(drawable2, paintDelegate, compositeOnly, forceSrcMode);
    }

    private static void draw(long nCanvas, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mSnapshot.draw(drawable2);
    }

    private static void drawText(long nativeCanvas, final char[] text, final int index, final int count, final float startX, final float startY, final boolean isRtl, long paint, final long typeface) {
        Canvas_Delegate.draw(nativeCanvas, paint, false, false, new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paintDelegate) {
                assert (typeface == paintDelegate.mNativeTypeface);
                float x = startX;
                int limit = index + count;
                if (paintDelegate.getTextAlign() != Paint.Align.LEFT.nativeInt) {
                    RectF bounds = paintDelegate.measureText(text, index, count, null, 0, isRtl);
                    float m = bounds.right - bounds.left;
                    if (paintDelegate.getTextAlign() == Paint.Align.CENTER.nativeInt) {
                        x -= m / 2.0f;
                    } else if (paintDelegate.getTextAlign() == Paint.Align.RIGHT.nativeInt) {
                        x -= m;
                    }
                }
                new BidiRenderer(graphics, paintDelegate, text).setRenderLocation(x, startY).renderText(index, limit, isRtl, null, 0, true);
            }
        });
    }

    private Canvas_Delegate(Bitmap_Delegate bitmap) {
        this.mBitmap = bitmap;
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(this.mBitmap);
    }

    private Canvas_Delegate() {
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(null);
    }

    private void dispose() {
        this.mSnapshot.dispose();
    }

    private int save(int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.save(saveFlags);
        return count;
    }

    private int saveLayerAlpha(RectF rect, int alpha, int saveFlags) {
        Paint_Delegate paint = new Paint_Delegate();
        paint.setAlpha(alpha);
        return this.saveLayer(rect, paint, saveFlags);
    }

    private int saveLayer(RectF rect, Paint_Delegate paint, int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.saveLayer(rect, paint, saveFlags);
        return count;
    }

    private void restoreTo(int saveCount) {
        this.mSnapshot = this.mSnapshot.restoreTo(saveCount);
    }

    private void restore() {
        this.mSnapshot = this.mSnapshot.restore();
    }

    private boolean clipRect(float left, float top, float right, float bottom, int regionOp) {
        return this.mSnapshot.clipRect(left, top, right, bottom, regionOp);
    }

    private static void drawBitmap(long nativeCanvas, Bitmap_Delegate bitmap, long nativePaintOrZero, final int sleft, final int stop, final int sright, final int sbottom, final int dleft, final int dtop, final int dright, final int dbottom) {
        Canvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nativePaintOrZero);
        final BufferedImage image = Canvas_Delegate.getImageToDraw(bitmap, paintDelegate, sBoolOut);
        Canvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, sBoolOut[0], new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                if (paint != null && paint.isFilterBitmap()) {
                    graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(image, dleft, dtop, dright, dbottom, sleft, stop, sright, sbottom, null);
            }
        });
    }

    private static BufferedImage getImageToDraw(Bitmap_Delegate bitmap, Paint_Delegate paint, boolean[] forceSrcMode) {
        BufferedImage image = bitmap.getImage();
        forceSrcMode[0] = false;
        if (bitmap.getConfig() == Bitmap.Config.ALPHA_8) {
            Canvas_Delegate.fixAlpha8Bitmap(image);
        } else if (!bitmap.hasAlpha()) {
            Xfermode_Delegate xfermodeDelegate;
            if (paint != null && (xfermodeDelegate = paint.getXfermode()) instanceof PorterDuffXfermode_Delegate) {
                PorterDuff.Mode mode = ((PorterDuffXfermode_Delegate)xfermodeDelegate).getMode();
                boolean bl = forceSrcMode[0] = mode == PorterDuff.Mode.SRC_OVER || mode == PorterDuff.Mode.SRC;
            }
            if (!forceSrcMode[0]) {
                image = Bitmap_Delegate.createCopy(image, 1, 255);
            }
        }
        return image;
    }

    private static void fixAlpha8Bitmap(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] argb = new int[w * h];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), argb, 0, image.getWidth());
        int length = argb.length;
        int i = 0;
        while (i < length) {
            int n = i++;
            argb[n] = argb[n] & 0xFF000000;
        }
        image.setRGB(0, 0, w, h, argb, 0, w);
    }
}

