/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.FullBackupDataOutput;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FullBackup {
    static final String TAG = "FullBackup";
    static final String TAG_XML_PARSER = "BackupXmlParserLogging";
    public static final String APK_TREE_TOKEN = "a";
    public static final String OBB_TREE_TOKEN = "obb";
    public static final String ROOT_TREE_TOKEN = "r";
    public static final String DATA_TREE_TOKEN = "f";
    public static final String NO_BACKUP_TREE_TOKEN = "nb";
    public static final String DATABASE_TREE_TOKEN = "db";
    public static final String SHAREDPREFS_TREE_TOKEN = "sp";
    public static final String MANAGED_EXTERNAL_TREE_TOKEN = "ef";
    public static final String CACHE_TREE_TOKEN = "c";
    public static final String SHARED_STORAGE_TOKEN = "shared";
    public static final String APPS_PREFIX = "apps/";
    public static final String SHARED_PREFIX = "shared/";
    public static final String FULL_BACKUP_INTENT_ACTION = "fullback";
    public static final String FULL_RESTORE_INTENT_ACTION = "fullrest";
    public static final String CONF_TOKEN_INTENT_EXTRA = "conftoken";
    private static final Map<String, BackupScheme> kPackageBackupSchemeMap = new ArrayMap<String, BackupScheme>();

    public static int backupToTar(String string2, String string3, String string4, String string5, String string6, FullBackupDataOutput fullBackupDataOutput) {
        return OverrideMethod.invokeI("android.app.backup.FullBackup#backupToTar(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/app/backup/FullBackupDataOutput;)I", true, null);
    }

    static synchronized BackupScheme getBackupScheme(Context context) {
        BackupScheme backupSchemeForPackage = kPackageBackupSchemeMap.get(context.getPackageName());
        if (backupSchemeForPackage == null) {
            backupSchemeForPackage = new BackupScheme(context);
            kPackageBackupSchemeMap.put(context.getPackageName(), backupSchemeForPackage);
        }
        return backupSchemeForPackage;
    }

    public static BackupScheme getBackupSchemeForTest(Context context) {
        BackupScheme testing = new BackupScheme(context);
        testing.mExcludes = new ArraySet();
        testing.mIncludes = new ArrayMap<String, Set<String>>();
        return testing;
    }

    public static void restoreFile(ParcelFileDescriptor data, long size, int type, long mode, long mtime, File outFile) throws IOException {
        if (type == 2) {
            if (outFile != null) {
                outFile.mkdirs();
            }
        } else {
            FileOutputStream out = null;
            try {
                if (outFile != null) {
                    File parent = outFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    out = new FileOutputStream(outFile);
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to create/open file " + outFile.getPath(), e);
            }
            byte[] buffer = new byte[32768];
            long origSize = size;
            FileInputStream in = new FileInputStream(data.getFileDescriptor());
            while (size > 0L) {
                int toRead = size > (long)buffer.length ? buffer.length : (int)size;
                int got = in.read(buffer, 0, toRead);
                if (got <= 0) {
                    Log.w(TAG, "Incomplete read: expected " + size + " but got " + (origSize - size));
                    break;
                }
                if (out != null) {
                    try {
                        out.write(buffer, 0, got);
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Unable to write to file " + outFile.getPath(), e);
                        out.close();
                        out = null;
                        outFile.delete();
                    }
                }
                size -= (long)got;
            }
            if (out != null) {
                out.close();
            }
        }
        if (mode >= 0L && outFile != null) {
            try {
                Os.chmod(outFile.getPath(), (int)(mode &= 0x1C0L));
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            outFile.setLastModified(mtime);
        }
    }

    public static class BackupScheme {
        private final File FILES_DIR;
        private final File DATABASE_DIR;
        private final File ROOT_DIR;
        private final File SHAREDPREF_DIR;
        private final File EXTERNAL_DIR;
        private final File CACHE_DIR;
        private final File NOBACKUP_DIR;
        final int mFullBackupContent;
        final PackageManager mPackageManager;
        final String mPackageName;
        Map<String, Set<String>> mIncludes;
        ArraySet<String> mExcludes;

        String tokenToDirectoryPath(String domainToken) {
            try {
                if (domainToken.equals(FullBackup.DATA_TREE_TOKEN)) {
                    return this.FILES_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DATABASE_TREE_TOKEN)) {
                    return this.DATABASE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.ROOT_TREE_TOKEN)) {
                    return this.ROOT_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.SHAREDPREFS_TREE_TOKEN)) {
                    return this.SHAREDPREF_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.CACHE_TREE_TOKEN)) {
                    return this.CACHE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.MANAGED_EXTERNAL_TREE_TOKEN)) {
                    if (this.EXTERNAL_DIR != null) {
                        return this.EXTERNAL_DIR.getCanonicalPath();
                    }
                    return null;
                }
                if (domainToken.equals(FullBackup.NO_BACKUP_TREE_TOKEN)) {
                    return this.NOBACKUP_DIR.getCanonicalPath();
                }
                Log.i(FullBackup.TAG, "Unrecognized domain " + domainToken);
                return null;
            }
            catch (IOException e) {
                Log.i(FullBackup.TAG, "Error reading directory for domain: " + domainToken);
                return null;
            }
        }

        BackupScheme(Context context) {
            this.mFullBackupContent = context.getApplicationInfo().fullBackupContent;
            this.mPackageManager = context.getPackageManager();
            this.mPackageName = context.getPackageName();
            this.FILES_DIR = context.getFilesDir();
            this.DATABASE_DIR = context.getDatabasePath("foo").getParentFile();
            this.ROOT_DIR = new File(context.getApplicationInfo().dataDir);
            this.SHAREDPREF_DIR = context.getSharedPrefsFile("foo").getParentFile();
            this.CACHE_DIR = context.getCacheDir();
            this.NOBACKUP_DIR = context.getNoBackupFilesDir();
            this.EXTERNAL_DIR = Process.myUid() != 1000 ? context.getExternalFilesDir(null) : null;
        }

        boolean isFullBackupContentEnabled() {
            if (this.mFullBackupContent < 0) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "android:fullBackupContent - \"false\"");
                }
                return false;
            }
            return true;
        }

        public synchronized Map<String, Set<String>> maybeParseAndGetCanonicalIncludePaths() throws IOException, XmlPullParserException {
            if (this.mIncludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mIncludes;
        }

        public synchronized ArraySet<String> maybeParseAndGetCanonicalExcludePaths() throws IOException, XmlPullParserException {
            if (this.mExcludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mExcludes;
        }

        private void maybeParseBackupSchemeLocked() throws IOException, XmlPullParserException {
            this.mIncludes = new ArrayMap<String, Set<String>>();
            this.mExcludes = new ArraySet();
            if (this.mFullBackupContent == 0) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "android:fullBackupContent - \"true\"");
                }
            } else {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "android:fullBackupContent - found xml resource");
                }
                XmlResourceParser parser = null;
                try {
                    parser = this.mPackageManager.getResourcesForApplication(this.mPackageName).getXml(this.mFullBackupContent);
                    this.parseBackupSchemeFromXmlLocked(parser, this.mExcludes, this.mIncludes);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IOException(e);
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
        }

        public void parseBackupSchemeFromXmlLocked(XmlPullParser parser, Set<String> excludes, Map<String, Set<String>> includes) throws IOException, XmlPullParserException {
            int event = parser.getEventType();
            while (event != 2) {
                event = parser.next();
            }
            if (!"full-backup-content".equals(parser.getName())) {
                throw new XmlPullParserException("Xml file didn't start with correct tag (<full-backup-content>). Found \"" + parser.getName() + "\"");
            }
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "Found valid fullBackupContent; parsing xml resource.");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "");
            }
            while ((event = parser.next()) != 1) {
                switch (event) {
                    case 2: {
                        this.validateInnerTagContents(parser);
                        String domainFromXml = parser.getAttributeValue(null, "domain");
                        File domainDirectory = this.getDirectoryForCriteriaDomain(domainFromXml);
                        if (domainDirectory == null) {
                            if (!Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) break;
                            Log.v(FullBackup.TAG_XML_PARSER, "...parsing \"" + parser.getName() + "\": " + "domain=\"" + domainFromXml + "\" invalid; skipping");
                            break;
                        }
                        File canonicalFile = this.extractCanonicalFile(domainDirectory, parser.getAttributeValue(null, "path"));
                        if (canonicalFile == null) break;
                        Set<String> activeSet = this.parseCurrentTagForDomain(parser, excludes, includes, domainFromXml);
                        activeSet.add(canonicalFile.getCanonicalPath());
                        if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                            Log.v(FullBackup.TAG_XML_PARSER, "...parsed " + canonicalFile.getCanonicalPath() + " for domain \"" + domainFromXml + "\"");
                        }
                        if (!"database".equals(domainFromXml) || canonicalFile.isDirectory()) break;
                        String canonicalJournalPath = canonicalFile.getCanonicalPath() + "-journal";
                        activeSet.add(canonicalJournalPath);
                        if (!Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) break;
                        Log.v(FullBackup.TAG_XML_PARSER, "...automatically generated " + canonicalJournalPath + ". Ignore if nonexistant.");
                    }
                }
            }
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
                Log.v(FullBackup.TAG_XML_PARSER, "Xml resource parsing complete.");
                Log.v(FullBackup.TAG_XML_PARSER, "Final tally.");
                Log.v(FullBackup.TAG_XML_PARSER, "Includes:");
                if (includes.isEmpty()) {
                    Log.v(FullBackup.TAG_XML_PARSER, "  ...nothing specified (This means the entirety of app data minus excludes)");
                } else {
                    for (Map.Entry<String, Set<String>> entry : includes.entrySet()) {
                        Log.v(FullBackup.TAG_XML_PARSER, "  domain=" + entry.getKey());
                        for (String includeData : entry.getValue()) {
                            Log.v(FullBackup.TAG_XML_PARSER, "  " + includeData);
                        }
                    }
                }
                Log.v(FullBackup.TAG_XML_PARSER, "Excludes:");
                if (excludes.isEmpty()) {
                    Log.v(FullBackup.TAG_XML_PARSER, "  ...nothing to exclude.");
                } else {
                    for (String excludeData : excludes) {
                        Log.v(FullBackup.TAG_XML_PARSER, "  " + excludeData);
                    }
                }
                Log.v(FullBackup.TAG_XML_PARSER, "  ");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
            }
        }

        private Set<String> parseCurrentTagForDomain(XmlPullParser parser, Set<String> excludes, Map<String, Set<String>> includes, String domain) throws XmlPullParserException {
            if ("include".equals(parser.getName())) {
                String domainToken = this.getTokenForXmlDomain(domain);
                Set<String> includeSet = includes.get(domainToken);
                if (includeSet == null) {
                    includeSet = new ArraySet<String>();
                    includes.put(domainToken, includeSet);
                }
                return includeSet;
            }
            if ("exclude".equals(parser.getName())) {
                return excludes;
            }
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "Invalid tag found in xml \"" + parser.getName() + "\"; aborting operation.");
            }
            throw new XmlPullParserException("Unrecognised tag in backup criteria xml (" + parser.getName() + ")");
        }

        private String getTokenForXmlDomain(String xmlDomain) {
            if ("root".equals(xmlDomain)) {
                return FullBackup.ROOT_TREE_TOKEN;
            }
            if ("file".equals(xmlDomain)) {
                return FullBackup.DATA_TREE_TOKEN;
            }
            if ("database".equals(xmlDomain)) {
                return FullBackup.DATABASE_TREE_TOKEN;
            }
            if ("sharedpref".equals(xmlDomain)) {
                return FullBackup.SHAREDPREFS_TREE_TOKEN;
            }
            if ("external".equals(xmlDomain)) {
                return FullBackup.MANAGED_EXTERNAL_TREE_TOKEN;
            }
            return null;
        }

        private File extractCanonicalFile(File domain, String filePathFromXml) {
            if (filePathFromXml == null) {
                filePathFromXml = "";
            }
            if (filePathFromXml.contains("..")) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", but the \"..\" path is not permitted; skipping.");
                }
                return null;
            }
            if (filePathFromXml.contains("//")) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", which contains the invalid \"//\" sequence; skipping.");
                }
                return null;
            }
            return new File(domain, filePathFromXml);
        }

        private File getDirectoryForCriteriaDomain(String domain) {
            if (TextUtils.isEmpty(domain)) {
                return null;
            }
            if ("file".equals(domain)) {
                return this.FILES_DIR;
            }
            if ("database".equals(domain)) {
                return this.DATABASE_DIR;
            }
            if ("root".equals(domain)) {
                return this.ROOT_DIR;
            }
            if ("sharedpref".equals(domain)) {
                return this.SHAREDPREF_DIR;
            }
            if ("external".equals(domain)) {
                return this.EXTERNAL_DIR;
            }
            return null;
        }

        private void validateInnerTagContents(XmlPullParser parser) throws XmlPullParserException {
            if (parser.getAttributeCount() > 2) {
                throw new XmlPullParserException("At most 2 tag attributes allowed for \"" + parser.getName() + "\" tag (\"domain\" & \"path\".");
            }
            if (!"include".equals(parser.getName()) && !"exclude".equals(parser.getName())) {
                throw new XmlPullParserException("A valid tag is one of \"<include/>\" or \"<exclude/>. You provided \"" + parser.getName() + "\"");
            }
        }
    }
}

