/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class BackupManager {
    private static final String TAG = "BackupManager";
    private Context mContext;
    private static IBackupManager sService;

    private static void checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    public BackupManager(Context context) {
        this.mContext = context;
    }

    public void dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d(TAG, "dataChanged() couldn't connect");
            }
        }
    }

    public static void dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "dataChanged(pkg) couldn't connect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestRestore(RestoreObserver observer) {
        int result = -1;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            RestoreSession session = null;
            try {
                IRestoreSession binder = sService.beginRestoreSession(this.mContext.getPackageName(), null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                    result = session.restorePackage(this.mContext.getPackageName(), observer);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "restoreSelf() unable to contact service");
            }
            finally {
                if (session != null) {
                    session.endRestoreSession();
                }
            }
        }
        return result;
    }

    public RestoreSession beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                if (binder != null) {
                    session = new RestoreSession(this.mContext, binder);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }

    public void setBackupEnabled(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setBackupEnabled(isEnabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "setBackupEnabled() couldn't connect");
            }
        }
    }

    public boolean isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.isBackupEnabled();
            }
            catch (RemoteException e) {
                Log.e(TAG, "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    public void setAutoRestore(boolean isEnabled) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.setAutoRestore(isEnabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "setAutoRestore() couldn't connect");
            }
        }
    }

    public String getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getCurrentTransport();
            }
            catch (RemoteException e) {
                Log.e(TAG, "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    public String[] listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.listAllTransports();
            }
            catch (RemoteException e) {
                Log.e(TAG, "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    public String selectBackupTransport(String transport) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.selectBackupTransport(transport);
            }
            catch (RemoteException e) {
                Log.e(TAG, "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    public void backupNow() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.backupNow();
            }
            catch (RemoteException e) {
                Log.e(TAG, "backupNow() couldn't connect");
            }
        }
    }

    public long getAvailableRestoreToken(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                return sService.getAvailableRestoreToken(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "getAvailableRestoreToken() couldn't connect");
            }
        }
        return 0L;
    }
}

