/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesKey;
import android.hardware.display.DisplayManagerGlobal;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.view.Display;
import android.view.DisplayAdjustments;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class ResourcesManager {
    static final String TAG = "ResourcesManager";
    private static final boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private final ArrayMap<ResourcesKey, WeakReference<Resources>> mActiveResources = new ArrayMap();
    private final ArrayMap<Pair<Integer, DisplayAdjustments>, WeakReference<Display>> mDisplays = new ArrayMap();
    CompatibilityInfo mResCompatibilityInfo;
    Configuration mResConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourcesManager getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    public Configuration getConfiguration() {
        return this.mResConfiguration;
    }

    DisplayMetrics getDisplayMetricsLocked() {
        return this.getDisplayMetricsLocked(0);
    }

    DisplayMetrics getDisplayMetricsLocked(int displayId) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getAdjustedDisplay(displayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
        if (display != null) {
            display.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    void applyNonDefaultDisplayMetricsToConfigurationLocked(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = config.screenWidthDp;
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    public boolean applyCompatConfiguration(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getAdjustedDisplay(int displayId, DisplayAdjustments displayAdjustments) {
        DisplayAdjustments displayAdjustmentsCopy = displayAdjustments != null ? new DisplayAdjustments(displayAdjustments) : new DisplayAdjustments();
        Pair<Integer, DisplayAdjustments> key = Pair.create(displayId, displayAdjustmentsCopy);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Display display;
            WeakReference<Display> wd = this.mDisplays.get(key);
            if (wd != null && (display = (Display)wd.get()) != null) {
                return display;
            }
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            Display display2 = dm.getCompatibleDisplay(displayId, (DisplayAdjustments)key.second);
            if (display2 != null) {
                this.mDisplays.put(key, new WeakReference<Display>(display2));
            }
            return display2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resources getTopLevelResources(String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfiguration, CompatibilityInfo compatInfo) {
        Configuration config;
        Resources r;
        float scale = compatInfo.applicationScale;
        Configuration overrideConfigCopy = overrideConfiguration != null ? new Configuration(overrideConfiguration) : null;
        ResourcesKey key = new ResourcesKey(resDir, displayId, overrideConfigCopy, scale);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = r = wr != null ? (Resources)wr.get() : null;
            if (r != null && r.getAssets().isUpToDate()) {
                return r;
            }
        }
        AssetManager assets = new AssetManager();
        if (resDir != null && assets.addAssetPath(resDir) == 0) {
            return null;
        }
        if (splitResDirs != null) {
            for (String splitResDir : splitResDirs) {
                if (assets.addAssetPath(splitResDir) != 0) continue;
                return null;
            }
        }
        if (overlayDirs != null) {
            for (String idmapPath : overlayDirs) {
                assets.addOverlayPath(idmapPath);
            }
        }
        if (libDirs != null) {
            for (String libDir : libDirs) {
                if (!libDir.endsWith(".apk") || assets.addAssetPath(libDir) != 0) continue;
                Log.w(TAG, "Asset path '" + libDir + "' does not exist or contains no resources.");
            }
        }
        DisplayMetrics dm = this.getDisplayMetricsLocked(displayId);
        boolean isDefaultDisplay = displayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                this.applyNonDefaultDisplayMetricsToConfigurationLocked(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        r = new Resources(assets, dm, config, compatInfo);
        ResourcesManager resourcesManager2 = this;
        synchronized (resourcesManager2) {
            Resources existing;
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = existing = wr != null ? (Resources)wr.get() : null;
            if (existing != null && existing.getAssets().isUpToDate()) {
                r.getAssets().close();
                return existing;
            }
            this.mActiveResources.put(key, new WeakReference<Resources>(r));
            return r;
        }
    }

    boolean applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        if (this.mResConfiguration == null) {
            this.mResConfiguration = new Configuration();
        }
        if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
            return false;
        }
        int changes = this.mResConfiguration.updateFrom(config);
        this.mDisplays.clear();
        DisplayMetrics defaultDisplayMetrics = this.getDisplayMetricsLocked();
        if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
            this.mResCompatibilityInfo = compat;
            changes |= 0xD00;
        }
        if (config.locale != null) {
            Locale.setDefault(config.locale);
        }
        Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
        ApplicationPackageManager.configurationChanged();
        Configuration tmpConfig = null;
        for (int i = this.mActiveResources.size() - 1; i >= 0; --i) {
            ResourcesKey key = this.mActiveResources.keyAt(i);
            Resources r = (Resources)this.mActiveResources.valueAt(i).get();
            if (r != null) {
                int displayId = key.mDisplayId;
                boolean isDefaultDisplay = displayId == 0;
                DisplayMetrics dm = defaultDisplayMetrics;
                boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
                if (!isDefaultDisplay || hasOverrideConfiguration) {
                    if (tmpConfig == null) {
                        tmpConfig = new Configuration();
                    }
                    tmpConfig.setTo(config);
                    if (!isDefaultDisplay) {
                        dm = this.getDisplayMetricsLocked(displayId);
                        this.applyNonDefaultDisplayMetricsToConfigurationLocked(dm, tmpConfig);
                    }
                    if (hasOverrideConfiguration) {
                        tmpConfig.updateFrom(key.mOverrideConfiguration);
                    }
                    r.updateConfiguration(tmpConfig, dm, compat);
                    continue;
                }
                r.updateConfiguration(config, dm, compat);
                continue;
            }
            this.mActiveResources.removeAt(i);
        }
        return changes != 0;
    }
}

