/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.format.DateUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mDateSetListener;
    private final Calendar mCalendar;
    private boolean mTitleNeedsUpdate = true;
    private final DatePicker.ValidationCallback mValidationCallback = new DatePicker.ValidationCallback(){

        @Override
        public void onValidationChanged(boolean valid) {
            Button positive = DatePickerDialog.this.getButton(-1);
            if (positive != null) {
                positive.setEnabled(valid);
            }
        }
    };

    public DatePickerDialog(Context context, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this(context, 0, callBack, year, monthOfYear, dayOfMonth);
    }

    static int resolveDialogTheme(Context context, int resid) {
        if (resid == 0) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(16843948, outValue, true);
            return outValue.resourceId;
        }
        return resid;
    }

    public DatePickerDialog(Context context, int theme, OnDateSetListener listener, int year, int monthOfYear, int dayOfMonth) {
        super(context, DatePickerDialog.resolveDialogTheme(context, theme));
        this.mDateSetListener = listener;
        this.mCalendar = Calendar.getInstance();
        Context themeContext = this.getContext();
        LayoutInflater inflater = LayoutInflater.from(themeContext);
        View view = inflater.inflate(17367109, null);
        this.setView(view);
        this.setButton(-1, (CharSequence)themeContext.getString(17039370), this);
        this.setButton(-2, (CharSequence)themeContext.getString(0x1040000), this);
        this.setButtonPanelLayoutHint(1);
        this.mDatePicker = (DatePicker)view.findViewById(16909080);
        this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
        this.mDatePicker.setValidationCallback(this.mValidationCallback);
    }

    @Override
    public void onDateChanged(DatePicker view, int year, int month, int day) {
        this.mDatePicker.init(year, month, day, this);
        this.updateTitle(year, month, day);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mDateSetListener == null) break;
                this.mDatePicker.clearFocus();
                this.mDateSetListener.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
                break;
            }
            case -2: {
                this.cancel();
            }
        }
    }

    public DatePicker getDatePicker() {
        return this.mDatePicker;
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    private void updateTitle(int year, int month, int day) {
        if (!this.mDatePicker.getCalendarViewShown()) {
            this.mCalendar.set(1, year);
            this.mCalendar.set(2, month);
            this.mCalendar.set(5, day);
            String title = DateUtils.formatDateTime(this.mContext, this.mCalendar.getTimeInMillis(), 98326);
            this.setTitle(title);
            this.mTitleNeedsUpdate = true;
        } else if (this.mTitleNeedsUpdate) {
            this.mTitleNeedsUpdate = false;
            this.setTitle(17040320);
        }
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mDatePicker.init(year, month, day, this);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

