/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.harmony.security.asn1.ASN1BitString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BitString;
import org.apache.harmony.security.x509.AlgorithmIdentifier;
import org.apache.harmony.security.x509.X509PublicKey;

public class SubjectPublicKeyInfo {
    private AlgorithmIdentifier algorithmID;
    private byte[] subjectPublicKey;
    private PublicKey publicKey;
    private int unusedBits;
    private byte[] encoding;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{AlgorithmIdentifier.ASN1, ASN1BitString.getInstance()}){

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)values[0], ((BitString)values[1]).bytes, ((BitString)values[1]).unusedBits, in.getEncoded());
        }

        @Override
        protected void getValues(Object object, Object[] values) {
            SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)object;
            values[0] = spki.algorithmID;
            values[1] = new BitString(spki.subjectPublicKey, spki.unusedBits);
        }
    };

    public SubjectPublicKeyInfo(AlgorithmIdentifier algID, byte[] subjectPublicKey) {
        this(algID, subjectPublicKey, 0);
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algID, byte[] subjectPublicKey, int unused) {
        this(algID, subjectPublicKey, 0, null);
    }

    private SubjectPublicKeyInfo(AlgorithmIdentifier algID, byte[] subjectPublicKey, int unused, byte[] encoding) {
        this.algorithmID = algID;
        this.subjectPublicKey = subjectPublicKey;
        this.unusedBits = unused;
        this.encoding = encoding;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmID;
    }

    public byte[] getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            byte[] encoded = this.getEncoded();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            String algName = this.algorithmID.getAlgorithmName();
            this.publicKey = SubjectPublicKeyInfo.generateKeyForAlgorithm(keySpec, algName);
            String algOid = this.algorithmID.getAlgorithm();
            if (this.publicKey == null && !algOid.equals(algName)) {
                this.publicKey = SubjectPublicKeyInfo.generateKeyForAlgorithm(keySpec, algOid);
            }
            if (this.publicKey == null) {
                this.publicKey = new X509PublicKey(algOid, encoded, this.subjectPublicKey);
            }
        }
        return this.publicKey;
    }

    private static PublicKey generateKeyForAlgorithm(KeySpec keySpec, String algorithm) {
        try {
            return KeyFactory.getInstance(algorithm).generatePublic(keySpec);
        }
        catch (InvalidKeySpecException ignored) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }
}

