/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    @Nullable
    public static Method getMethod(@NonNull Class<?> clazz, @NonNull String name, Class<?> ... params) throws ReflectionException {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    @Nullable
    public static Object invoke(@NonNull Method method, @Nullable Object object, Object ... args) throws ReflectionException {
        ReflectiveOperationException ex;
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new ReflectionException(ex);
    }

    public static class ReflectionException
    extends Exception {
        public ReflectionException() {
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

