/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.NinePatch_Delegate;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.TypedValue;
import com.android.annotations.NonNull;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.ninepatch.NinePatch;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.Density;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourceHelper {
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f), new UnitEntry("%", 6, 0, 0.01f), new UnitEntry("%p", 6, 1, 0.01f)};

    public static int getColor(String value) {
        if (value != null) {
            if (!value.startsWith("#")) {
                throw new NumberFormatException(String.format("Color value '%s' must start with #", value));
            }
            if ((value = value.substring(1)).length() > 8) {
                throw new NumberFormatException(String.format("Color value '%s' is too long. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value));
            }
            if (value.length() == 3) {
                char[] color2 = new char[8];
                color2[1] = 70;
                color2[0] = 70;
                color2[2] = color2[3] = value.charAt(0);
                color2[4] = color2[5] = value.charAt(1);
                color2[6] = color2[7] = value.charAt(2);
                value = new String(color2);
            } else if (value.length() == 4) {
                char[] color3 = new char[8];
                color3[0] = color3[1] = value.charAt(0);
                color3[2] = color3[3] = value.charAt(1);
                color3[4] = color3[5] = value.charAt(2);
                color3[6] = color3[7] = value.charAt(3);
                value = new String(color3);
            } else if (value.length() == 6) {
                value = "FF" + value;
            }
            return (int)Long.parseLong(value, 16);
        }
        throw new NumberFormatException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getColorStateList(ResourceValue resValue, BridgeContext context) {
        String value = resValue.getValue();
        if (value != null && !"@null".equals(value)) {
            File f = new File(value);
            if (f.isFile()) {
                XmlPullParser parser = ParserFactory.create(f);
                BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser, context, resValue.isFramework());
                try {
                    ColorStateList colorStateList = ColorStateList.createFromXml(context.getResources(), blockParser);
                    blockParser.ensurePopped();
                    return colorStateList;
                }
                catch (Throwable throwable) {
                    try {
                        blockParser.ensurePopped();
                        throw throwable;
                    }
                    catch (XmlPullParserException e) {
                        Bridge.getLog().error("broken", "Failed to configure parser for " + value, (Throwable)e, null);
                    }
                    catch (Exception e) {
                        Bridge.getLog().error("resources.read", "Failed to parse file " + value, (Throwable)e, null);
                        return null;
                    }
                }
            } else {
                try {
                    int color2 = ResourceHelper.getColor(value);
                    return ColorStateList.valueOf(color2);
                }
                catch (NumberFormatException e) {
                    Bridge.getLog().error("resources.format", "Failed to convert " + value + " into a ColorStateList", (Throwable)e, null);
                    return null;
                }
            }
        }
        return null;
    }

    public static Drawable getDrawable(ResourceValue value, BridgeContext context) {
        return ResourceHelper.getDrawable(value, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(ResourceValue value, BridgeContext context, Resources.Theme theme) {
        if (value == null) {
            return null;
        }
        String stringValue = value.getValue();
        if ("@null".equals(stringValue)) {
            return null;
        }
        String lowerCaseValue = stringValue.toLowerCase();
        Density density = Density.MEDIUM;
        if (value instanceof DensityBasedResourceValue) {
            density = ((DensityBasedResourceValue)value).getResourceDensity();
        }
        if (lowerCaseValue.endsWith(".9.png")) {
            File file = new File(stringValue);
            if (file.isFile()) {
                try {
                    return ResourceHelper.getNinePatchDrawable(new FileInputStream(file), density, value.isFramework(), stringValue, context);
                }
                catch (IOException e) {
                    Bridge.getLog().error("resources.read", "Failed lot load " + file.getAbsolutePath(), (Throwable)e, null);
                }
            }
            return null;
        }
        if (lowerCaseValue.endsWith(".xml")) {
            File f = new File(stringValue);
            if (f.isFile()) {
                XmlPullParser parser = ParserFactory.create(f);
                BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser, context, value.isFramework());
                try {
                    Drawable drawable2 = Drawable.createFromXml(context.getResources(), blockParser, theme);
                    blockParser.ensurePopped();
                    return drawable2;
                }
                catch (Throwable throwable) {
                    try {
                        blockParser.ensurePopped();
                        throw throwable;
                    }
                    catch (Exception e) {
                        Bridge.getLog().error(null, "Failed to parse file " + stringValue, (Throwable)e, null);
                    }
                }
            } else {
                Bridge.getLog().error("broken", String.format("File %s does not exist (or is not a file)", stringValue), null);
            }
            return null;
        }
        File bmpFile = new File(stringValue);
        if (bmpFile.isFile()) {
            try {
                Bitmap bitmap = Bridge.getCachedBitmap(stringValue, value.isFramework() ? null : context.getProjectKey());
                if (bitmap == null) {
                    bitmap = Bitmap_Delegate.createBitmap(bmpFile, false, density);
                    Bridge.setCachedBitmap(stringValue, bitmap, value.isFramework() ? null : context.getProjectKey());
                }
                return new BitmapDrawable(context.getResources(), bitmap);
            }
            catch (IOException e) {
                Bridge.getLog().error("resources.read", "Failed lot load " + bmpFile.getAbsolutePath(), (Throwable)e, null);
            }
        } else {
            try {
                int color2 = ResourceHelper.getColor(stringValue);
                return new ColorDrawable(color2);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().error("resources.format", "Failed to convert " + stringValue + " into a drawable", (Throwable)e, null);
            }
        }
        return null;
    }

    private static Drawable getNinePatchDrawable(InputStream inputStream, Density density, boolean isFramework, String cacheKey, BridgeContext context) throws IOException {
        NinePatchChunk chunk = Bridge.getCached9Patch(cacheKey, isFramework ? null : context.getProjectKey());
        Bitmap bitmap = Bridge.getCachedBitmap(cacheKey, isFramework ? null : context.getProjectKey());
        if (chunk == null || bitmap == null) {
            try {
                NinePatch ninePatch = NinePatch.load(inputStream, true, false);
                if (ninePatch != null) {
                    if (chunk == null) {
                        chunk = ninePatch.getChunk();
                        Bridge.setCached9Patch(cacheKey, chunk, isFramework ? null : context.getProjectKey());
                    }
                    if (bitmap == null) {
                        bitmap = Bitmap_Delegate.createBitmap(ninePatch.getImage(), false, density);
                        Bridge.setCachedBitmap(cacheKey, bitmap, isFramework ? null : context.getProjectKey());
                    }
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (chunk != null && bitmap != null) {
            int[] padding = chunk.getPadding();
            Rect paddingRect = new Rect(padding[0], padding[1], padding[2], padding[3]);
            return new NinePatchDrawable(context.getResources(), bitmap, NinePatch_Delegate.serialize(chunk), paddingRect, null);
        }
        return null;
    }

    public static TypedValue getValue(String attribute, String value, boolean requireUnit) {
        if (ResourceHelper.parseFloatAttribute(attribute, value, mValue, requireUnit)) {
            return mValue;
        }
        return null;
    }

    public static boolean parseFloatAttribute(String attribute, @NonNull String value, TypedValue outValue, boolean requireUnit) {
        assert (!requireUnit || attribute != null);
        int len = (value = value.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-' && buf[0] != '+') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    Bridge.getLog().error("resources.resolve", String.format("Dimension \"%1$s\" in attribute \"%2$s\" is missing unit!", value, attribute), null);
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value *= scale) < 0.0f;
        if (neg) {
            value = -value;
        }
        if (((bits = (long)(value * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            ResourceHelper.applyUnit(unit, outValue, outScale);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue, float[] outScale) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        outScale[0] = unit.scale;
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

